
<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loadCommissiondetails", '$(document).ready(function() {
        filterDataTable();
    });', CClientScript::POS_HEAD);
$cs->registerScript("loaddetails", 'function filterDataTable(){
        var provider_id=$("#provider_name").val();
        var table_id ="#tbl_uploaded_commission_details";
        var table = $(table_id).DataTable({
            scrollY         : "380px",
//            scrollX         : "true",
           // scrollCollapse  : true,
           "bAutoWidth": true,
            pageLength      : 50,
            processing: true, 
             columns:[
        {className:"nw sl col-max-1"},
        {className:"nw sl col-max-5"},
        {className:"nw sl col-max-4"},
        {className:"nw sl col-max-5"},
        {className:"nw sl col-max-1"},
        {className:"nw sl col-max-4"},
        ],
            //bSort: false,
            order: [[ 2, "asc" ]],
            "columnDefs": [
                { "bSortable": false, "aTargets": [0,2,3,4,5] },
                 ],
            ajax: {
                url: "' . Yii::app()->createUrl('commission/getlistforcalculation') . '",
                type: "POST",
                "data" : {
                    "provider_id" : provider_id,
                },
                cache : false,
            },          
            serverSide:     true,
            fixedColumns:   true,
            processing: true,           
            // fixedHeader: {
            //     headerOffset: $("header.main").outerHeight()
            // },
            
        });
       // $(".dataTables_scrollFoot").hide();
    }', CClientScript::POS_HEAD);
$cs->registerScript("getcommisiondetails", "function getcommisiondetails(){  
    $('#tbl_uploaded_commission_details').DataTable().destroy();
    filterDataTable();
   
};", CClientScript::POS_HEAD);
$cs->registerScript('deletecommissionfile', 'function deletecommissionfile(id){ 
        jConfirm("Confirm Commission File Deletion?", "Confirmation Dialog", function(r) {
            if (r == true) {
                jQuery.ajax({
                    "dataType":"json",
                    "data" : {"id" : id},
                    "type"  : "post",
                    "url": "' . Yii::app()->createUrl('commission/deletecommissionfile') . '",
                    "success":function(data){
                        if(data.status=="success"){  
                            t8.success("Deleted Successfully!");
                            reloadTable("#tbl_uploaded_commission_details");
                        } else { 
                           t8.error("Error in Deletion!");
                        } 
                    },
                    "beforeSend":function(){
                        $("#loader").show();
                    },
                    "complete":function(){
                        $("#loader").hide();
                    }
                });
            }else{
                
            }
        }); 
};', CClientScript::POS_HEAD);
$cs->registerScript('deletecalculatedcommission', 'function deletecalculatedcommission(id){ 
        jConfirm("Confirm Commission File Deletion?", "Confirmation Dialog", function(r) {
            if (r == true) {
                jQuery.ajax({
                    "dataType":"json",
                    "data" : {"id" : id},
                    "type"  : "post",
                    "url": "' . Yii::app()->createUrl('commission/deletecalculatedcommission') . '",
                    "success":function(data){
                        if(data.status=="success"){  
                            t8.success("Deleted Successfully!");
                            reloadTable("#tbl_uploaded_commission_details");
                        } else { 
                           t8.error("Error in Deletion!");
                        } 
                    },
                    "beforeSend":function(){
                        $("#loader").show();
                    },
                    "complete":function(){
                        $("#loader").hide();
                    }
                });
            }else{
                
            }
        }); 
};', CClientScript::POS_HEAD);
?>
<section class="panel">
    <header class="panel-heading clearfix panel-theame">
        <i class="fa fa-money"></i> Commission List
        <div class="pull-right" style="display: inline-flex;">
            <?php
            echo CHtml::dropdownlist('provider_name', '', Provider::getAll(), array('class' => 'activity-dropdown-1', 'title' => 'Please Select Provider', 'onchange' => 'getcommisiondetails();', 'empty' => 'All Providers'));
            ?>
        </div>
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_uploaded_commission_details">
                <thead>
                    <tr>
                        <th>No</th>
                        <th >Provider Name</th>
                        <th >Statement Date</th>
                        <th >Uploaded By</th>
                        <th >Uploaded On</th>
                        <th >Actions</th>
                    </tr>
                </thead>
                <tfoot>
                    <tr>
                       <th>No</th>
                        <th >Provider Name</th>
                        <th >Statement Date</th>
                        <th >Uploaded By</th>
                        <th >Uploaded On</th>
                        <th >Actions</th>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>
</section>