<?php

$colour = MasColourScheme::model()->findAll();
$cs = Yii::app()->getClientScript();
$baseUrl = Yii::app()->baseUrl;

$cs->registerScript("loadSettings", '
        $(document).ready(function() {

        var table_id ="#tbl_colour_details";
        var table = $(table_id).DataTable({
            scrollY         : "380px",
           // scrollX         : "true",
           // scrollCollapse  : true,
            pageLength      : 50,
			processing: true,
            ajax: {
                url: "' . Yii::app()->createUrl('colourscheme/GetList') . '",
                type: "POST",
                cache : false,
            },
             "columnDefs": [
                    {
                       "targets": [0,2],
                       "visible": false,
                    }
                 ],
             "rowCallback": function ( row, data ){
               
                     $("td", row).css("background-color", ""+data[2]+"");
              },
            serverSide:     true,
            fixedColumns:   true,
			processing: true,
//            fixedHeader: {
//                headerOffset: $("header.main").outerHeight()
//            }
        } );
        $(".dataTables_scrollFoot").hide();
    });', CClientScript::POS_HEAD);
    ?>
    <section class="panel">
        <header class="panel-heading clearfix panel-theame">
            <i class="fa fa-crosshairs"></i> Colour Scheme
            
<!--            <div class="pull-right">
                <button class="btn btn-sm btn-theme" onclick="loadPopupModal('colourscheme/create','Add','lg')"><i class="fa fa-plus"></i> ADD</button>
            </div>-->
            
        </header>
        <div class="panel-body">
            <div class="custom-data-table">
                <table class="table table-hover table-bordered personal-task" id="tbl_colour_details">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Item</th>
                            <th>Colour</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tfoot>
                        <tr>
                            <th>No</th>
                            <th>Item</th>
                            <th>Colour</th>
                            <th>Actions</th>
                            
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </section>
