<section class="panel">
    <header class="panel-heading clearfix panel-theame">
        <i class="fa fa-money"></i> Annual Commission List
        <div class="pull-right" style="display: inline-flex;">
             <?php
            echo CHtml::dropdownlist('annual_executive_name','',User::getUsersList(),  array('class'=>'activity-dropdown-1','title' => 'Please Select Executive','onchange'=>'getcommissiondetails();','empty'=>'All Executives')); 
            ?> 
            <?php
            echo CHtml::dropdownlist('annual_executive_target_year',date('Y'),UserTarget::listYears(2,0),  array('class'=>'activity-dropdown-1','title' => 'Please Select Year','onchange'=>'getcommissiondetails();')); 
            ?> 
        </div>
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_annual_commission_details">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Executive Name</th>
                        <th>Year</th>
                        <th>Target Amount</th>
                        <th>Target Acheived</th>
                        <th>Commission Amount</th>
                        <th align="center">Actions</th>
                    </tr>
                </thead>
                <tbody id="tbody_annual_commission_details">
                    <?php
                    $sl=1;
                    $current_date=date('Y-m-d');      
                    $value_target = UserTarget::model()->find(array('condition' =>'target_year="'.date('Y').'" and target_id="5"'));
                    if(!empty($value_target)){
                        $model_commission_ledger= ExecutiveHoldCommission::model()->findAll(array('condition' =>"t.transaction_date>='".$value_target->start_date."' and t.transaction_date<='".$value_target->end_date."' and t.type='EXE_ANN_COM' and in_or_out='IN' and status='HOLD'",'group'=>'t.user_id'));
                        if(!empty($model_commission_ledger)){    
                            foreach ($model_commission_ledger as $key_1 => $value_ledger) {
                                $model_employee_target = UserTarget::model()->find(array('condition' =>'user_id="'.$value_ledger->user_id.'" and target_id="'.$value_target->target_id.'" and start_date>="'.$value_target->start_date.'" and end_date<="'.$value_target->end_date.'"'));        
                                $condition_1_IN = "commissionfiledetails.type='NB' and user_id='" . $value_ledger->user_id . "' and transaction_date>='" . $model_employee_target->start_date . "' and transaction_date<='" . $model_employee_target->end_date . "' and (t.type='EXE_ANN_COM') and status='HOLD'";
                                $model_target_in_amount = ExecutiveHoldCommission::model()->with('commissionfiledetails')->find(array('select' => 'sum(in_amount) as in_amount,sum(commission_amount) as total_amount', 'condition' => $condition_1_IN));
                                $condition_1_OUT = "commissionfiledetails.type='NB' and user_id='" . $value_ledger->user_id . "' and transaction_date>='" . $model_employee_target->start_date . "' and transaction_date<='" . $model_employee_target->end_date . "' and (t.type='EXE_ANN_COM_RET') and status='HOLD'";
                                $model_target_out_amount = ExecutiveHoldCommission::model()->with('commissionfiledetails')->find(array('select' => 'sum(out_amount) as in_amount,sum(commission_amount) as total_amount', 'condition' => $condition_1_OUT));
                                $condition_2 = "user_id='".$value_ledger->user_id."' and transaction_date>='".$model_employee_target->start_date."' and transaction_date<='".$model_employee_target->end_date."' and (t.type='EXE_ANN_COM' OR t.type='EXE_ANN_COM_RET')  and status='HOLD'";
                                $model_com_amount = ExecutiveHoldCommission::model()->with('commissionfiledetails')->find(array('select'=>'sum(in_amount-out_amount) as in_amount','condition' =>$condition_2));
                                $model_target_amount->total_amount=$model_target_in_amount->total_amount-$model_target_out_amount->total_amount;
                                $tax_perc=100-$value_ledger->commission_masplan->general_vat;
                                $employee_acheived_target=(int)($model_target_amount->total_amount*$tax_perc)/100;
                                $class='';
                                if($employee_acheived_target<$model_employee_target->target_amount){
                                  $class='bg-danger';  
                                }else if($employee_acheived_target>$model_employee_target->target_amount){
                                    $class='bg-success';  
                                }
                                //Quarter Commission
                                $condition = "user_id='".$value_ledger->user_id."' and transaction_date>='".$value_target->start_date."' and transaction_date<='".$value_target->end_date."' and (type='EXE_QUA_COM' OR type='EXE_QUA_COM_RET') and status='H_ANN'";
                                $model_quarter_commission_ledger = ExecutiveHoldCommission::model()->findAll(array('condition' =>$condition));    
                                $quarter_amount=0.00;
                                foreach($model_quarter_commission_ledger as $each_quarter_ledger){
                                    if($each_quarter_ledger->in_or_out=='OUT'){
                                        $each_quarter_ledger->in_amount=-$each_quarter_ledger->out_amount;
                                    }
                                    $quarter_amount+=$each_quarter_ledger->in_amount;   
                                }
                                $total_commission=$quarter_amount+$model_com_amount->in_amount;
                                ?>
                        <tr class="<?php echo $class; ?>">
                            <td><?php echo $sl; ?></td>
                            <td><?php echo $value_ledger->userdetails->fullname; ?></td>
                            <td><?php echo $value_target->target_year; ?></td>
                            <td class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($model_employee_target->target_amount,""); ?></td>
                            <td class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($employee_acheived_target,""); ?></td>
                            <td class="text-right"><?php 
                            if($employee_acheived_target>=$model_employee_target->target_amount){
                                echo Yii::app()->numberFormatter->formatCurrency($total_commission,""); 
                            }else{
                                echo '0.00';
                            }
                            ?></td>
                            <td class="text-center">
                                <?php
                                    if($employee_acheived_target>=$model_employee_target->target_amount && strtotime($current_date)>=strtotime($model_employee_target->end_date)){ ?>
                                        <a href="javascript:void(0);" class="btn btn-primary btn-xs" title="Calculate Commission" onclick="loadPopupModal('annualcommission/executivecommissiondetails&type=1&id=<?php echo $value_ledger->user_id ?>&target=<?php echo $model_employee_target->id ?>','Transfer Commission to Executive Account','xl')"><i class="fa fa-exchange"></i></a>                            
                                    <?php
                                    }else if(strtotime($current_date)> strtotime($model_employee_target->end_date)){ ?>
                                       <a href="javascript:void(0);" class="btn btn-primary btn-xs" title="Calculate Commission" onclick="loadPopupModal('annualcommission/executivecommissiondetails&type=2&id=<?php echo $value_ledger->user_id ?>&target=<?php echo $model_employee_target->id ?>','Transfer Commission to Company Account','xl')"><i class="fa fa-exchange"></i></a>
                                       <?php
                                    }
                                ?>
                            </td>
                        </tr>
                                <?php
                                $sl++;
                            }
                        }else{
                            ?>
                        <tr><td colspan="8" class="text-center"><b>No Data Available</b></td></tr>
                        <?php
                        }}
                    ?>
                </tbody>
            </table>
        </div>
    </div>
</section>
<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("getcommissiondetails", "function getcommissiondetails() { 
    var executive_id=$('#annual_executive_name').val();
    var year=$('#annual_executive_target_year').val();
            jQuery.ajax({
               // 'dataType':'json', 
                'data' : {
                    'executive_id':executive_id,'year':year
                },
                'type':'post',
                'url': '" . Yii::app()->createUrl('annualcommission/getcommissiondetails') . "',
                'cache': false,
                'success': function(data) {
                    $('#tbody_annual_commission_details').html(data);
                },
                'beforeSend': function(data) {
                    $('#loader').show();
                },
                'complete': function(data) {
                    $('#loader').hide();
                },
        });
    };", CClientScript::POS_HEAD);
?>