<ul class="nav nav-tabs company-nav-tabs nav-tab-theme">
    <li class="active"><a href="#history_tab" data-toggle="tab">History</a></li>
    <li><a href="#calls_tab" data-toggle="tab">Calls</a></li>
    <li><a href="#appointment_tab" data-toggle="tab" id="appointment_li">Appointments</a></li>
    <li><a href="#visit_tab" data-toggle="tab" id="joint_field_li">Joint Field Visit</a></li>
    <li><a href="#fact_tab" data-toggle="tab">Fact Find Notes</a></li>
    <li><a href="#presentation_tab" data-toggle="tab">Presentation</a></li>
    <li><a href="#application_tab" data-toggle="tab">Application</a></li>
    <?php if (isset(Yii::app()->user->havePermissionOn['activity_welcome'])) { ?>
        <li><a href="#welcome_tab" data-toggle="tab">Welcome Call</a></li>
    <?php } ?>
    <li><a href="#review_tab" data-toggle="tab">Review Meeting</a></li>
    <?php if (isset(Yii::app()->user->havePermissionOn['client_verification'])) { ?>
        <li><a href="#verification_tab" data-toggle="tab">Client Verification</a></li>
    <?php } ?>
    <!--<li><a href="#premium_tab" data-toggle="tab">Premium</a></li>-->
    <li onclick='reloadTable("#tbl_activitydocument_details");'><a href="#document_tab" data-toggle="tab">Documents</a></li>
</ul>
<div class="tab-content">
    <div class="tab-pane active" id="history_tab">
        <?php $this->renderPartial('activity_history', array('customer_id' => $customer_id)); ?>
    </div>
    <div class="tab-pane" id="calls_tab">
        <?php $this->renderPartial('activity_calls', array('model' => new Activity(), 'customer_id' => $customer_id)); ?>
    </div>
    <div class="tab-pane" id="appointment_tab">
        <?php $this->renderPartial('activity_appointment', array('model' => new Activity(), 'customer_id' => $customer_id)); ?>
    </div>
    <div class="tab-pane" id="visit_tab">
        <?php $this->renderPartial('activity_joint_visit', array('model' => new Activity(), 'customer_id' => $customer_id)); ?>
    </div>
    <div class="tab-pane" id="fact_tab">
        <?php $this->renderPartial('activity_fact_find', array('model' => new Activity(), 'customer_id' => $customer_id)); ?>
    </div>
    <div class="tab-pane" id="presentation_tab">
        <?php $this->renderPartial('activity_presentation', array('model' => new Activity(), 'customer_id' => $customer_id)); ?>
    </div>
    <div class="tab-pane" id="application_tab">
        <?php $this->renderPartial('activity_application', array('model' => new Activity(), 'customer_id' => $customer_id)); ?>
    </div>
    <div class="tab-pane" id="welcome_tab">
        <?php $this->renderPartial('activity_welcome_call', array('model' => new Activity(), 'customer_id' => $customer_id)); ?>
    </div>
    <div class="tab-pane" id="review_tab">
        <?php $this->renderPartial('activity_review', array('model' => new Activity(), 'customer_id' => $customer_id)); ?>
    </div>
    <div class="tab-pane" id="verification_tab">
        <?php $this->renderPartial('activity_client_verification', array('model' => new Activity(), 'customer_id' => $customer_id)); ?>
    </div>
    <div class="tab-pane" id="document_tab">
        <?php $this->renderPartial('activity_documents', array('model' => new ActivityDocument(), 'customer_id' => $customer_id)); ?>
    </div>
</div>
<?php
$previous_date = date('Y-m-d', strtotime('-3 days', strtotime(date('Y-m-d'))));
$previous_date = date('d/m/Y', strtotime($previous_date));
$flag = 0;
if (isset(Yii::app()->user->havePermissionOn['fact_find_unlock'])) {
    $flag = 1;
}
?>
<input type="hidden" id="activity_min_date" value="<?php echo $previous_date; ?>" />
<input type="hidden" id="activity_max_date" value="<?php echo date("d/m/Y"); ?>" />
<input type="hidden" id="activity_permission_type" value="<?php echo $flag; ?>" />
<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("datepickerfield", "$(document).ready(function() {
        // $('#Activity_manager_id').multiselect({
        //   enableFiltering: true,
        //   includeSelectAllOption:true,
        //   enableCaseInsensitiveFiltering: true,
        // });
        setminmaxdate();
        filterDataTable(0);
        loadDocuments();
});", CClientScript::POS_HEAD);
$cs->registerScript("loaddetails", 'function filterDataTable(type){
    var customer_id=$("#activity_customer_id").val();
        var table_id ="#tbl_activity_details";
        var table = $(table_id).DataTable({
            scrollY         : "380px",
            scrollX         : "true",
           // scrollCollapse  : true,
            pageLength      : 50,
            processing: true,
           // bSort: false,
           "columnDefs": [
                    {
                       "targets": [8],
                       "visible": false,
                    },
                 ],
            ajax: {
                url: "' . Yii::app()->createUrl('activity/GetActivityList') . '",
                type: "POST",
                "data" : {
                    "type" : type,
                    "customer_id" : customer_id
                },
                cache : false,
            },
            rowCallback: function (row, data){
                    if (data[8] == "N"){
                        $("td", row).css("text-decoration", "line-through");
                    }
            },
            serverSide:     true,
            fixedColumns:   true,
            processing: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            },

        });
        $(".dataTables_scrollFoot").hide();
    }', CClientScript::POS_HEAD);
$cs->registerScript("setminmaxdate", "function setminmaxdate(){
        var min_date = $('#activity_min_date').val().split('/');
        var activity_permission_type = $('#activity_permission_type').val();
        var min_date = new Date(min_date[2], min_date[1] - 1, min_date[0]);
        var max_date = $('#activity_max_date').val().split('/');
        var max_date = new Date(max_date[2], max_date[1] - 1, max_date[0]);
        if(parseInt(activity_permission_type)!=1){
            $('#Activity_actual_date_2').datepicker('option', 'dateFormat', 'dd/mm/yy');
            $('#Activity_actual_date_2').datepicker('option', 'minDate', min_date);
        }
        $('#Activity_actual_date, #Activity_actual_date_1, #Activity_actual_date_3, #Activity_actual_date_4, #Activity_actual_date_5, #Activity_actual_date_6, #Activity_plan_date, #Activity_plan_date_1, #Activity_plan_date_2, #Activity_call_date, #Activity_callback_date').datepicker('option', 'dateFormat', 'dd/mm/yy');
        $('#Activity_actual_date, #Activity_actual_date_1, #Activity_actual_date_3, #Activity_actual_date_4, #Activity_actual_date_5, #Activity_actual_date_6, #Activity_plan_date, #Activity_plan_date_1, #Activity_plan_date_2, #Activity_call_date').datepicker('option', 'minDate', min_date);
        $('#Activity_callback_date').datepicker('option', 'minDate', max_date);
}", CClientScript::POS_HEAD);
$cs->registerScript("getactivitydetails", "function getactivitydetails(){
    $('#tbl_activity_details').DataTable().destroy();
        var type = $('#activity_type').val();
        filterDataTable(type);

};", CClientScript::POS_HEAD);
$cs->registerScript("deleteactivitydetails", "function deleteactivitydetails(id) {
            jQuery.ajax({
                'dataType':'json',
                'data' : {
                    'id':id
                },
                'type':'post',
                'url': '" . Yii::app()->createUrl('activity/deleteactivitydetails') . "',
                'cache': false,
                'success': function(data) {
                    t8.success('Deleted Saved Successfully!');
                    reloadTable('#tbl_activity_details');
                },
                'beforeSend': function(data) {
                    $('#loader').show();
                },
                'complete': function(data) {
                    $('#loader').hide();
                },
        });
    };", CClientScript::POS_HEAD)
?>
<script>
    // on ready function

    $(document).ready(function () {
        console.log("ready!");
        $('.datepicker').datepicker();
    });
</script>
