<?php

/**
 * This is the model class for table "{{user}}".
 *
 * The followings are the available columns in table '{{user}}':
 * @property integer $id
 * @property string $username
 * @property string $password
 * @property string $isActive
 *
 * The followings are the available model relations:
 * @property Company[] $companies
 * @property CompanyContact[] $companyContacts
 * @property CreditNote[] $creditNotes
 * @property DeliveryNotes[] $deliveryNotes
 * @property GoodsReturn[] $goodsReturns
 * @property Invoice[] $invoices
 * @property Lead[] $leads
 * @property MasterFile[] $masterFiles
 * @property Order[] $orders
 * @property Quotes[] $quotes
 * @property Store $store
 */
class User extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{user}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public $manager_self;
    public $asstmanager_self;
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('username,user_group_id,first_name,last_name,email,phno,commission_scheme_id', 'required'),
            array('password', 'required', 'on' => 'add'),
            array('username, first_name, last_name, email, designation,user_group_id, auth_code,commission_main,commission_sub,iris_main,iris_sub,deferment_main,deferment_sub', 'length', 'max' => 255),
            array('phno', 'length', 'max' => 255),
            array('manager_iris_main,manager_iris_sub,password_1,password_2,password_3', 'length', 'max' => 500),
            array('assistant_manager_id,manager_id,commission_scheme_id', 'numerical', 'integerOnly'=>true),
            array('consultant_edit,isActive', 'length', 'max' => 1),
            array('signature', 'length', 'max' => 5000),
            array('username', 'filter', 'filter' => 'trim'),
            array('username', 'unique'),
            //array('password', 'validatepassword'),
            //array('password', 'validatecuurentpassword'),
            array('commission_main,commission_sub,iris_main,iris_sub,deferment_main,deferment_sub', 'filter', 'filter' => 'trim'),
            //array('commission_main,commission_sub,iris_main,iris_sub,deferment_main,deferment_sub', 'unique'),
            
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, username, password, isActive,created_by,updated_by,created_datetime,updated_datetime', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'own_company' => array(self::BELONGS_TO, 'MasCompany', 'company_id'),
            'leads' => array(self::HAS_MANY, 'Lead', 'crm_user_id'),
            'manager' => array(self::BELONGS_TO, 'User', 'manager_id'),
            'assistantmanager' => array(self::BELONGS_TO, 'User', 'assistant_manager_id'),
            'designation_details' => array(self::BELONGS_TO, 'MasDesignation', 'designation'),
            'userGroup' => array(self::BELONGS_TO, 'MasUserGroup', 'user_group_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'username' => 'User Name',
            'password' => 'Password',
            'isActive' => 'Is Active',
            'user_group_id' => 'User Group ID',
            'phno' => 'Phone No.',
            'email' => 'E-mail',
            'first_name' => 'First Name',
            'last_name' => 'Last Name',
            'designation' => 'Designation',
            'auth_code' => 'auth_code',
            'signature' => 'signature',
            'created_date_time' => 'Created Date',
            'created_by' => 'Created By',
            'updated_date_time' => 'Last Updated Date',
            'updated_by' => 'Last Updated By',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;
        $criteria->addCondition('isActive="Y" AND id<>' . Yii::app()->user->id . ' AND  t.company_id=' . Yii::app()->user->master_user_company_id);
        /* if(Yii::app()->user->authorised_user==1)
          {
          $criteria->addCondition('isActive="Y" AND id<>' . Yii::app()->user->id . ' AND  t.company_id=' . Yii::app()->user->master_user_company_id);
          }
          else
          {
          $criteria->addCondition('isActive="Y" AND id<>' . Yii::app()->user->id . ' AND  t.company_id=' . Yii::app()->user->master_user_company_id.' AND  t.branch_id=' . Yii::app()->user->master_user_branch_id);
          } */

        return new CActiveDataProvider($this, array(
            'pagination' => array(
                'pageSize' => 5,
            ),
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.user_group_id ,t.username ASC',
            ),
        ));
    }
    public function validatepassword($attribute) {
            if($this->password!=''){
                $model_password_exist =User::model()->find(array('condition'=>'id="'.$this->id.'" AND (password_1="'.$this->password.'" OR password_2="'.$this->password.'" OR password_3="'.$this->password.'")'));

                if(empty($model_password_exist)) {
                    return true;         
                } else {           
                    $this->addError($attribute, 'Cannot use last three passwords');
                    return false; 
                }
            }else{
                return true;
            }
    }
    public function validatecuurentpassword($attribute) {
            if($this->password!=''){
                $model_password_exist =User::model()->find(array('condition'=>'id="'.$this->id.'" AND password="'.$this->password.'"'));
                if(empty($model_password_exist)) {
                    return true;         
                } else {           
                    $this->addError($attribute, 'Password same as old password');
                    return false; 
                }
            }else{
                return true;
            }
    }
    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return User the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    /**
     * Authenticates the password.
     * This is the 'authenticate' validator as declared in rules().
     */
    public function authenticate($attribute, $params) {
        if (!$this->hasErrors()) {
            $this->_identity = new UserIdentity($this->username, $this->password);
            if (!$this->_identity->authenticate())
                $this->addError('password', 'Incorrect username or password.');
        }
    }

    /**
     * Logs in the user using the given username and password in the model.
     * @return boolean whether login is successful
     */
    public function login() {
        if ($this->_identity === null) {
            $this->_identity = new UserIdentity($this->username, $this->password);
            $this->_identity->authenticate();
        }
        if ($this->_identity->errorCode === UserIdentity::ERROR_NONE) {
            $duration = $this->rememberMe ? 3600 * 24 * 30 : 0; // 30 days
            Yii::app()->user->login($this->_identity, $duration);
            return true;
        } else {
            return false;
        }
    }

    public function getFullname() {
        return ($this->first_name . ' ' . $this->last_name);
    }

    /* bfeore save function for password enecryption 
     * 
     */

//    function beforeSave() {
//        if (isset($_POST['User']['password']) && $_POST['User']['password'] != '') {
//            //START Code modified on 08-04-2016 for secured password
//            $salt = '$2a$10$1qAz2wSx3eDc4rFv5tGb5t';
//            $this->password = crypt($_POST['User']['password'], $salt);
//            //END Code modified on 08-04-2016 for secured password
//        }
//        return true;
//    }

    public static function getUsers($id=0) {
        $condition = 'isActive =  "Y" and level >0 and type= "IND"';
        if($id>0){
            $condition.=' AND id!='.$id;
        }
        $model = self::model()->findAll(array('condition' => $condition, 'order' => 't.first_name,t.username'));
        return CHtml::listData($model, 'id', 'fullname');
    }
    public static function getAllUsers() {
        $condition = 'isActive =  "Y"';
        $model = self::model()->findAll(array('condition' => $condition, 'order' => 't.first_name'));
        return CHtml::listData($model, 'id', 'fullname');
    }
    public static function getManagers() {
        $condition = 'isActive =  "Y" and user_group_id="2"';
        $model = self::model()->findAll(array('condition' => $condition, 'order' => 't.first_name'));
        return CHtml::listData($model, 'id', 'fullname');
    }
    public function getUserwithImg() {
        $model = self::model()->findAll(array( 'condition' => 'isActive = "Y"', 'order'=>'first_name'));
        $data = array();
        foreach( $model as $each )
                $data[$each->id] = array( 'data-image'=> '/insurance/images/executive.png');
        return $data;
    }
    public static function getUsersList() {
        $condition = 'isActive =  "Y" AND level > "0" and type= "IND"';
        $model = self::model()->findAll(array('condition' => $condition, 'order' => 't.first_name,t.username'));
        return CHtml::listData($model, 'id', 'fullname');
    }

    public function getName($id) {
        $model = User::model()->findByPk($id);
        return $model->first_name . " " . $model->last_name;
    }
    
    public static function getConnectedUsers($users) {
        if(empty($users)){
            $users  = 0;
        }
        $condition = 'id IN ( ' . $users .' )';
        $model = self::model()->findAll(array('condition' => $condition, 'order' => 't.first_name,t.username'));
        return CHtml::listData($model, 'id', 'fullname');
    }
    public static function getCompany(){
            $condition = 'isActive =  "Y" AND type="COM" ';
            return self::model()->find(array('condition' => $condition))->id;
    }
}
