<?php

/**
 * This is the model class for table "{{provider_send_receive_info}}".
 *
 * The followings are the available columns in table '{{provider_send_receive_info}}':
 * @property integer $id
 * @property integer $customer_id
 * @property integer $plan_id
 * @property string $send_or_receive
 * @property string $send_or_receive_date_time
 * @property string $expected_date_time
 * @property integer $send_method
 * @property string $send_method_details
 * @property string $notes
 * @property integer $created_by
 * @property string $created_datetime
 * @property integer $updated_by
 * @property string $updated_datetime
 */
class ProviderSendReceiveInfo extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{provider_send_receive_info}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('customer_id, plan_id, send_or_receive, send_or_receive_date_time, send_receive_type, send_method,  notes', 'required'),
			array('customer_id, plan_id,activity_id, send_method, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('send_or_receive', 'length', 'max'=>1),
			array('notes,send_method_details', 'length', 'max'=>5000),
			array('customer_name', 'length', 'max'=>255),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, customer_id, plan_id, send_or_receive, send_or_receive_date_time, expected_date_time, send_method, send_method_details, notes, created_by, created_datetime, updated_by, updated_datetime', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'customer_detail'=>array(self::BELONGS_TO,'Customer','customer_id'),
                    'send_method_detail'=>array(self::BELONGS_TO,'MasSendMethods','send_method'),
                    'plan_detail'=>array(self::BELONGS_TO,'CustomerPlanDetails','plan_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'customer_id' => 'Customer',
			'plan_id' => 'Plan',
			'send_or_receive' => 'Send Or Receive',
                        'send_receive_type'=>'Type',
			'send_or_receive_date_time' => 'Send Or Receive Date Time',
			'expected_date_time' => 'Expected Date Time',
			'send_method' => 'Send Method',
			'send_method_details' => 'Send Method Details',
			'notes' => 'Notes',
			'created_by' => 'Created By',
			'created_datetime' => 'Created Datetime',
			'updated_by' => 'Updated By',
			'updated_datetime' => 'Updated Datetime',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('customer_id',$this->customer_id);
		$criteria->compare('plan_id',$this->plan_id);
		$criteria->compare('send_or_receive',$this->send_or_receive,true);
		$criteria->compare('send_or_receive_date_time',$this->send_or_receive_date_time,true);
		$criteria->compare('expected_date_time',$this->expected_date_time,true);
		$criteria->compare('send_method',$this->send_method);
		$criteria->compare('send_method_details',$this->send_method_details,true);
		$criteria->compare('notes',$this->notes,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_datetime',$this->created_datetime,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_datetime',$this->updated_datetime,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return ProviderSendReceiveInfo the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
        public static function gettype($id) {  
            switch ($id) {     	
                case 'S':    	
                    $type = "Send";    
                    break;    	
                case 'R':  
                    $type = "Received";   
                    break; 
                default:    	
                    $type = "Send";  
            }    
            return $type;  
        }
}
