<?php

/**
 * This is the model class for table "{{policy_installment_details}}".
 *
 * The followings are the available columns in table '{{policy_installment_details}}':
 * @property integer $id
 * @property integer $cus_plan_id
 * @property integer $payment_term_id
 * @property string $start_date
 * @property string $end_date
 * @property integer $total_installments
 * @property integer $paid_installment_count
 * @property string $isActive
 */
class PolicyInstallmentDetails extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{policy_installment_details}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('cus_plan_id, payment_term_id, start_date, end_date, total_installments', 'required'),
			array('cus_plan_id, payment_term_id, total_installments, paid_installment_count', 'numerical', 'integerOnly'=>true),
			array('isActive', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, cus_plan_id, payment_term_id, start_date, end_date, total_installments, paid_installment_count, isActive', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'cus_plan_id' => 'Cus Plan',
			'payment_term_id' => 'Payment Term',
			'start_date' => 'Start Date',
			'end_date' => 'End Date',
			'total_installments' => 'Total Installments',
			'paid_installment_count' => 'Paid Installment Count',
			'isActive' => 'Is Active',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('cus_plan_id',$this->cus_plan_id);
		$criteria->compare('payment_term_id',$this->payment_term_id);
		$criteria->compare('start_date',$this->start_date,true);
		$criteria->compare('end_date',$this->end_date,true);
		$criteria->compare('total_installments',$this->total_installments);
		$criteria->compare('paid_installment_count',$this->paid_installment_count);
		$criteria->compare('isActive',$this->isActive,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return PolicyInstallmentDetails the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
