<?php

/**
 * This is the model class for table "{{master_commission_schemes}}".
 *
 * The followings are the available columns in table '{{master_commission_schemes}}':
 * @property integer $id
 * @property string $scheme_name
 * @property string $company_commission
 * @property string $manager_total_commision
 * @property string $manager_with_assitant_commission
 * @property string $assistant_manager_commission
 * @property string $executive_total_commission
 * @property string $executive_commission_without_deferment
 * @property string $executive_commission_with_deferment
 * @property string $excecutive_deferment_commission
 * @property string $executive_quarter_sale_commission
 * @property string $executive_annual_sale_commission
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class MasterCommissionSchemes extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{master_commission_schemes}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('scheme_name,company_commission, manager_total_commision, manager_with_assitant_commission, assistant_manager_commission, executive_total_commission, executive_commission_without_deferment, executive_commission_with_deferment, excecutive_deferment_commission, executive_quarter_sale_commission, executive_annual_sale_commission,manager_quarter_sale_commission,ass_manager_quarter_sale_commission,manager_annual_sale_commission,ass_manager_annual_sale_commission', 'required'),
			array('created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('scheme_name', 'length', 'max'=>255),
                        array('scheme_name', 'unique'),
			array('company_commission, manager_total_commision, manager_with_assitant_commission, assistant_manager_commission, executive_total_commission, executive_commission_without_deferment, executive_commission_with_deferment, excecutive_deferment_commission, executive_quarter_sale_commission, executive_annual_sale_commission', 'length', 'max'=>15),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, scheme_name, company_commission, manager_total_commision, manager_with_assitant_commission, assistant_manager_commission, executive_total_commission, executive_commission_without_deferment, executive_commission_with_deferment, excecutive_deferment_commission, executive_quarter_sale_commission, executive_annual_sale_commission, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'scheme_name' => 'Scheme Name',
			'company_commission' => 'Company Commission',
			'manager_total_commision' => 'Manager Total Commision',
			'manager_with_assitant_commission' => 'Manager With Assitant Commission',
			'assistant_manager_commission' => 'Assistant Manager Commission',
			'executive_total_commission' => 'Executive Total Commission',
			'executive_commission_without_deferment' => 'Executive Commission Without Deferment',
			'executive_commission_with_deferment' => 'Executive Commission With Deferment',
			'excecutive_deferment_commission' => 'Excecutive Deferment Commission',
			'executive_quarter_sale_commission' => 'Executive Quarter Sale Commission',
			'executive_annual_sale_commission' => 'Executive Annual Sale Commission',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('scheme_name',$this->scheme_name,true);
		$criteria->compare('company_commission',$this->company_commission,true);
		$criteria->compare('manager_total_commision',$this->manager_total_commision,true);
		$criteria->compare('manager_with_assitant_commission',$this->manager_with_assitant_commission,true);
		$criteria->compare('assistant_manager_commission',$this->assistant_manager_commission,true);
		$criteria->compare('executive_total_commission',$this->executive_total_commission,true);
		$criteria->compare('executive_commission_without_deferment',$this->executive_commission_without_deferment,true);
		$criteria->compare('executive_commission_with_deferment',$this->executive_commission_with_deferment,true);
		$criteria->compare('excecutive_deferment_commission',$this->excecutive_deferment_commission,true);
		$criteria->compare('executive_quarter_sale_commission',$this->executive_quarter_sale_commission,true);
		$criteria->compare('executive_annual_sale_commission',$this->executive_annual_sale_commission,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return MasterCommissionSchemes the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
        public static function getScheme() {
            $model = self::model()->findAll(array('order'=>'scheme_name'));
            return CHtml::listData($model, 'id', 'scheme_name');
        }
}
