<?php

/**
 * This is the model class for table "{{mas_plan_payment_terms}}".
 *
 * The followings are the available columns in table '{{mas_plan_payment_terms}}':
 * @property integer $id
 * @property string $payment_term
 * @property string $isActive
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class MasPlanPaymentTerms extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{mas_plan_payment_terms}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('payment_term,no_of_times', 'required'),
			array('id, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('payment_term', 'length', 'max'=>255),
			array('isActive', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, payment_term, isActive, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'payment_term' => 'Payment Term',
			'no_of_times'  => 'No of Times',
			'isActive' => 'Is Active',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('payment_term',$this->payment_term,true);
		$criteria->compare('isActive',$this->isActive,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return MasPlanPaymentTerms the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
	
	public static function getPlanPaymentTerms() {
        $condition = 'isActive =  "Y"';
        $model = self::model()->findAll(array('condition' => $condition,'order'=>'payment_term'));
        return CHtml::listData($model, 'id', 'payment_term');
    }
    //only use this function for, if you need no of times in combo 
    public static function getPlanPaymentTermsWithTimes() {
        $condition = 'isActive =  "Y"';
        $model = self::model()->findAll(array('condition' => $condition,'order'=>'payment_term'));
        return CHtml::listData($model, 'IdWithTimes', 'payment_term');
    }
    
    public function getIdWithTimes(){
        return ($this->id . '#' . $this->no_of_times);
    }
    
    public static function getPaymentTermIdWithTime($id) {
        $model = self::model()->findByPk($id);
        return $model->id."#".$model->no_of_times;
    }
}
