<?php

/**
 * This is the model class for table "{{mas_emirates}}".
 *
 * The followings are the available columns in table '{{mas_emirates}}':
 * @property integer $id
 * @property string $emirate_name
 * @property string $isActive
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class MasEmirates extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{mas_emirates}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('emirate_name,country_id', 'required'),
			array('created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('emirate_name,emirate_image', 'length', 'max'=>255),
			array('isActive', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, emirate_name, isActive, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		    'country'=>array(self::BELONGS_TO,'MasCountry','country_id')
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'emirate_name' => 'Emirate Name',
			'isActive' => 'Is Active',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	  public function search() {
        $criteria = new CDbCriteria;
        $searchterm = trim(Yii::app()->request->getParam('emirate_name'));
        //$criteria->addCondition('isActive =  "Y" AND company_id=' . Yii::app()->user->master_user_company_id, 'AND');
        $criteria->addCondition('isActive =  "Y"', 'AND');
        if (!empty($searchterm))
            $criteria->addCondition('emirate_name like "%' . $searchterm . '%"', 'AND');
        return new CActiveDataProvider($this, array(
            'pagination' => array(
                'pageSize' => 5,
            ),
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.emirate_name ASC',
            ),
        ));
    }

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return MasEmirates the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
	
	
	public static function getEmirates() {
        $condition = 'isActive =  "Y" AND country_id='.Yii::app()->user->default_billing_country_id;
        $model = self::model()->findAll(array('condition' => $condition,'order'=>'emirate_name'));
        return CHtml::listData($model, 'id', 'emirate_name');
    }
    public static function listImagePath() {
        $condition = 'isActive =  "Y" AND country_id='.Yii::app()->user->default_billing_country_id;
        $model = self::model()->findAll(array('condition' => $condition,'order'=>'emirate_name'));
        return CHtml::listData($model, 'id', 'imgdata');
    }
    public static function getEmiratewithImg() {
        $model = self::model()->findAll(array( 'condition' => 'isActive = "Y" AND country_id='.Yii::app()->user->default_billing_country_id, 'order'=>'emirate_name'));
        $data = array();
        foreach( $model as $each )
                $data[$each->id] = array( 'data-image'=> 'uploads/emirate/'.$each->emirate_image );
        return $data;
    }
}
