<?php

/**
 * This is the model class for table "{{execuitve_request}}".
 *
 * The followings are the available columns in table '{{execuitve_request}}':
 * @property integer $id
 * @property integer $customer_id
 * @property integer $executive_id
 * @property integer $request_executive_id
 * @property integer $approved_by
 * @property string $approved_date_time
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 * @property string $isActive
 */
class ExecutiveRequest extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{executive_request}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
        public $hold_date;
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('customer_id, executive_id, request_executive_id', 'required'),
			array('customer_id, executive_id, request_executive_id, approved_by, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('isActive', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, customer_id, executive_id, request_executive_id, approved_by, approved_date_time, created_by, created_date_time, updated_by, updated_date_time, isActive', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'customerdetails' => array(self::BELONGS_TO, 'Customer', 'customer_id'),
                    'oldexecutive' => array(self::BELONGS_TO, 'User', 'executive_id'),
                    'newexecutive' => array(self::BELONGS_TO, 'User', 'request_executive_id'),
                    'addedby' => array(self::BELONGS_TO, 'User', 'approved_by')
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'customer_id' => 'Customer',
			'executive_id' => 'Executive',
			'request_executive_id' => 'Request Executive',
			'approved_by' => 'Approved By',
			'approved_date_time' => 'Approved Date Time',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
			'isActive' => 'Is Active',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('customer_id',$this->customer_id);
		$criteria->compare('executive_id',$this->executive_id);
		$criteria->compare('request_executive_id',$this->request_executive_id);
		$criteria->compare('approved_by',$this->approved_by);
		$criteria->compare('approved_date_time',$this->approved_date_time,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);
		$criteria->compare('isActive',$this->isActive,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return ExecuitveRequest the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
