<?php

/**
 * This is the model class for table "{{executive_hold_commission}}".
 *
 * The followings are the available columns in table '{{executive_hold_commission}}':
 * @property integer $id
 * @property integer $commision_upload_id
 * @property integer $user_id
 * @property integer $customer_id
 * @property integer $provider_id
 * @property integer $mas_plan_id
 * @property string $user_account
 * @property integer $cus_plan_id
 * @property string $transaction_date
 * @property string $posted_date
 * @property string $type
 * @property string $description
 * @property string $total_amount
 * @property string $percentage
 * @property string $in_or_out
 * @property string $in_amount
 * @property string $out_amount
 * @property string $status
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class ExecutiveHoldCommission extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{executive_hold_commission}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('commision_upload_id, user_id, customer_id, provider_id, mas_plan_id, user_account, cus_plan_id, transaction_date, posted_date, type, description, total_amount, percentage, in_or_out, in_amount, out_amount, created_by, created_date_time', 'required'),
			array('commision_upload_id, user_id, customer_id, provider_id, mas_plan_id, cus_plan_id, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('user_account, in_or_out', 'length', 'max'=>3),
			array('type', 'length', 'max'=>11),
			array('description', 'length', 'max'=>500),
			array('total_amount, percentage, in_amount, out_amount', 'length', 'max'=>15),
			array('status', 'length', 'max'=>4),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, commision_upload_id, user_id, customer_id, provider_id, mas_plan_id, user_account, cus_plan_id, transaction_date, posted_date, type, description, total_amount, percentage, in_or_out, in_amount, out_amount, status, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'commissionfiledetails' => array(self::BELONGS_TO, 'CommissionUploaded', 'commision_upload_id'),
                    'userdetails' => array(self::BELONGS_TO, 'User', 'user_id'),
                    'customerplan' => array(self::BELONGS_TO, 'CustomerPlanDetails', 'cus_plan_id'),
                    'commission_customer' => array(self::BELONGS_TO, 'Customer', 'customer_id'),
                    'commission_provider' => array(self::BELONGS_TO, 'Provider', 'provider_id'),
                    'commission_masplan' => array(self::BELONGS_TO, 'MasProviderPlans', 'mas_plan_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'commision_upload_id' => 'Commision Upload',
			'user_id' => 'User',
			'customer_id' => 'Customer',
			'provider_id' => 'Provider',
			'mas_plan_id' => 'Mas Plan',
			'user_account' => 'User Account',
			'cus_plan_id' => 'Cus Plan',
			'transaction_date' => 'Transaction Date',
			'posted_date' => 'Posted Date',
			'type' => 'Type',
			'description' => 'Description',
			'total_amount' => 'Total Amount',
			'percentage' => 'Percentage',
			'in_or_out' => 'In Or Out',
			'in_amount' => 'In Amount',
			'out_amount' => 'Out Amount',
			'status' => 'Status',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('commision_upload_id',$this->commision_upload_id);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('customer_id',$this->customer_id);
		$criteria->compare('provider_id',$this->provider_id);
		$criteria->compare('mas_plan_id',$this->mas_plan_id);
		$criteria->compare('user_account',$this->user_account,true);
		$criteria->compare('cus_plan_id',$this->cus_plan_id);
		$criteria->compare('transaction_date',$this->transaction_date,true);
		$criteria->compare('posted_date',$this->posted_date,true);
		$criteria->compare('type',$this->type,true);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('total_amount',$this->total_amount,true);
		$criteria->compare('percentage',$this->percentage,true);
		$criteria->compare('in_or_out',$this->in_or_out,true);
		$criteria->compare('in_amount',$this->in_amount,true);
		$criteria->compare('out_amount',$this->out_amount,true);
		$criteria->compare('status',$this->status,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return ExecutiveHoldCommission the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
