<?php

/**
 * This is the model class for table "{{customer_priorities}}".
 *
 * The followings are the available columns in table '{{customer_priorities}}':
 * @property integer $id
 * @property integer $customer_id
 * @property integer $fa_welfare_priority
 * @property string $fa_welfare_required
 * @property string $fa_welfare_cur_provision
 * @property string $fa_welfare_short_fall
 * @property integer $ch_education_priority
 * @property string $ch_education_required
 * @property string $ch_education_cur_provision
 * @property string $ch_education_short_fall
 * @property integer $asp_dream_priority
 * @property string $asp_dream_required
 * @property string $asp_dream_cur_provision
 * @property string $asp_dream_short_fall
 * @property integer $ret_finance_priority
 * @property string $ret_finance_required
 * @property string $ret_finance_cur_provision
 * @property string $ret_finance_short_fall
 */
class CustomerPriorities extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{customer_priorities}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('fa_welfare_priority, ch_education_priority, asp_dream_priority, ret_finance_priority', 'required'),
			array('customer_id', 'numerical', 'integerOnly'=>true),
			array('fa_welfare_required, fa_welfare_cur_provision, fa_welfare_short_fall, ch_education_required, ch_education_cur_provision, ch_education_short_fall, asp_dream_required, asp_dream_cur_provision, asp_dream_short_fall, ret_finance_required, ret_finance_cur_provision, ret_finance_short_fall', 'length', 'max'=>15),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
                        array('isActive', 'length', 'max' => 1),
                        array('fa_welfare_priority, ch_education_priority, asp_dream_priority, ret_finance_priority', 'length', 'max'=>5),
			array('fa_welfare_priority', 'validateDuplicateProirty'),
                        array('id, customer_id, fa_welfare_priority, fa_welfare_required, fa_welfare_cur_provision, fa_welfare_short_fall, ch_education_priority, ch_education_required, ch_education_cur_provision, ch_education_short_fall, asp_dream_priority, asp_dream_required, asp_dream_cur_provision, asp_dream_short_fall, ret_finance_priority, ret_finance_required, ret_finance_cur_provision, ret_finance_short_fall', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                     'customer' => array(self::BELONGS_TO, 'Customer','customer_id')
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'customer_id' => 'Customer',
			'fa_welfare_priority' => 'Welfare Priority',
			'fa_welfare_required' => 'Welfare Required',
			'fa_welfare_cur_provision' => 'Welfare Cur Provision',
			'fa_welfare_short_fall' => 'Welfare Short Fall',
			'ch_education_priority' => 'Education Priority',
			'ch_education_required' => 'Education Required',
			'ch_education_cur_provision' => 'Education Cur Provision',
			'ch_education_short_fall' => 'Education Short Fall',
			'asp_dream_priority' => 'Dream Priority',
			'asp_dream_required' => 'Dream Required',
			'asp_dream_cur_provision' => 'Dream Cur Provision',
			'asp_dream_short_fall' => 'Dream Short Fall',
			'ret_finance_priority' => 'Finance Priority',
			'ret_finance_required' => 'Finance Required',
			'ret_finance_cur_provision' => 'Finance Cur Provision',
			'ret_finance_short_fall' => 'Finance Short Fall',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('customer_id',$this->customer_id);
		$criteria->compare('fa_welfare_priority',$this->fa_welfare_priority);
		$criteria->compare('fa_welfare_required',$this->fa_welfare_required,true);
		$criteria->compare('fa_welfare_cur_provision',$this->fa_welfare_cur_provision,true);
		$criteria->compare('fa_welfare_short_fall',$this->fa_welfare_short_fall,true);
		$criteria->compare('ch_education_priority',$this->ch_education_priority);
		$criteria->compare('ch_education_required',$this->ch_education_required,true);
		$criteria->compare('ch_education_cur_provision',$this->ch_education_cur_provision,true);
		$criteria->compare('ch_education_short_fall',$this->ch_education_short_fall,true);
		$criteria->compare('asp_dream_priority',$this->asp_dream_priority);
		$criteria->compare('asp_dream_required',$this->asp_dream_required,true);
		$criteria->compare('asp_dream_cur_provision',$this->asp_dream_cur_provision,true);
		$criteria->compare('asp_dream_short_fall',$this->asp_dream_short_fall,true);
		$criteria->compare('ret_finance_priority',$this->ret_finance_priority);
		$criteria->compare('ret_finance_required',$this->ret_finance_required,true);
		$criteria->compare('ret_finance_cur_provision',$this->ret_finance_cur_provision,true);
		$criteria->compare('ret_finance_short_fall',$this->ret_finance_short_fall,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return CustomerPriorities the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
        public function validateDuplicateProirty($attribute) {
            if ($this->fa_welfare_priority!=''&& $this->ch_education_priority!='' && $this->asp_dream_priority!='' && $this->ret_finance_priority!='') {
                $array_priority = array($this->fa_welfare_priority,$this->ch_education_priority,$this->asp_dream_priority,$this->ret_finance_priority);
                $array_without_napriority=array_diff($array_priority, array('NA'));
                if(count(array_unique($array_without_napriority))<count($array_without_napriority))
                {
                    $this->addError($attribute, 'Priority Duplicated, Please add distinct');
                    return false;
                }
                else
                {
                    return true;
                }
            }
           
        }
        public function getdateinformat() {
            return (date("d/m/Y",strtotime($this->start_date)));
        }
        public static function getPrioritydate($customer_id) {
            $condition = 'customer_id =  "'.$customer_id.'"';
            $model = self::model()->findAll(array('condition' => $condition,'order'=>'start_date desc'));
            return CHtml::listData($model, 'id', 'dateinformat');
        }
}
