<?php

/**
 * This is the model class for table "{{customer_plan_installments}}".
 *
 * The followings are the available columns in table '{{customer_plan_installments}}':
 * @property integer $id
 * @property integer $cus_plan_id
 * @property string $payment_due_date
 * @property integer $installment_no
 * @property string $premium_amount
 * @property string $paid_date
 * @property string $status
 * @property integer $created_by
 * @property string $created_date_time
 */
class CustomerPlanInstallments extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{customer_plan_installments}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('cus_plan_id, payment_due_date, installment_no, premium_amount', 'required'),
			array('cus_plan_id, installment_no, created_by', 'numerical', 'integerOnly'=>true),
			array('premium_amount,paid_date', 'length', 'max'=>15),
			array('status', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, cus_plan_id, payment_due_date, installment_no, premium_amount, paid_date, status, created_by, created_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'cusplandetail'=>array(self::BELONGS_TO,'CustomerPlanDetails','cus_plan_id'),
                    'customerpayment'=>array(self::BELONGS_TO,'CustomerPaymentDetails','cus_payment_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'cus_plan_id' => 'Cus Plan',
			'payment_due_date' => 'Payment Due Date',
			'installment_no' => 'Installment No',
			'premium_amount' => 'Premium Amount',
			'paid_date' => 'Paid Date',
			'status' => 'Status',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('cus_plan_id',$this->cus_plan_id);
		$criteria->compare('payment_due_date',$this->payment_due_date,true);
		$criteria->compare('installment_no',$this->installment_no);
		$criteria->compare('premium_amount',$this->premium_amount,true);
		$criteria->compare('paid_date',$this->paid_date,true);
		$criteria->compare('status',$this->status,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return CustomerPlanInstallments the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
