<?php

/**
 * This is the model class for table "{{customer_plan_details}}".
 *
 * The followings are the available columns in table '{{customer_plan_details}}':
 * @property integer $id
 * @property integer $customer_id
 * @property string $provider_id
 * @property string $plan_name
 * @property string $amount
 * @property integer $payment_term
 * @property string $annualized_premium
 */
class CustomerPlanDetails extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{customer_plan_details}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
        public $mobile_number,$provider_name,$plan_name,$class_name,$sub_class_name,$paymenttermname,$statusname;
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('customer_id, provider_id, plan_id, amount, payment_term, annualized_premium,tennure,policy_status', 'required'),
			array('customer_id, payment_term,plan_id', 'numerical', 'integerOnly'=>true),
			array('provider_id,policy_no,reason', 'length', 'max'=>255),
			array('amount, annualized_premium,start_date,policy_status', 'length', 'max'=>15),
			array('policy_status', 'validateStatus'),
                        array('policy_no', 'unique'),
                        array('customer_id, provider_id, plan_id, amount, payment_term, annualized_premium,tennure,policy_status', 'required', 'on' => 'excelupload'),
                        array('start_date', 'validatestartdate', 'on' => 'excelupload'),
                        array('issue_date', 'validatissuedate', 'on' => 'excelupload'),
                        // The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, customer_id, provider_id, plan_id, amount, payment_term, annualized_premium', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'providerdetails'=>array(self::BELONGS_TO,'Provider','provider_id'),
                    'masplandetails'=>array(self::BELONGS_TO,'MasProviderPlans','plan_id'),
                    'payterm_details'=>array(self::BELONGS_TO,'MasPlanPaymentTerms','payment_term'),
                    'customer'=>array(self::BELONGS_TO,'Customer','customer_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'customer_id' => 'Customer',
			'provider_id' => 'Provider Name',
			'plan_id' => 'Plan Name',
			'amount' => 'Amount',
			'payment_term' => 'Payment Term',
			'annualized_premium' => 'Annualized Premium',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
        public function validatestartdate($attribute) {
            if($this->start_date!=''){
                if(DateTime::createFromFormat('Y-m-d', $this->start_date) !== FALSE) {
                    return true;         
                } else {           
                    $this->addError($attribute, 'Not in YYYY-mm-dd Format');
                    return false; 
                }
            }else{
                return true;
            }
        }
        public function validatissuedate($attribute) {
            if($this->issue_date!=''){
                if(DateTime::createFromFormat('Y-m-d', $this->issue_date) !== FALSE) {
                    return true;         
                } else {           
                    $this->addError($attribute, 'Not in YYYY-mm-dd Format');
                    return false; 
                }
            }else{
                return true;
            }
        }
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('customer_id',$this->customer_id);
		$criteria->compare('provider_id',$this->provider_id,true);
		$criteria->compare('plan_id',$this->plan_id,true);
		$criteria->compare('amount',$this->amount,true);
		$criteria->compare('payment_term',$this->payment_term);
		$criteria->compare('annualized_premium',$this->annualized_premium,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
        public function validateStatus($attribute) {
            $status = $this->policy_status;
            if ($status!='O') {
                if($this->reason==''){
                    $this->addError($attribute, 'Reason Cannot Be Blank');
                    return false;
                }
            }
            else{
                return true;
            }     
        }
        public static function getStatusName($id) {  
            switch ($id) {     	
                case 'P':    	
                    $type = 'Pending';    
                    break;    	
                case 'O':  
                    $type = "InForce";   
                    break; 
                case 'L':  
                    $type = "Lapsed";   
                    break; 
                case 'U':  
                    $type = "Paid Up";   
                    break;
                case 'S':  
                    $type = "Surrender";   
                    break;
                case 'C':  
                    $type = "Benefit Claim";   
                    break;
                case 'M':  
                    $type = "Maturity";   
                    break;
                case 'N':  
                    $type = "NEF";   
                    break;
                case 'CN':  
                    $type = "Cancelled";   
                    break;
            }    
            return $type;  
        }
	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return CustomerPlanDetails the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
        //to get provider-planname of customer
        public function getproviderplanname() {
            return ($this->providerdetails->provider_name.' - '.$this->masplandetails->plan_name.' - '.$this->policy_no  );
        }
        public static function getPlansByCustomer($customer_id=0) {
            $condition = " 1=1 ";
            if($customer_id>0){
                $condition .= ' AND t.customer_id =' . $customer_id;
            }
            $model = self::model()->findAll(array('condition' => $condition, 'order' => 't.id DESC'));
            return CHtml::listData($model, 'id', 'providerplanname');
        }
        public static function getPlansWithPolicyByCustomer($customer_id=0) {
            $condition = " t.policy_no!='' AND t.start_date!='0000-00-00' AND t.policy_status IN('P','O','L','U') ";
            if($customer_id>0){
                $condition .= ' AND t.customer_id =' . $customer_id;
            }
            $model = self::model()->findAll(array('condition' => $condition, 'order' => 't.id DESC'));
            return CHtml::listData($model, 'id', 'providerplanname');
        }
        public static function getPlansNameById($id=0) {
            $model = self::model()->findBYPk($id);
            return $model->providerplanname;
        }
}
