<?php

/**
 * This is the model class for table "{{customer_payment_details}}".
 *
 * The followings are the available columns in table '{{customer_payment_details}}':
 * @property integer $id
 * @property integer $customer_id
 * @property integer $cus_plan_id
 * @property integer $payment_type
 * @property string $pay_amount
 * @property integer $installment_no
 * @property string $bank_name
 * @property string $pay_date
 * @property integer $expiry_date
 * @property string $status$installment_no
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class CustomerPaymentDetails extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{customer_payment_details}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
        public $paymentname,$statusname,$payment_due_date,$policy_number;
        public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('cus_plan_id,payment_type, pay_amount, installment_no, bank_name, pay_date, ac_no', 'required'),
			array('customer_id, cus_plan_id, payment_type,   created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('expiry_date,pay_amount', 'length', 'max'=>15),
			array('bank_name,installment_no,ac_no', 'length', 'max'=>255),
			array('status', 'length', 'max'=>1),
			array('status', 'validateStatus'),
                        array('payment_type', 'validatePaymentType'),
                        array('payment_type, pay_amount, installment_no, bank_name, pay_date, ac_no', 'required', 'on' => 'excelupload'),
                        array('customer_id', 'required','message'=>'Policy Details doesnot exist'),
                        array('payment_due_date', 'validatepaymentduedate', 'on' => 'excelupload'),
                        array('pay_date', 'validatepaymentdate', 'on' => 'excelupload'),
                        array('expiry_date', 'validateexpirydate', 'on' => 'excelupload'),
                        array('realization_date', 'validatechequedate', 'on' => 'excelupload'),
                        // The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, customer_id, cus_plan_id, payment_type, pay_amount, installment_no, bank_name, pay_date, expiry_date, status, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'cus_details'=>array(self::BELONGS_TO,'Customer','customer_id'),
                    'cus_plan_details'=>array(self::BELONGS_TO,'CustomerPlanDetails','cus_plan_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'customer_id' => 'Customer',
			'cus_plan_id' => 'Plan',
			'payment_type' => '1-cheque,2-creditcard,3-banktransfer',
			'pay_amount' => 'Pay Amount',
			'installment_no' => 'Installment No',
			'bank_name' => 'Bank Name',
			'pay_date' => 'Pay Date',
			'expiry_date' => 'Card Type',
			'ac_no' => 'A/c /Card/Cheque No.',
			'status' => '1->completed,2->inprocess,3->cancelled,4->returned',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('customer_id',$this->customer_id);
		$criteria->compare('cus_plan_id',$this->cus_plan_id);
		$criteria->compare('payment_type',$this->payment_type);
		$criteria->compare('pay_amount',$this->pay_amount,true);
		$criteria->compare('installment_no',$this->installment_no);
		$criteria->compare('bank_name',$this->bank_name,true);
		$criteria->compare('pay_date',$this->pay_date,true);
		$criteria->compare('expiry_date',$this->expiry_date);
		$criteria->compare('status',$this->status,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
        public function validatepaymentduedate($attribute) {
            if($this->payment_due_date!=''){
                if(DateTime::createFromFormat('Y-m-d', $this->payment_due_date) !== FALSE) {
                    return true;         
                } else {           
                    $this->addError($attribute, 'Due Date Not in YYYY-mm-dd Format');
                    return false; 
                }
            }else if($this->payment_due_date==''){        
                    $this->addError($attribute, 'Due Date Cannot be blank');
                    return false; 
            }
        }
        public function validatepaymentdate($attribute) {
            if($this->pay_date!=''){
                if(DateTime::createFromFormat('Y-m-d', $this->pay_date) !== FALSE) {
                    return true;         
                } else {           
                    $this->addError($attribute, 'Payment Date Not in YYYY-mm-dd Format');
                    return false; 
                }
            }else if($this->pay_date==''){        
                    $this->addError($attribute, 'Payment Date Cannot be blank');
                    return false; 
            }
        }
        public function validateexpirydate($attribute) {
            if($this->expiry_date!='' && $this->payment_type==2){
                if(DateTime::createFromFormat('Y-m-d', $this->expiry_date) !== FALSE) {
                    return true;         
                } else {           
                    $this->addError($attribute, 'Expiry Date Not in YYYY-mm-dd Format');
                    return false; 
                }
            }else if($this->expiry_date=='' && $this->payment_type==2){         
                    $this->addError($attribute, 'Expiry Date cannot be blank');
                    return false;
            }else{
                return true;
            }
        }
        public function validatechequedate($attribute) {
            if($this->realization_date!='' && $this->payment_type==1 && $this->status==1){
                if(DateTime::createFromFormat('Y-m-d', $this->realization_date) !== FALSE) {
                    return true;         
                } else {           
                    $this->addError($attribute, 'Realisation Date Not in YYYY-mm-dd Format');
                    return false; 
                }
            }else if($this->realization_date=='' && $this->payment_type==1 && $this->status==1){         
                    $this->addError($attribute, 'Realisation Date cannot be blank');
                    return false;
            }else{
                return true;
            }
        }
	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return CustomerPaymentDetails the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
        public static function getPaymentType($id) {  
            switch ($id) {     	
                case '1':    	
                    $type = "Cheque";    
                    break;    	
                case '2':  
                    $type = "Credit Card";   
                    break; 
                case '3':  
                    $type = "Bank Transfer";   
                    break; 
                
            }    
            return $type;  
        }
        public static function getStatusName($id) {  
            switch ($id) {     	
                case 'P':    	
                    $type = 'Pending';    
                    break;    	
                case 'O':  
                    $type = "InForce";   
                    break; 
                case 'L':  
                    $type = "Lapsed";   
                    break; 
                case 'U':  
                    $type = "Paid Up";   
                    break;
                case 'S':  
                    $type = "Surrender";   
                    break;
                case 'C':  
                    $type = "Benefit Claim";   
                    break;
                case 'M':  
                    $type = "Maturity";   
                    break;
            }    
            return $type;  
        }
        public static function getPaymentStatus($id) {  
            switch ($id) {     	
                case '1':    	
                    $type = "Completed";    
                    break;    	
                case '2':  
                    $type = "InProcess";   
                    break; 
                case '3':  
                    $type = "Bounced";   
                    break; 
                case '4':  
                    $type = "Returned";   
                    break;
            }    
            return $type;  
        }
    public function validateStatus($attribute) {
        $status = $this->status;
        if ($status=='1') {
            if($this->realization_date==''){
                $this->addError($attribute, 'Realization Date is Mandatory');
                return false;
            }
        }
        else{
            return true;
        }     
    }
    public function validatePaymentType($attribute) {
        $payment_type = $this->payment_type;
        if ($payment_type=='2') {
            if($this->expiry_date==''){
                $this->addError($attribute, 'Expiry Date is Mandatory');
                return false;
            }
        }
        else{
            return true;
        }  
    }
}
