<?php

/**
 * This is the model class for table "{{commission_uploaded}}".
 *
 * The followings are the available columns in table '{{commission_uploaded}}':
 * @property integer $id
 * @property integer $customer_plan_id
 * @property string $policy_no
 * @property integer $provider_id
 * @property string $provider_name
 * @property integer $customer_id
 * @property string $customer_name
 * @property string $type
 * @property string $commission_amount
 * @property string $commission_date
 * @property string $uploaded_document_name
 * @property integer $created_by
 * @property string $created_date_time
 */
class CommissionUploaded extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{commission_uploaded}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('policy_no, provider_id, provider_name,customer_name, type, commission_amount, commission_date, uploaded_document_name, created_by, created_date_time', 'required'),
			array('customer_plan_id, provider_id, customer_id, created_by', 'numerical', 'integerOnly'=>true),
			array('policy_no', 'length', 'max'=>200),
                        array('commission_date', 'validatecommissiondate'),
                        array('customer_plan_id', 'required','message'=>'Policy Details doesnot exist'),
			array('provider_name, customer_name, uploaded_document_name', 'length', 'max'=>500),
			array('type', 'length', 'max'=>50),
//			array('commission_amount', 'length', 'max'=>10),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, customer_plan_id, policy_no, provider_id, provider_name, customer_id, customer_name, type, commission_amount, commission_date, uploaded_document_name, created_by, created_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'customerdetails' => array(self::BELONGS_TO, 'Customer', 'customer_id'),
                    'providerdetails' => array(self::BELONGS_TO, 'Provider', 'provider_id'),
                    'customerplan' => array(self::BELONGS_TO, 'CustomerPlanDetails', 'customer_plan_id'),
                    'userdetails' => array(self::BELONGS_TO, 'User', 'created_by'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'customer_plan_id' => 'Customer Plan',
			'policy_no' => 'Policy No',
			'provider_id' => 'Provider',
			'provider_name' => 'Provider Name',
			'customer_id' => 'Customer',
			'customer_name' => 'Customer Name',
			'type' => 'Type',
			'commission_amount' => 'Commission Amount',
			'commission_date' => 'Commission Date',
			'uploaded_document_name' => 'Uploaded Document Name',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('customer_plan_id',$this->customer_plan_id);
		$criteria->compare('policy_no',$this->policy_no,true);
		$criteria->compare('provider_id',$this->provider_id);
		$criteria->compare('provider_name',$this->provider_name,true);
		$criteria->compare('customer_id',$this->customer_id);
		$criteria->compare('customer_name',$this->customer_name,true);
		$criteria->compare('type',$this->type,true);
		$criteria->compare('commission_amount',$this->commission_amount,true);
		$criteria->compare('commission_date',$this->commission_date,true);
		$criteria->compare('uploaded_document_name',$this->uploaded_document_name,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return CommissionUploaded the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
        public function validatecommissiondate($attribute) {
            if($this->commission_date!=''){
                if(DateTime::createFromFormat('Y-m-d', $this->commission_date) !== FALSE) {
                    return true;         
                } else {           
                    $this->addError($attribute, 'Transaction Date Not in YYYY-mm-dd Format');
                    return false; 
                }
            }else if($this->commission_date==''){         
                    $this->addError($attribute, 'Transaction Date cannot be blank');
                    return false;
            }else{
                return true;
            }
        }
//        public function validatecommissiondate($attribute) {
//            $date = $this->commission_date;
//            if (preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/", $date)) {
//                return true;
//            } else {
//                $this->addError($attribute, 'Not in YYYY-mm-dd Format');
//                return false;
//            }
//        }
}
