<?php

/**
 * This is the model class for table "{{activity}}".
 *
 * The followings are the available columns in table '{{activity}}':
 * @property integer $id
 * @property integer $customer_id
 * @property integer $type_of_activity
 * @property string $call_or_plan_date_time
 * @property string $call_back_or_actual_date
 * @property integer $duration
 * @property integer $manager_id
 * @property string $activity_notes
 * @property integer $created_by
 * @property string $created_datetime
 * @property integer $updated_by
 * @property string $updated_datetime
 * @property string $isActive
 */
class Activity extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{activity}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
        public $call_date;
        public $call_time;
        public $callback_date;
        public $callback_time;
        public $plan_date;
        public $plan_time;
        public $actual_date;
        public $actual_time;
        public $plan_date_1;
        public $plan_time_1;
        public $actual_date_1;
        public $actual_time_1;
        public $plan_date_2;
        public $plan_time_2;
        public $actual_date_2;
        public $actual_time_2;      
        public $actual_date_3;
        public $actual_time_3;
        public $actual_date_4;
        public $actual_time_4;
        public $actual_date_5;
        public $actual_time_5,$actual_date_6,$actual_date_7,$actual_time_6,$plan_id_1,$factfind_date,$factfind_time;
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('type_of_activity', 'required'),
			array('customer_id,lead_customer_id,plan_id, type_of_activity, duration, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('isActive', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, customer_id, type_of_activity, call_or_plan_date_time, call_back_or_actual_date, duration, manager_id, activity_notes, created_by, created_datetime, updated_by, updated_datetime, isActive', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'customerdetails' => array(self::BELONGS_TO, 'Customer', 'customer_id'),
                    'leadcustomerdetails' => array(self::BELONGS_TO, 'LeadCustomer', 'lead_customer_id'),
                    'addedby' => array(self::BELONGS_TO, 'User', 'created_by'),
                    'plan_detail'=>array(self::BELONGS_TO,'CustomerPlanDetails','plan_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'customer_id' => 'Customer',
			'type_of_activity' => 'Type Of Activity',
			'call_or_plan_date_time' => 'Call Or Plan Date Time',
			'call_back_or_actual_date' => 'Call Back Or Actual Date',
			'duration' => 'Duration',
			'manager_id' => 'Manager',
			'activity_notes' => 'Activity Notes',
			'created_by' => 'Created By',
			'created_datetime' => 'Created Datetime',
			'updated_by' => 'Updated By',
			'updated_datetime' => 'Updated Datetime',
			'isActive' => 'Is Active',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('customer_id',$this->customer_id);
		$criteria->compare('type_of_activity',$this->type_of_activity);
		$criteria->compare('call_or_plan_date_time',$this->call_or_plan_date_time,true);
		$criteria->compare('call_back_or_actual_date',$this->call_back_or_actual_date,true);
		$criteria->compare('duration',$this->duration);
		$criteria->compare('manager_id',$this->manager_id);
		$criteria->compare('activity_notes',$this->activity_notes,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_datetime',$this->created_datetime,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_datetime',$this->updated_datetime,true);
		$criteria->compare('isActive',$this->isActive,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Activity the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
         public static function gettype($id) {  
            switch ($id) {     	
                case 1:    	
                    $type = "Call";    
                    break;    	
                case 2:  
                    $type = "Appointment";   
                    break; 
                case 3:  
                    $type = "Joint Field Visit";   
                    break;
                case 4:  
                    $type = "Fact Find";   
                    break;
                case 5:  
                    $type = "Presentation";   
                    break;
                case 6:  
                    $type = "Application";   
                    break;
                case 7:  
                    $type = "Review Meeting";   
                    break;
                case 8:  
                    $type = "Fact Find Note";   
                    break;
                case 9:  
                    $type = "Client Verification";   
                    break;
                case 10:  
                    $type = "Policy Receipt to Customer";   
                    break;
                case 11:  
                    $type = "Handedover to Executive";   
                    break;
                case 12:  
                    $type = "Welcome Call";   
                    break;
                default:    	
                    $type = "Call";  
            }    
            return $type;  
        }
}
