<?php
class SiteController extends Controller {
    /**
     * Declares class-based actions.
     */
    public function actions() {
        return array(
			// captcha action renders the CAPTCHA image displayed on the contact page
            'captcha' => array(
                'class' => 'CCaptchaAction',
                'backColor' => 0xFFFFFF,
            ),
            // page action renders "static" pages stored under 'protected/views/site/pages'
			// They can be accessed via: index.php?r=site/page&view=FileName
            'page' => array(
                'class' => 'CViewAction',
            ),
        );
    }
    
     public function init() {
        parent::init();
        $this->initAjaxCsrfToken();
    }

    // this function will work to post csrf token.
    protected function initAjaxCsrfToken() {

        Yii::app()->clientScript->registerScript('AjaxCsrfToken', ' $.ajaxSetup({
                         data: {"' . Yii::app()->request->csrfToken . '": "' . Yii::app()->request->csrfToken . '"},
                         cache:false
                    });', CClientScript::POS_HEAD);
    }
    
    
        public function accessRules() {

        return array(

                array('allow', // allow all users to perform 'index' and 'view' actions

                  'actions' => array('login', 'error', 'logout','newlogin'),

                  'users' => array('*'),

                  ),

                array('allow', // allow authenticated user to perform 'create' and 'update' actions

                  'actions' => array('Index','ChangePassword','UpdatePassword','GetAllDetailsForProduct', 'Openbal', 'AdjustQty','Profile','ResetPassword'),

                  'expression' => '$user->isMember()',

                  ),

                array('deny', // deny all users

                  'users' => array('*'),

                  ),

                );

    }


    /**
     * This is the default 'index' action that is invoked
     * when an action is not explicitly requested by users.
     */
    public function actionIndex() {
        $user_id=Yii::app()->user->id;
        $model_user=User::model()->findByPk($user_id);
        $this->render('//dashboard/index',array('model_user'=>$model_user));
    }
    public function actionProfile() {
        $user_id=Yii::app()->user->id;
        $model_user=User::model()->findByPk($user_id);
        $this->render('index',array('model_user'=>$model_user));
    }
    public function actionNewLogin() {
        Yii::app()->user->logout();
        $model = new LoginForm;
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('login_new',array('model'=>$model));
    }
    
    public function actionChangePassword() {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('changepassword');
    }
    public function actionResetPassword() {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('resetpassword');
    }
    public function actionUpdatePassword() {
        $curr_pwd      = $_POST['user_current_password'];
        $new_pwd       = $_POST['user_new_password'];
        $rep_pwd       = $_POST['user_reenter_password'];
        $login_user_id = Yii::app()->user->id;
        $arr_user_details= User::model()->findByPk($login_user_id);
        $old_pasword=$arr_user_details->password;
        $salt       = '$2a$10$1qAz2wSx3eDc4rFv5tGb5t';
        $password   = crypt($_POST['user_current_password'], $salt);
        $new_password   = crypt($_POST['user_new_password'], $salt);
        if($arr_user_details->password == $new_password){
            $json['status'] = "oldpassword";
        }else if($arr_user_details->password == $password){
            $arr_user_details->password_last_updated=date('Y-m-d');
            $arr_user_details->password=$new_password;
            $arr_user_details->save(false);
            Yii::app()->session->clear();
            Yii::app()->session->destroy();
            $json['status'] = "success";
        }
        else
        {  
            $json['status'] = "fail";
        }
        echo CJSON::encode($json);
    }
    public function actionGetAllDetailsForProduct(){
        $product_id     = $_POST['product_id'];
        $customer_id    = $_POST['customer_id'];
        $modelCustomer = new Customer();
        $arr_customer_details = $modelCustomer->findByPk($customer_id);
        
        
        $sales_pricing_group_id = $arr_customer_details->sales_pricing_group;
        
        
        $model = new SalesPriceGroup();
        $arr_price_details = $model->find(array('condition'=>'product_id='.$product_id));
       
        $price = $arr_price_details->sales_price1;
        
        
        $jsonData['price'] = number_format(floatval($price), 2, '.', '');
        echo CJSON::encode($jsonData);
        Yii::app()->end();
        
    }

    public function actionOpenbal(){
        $sql = 'SELECT SUM(in_qty)-SUM(out_qty) AS net_qty, product_id FROM `crm_stock_ledger` WHERE transaction_date BETWEEN "2014-01-01" AND "2018-12-31" GROUP BY product_id';
        $mod_stock_till 	= Yii::app()->db->createCommand($sql)->queryAll();
        foreach(  $mod_stock_till  as $each ){
                //if($ledger_qty > 0){
                    $product_location = ProductLocation::model()->find(array('condition' => 'stock_id = '.$each['product_id']));
                    if($product_location->id > 0){
                        ProductLocation::model()->updateBypk($product_location->id,array('updated_by' => 2,'quantity' => $product_location->quantity + $each['net_qty']));
                    }else{
                        $loc = new ProductLocation;
                        $loc->stock_id = $each['product_id'];
                        $loc->warehouse_id = 1;
                        $loc->is_default_warehouse_id = "Y";
                        $loc->quantity = $ledger_qty;
                        $loc->save(false);
                    }
                //}
            }
       
    }
    public function actionAdjustQty(){
        $store = Store::model()->findAll();
        foreach ( $store as $each ){
            $trans = Yii::app()->db->createCommand('SELECT SUM(in_qty) - SUM(out_qty) FROM `crm_stock_ledger` WHERE product_id ='.$each->id)->queryScalar();
            $old_qty = Yii::app()->db->createCommand('SELECT SUM(quantity) FROM  crm_product_location WHERE stock_id='.$each->id)->queryScalar();
            if( $trans > 0){
                $open = new OpeningBalance;
                $open->product_id = $each->id;
                $bal =  $old_qty -  abs($trans) ;
                $open->opening_quantity =  $bal;
                $open->rate = 0;
                $open->total_value = 0;
                $open->save(false);
            }else{
                $open = new OpeningBalance;
                $open->product_id = $each->id;
                $bal =  $old_qty +  abs($trans) ;
                $open->opening_quantity =  $bal;
                $open->rate = 0;
                $open->total_value = 0;
                $open->save(false);
            }

        }
    }

}
