<?php

class ProviderinfoController extends Controller {

    /**
     * Declares class-based actions.
     */
    public function accessRules() {

        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('CreateSend', 'CreateReceive', 'SaveSendInfo', 'GetProviderInfoHistory'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    /**
     * This is the default 'index' action that is invoked
     * when an action is not explicitly requested by users.
     */
    public function actionIndex() {
        $this->render('index');
    }

    /** ---Sending Information to Provider about Sended documents */

    public function actionCreateSend() {
        date_default_timezone_set("Asia/Dubai");
        $id = (int) Yii::app()->request->getParam('id');
        $customer_id = (int) Yii::app()->request->getParam('customer_id');
        $activity_id = (int) Yii::app()->request->getParam('activity_id');
        $plan_id = (int) Yii::app()->request->getParam('plan_id');
        $model = new ProviderSendReceiveInfo();
        if ($id > 0) {
            $model = $model->findByPk($id);
            if ($model->send_or_receive_date_time != '0000-00-00 00:00:00') {
                $model->send_or_receive_date_time = date("d/m/Y H:i", strtotime($model->send_or_receive_date_time));
            }
            if ($model->expected_date_time != '0000-00-00 00:00:00') {
                $model->expected_date_time = date("d/m/Y H:i", strtotime($model->expected_date_time));
            }
        } else {
            $model->send_or_receive = 'S';
            $model->send_or_receive_date_time = date("d/m/Y H:i");
        }
        if ($customer_id > 0) {
            $model->customer_id = $customer_id;
            $model->customer_name = Customer::model()->findByPk($customer_id)->Fullname;
        }
        //Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
        Yii::app()->clientScript->scriptMap = array('jquery.js' => false, 'jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false, 'jquery.datetimepicker.full.min.js' => false);
        $this->render('create_send', array('model' => $model,'activity_id'=>$activity_id,'plan_id'=>$plan_id));
    }

    /** ---Receive Information from Provider about Sended documents */
    public function actionCreateReceive() {
        date_default_timezone_set("Asia/Dubai");
        $id = (int) Yii::app()->request->getParam('id');
        $customer_id = (int) Yii::app()->request->getParam('customer_id');
        $activity_id = (int) Yii::app()->request->getParam('activity_id');
        $plan_id = (int) Yii::app()->request->getParam('plan_id');
        $model = new ProviderSendReceiveInfo();
        if ($id > 0) {
            $model = $model->findByPk($id);
            if ($model->send_or_receive_date_time != '0000-00-00 00:00:00') {
                $model->send_or_receive_date_time = date("d/m/Y H:i", strtotime($model->send_or_receive_date_time));
            }
        } else {
            $model->send_or_receive = 'R';
            $model->send_or_receive_date_time = date("d/m/Y H:i");
        }
        if ($customer_id > 0) {
            $model->customer_id = $customer_id;
            $model->customer_name = Customer::model()->findByPk($customer_id)->Fullname;
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
        $this->render('create_receive', array('model' => $model,'activity_id'=>$activity_id,'plan_id'=>$plan_id));
    }

    /** For Saving Provider send and receive information* */
    public function actionSaveSendInfo() {
        date_default_timezone_set("Asia/Dubai");
        $model = new ProviderSendReceiveInfo();
        if (isset($_POST['ProviderSendReceiveInfo'])) {
            if ($_POST['ProviderSendReceiveInfo']['id'] > 0) {
                $id = $_POST['ProviderSendReceiveInfo']['id'];
                $model = $model->findByPK($id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_datetime = date('Y-m-d H:i:s');
            } else {
                $model->created_by = Yii::app()->user->id;
                $model->created_datetime = date('Y-m-d H:i:s');
            }
            $model->attributes = $_POST['ProviderSendReceiveInfo'];
            if ($_POST['ProviderSendReceiveInfo']['send_or_receive_date_time'] != '') {
                $model->send_or_receive_date_time = str_replace('/', '-', $_POST['ProviderSendReceiveInfo']['send_or_receive_date_time']);
                $model->send_or_receive_date_time = date("Y-m-d H:i:s", strtotime($model->send_or_receive_date_time));
            }
            if ($_POST['ProviderSendReceiveInfo']['expected_date_time'] != '') {
                $model->expected_date_time = str_replace('/', '-', $_POST['ProviderSendReceiveInfo']['expected_date_time']);
                $model->expected_date_time = date("Y-m-d H:i:s", strtotime($model->expected_date_time));
            }
            $activity_id= $_POST['ProviderSendReceiveInfo']['activity_id'];
            $send_receive_type = $_POST['ProviderSendReceiveInfo']['send_receive_type'];
            $valid = $model->validate();
            if ($valid) {
                $model->save();
                if($send_receive_type==2){
                        Activity::model()->updateByPk($activity_id, array('application_status' => 'C'));   
                }
                $jsonData['status'] = 'success';
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
            } else {
                $error2 = array();
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                $error = CJSON::encode(array_merge_recursive($error1, $error2));
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    /** For loading Provider send and receive information* */
    public function actionGetProviderInfoHistory() {
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $model = new ProviderSendReceiveInfo();
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'actual_date',
            2 => 'send_or_receive',
            3 => 'plan_id',
            4 => 'notes',
            5 => '',
            6 => '',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $customer_id = (int) Yii::app()->request->getParam('customer_id');
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.customer_id=' . $customer_id;
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
           // $condition .= " AND (masplandetails.plan_name LIKE '%" . $searchString . "%' )";
        }
        $sql="CREATE OR REPLACE VIEW view_provider_info_details AS 
               select A.id AS id,A.plan_id AS plan_id,'' as send_or_receive,'' as send_method_details,'' as send_receive_type,A.activity_notes AS notes,A.customer_id AS customer_id,A.call_back_or_actual_date AS actual_date,'1' AS type from (crm_activity A join crm_customer C on(A.customer_id=C.id)) where A.type_of_activity=6 AND customer_id='".$customer_id."'
               union 
               select D.id AS id,D.plan_id AS plan_id,D.send_or_receive AS send_or_receive,D.send_method_details AS send_method_details,D.send_receive_type as send_receive_type,D.notes AS notes,D.customer_id AS customer_id,D.send_or_receive_date_time AS actual_date,'2' AS type from (crm_provider_send_receive_info D join crm_customer B on(D.customer_id=B.id)) where customer_id='".$customer_id."'
               order by actual_date asc"; 
        Yii::app()->db->createCommand($sql)->execute();         
        $model=Yii::app()->db->createCommand('select * from view_provider_info_details where customer_id="'.$customer_id.'" order by actual_date asc')->queryAll();
        $count=  count($model);
        
        //$count = $model->with('plan_detail','plan_detail.masplandetails')->count(array('condition' => $condition));
        //$model = $model->with('plan_detail','plan_detail.masplandetails')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $i = 1;
        foreach ($model as $row) {
            $div = '';
            $date = date("d/m/Y H:i", strtotime($row['actual_date']));
            $type='';
            if($row['type']==1){
                $type='Application';
            }else{
                $type = ($row['send_or_receive'] == 'S') ? 'Send' : 'Receive';
            }
            $model_customer=Customer::model()->findByPk($row['customer_id']);
            if (isset(Yii::app()->user->havePermissionOn['prospects_customers_send_view'])) {
                if ($row['send_or_receive'] == 'S') {
                    $div = '<button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'providerinfo/createsend&id=' . $row['id'] . '&customer_id=' . $row['customer_id'] . '\',\'' .$model_customer->Fullname. ' - Send Info Provider ' . '\',\'xl\')"><i class="fa fa-edit"></i></button>';
                } 
            }
            if (isset(Yii::app()->user->havePermissionOn['prospects_customers_receive_view'])) {
                if ($row['send_or_receive'] == 'R') {
                   $div = '<button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'providerinfo/createreceive&id=' . $row['id'] . '&customer_id=' . $row['customer_id'] . '\',\'' .$model_customer->Fullname. ' - Receive Info Provider ' . '\',\'xl\')"><i class="fa fa-edit"></i></button>';
                }
            }
            $model_plan_details=CustomerPlanDetails::model()->findByPk($row['plan_id']);
            $model_mas_send_receive_type=MasSendReceiveType::model()->findByPk($row['send_receive_type']);    
            $rowData[] = array($i, $date, $type, $model_plan_details->masplandetails->plan_name, $row['send_method_details'],$row['notes'],$model_mas_send_receive_type->type_name, '<div class="btn-wrap text-center">' . $div . '</div>');
            $i++;
        }

        $data['data'] = $rowData;
        echo json_encode($data);
    }
    /** For loading Provider send and receive information End* */
    
}
