<?php

class ExecutiveController extends Controller {

    /**
     * Declares class-based actions.
     */
    public function accessRules() {

        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index','GetList','Approve','SaveStatus','checkplanexist','Activity','GetActivityList'
                    ),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    /**
     * This is the default 'index' action that is invoked
     * when an action is not explicitly requested by users.
     */
    public function actionIndex() {
        $this->render('index');
    }

    public function actionGetList() {
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $model = new ExecutiveRequest();
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 'customer_id',
            2 => 'executive_id',
            3 => 'request_executive_id',
            4 => '',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.status="0"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " AND (customerdetails.cust_first_name LIKE '%" . $searchString . "%' OR customerdetails.cust_middle_name LIKE '%" . $searchString . "%' OR customerdetails.cust_last_name LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('customerdetails','oldexecutive','newexecutive')->count(array('condition' => $condition));
        $model = $model->with('customerdetails','oldexecutive','newexecutive')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        foreach ($model as $row) {
            $div= '<button class="btn btn-primary btn-xs" title="Activity Details" onclick="loadPopupModal(\'executive/activity&customer_id=' . $row['customer_id'] . '&executive=' . $row['executive_id'] . '\',\'Activity\',\'lg\')"><i class="fa fa-certificate"></i></button>&nbsp;';   
            $div.= '<button class="btn btn-primary btn-xs" title="Approve" onclick="loadPopupModal(\'executive/approve&id=' . $row['id'] . '\',\'Approve\',\'lg\')"><i class="fa fa-thumbs-up"></i></button>&nbsp;';   
            $rowData[] = array($row['id'], $row['customerdetails']['Fullname'], $row['oldexecutive']['fullname'], $row['newexecutive']['fullname'], '<div class="btn-wrap text-center">' . $div . '</div>');
        }

        $data['data'] = $rowData;
        echo json_encode($data);
    }
     public function actionApprove() {
        $id = (int) Yii::app()->request->getParam('id');
        $model = new ExecutiveRequest();
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        //Activity-start
        $model_activity = Activity::model()->find(array('condition' =>'customer_id="'.$model->customer_id.'" and created_by="'.$model->executive_id.'"','order'=>'id desc'));
        //Activity-end
        //Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
        Yii::app()->clientScript->scriptMap = array('jquery.js' => false, 'jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
        $this->render('approve', array('model' => $model,'model_activity' => $model_activity));
    }
    public function actionSaveStatus() {
        if (isset($_POST['ExecutiveRequest'])) {
            $model = new ExecutiveRequest();
            if ((int) @$_POST['ExecutiveRequest']['id'] > 0) {
                $model->id = (int) $_POST['ExecutiveRequest']['id'];
                $model = $model->findByPK($model->id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d h:i:s');
            }else{
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d h:i:s');
            }
            $model->status = $_POST['ExecutiveRequest']['status'];
            $status=$_POST['ExecutiveRequest']['status'];;
            $model->approved_by = Yii::app()->user->id;
            $model->approved_date_time =date('Y-m-d h:i:s');
            $model->remarks = $_POST['ExecutiveRequest']['remarks'];
            if ($model->validate()) {
                $model->save();
                $cust_locked_date='';
                $cust_executive_id='';
                if($status==1 || $status==3){
                    if($status==1){
                        $cust_locked_date=date('Y-m-d', strtotime('+90 days', strtotime(date('Y-m-d'))));
                        $cust_executive_id=$model->request_executive_id;
                    }else if($status==3){
                        if (isset($_POST['ExecutiveRequest']['hold_date']) && $_POST['ExecutiveRequest']['hold_date'] != '') {
                            $cust_locked_date= str_replace('/', '-', $_POST['ExecutiveRequest']['hold_date']);
                            $cust_locked_date= date("Y-m-d", strtotime($cust_locked_date));
                            $cust_executive_id=$model->executive_id;
                        }
                    }
                    Customer::model()->updateByPK($model->customer_id, array('cust_locked_date' =>$cust_locked_date,'cust_executive_id' =>$cust_executive_id,'cust_executive_change_request' =>'N'));
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    //Check plan exist-Start
    public function actioncheckplanexist() {
        $id=Yii::app()->request->getParam('id');
        $model_customer= Customer::model()->findbyPK($id);
        if($model_customer->cust_policy_taken=="Y"){
            $jsonData['status'] = 'error';
        }else{
            $jsonData['status'] = 'success';
        }
        echo CJSON::encode($jsonData);
    }
    //Check plan exist-End
    //Executive Activity Details-Start
    public function actionActivity() {
        $customer_id= (int) Yii::app()->request->getParam('customer_id');
        $executive= (int) Yii::app()->request->getParam('executive');
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
        $this->render('activity_details',array('customer_id'=>$customer_id,'executive'=>$executive));
    }
    //Executive Activity Details-End
       //Start Activity List
    public function actionGetActivityList(){
        $model=new Activity();
        $draw    = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $id= $_POST['id'];
        $customer_id= $_POST['customer_id'];
        $executive_id= $_POST['executive_id'];
        $type= $_POST['type'];
        $columns = array(
            0 =>'id',
            1 =>'type_of_activity',
            2 =>'call_or_plan_date_time',
            3 =>'call_back_or_actual_date',
            4 =>'activity_notes',
            5=>'created_by',
            6=>'created_datetime',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy   = $filterColumn." ".$filterOrder;
        $condition = 't.customer_id="'.$customer_id.'" and created_by="'.$executive_id.'"';    
        if($type>0){
            $condition.= ' AND t.type_of_activity="'.$type.'"';
        }
        if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
        {
          $searchString = $_POST['search']['value'];
          $condition =" (activity_notes LIKE '%".$searchString."%')";
        }
        $count = $model->count(array('condition'=>$condition));
        $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData=array();
        $m=1;
        foreach ($model as $row)
        {
            $button_string="";                  
            $call_or_plan_date_time="";
            if($row['call_or_plan_date_time']!='' && $row['call_or_plan_date_time']!='0000-00-00 00:00:00'){
                $call_or_plan_date_time=date("d/m/Y H:i",strtotime($row->call_or_plan_date_time));
            }
            $call_back_or_actual_date="";
            if($row->type_of_activity!=1){
                if($row['call_back_or_actual_date']!='' && $row['call_back_or_actual_date']!='0000-00-00 00:00:00'){
                    $call_back_or_actual_date=date("d/m/Y H:i",strtotime($row->call_back_or_actual_date));
                }
            }
            $created_datetime="";
            if($row['created_datetime']!='' && $row['created_datetime']!='0000-00-00 00:00:00'){
                $created_datetime=date("d/m/Y h:i:s a",strtotime($row->created_datetime));
            }
            $name=$row->addedby->first_name.' '.$row->addedby->last_name;
            $rowData[]=array($m,Activity::gettype($row->type_of_activity),$call_or_plan_date_time,$call_back_or_actual_date,$row['activity_notes'],$name,$created_datetime,$button_string);
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
     //End Activity List
}
