<?php

class CustomeruploadController extends Controller
{
	public function accessRules() {
        return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                    'actions' => array('login', 'error', 'logout'),
                    'users' => array('*'),
                    ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                    'actions' => array('uploadCustomer','Upload','Downloadformat','SaveUploadCsv','readCSVfile','DownloadErrorCsv'),
                    'expression' => '$user->isMember()',
                    ),
                array('deny', // deny all users
                    'users' => array('*'),
                    ),
                );
    }
    public function filters()
    {
        return array(
            'accessControl', // perform access control for CRUD operations
            );
    }
    /**
     * This is the default 'index' action that is invoked
     * when an action is not explicitly requested by users.
     */
    public function actionuploadCustomer(){	 
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('upload_customer');
    }
    public function actionSaveUploadCsv() {
        $file_name = Yii::app()->request->getParam('filename');         
       // $url = Yii::app()->basePath . '/../uploads/customerdetails/' . $file_name;
          $url = 'uploads/customerdetails/' . $file_name;
         //$error_url = Yii::app()->basePath . '/../uploads/customerdetails/error/' . $file_name;
        $error_url = 'uploads/customerdetails/error/' . $file_name;
        $file = fopen($url, "r");
        $data = fgetcsv($file);
        $validate=TRUE;
        $validate1=TRUE;
        $error_list = array();
        $error_list_customer= array();
        $error_list_priority= array();
        $mobile_error = array();
       
        $customer_list = Yii::app()->controller->readCSVfile("uploads/customerdetails/" . $file_name);
       // print_r($customer_list);
        foreach (array_slice($customer_list, 1) as $i => $data) {
            if($data[0]!=''||$data[1]!=''||$data[2]!=''||$data[3]!=''||$data[4]!=''||$data[5]!=''||$data[6]!=''||$data[7]!=''||$data[8]!='' ||$data[9]!='' ||$data[10]!='' ||$data[11]!='' ||$data[12]!='' ||$data[13]!=''
                    ||$data[14]!='' ||$data[15]!='' ||$data[16]!='' ||$data[17]!='' ||$data[18]!='' ||$data[19]!=''){
            $model_customer[$i] = new Customer();
            $model_customer[$i]->scenario="excelupload";		
            if($data[0]!=''){
                $model_customer[$i]->cust_first_name = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[0]), '"'));
                               
            }else{                    
                $model_customer[$i]->cust_first_name = '';
            }
            if($data[1]!=''){
                $model_customer[$i]->cust_middle_name = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[1]), '"'));
                               
            }else{                    
                $model_customer[$i]->cust_middle_name = '';
            }
            if($data[2]!=''){
                $model_customer[$i]->cust_last_name = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[2]), '"'));
                               
            }else{                    
                $model_customer[$i]->cust_last_name = '';
            }
            
            //echo $data[3];exit;
            if($data[3]!=''){
                $model_customer[$i]->cust_date_of_birth =trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[3]), '"'));
                               
            }else{                    
                $model_customer[$i]->cust_date_of_birth = '';
            }
            if($data[4]!=''){
                $gend=  strtoupper(trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[4]), '"')));
                $gender=1;
                $status='';
                if($gend=='MALE' || $gend==1){
                    $gender=1;
                }else if($gend=='MALE' || $gend==2){
                    $gender=2;
                }
                $model_customer[$i]->cust_gender =$gender;
                               
            }else{                    
                $model_customer[$i]->cust_gender = '';
            }
            $model_customer[$i]->gender = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[4]), '"'));       
            $country_code='';
            if($data[5]!=''){
                $condition = '((REPLACE(`country_name`, " ", "") LIKE "%'.str_replace(' ', '', trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[5]), '"'))).'%" OR REPLACE(`country_code`, " ", "") LIKE "%'.str_replace(' ', '', trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[5]), '"'))).'%" OR id LIKE "%'.$data[5].'%"))';        
                $model_country[$i] = MasCountry::model()->find(array('condition' => $condition));
                $model_customer[$i]->cust_country_code = $model_country[$i]->id;
                $country_code=$model_country[$i]->phone_code;
            }else{
                $model_customer[$i]->cust_country_code = '';
            }
            $model_customer[$i]->cont = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[5]), '"')); 
            if($data[6]!=''){
                $condition = '((REPLACE(`emirate_name`, " ", "") LIKE "%'.str_replace(' ', '', trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[6]), '"'))).'%" OR id LIKE "%'.$data[6].'%"))';        
                $model_emirate[$i] = MasEmirates::model()->find(array('select' =>'id','condition' => $condition));
                $model_customer[$i]->cust_emirate_id = $model_emirate[$i]->id;
            }else{
                $model_customer[$i]->cust_emirate_id = '';
            }
            $model_customer[$i]->emt = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[6]), '"'));
            if($data[7]!=''){
                $condition = '((REPLACE(`country_name`, " ", "") LIKE "%'.str_replace(' ', '', trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[7]), '"'))).'%" OR REPLACE(`country_code`, " ", "") LIKE "%'.str_replace(' ', '', trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[7]), '"'))).'%" OR id LIKE "%'.$data[7].'%"))';        
                $model_nationaliy[$i] = MasCountry::model()->find(array('select' =>'id','condition' => $condition));
                $model_customer[$i]->cust_nationality_id = $model_nationaliy[$i]->id;
            }else{
                $model_customer[$i]->cust_nationality_id = '';
            }
            $model_customer[$i]->nat = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[7]), '"'));
            if($data[8]!=''){
                $model_customer[$i]->cust_phone_no =trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[8]), '"'));
                               
            }else{                    
                $model_customer[$i]->cust_phone_no = '';
            } 
            if($data[9]!=''){
                $mobile_number= trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[9]), '"'));
                $model_customer[$i]->cust_mobile1 =$country_code."-".$mobile_number;      
                $model_customer[$i]->mobile_number =$mobile_number;
                $mobile_error[$i] = $mobile_number;
            }else{                    
                $model_customer[$i]->cust_mobile1 = '';
            }        
            if($data[10]!=''){
                $model_customer[$i]->cust_email1 =trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[10]), '"'));
                               
            }else{                    
                $model_customer[$i]->cust_email1 = '';
            }
            if($data[11]!=''){
                $condition = '((REPLACE(`marital_status`, " ", "") LIKE "%'.str_replace(' ', '', trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[11]), '"'))).'%"))';        
                $model_marital[$i] = MasMaritalStatus::model()->find(array('select' =>'id','condition' => $condition));
                $model_customer[$i]->cust_marital_status = $model_marital[$i]->id;
            }else{
                $model_customer[$i]->cust_marital_status = '';
            }
            $model_customer[$i]->mt_status = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[11]), '"'));
            if($data[12]!=''){
                $condition = '((REPLACE(`health_status`, " ", "") LIKE "%'.str_replace(' ', '', trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[12]), '"'))).'%"))';        
                $model_health[$i] = MasHealthStatus::model()->find(array('select' =>'id','condition' => $condition));
                $model_customer[$i]->cust_health = $model_health[$i]->id;
            }else{
                $model_customer[$i]->cust_health = '';
            }
            $model_customer[$i]->health = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[12]), '"')); 
            if($data[13]!=''){
                $cust_smoker =strtoupper(trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[13]), '"')));
                $status='';
                if($cust_smoker=='YES' || $cust_smoker=='Y'){
                    $status='Y';
                }else if($cust_smoker=='NO' || $cust_smoker=='N'){
                    $status='N';
                }
                $model_customer[$i]->cust_smoker =$status;
            }else{
                $model_customer[$i]->cust_smoker = '';
            }
            if($data[14]!=''){
                $customer_source_prospect =trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[14]), '"'));
                $source='';
                if($customer_source_prospect=='Referral'){
                    $source=1;
                }else if($customer_source_prospect=='Network'){
                    $source=2;
                }else if($customer_source_prospect=='Website'){
                    $source=3;
                }else if($customer_source_prospect=='Advertisement'){
                    $source=4;
                }
                $model_customer[$i]->cust_prospect_source=$source;
                $model_customer[$i]->source =$customer_source_prospect;               
            }else{                    
                $model_customer[$i]->cust_prospect_source = '';
            }         
            if($data[15]!=''){
                $condition = '((REPLACE(CONCAT(first_name," ",last_name), " ", "") LIKE "%'.str_replace(' ', '', trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[15]), '"'))).'%"))';        
                $model_user[$i] = User::model()->find(array('select' =>'id','condition' => $condition));
                $model_customer[$i]->cust_executive_id = $model_user[$i]->id;
            }else{
                $model_customer[$i]->cust_executive_id = '';
            } 
            $model_customer[$i]->exec = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[15]), '"')); 
            $model_customer[$i]->created_by= Yii::app()->user->id;  
            $model_customer[$i]->created_date_time = date('Y-m-d h:i:s');
            $model_customer[$i]->cust_policy_taken ='Y';
            //$model_customer[$i]->cust_locked_date = date('Y-m-d', strtotime('+90 days', strtotime(date('Y-m-d'))));            
            $validate = $model_customer[$i]->validate() && $validate; 
            //Priority 
            $model_customer_priority[$i] = new CustomerPriorities();
            $model_customer_priority[$i]->scenario="excelupload";
            if($data[16]!=''){
                $model_customer_priority[$i]->fa_welfare_priority =trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[16]), '"'));
                               
            }else{                    
                $model_customer_priority[$i]->fa_welfare_priority = '';
            } 
            if($data[17]!=''){
                $model_customer_priority[$i]->ch_education_priority =trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[17]), '"'));
                               
            }else{                    
                $model_customer_priority[$i]->ch_education_priority = '';
            } 
            if($data[18]!=''){
                $model_customer_priority[$i]->asp_dream_priority =trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[18]), '"'));
                               
            }else{                    
                $model_customer_priority[$i]->asp_dream_priority = '';
            } 
            if($data[19]!=''){
                $model_customer_priority[$i]->ret_finance_priority =trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[19]), '"'));
                               
            }else{                    
                $model_customer_priority[$i]->ret_finance_priority = '';
            } 
            $model_customer_priority[$i]->created_by = Yii::app()->user->id;
            $model_customer_priority[$i]->created_date_time = date('Y-m-d H:i:s');
            $model_customer_priority[$i]->start_date=date('Y-m-d');
            $validate1 = $model_customer_priority[$i]->validate() && $validate1; 
            
            }
        }
        function array_not_unique($raw_array) {
            $dupes = array();
            natcasesort($raw_array);
            reset($raw_array);

            $old_key   = NULL;
            $old_value = NULL;
            foreach ($raw_array as $key => $value) {
                if ($value === NULL) { continue; }
                if (strcasecmp($old_value, $value) === 0) {
                    $dupes[$old_key] = $old_value;
                    $dupes[$key]     = $value;
                }
                $old_value = $value;
                $old_key   = $key;
            }
            return $dupes;
        }
        $mobilenumber_common = array_not_unique($mobile_error);        
        if ($validate && empty($mobilenumber_common) && $validate1){					
            if (!empty($model_customer)) {
                foreach ($model_customer as $s=>$eachModel) {                            
                    $eachModel->save();
                    //Priority Save
                    $model_priority= new CustomerPriorities();
                    $model_priority->fa_welfare_priority =$model_customer_priority[$s]->fa_welfare_priority;
                    $model_priority->ch_education_priority =$model_customer_priority[$s]->ch_education_priority;
                    $model_priority->asp_dream_priority =$model_customer_priority[$s]->asp_dream_priority;
                    $model_priority->ret_finance_priority =$model_customer_priority[$s]->ret_finance_priority;
                    $model_priority->created_by = Yii::app()->user->id;
                    $model_priority->created_date_time = date('Y-m-d H:i:s');
                    $model_priority->start_date=date('Y-m-d');
                    $model_priority->customer_id=$eachModel->id;
                    $model_priority->save();
                    //Activity
                    $model_fact_find = new Activity();
                    $model_fact_find->created_by = Yii::app()->user->id;
                    $model_fact_find->created_datetime = date('Y-m-d h:i:s');
                    $model_fact_find->call_back_or_actual_date =date("Y-m-d H:i:s");
                    $model_fact_find->customer_id=$eachModel->id;
                    $model_fact_find->type_of_activity=4;
                    $model_fact_find->activity_notes='Family and Welfare-'.$model_priority->fa_welfare_priority.',Children University Education-'.$model_priority->ch_education_priority.',Aspiration and Dreams-'.$model_priority->asp_dream_priority.',Financial Freedom at Retirement-'.$model_priority->ret_finance_priority;
                    $model_fact_find->save();
                }
                $jsonData['status'] = "success";
            }	
        } else {			
            if (!empty($model_customer)) {
                foreach ($model_customer as $s => $data_model) { 
                    $error_list_customer[$s]['cust_first_name'] =$data_model['cust_first_name'];
                    $error_list_customer[$s]['cust_middle_name'] =$data_model['cust_middle_name'];
                    $error_list_customer[$s]['cust_last_name'] =$data_model['cust_last_name'];
                    $error_list_customer[$s]['cust_date_of_birth']  =$data_model['cust_date_of_birth'];
                    $error_list_customer[$s]['gender']   =$data_model['gender'];
                    $error_list_customer[$s]['cust_country_code']  =$data_model['cont'];
                    $error_list_customer[$s]['cust_emirate_id'] =$data_model['emt'];
                    $error_list_customer[$s]['cust_nationality_id']    =$data_model['nat'];
                    $error_list_customer[$s]['cust_phone_no']      =$data_model['cust_phone_no'];
                    $error_list_customer[$s]['cust_mobile1']      =$data_model['mobile_number'];
                    $error_list_customer[$s]['cust_email1']      =$data_model['cust_email1'];
                    $error_list_customer[$s]['cust_marital_status'] =$data_model['mt_status'];
                    $error_list_customer[$s]['cust_health']      =$data_model['health'];
                    $error_list_customer[$s]['cust_smoker']      =$data_model['cust_smoker'];
                    $error_list_customer[$s]['source']      =$data_model['source'];
                    $error_list_customer[$s]['executive']      =$data_model['exec'];
                    if($data_model->validate()){
                        $error_list_customer[$s]['remarks']     ="Customers Details Correct";
                    }else{
                        $error_list_customer[$s]['remarks']     =$data_model->getErrors();	
                    }
                }
            }
            
            if (!empty($model_customer_priority)) {
                foreach ($model_customer_priority as $s => $data_model) { 
                    $error_list_priority[$s]['priority1']      =$data_model['fa_welfare_priority'];
                    $error_list_priority[$s]['priority2']      =$data_model['ch_education_priority'];
                    $error_list_priority[$s]['priority3']      =$data_model['asp_dream_priority'];
                    $error_list_priority[$s]['priority4']      =$data_model['ret_finance_priority'];
                    if($data_model->validate()){
                        $error_list_priority[$s]['remarks_1']     =" Priority Details Correct"; 
                    }else{
                        $error_list_priority[$s]['remarks_1']     =$data_model->getErrors();	
                    }
                }
            }	
            
            for($s=0;$s<count($error_list_customer);$s++){
                $error_list[$s]['cust_first_name']=$error_list_customer[$s]['cust_first_name'];
                $error_list[$s]['cust_middle_name']=$error_list_customer[$s]['cust_middle_name'];
                $error_list[$s]['cust_last_name']=   $error_list_customer[$s]['cust_last_name'];
                $error_list[$s]['cust_date_of_birth']=  $error_list_customer[$s]['cust_date_of_birth'];
                $error_list[$s]['gender']=  $error_list_customer[$s]['gender'];
                $error_list[$s]['cust_country_code']=  $error_list_customer[$s]['cust_country_code'];
                $error_list[$s]['cust_emirate_id']=  $error_list_customer[$s]['cust_emirate_id'];
                $error_list[$s]['cust_nationality_id']=  $error_list_customer[$s]['cust_nationality_id'];
                $error_list[$s]['cust_phone_no']=  $error_list_customer[$s]['cust_phone_no'];
                $error_list[$s]['cust_mobile1']=  $error_list_customer[$s]['cust_mobile1'];
                $error_list[$s]['cust_email1']=  $error_list_customer[$s]['cust_email1'];
                $error_list[$s]['cust_marital_status']=  $error_list_customer[$s]['cust_marital_status'];
                $error_list[$s]['cust_health']=$error_list_customer[$s]['cust_health'];
                $error_list[$s]['cust_smoker']=$error_list_customer[$s]['cust_smoker'];
                $error_list[$s]['source']=  $error_list_customer[$s]['source'];
                $error_list[$s]['executive']=  $error_list_customer[$s]['executive'];
                $error_list[$s]['priority1']=$error_list_priority[$s]['priority1'];
                $error_list[$s]['priority2']=$error_list_priority[$s]['priority2'];
                $error_list[$s]['priority3']=$error_list_priority[$s]['priority3'];
                $error_list[$s]['priority4']=$error_list_priority[$s]['priority4'];
                $remarks='';
                if(!empty($error_list_customer[$s]['remarks'])){
                    foreach($error_list_customer[$s]['remarks'] as $p => $error_value){						
                        $remarks .= $error_value[0]." / ";	

                    }
                }
                if(!empty($error_list_priority[$s]['remarks_1'])){
                    foreach($error_list_priority[$s]['remarks_1'] as $p => $error_value){						
                        $remarks .= ' '.$error_value[0]." / ";	

                    }
                }
                $error_list[$s]['remarks']=$remarks;
            }
            $jsonData['status'] = "error";            
	}				
              		 
	$j=0;
        fclose($file);        
        $list = array();        
        if(!empty($error_list)){
            $file_error = fopen($error_url, "w+");
            $list[$j++] = 'First Name,Middle Name,Last Name,Date of Birth(YYYY-mm-dd),Gender,Country Code,Emirate Name,Nationality,Phone,Mobile(Without Country Code),Personal Mail,Marital Status,Fitness,Smoker,Prospect Source,Executive Name,Family and Welfare,Children University Education,Aspiration and Dreams,Financial Freedom at Retirement,Remarks';
            foreach ($error_list as $i => $error_detail) {			
                if(!empty($error_detail)){
                    if (in_array($error_detail['cust_mobile1'], $mobilenumber_common)){
                        $error_detail['remarks'] .= " Mobile number Duplicated/";
                    }	                
                    $list[$j++] = $error_detail['cust_first_name']. ',' .$error_detail['cust_middle_name']. ',' .$error_detail['cust_last_name']. ',' .$error_detail['cust_date_of_birth']. ','.$error_detail['gender']. ',' .$error_detail['cust_country_code']. ',' .$error_detail['cust_emirate_id']. ',' .$error_detail['cust_nationality_id']. ',' .$error_detail['cust_phone_no'] . ',' .$error_detail['cust_mobile1'].',' .$error_detail['cust_email1'] . ',' .$error_detail['cust_marital_status'] . ',' .$error_detail['cust_health'] . ',' .$error_detail['cust_smoker'] . ',' .$error_detail['source'] . ',' .$error_detail['executive']. ',' .$error_detail['priority1']. ',' .$error_detail['priority2']. ',' .$error_detail['priority3']. ',' .$error_detail['priority4']. ',' .$error_detail['remarks'];
                }
            }
            foreach ($list as $line) {
                fputcsv($file_error, explode(',', $line));
            }
            fclose($file_error);
        }
		

        $jsonData['error_url'] = $error_url;
        $jsonData['filename'] = $file_name;
        $jsonData['link'] = CHtml::link('Download log', array('customerupload/DownloadErrorCsv', 'file_name'=>$file_name), array('target' => '_blank',
            'style'=>'border: 1px solid #686869;padding: 2px 10px;border-radius: 10px;font-size: 10px;background: #a1a1a1;color: #fff;'
            . ''
            ));
        echo CJSON::encode($jsonData);
    }
    public function actionDownloadErrorCsv() {
        $file_name =Yii::app()->request->getParam('file_name');
        $error_url = Yii::app()->basePath . '/../uploads/customerdetails/error/' . $file_name;
        return Yii::app()->getRequest()->sendFile('log.csv', @file_get_contents($error_url));
    }
    public function actionDownloadformat() {
        $error_url = Yii::app()->basePath . '/../uploads/customerdetails/customeruploadformat.csv';
        return Yii::app()->getRequest()->sendFile('uploadformat.csv', @file_get_contents($error_url));
    }
    
}