<?php
class CommissionController extends Controller {

    /**
     * Declares class-based actions.
     */
    public function accessRules() {

        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index','GetlistforCalculation','ViewList','CalculateCommision','EditList','downloadcommissionfile','ViewcommissionList',
                                    'Deletecommissionfile','DeletecalculatedCommission'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    /**
     * This is the default 'index' action that is invoked
     * when an action is not explicitly requested by users.
     */
    public function actionIndex() {
        $this->render('index');
    }
    
    //addtoCommissionLedger-start
    public function addtoCommissionLedger($id) {
        $model_commission = new CommissionUploaded();
        if($id>0){
            $model_commission = $model_commission->findByPK($id);
            $cus_plan_id      = $model_commission->customer_plan_id;
            $upload_amount    = $model_commission->commission_amount;
            $upload_date      = $model_commission->commission_date;
            $user_id          = $model_commission->customerdetails->cust_executive_id;
            $icp_months       = $model_commission->customerplan->icp_months;
            $provider_id =$model_commission->provider_id;
            $customer_id=$model_commission->customer_id;
            $mas_plan_id=$model_commission->customerplan->plan_id;
            $upload_type=$model_commission->type;
            $scheme_id        = User::model()->findByPK($user_id)->commission_scheme_id;
            $mas_commission   = MasterCommissionSchemes::model()->findByPK($scheme_id);
            if($upload_amount>0){
                //save provider given whole amount to commision ledger
                $desc='Commission from '.$model_commission->providerdetails->provider_name.' for  Policy No.'.$model_commission->policy_no;
                $this->savetoCommissionLedger($id, User::getCompany(),$model_commission->customer_plan_id,$upload_date,100,
                                                 $upload_amount,$upload_amount,0,'PRO_ISSUE',$desc,'IN','GEN',$provider_id,$customer_id,$mas_plan_id,'NA');           
                //save general vat to commision ledger            
                $vat_percent=$model_commission->customerplan->masplandetails->general_vat;
                $vat_amount=$upload_amount*$vat_percent/100;
                $vat_amount=number_format($vat_amount, 6, '.', '');
                $desc='VAT for Policy No.'.$model_commission->policy_no.' ('.$vat_percent.' % of '.$upload_amount.')';
                $this->savetoCommissionLedger($id,User::getCompany(),$model_commission->customer_plan_id,$upload_date,$vat_percent,
                                                $upload_amount,0,$vat_amount,'VAT_OUT',$desc,'OUT','GEN',$provider_id,$customer_id,$mas_plan_id,'NA');
                //save amount deducting vat to commision ledger            
                $net_amount=$upload_amount-$vat_amount;
                $this->savetoCommissionLedger($id,User::getCompany(),$model_commission->customer_plan_id,$upload_date,$vat_percent,
                                                $upload_amount,$vat_amount,0,'VAT_IN',$desc,'IN','VAT',$provider_id,$customer_id,$mas_plan_id,'NA');
                //update totals to user company
                $model_comp= User::model()->findbyPK(User::getCompany());
                $account_balance=$model_comp->account_total_amount+$upload_amount-$vat_amount;
                $account_vat=$model_comp->account_vat_amount+$vat_amount;
                User::model()->updateByPK(User::getCompany(), array('account_total_amount' =>$account_balance,'account_vat_amount' =>$account_vat,'updated_by'=>Yii::app()->user->id,'updated_date_time'=>date('Y-m-d H:i:s')));
                //save commision amount of executive to commision ledger 
                    $exec_defer_com_amount=0;
                    if($icp_months<12 || $upload_type!='NB'){//if not a deferment plan add full commission to excecutive account
                        //executive commission
                        $exec_com = $mas_commission->executive_commission_without_deferment;
                        $exec_com_amount=$net_amount*$exec_com/100;
                        $exec_com_amount=number_format($exec_com_amount, 6, '.', '');
                        $desc='Executive Commission for Policy No.'.$model_commission->policy_no.' ('.$exec_com.' % of '.$net_amount.')';
                        $this->savetoCommissionLedger($id,User::getCompany(),$model_commission->customer_plan_id,$upload_date,$exec_com,
                                                    $net_amount,0,$exec_com_amount,'EXE_COM',$desc,'OUT','GEN',$provider_id,$customer_id,$mas_plan_id,'NA');
                        
                        $this->savetoCommissionLedger($id,$user_id,$model_commission->customer_plan_id,$upload_date,$exec_com,
                                                    $net_amount,$exec_com_amount,0,'EXE_COM',$desc,'IN','GEN',$provider_id,$customer_id,$mas_plan_id,'NA');
                 
                    }else{
                        //executive commission
                        $exec_com = $mas_commission->executive_commission_with_deferment;
                        $exec_com_amount=$net_amount*$exec_com/100;
                        $exec_com_amount=number_format($exec_com_amount, 6, '.', '');
                        $desc='Executive Commission for Policy No.'.$model_commission->policy_no.' ('.$exec_com.' % of '.$net_amount.')';
                        $this->savetoCommissionLedger($id,User::getCompany(),$model_commission->customer_plan_id,$upload_date,$exec_com,
                                                    $net_amount,0,$exec_com_amount,'EXE_COM',$desc,'OUT','GEN',$provider_id,$customer_id,$mas_plan_id,'NA');
                        $this->savetoCommissionLedger($id,$user_id,$model_commission->customer_plan_id,$upload_date,$exec_com,
                                                    $net_amount,$exec_com_amount,0,'EXE_COM',$desc,'IN','GEN',$provider_id,$customer_id,$mas_plan_id,'NA');
                        //deferment commission
                        $exec_defer_com = $mas_commission->excecutive_deferment_commission;
                        $exec_defer_com_amount=$net_amount*$exec_defer_com/100;
                        $exec_defer_com_amount=number_format($exec_defer_com_amount, 6, '.', '');
                        $desc='Executive Deferment Commission for Policy No.'.$model_commission->policy_no.' ('.$exec_defer_com.' % of '.$net_amount.')';
                        $this->savetoCommissionLedger($id,User::getCompany(),$model_commission->customer_plan_id,$upload_date,$exec_defer_com,
                                                    $net_amount,0,$exec_defer_com_amount,'EXE_DEF_COM',$desc,'OUT','GEN',$provider_id,$customer_id,$mas_plan_id,'NA');
                        $this->savetoCommissionLedger($id,$user_id,$model_commission->customer_plan_id,$upload_date,$exec_defer_com,
                                                    $net_amount,$exec_defer_com_amount,0,'EXE_DEF_COM',$desc,'IN','DEF',$provider_id,$customer_id,$mas_plan_id,'HOLD');
                    }
                    //update totals to executive
                        $model_exe= User::model()->findbyPK($user_id);
                        $account_balance=$model_exe->account_total_amount+$exec_com_amount;
                        $account_defer=$model_exe->account_deferement_amount+$exec_defer_com_amount;
                        User::model()->updateByPK($user_id, array('account_total_amount' =>$account_balance,'account_deferement_amount' =>$account_defer,'updated_by'=>Yii::app()->user->id,'updated_date_time'=>date('Y-m-d H:i:s')));

                    //update totals to user company
                        $model_comp= User::model()->findbyPK(User::getCompany());
                        $account_balance=$model_comp->account_total_amount-$exec_com_amount-$exec_defer_com_amount;;
                        $account_defer=$model_comp->account_deferement_amount+$exec_defer_com_amount;
                        User::model()->updateByPK(User::getCompany(), array('account_total_amount' =>$account_balance,'account_deferement_amount' =>$account_defer,'updated_by'=>Yii::app()->user->id,'updated_date_time'=>date('Y-m-d H:i:s')));

                    //executive total commission including deferment amount
                    $total_exe_comm_amount =$exec_com_amount+$exec_defer_com_amount;
                    /*added to another table start*/
                    //Quarterly commision- 3% of commision of executive commission
                    if($upload_type=='NB'){
                        $exec_quar_com = $mas_commission->executive_quarter_sale_commission;
                        $exec_quar_com_amount=$total_exe_comm_amount*$exec_quar_com/100;
                        $exec_quar_com_amount=number_format($exec_quar_com_amount, 6, '.', '');
                        $desc='Executive Quarterly Commission for Policy No.'.$model_commission->policy_no.' ('.$exec_quar_com.' % of '.$total_exe_comm_amount.')';
                        $this->savetoExecutiveHoldCommissionLedger($id,User::getCompany(),$model_commission->customer_plan_id,$upload_date,$exec_quar_com,
                                                    $total_exe_comm_amount,0,$exec_quar_com_amount,'EXE_QUA_COM',$desc,'OUT','GEN',$provider_id,$customer_id,$mas_plan_id,'NA',$user_id);
                        $this->savetoExecutiveHoldCommissionLedger($id,$user_id,$model_commission->customer_plan_id,$upload_date,$exec_quar_com,
                                                    $total_exe_comm_amount,$exec_quar_com_amount,0,'EXE_QUA_COM',$desc,'IN','QUA',$provider_id,$customer_id,$mas_plan_id,'HOLD',$user_id);
                        //annual commission- 3% of commision of executive commission
                        $exec_ann_com = $mas_commission->executive_annual_sale_commission;
                        $exec_ann_com_amount=$total_exe_comm_amount*$exec_ann_com/100;
                        $exec_ann_com_amount=number_format($exec_ann_com_amount, 6, '.', '');
                        $desc='Executive Annual Commission for Policy No.'.$model_commission->policy_no.' ('.$exec_ann_com.' % of '.$total_exe_comm_amount.')';
                        $this->savetoExecutiveHoldCommissionLedger($id,User::getCompany(),$model_commission->customer_plan_id,$upload_date,$exec_ann_com,
                                                    $total_exe_comm_amount,0,$exec_ann_com_amount,'EXE_ANN_COM',$desc,'OUT','GEN',$provider_id,$customer_id,$mas_plan_id,'NA',$user_id);
                        $this->savetoExecutiveHoldCommissionLedger($id,$user_id,$model_commission->customer_plan_id,$upload_date,$exec_ann_com,
                                                    $total_exe_comm_amount,$exec_ann_com_amount,0,'EXE_ANN_COM',$desc,'IN','ANN',$provider_id,$customer_id,$mas_plan_id,'HOLD',$user_id);
                    }
                    /* added to another table end*/
                    //save commision amount of managers to commision ledger 
                    $assistant_manger =$model_commission->customerdetails->executive->assistant_manager_id;
                    $manager =$model_commission->customerdetails->executive->manager_id;
                    if($manager=='0'){
                        $manager = $user_id;
                    }
                    $ass_manager_quarter_amount=$ass_manager_annual_amount=0;                        
                    $manager_quarter_amount=$manager_annual_amount=0;
                    if($assistant_manger >0){
                        $ass_manager_com = $mas_commission->assistant_manager_commission;
                        $ass_manager_amount=$total_exe_comm_amount*$ass_manager_com/100;
                        $ass_manager_amount=number_format($ass_manager_amount, 6, '.', '');
                        $desc='Executive Assistant Manager Commission for Policy No.'.$model_commission->policy_no.' ('.$ass_manager_com.' % of '.$total_exe_comm_amount.')';
                        $this->savetoCommissionLedger($id,User::getCompany(),$model_commission->customer_plan_id,$upload_date,$ass_manager_com,
                                                $total_exe_comm_amount,0,$ass_manager_amount,'ASS_MAN_COM',$desc,'OUT','GEN',$provider_id,$customer_id,$mas_plan_id,'NA');
                        $this->savetoCommissionLedger($id,$assistant_manger,$model_commission->customer_plan_id,$upload_date,$ass_manager_com,
                                                $total_exe_comm_amount,$ass_manager_amount,0,'ASS_MAN_COM',$desc,'IN','GEN',$provider_id,$customer_id,$mas_plan_id,'NA');
                        /*added to another table start*/
                        if($upload_type=='NB'){
                            //Quarterly commision- 3% of commision of assistant manager commission-- start
                            $ass_manager_qua_com = $mas_commission->ass_manager_quarter_sale_commission;
                            $ass_manager_quarter_amount=$ass_manager_amount*$ass_manager_qua_com/100;
                            $ass_manager_quarter_amount=number_format($ass_manager_quarter_amount, 6, '.', '');
                            $desc='Assistant Manager Quarterly Commission for Policy No.'.$model_commission->policy_no.' ('.$ass_manager_qua_com.' % of '.$ass_manager_amount.')';
                            $this->savetoExecutiveHoldCommissionLedger($id,User::getCompany(),$model_commission->customer_plan_id,$upload_date,$ass_manager_qua_com,
                                                        $ass_manager_amount,0,$ass_manager_quarter_amount,'ASS_MAN_QUA_COM',$desc,'OUT','GEN',$provider_id,$customer_id,$mas_plan_id,'NA',$user_id);
                            $this->savetoExecutiveHoldCommissionLedger($id,$assistant_manger,$model_commission->customer_plan_id,$upload_date,$ass_manager_qua_com,
                                                        $ass_manager_amount,$ass_manager_quarter_amount,0,'ASS_MAN_QUA_COM',$desc,'IN','QUA',$provider_id,$customer_id,$mas_plan_id,'HOLD',$user_id);
                            //Quarterly commision- 3% of commision of assistant manager commission-- end
                            //annual commision- 3% of commision of assistant manager commission-- start
                            $ass_manager_ann_com = $mas_commission->ass_manager_annual_sale_commission;
                            $ass_manager_annual_amount=$ass_manager_amount*$ass_manager_ann_com/100;
                            $ass_manager_annual_amount=number_format($ass_manager_annual_amount, 6, '.', '');
                            $desc='Assistant Manager Annual Commission for Policy No.'.$model_commission->policy_no.' ('.$ass_manager_ann_com.' % of '.$ass_manager_amount.')';
                            $this->savetoExecutiveHoldCommissionLedger($id,User::getCompany(),$model_commission->customer_plan_id,$upload_date,$ass_manager_ann_com,
                                                        $ass_manager_amount,0,$ass_manager_annual_amount,'ASS_MAN_ANN_COM',$desc,'OUT','GEN',$provider_id,$customer_id,$mas_plan_id,'NA',$user_id);
                            $this->savetoExecutiveHoldCommissionLedger($id,$assistant_manger,$model_commission->customer_plan_id,$upload_date,$ass_manager_ann_com,
                                                        $ass_manager_amount,$ass_manager_annual_amount,0,'ASS_MAN_ANN_COM',$desc,'IN','ANN',$provider_id,$customer_id,$mas_plan_id,'HOLD',$user_id);
                            //annual commision- 3% of commision of assistant manager commission-- end
                            
                        }
                        /* added to another table end*/
                        $manager_com = $mas_commission->manager_with_assitant_commission;
                        $manager_amount=$total_exe_comm_amount*$manager_com/100;
                        $manager_amount=number_format($manager_amount, 6, '.', '');
                        $desc='Executive Manager Commission for Policy No.'.$model_commission->policy_no.' ('.$manager_com.' % of '.$total_exe_comm_amount.')';
                        $this->savetoCommissionLedger($id,User::getCompany(),$model_commission->customer_plan_id,$upload_date,$manager_com,
                                                $total_exe_comm_amount,0,$manager_amount,'MAN_COM',$desc,'OUT','GEN',$provider_id,$customer_id,$mas_plan_id,'NA');
                        $this->savetoCommissionLedger($id,$manager,$model_commission->customer_plan_id,$upload_date,$manager_com,
                                                $total_exe_comm_amount,$manager_amount,0,'MAN_COM',$desc,'IN','GEN',$provider_id,$customer_id,$mas_plan_id,'NA');
                        /*added to another table start*/
                        if($upload_type=='NB'){
                            //Quarterly commision- 3% of commision of manager commission-- start
                            $manager_qua_com = $mas_commission->manager_quarter_sale_commission;
                            $manager_quarter_amount=$manager_amount*$manager_qua_com/100;
                            $manager_quarter_amount=number_format($manager_quarter_amount, 6, '.', '');
                            $desc='Manager Quarterly Commission for Policy No.'.$model_commission->policy_no.' ('.$manager_qua_com.' % of '.$manager_amount.')';
                            $this->savetoExecutiveHoldCommissionLedger($id,User::getCompany(),$model_commission->customer_plan_id,$upload_date,$manager_qua_com,
                                                        $manager_amount,0,$manager_quarter_amount,'MAN_QUA_COM',$desc,'OUT','GEN',$provider_id,$customer_id,$mas_plan_id,'NA',$user_id);
                            $this->savetoExecutiveHoldCommissionLedger($id,$manager,$model_commission->customer_plan_id,$upload_date,$manager_qua_com,
                                                        $manager_amount,$manager_quarter_amount,0,'MAN_QUA_COM',$desc,'IN','QUA',$provider_id,$customer_id,$mas_plan_id,'HOLD',$user_id);
                            //Quarterly commision- 3% of commision of manager commission-- end
                            //annual commision- 3% of commision of manager commission-- start
                            $manager_ann_com = $mas_commission->manager_annual_sale_commission;
                            $manager_annual_amount=$manager_amount*$manager_ann_com/100;
                            $manager_annual_amount=number_format($manager_annual_amount, 6, '.', '');
                            $desc='Manager Annual Commission for Policy No.'.$model_commission->policy_no.' ('.$manager_ann_com.' % of '.$manager_amount.')';
                            $this->savetoExecutiveHoldCommissionLedger($id,User::getCompany(),$model_commission->customer_plan_id,$upload_date,$manager_ann_com,
                                                        $manager_amount,0,$manager_annual_amount,'MAN_ANN_COM',$desc,'OUT','GEN',$provider_id,$customer_id,$mas_plan_id,'NA',$user_id);
                            $this->savetoExecutiveHoldCommissionLedger($id,$manager,$model_commission->customer_plan_id,$upload_date,$manager_ann_com,
                                                        $manager_amount,$manager_annual_amount,0,'MAN_ANN_COM',$desc,'IN','ANN',$provider_id,$customer_id,$mas_plan_id,'HOLD',$user_id);
                            //annual commision- 3% of commision of manager commission-- end
                            
                        }
                        /* added to another table end*/
                        //update totals to assistant manager
                        $model_am= User::model()->findbyPK($assistant_manger);
                        $account_balance=$model_am->account_total_amount+$ass_manager_amount;
                        User::model()->updateByPK($assistant_manger, array('account_total_amount' =>$account_balance,'updated_by'=>Yii::app()->user->id,'updated_date_time'=>date('Y-m-d H:i:s')));
                        
                        //update totals to manager
                        $model_mr= User::model()->findbyPK($manager);
                        $account_balance=$model_mr->account_total_amount+$manager_amount;
                        User::model()->updateByPK($manager, array('account_total_amount' =>$account_balance,'updated_by'=>Yii::app()->user->id,'updated_date_time'=>date('Y-m-d H:i:s')));
                        //update totals to user company
                        $model_comp= User::model()->findbyPK(User::getCompany());
                        $account_balance=$model_comp->account_total_amount-$manager_amount-$ass_manager_amount;
                        User::model()->updateByPK(User::getCompany(), array('account_total_amount' =>$account_balance,'updated_by'=>Yii::app()->user->id,'updated_date_time'=>date('Y-m-d H:i:s')));

                    }else{
                        $manager_com = $mas_commission->manager_total_commision;
                        $manager_amount=$total_exe_comm_amount*$manager_com/100;
                        $manager_amount=number_format($manager_amount, 6, '.', '');
                        $desc='Executive Manager Commission for Policy No.'.$model_commission->policy_no.' ('.$manager_com.' % of '.$total_exe_comm_amount.')';
                        $this->savetoCommissionLedger($id,User::getCompany(),$model_commission->customer_plan_id,$upload_date,$manager_com,
                                                $total_exe_comm_amount,0,$manager_amount,'MAN_COM',$desc,'OUT','GEN',$provider_id,$customer_id,$mas_plan_id,'NA');
                        $this->savetoCommissionLedger($id,$manager,$model_commission->customer_plan_id,$upload_date,$manager_com,
                                                $total_exe_comm_amount,$manager_amount,0,'MAN_COM',$desc,'IN','GEN',$provider_id,$customer_id,$mas_plan_id,'NA');
                        /*added to another table start*/
                        if($upload_type=='NB'){
                            //Quarterly commision- 3% of commision of manager commission-- start
                            $manager_qua_com = $mas_commission->manager_quarter_sale_commission;
                            $manager_quarter_amount=$manager_amount*$manager_qua_com/100;
                            $manager_quarter_amount=number_format($manager_quarter_amount, 6, '.', '');
                            $desc='Manager Quarterly Commission for Policy No.'.$model_commission->policy_no.' ('.$manager_qua_com.' % of '.$manager_amount.')';
                            $this->savetoExecutiveHoldCommissionLedger($id,User::getCompany(),$model_commission->customer_plan_id,$upload_date,$manager_qua_com,
                                                        $manager_amount,0,$manager_quarter_amount,'MAN_QUA_COM',$desc,'OUT','GEN',$provider_id,$customer_id,$mas_plan_id,'NA',$user_id);
                            $this->savetoExecutiveHoldCommissionLedger($id,$manager,$model_commission->customer_plan_id,$upload_date,$manager_qua_com,
                                                        $manager_amount,$manager_quarter_amount,0,'MAN_QUA_COM',$desc,'IN','QUA',$provider_id,$customer_id,$mas_plan_id,'HOLD',$user_id);
                            //Quarterly commision- 3% of commision of manager commission-- end
                            //annual commision- 3% of commision of manager commission-- start
                            $manager_ann_com = $mas_commission->manager_annual_sale_commission;
                            $manager_annual_amount=$manager_amount*$manager_ann_com/100;
                            $manager_annual_amount=number_format($manager_annual_amount, 6, '.', '');
                            $desc='Manager Annual Commission for Policy No.'.$model_commission->policy_no.' ('.$manager_ann_com.' % of '.$manager_amount.')';
                            $this->savetoExecutiveHoldCommissionLedger($id,User::getCompany(),$model_commission->customer_plan_id,$upload_date,$manager_ann_com,
                                                        $manager_amount,0,$manager_annual_amount,'MAN_ANN_COM',$desc,'OUT','GEN',$provider_id,$customer_id,$mas_plan_id,'NA',$user_id);
                            $this->savetoExecutiveHoldCommissionLedger($id,$manager,$model_commission->customer_plan_id,$upload_date,$manager_ann_com,
                                                        $manager_amount,$manager_annual_amount,0,'MAN_ANN_COM',$desc,'IN','ANN',$provider_id,$customer_id,$mas_plan_id,'HOLD',$user_id);
                            //annual commision- 3% of commision of manager commission-- end
                            
                        }
                        /* added to another table end*/
                        //update totals to manager
                        $model_mr= User::model()->findbyPK($manager);
                        $account_balance=$model_mr->account_total_amount+$manager_amount;
                        User::model()->updateByPK($manager, array('account_total_amount' =>$account_balance,'updated_by'=>Yii::app()->user->id,'updated_date_time'=>date('Y-m-d H:i:s')));
                        //update totals to user company
                        $model_comp= User::model()->findbyPK(User::getCompany());
                        $account_balance=$model_comp->account_total_amount-$manager_amount;
                        User::model()->updateByPK(User::getCompany(), array('account_total_amount' =>$account_balance,'updated_by'=>Yii::app()->user->id,'updated_date_time'=>date('Y-m-d H:i:s')));

                    }
                    
                
            }else{
                $upload_amount=-$upload_amount;
                //save provider given whole amount to commision ledger
                $desc='Commission Return to '.$model_commission->providerdetails->provider_name.' for  Policy No.'.$model_commission->policy_no;
                $this->savetoCommissionLedger($id, User::getCompany(),$model_commission->customer_plan_id,$upload_date,100,
                                                 $upload_amount,0,$upload_amount,'PRO_RETURN',$desc,'OUT','GEN',$provider_id,$customer_id,$mas_plan_id,'NA');           
                $vat_percent=$model_commission->customerplan->masplandetails->general_vat;
                $vat_amount=$upload_amount*$vat_percent/100;
                $vat_amount=number_format($vat_amount, 6, '.', '');
                $desc='VAT Return for Policy No.'.$model_commission->policy_no.' ('.$vat_percent.' % of '.$upload_amount.')';
                //save general vat to commision ledger            
                $this->savetoCommissionLedger($id,User::getCompany(),$model_commission->customer_plan_id,$upload_date,$vat_percent,
                                                $upload_amount,$vat_amount,0,'VAT_IN',$desc,'IN','GEN',$provider_id,$customer_id,$mas_plan_id,'NA');
                //save amount deducting vat to commision ledger            
                $net_amount=$upload_amount-$vat_amount;
                $this->savetoCommissionLedger($id,User::getCompany(),$model_commission->customer_plan_id,$upload_date,$vat_percent,
                                                $upload_amount,0,$vat_amount,'VAT_OUT',$desc,'OUT','VAT',$provider_id,$customer_id,$mas_plan_id,'NA');
                //update totals to user company
                $model_comp= User::model()->findbyPK(User::getCompany());
                $account_balance=$model_comp->account_total_amount-$upload_amount+$vat_amount;
                $account_vat=$model_comp->account_vat_amount-$vat_amount;
                User::model()->updateByPK(User::getCompany(), array('account_total_amount' =>$account_balance,'account_vat_amount' =>$account_vat,'updated_by'=>Yii::app()->user->id,'updated_date_time'=>date('Y-m-d H:i:s')));
                //save commision amount return of executive to commision ledger 
                    $exec_defer_com_amount=0;
                    if($icp_months<12 || $upload_type!='NB'){//if not a deferment plan add full commission to excecutive account
                        //executive commission
                        $exec_com = $mas_commission->executive_commission_without_deferment;
                        $exec_com_amount=$net_amount*$exec_com/100;
                        $exec_com_amount=number_format($exec_com_amount, 6, '.', '');
                        $desc='Executive Commission Return for Policy No.'.$model_commission->policy_no.' ('.$exec_com.' % of '.$net_amount.')';
                        $this->savetoCommissionLedger($id,User::getCompany(),$model_commission->customer_plan_id,$upload_date,$exec_com,
                                                    $net_amount,$exec_com_amount,0,'EXE_COM_RET',$desc,'IN','GEN',$provider_id,$customer_id,$mas_plan_id,'NA');
                        
                        $this->savetoCommissionLedger($id,$user_id,$model_commission->customer_plan_id,$upload_date,$exec_com,
                                                    $net_amount,0,$exec_com_amount,'EXE_COM_RET',$desc,'OUT','GEN',$provider_id,$customer_id,$mas_plan_id,'NA');
                 
                    
                        //update totals to executive
                        $model_exe= User::model()->findbyPK($user_id);
                        $account_balance=$model_exe->account_total_amount-$exec_com_amount;
                        $account_defer=$model_exe->account_deferement_amount-$exec_defer_com_amount;
                        User::model()->updateByPK($user_id, array('account_total_amount' =>$account_balance,'account_deferement_amount' =>$account_defer,'updated_by'=>Yii::app()->user->id,'updated_date_time'=>date('Y-m-d H:i:s')));
                    }else{
                        //executive commission holded in deferment account
                        $exe_cond ='type="EXE_DEF_COM" and in_or_out="IN" AND cus_plan_id="'.$model_commission->customer_plan_id.'" AND user_id="'.$user_id.'" AND status="HOLD"';
                        $exe_def_com_bal= CommissionLedger::model()->find(array('select'=>'SUM(in_amount) AS in_amount','condition'=>$exe_cond))->in_amount;
                        //executive commission
                        $exec_com = $mas_commission->executive_commission_with_deferment;
                        $exec_com_amount=$net_amount*$exec_com/100;
                        $exec_com_amount=number_format($exec_com_amount, 6, '.', '');
                        //deferment commission                        
                        $exec_defer_com = $mas_commission->excecutive_deferment_commission;
                        $exec_defer_com_amount=$net_amount*$exec_defer_com/100;
                        //totalamount returned on clawback
                        $exe_claw_total =$exec_com_amount+$exec_defer_com_amount;
                        $model_exe= User::model()->findbyPK($user_id);
                        if($exe_def_com_bal>=$exe_claw_total){
                            $account_balance=$model_exe->account_total_amount;
                            $account_defer=$model_exe->account_deferement_amount-$exe_claw_total;
                            $desc='Executive (Commission+Deferment) Return for Policy No.'.$model_commission->policy_no.' ('.$exec_com.' % of '.$net_amount.','.$exec_defer_com.' % of '.$net_amount.')';
                            $this->savetoCommissionLedger($id,User::getCompany(),$model_commission->customer_plan_id,$upload_date,$exec_com+$exec_defer_com,
                                                    (2*$net_amount),$exe_claw_total,0,'EXE_DEF_COM_RET',$desc,'IN','GEN',$provider_id,$customer_id,$mas_plan_id,'NA');
                            $this->savetoCommissionLedger($id,$user_id,$model_commission->customer_plan_id,$upload_date,$exec_com+$exec_defer_com,
                                                   (2*$net_amount),0,$exe_claw_total,'EXE_DEF_COM_RET',$desc,'OUT','DEF',$provider_id,$customer_id,$mas_plan_id,'HOLD');
                        }else{
                            $return_frm_exe= $exe_claw_total-$exe_def_com_bal;
                            $account_balance=$model_exe->account_total_amount-$return_frm_exe;
                            $account_defer=$model_exe->account_deferement_amount-$exe_def_com_bal;
                            $desc='Executive Deferment Commission Return for Policy No.'.$model_commission->policy_no.'('.$return_frm_exe.' out of'.$exe_claw_total.')';
                            $this->savetoCommissionLedger($id,User::getCompany(),$model_commission->customer_plan_id,$upload_date,0,
                                        0,$exe_def_com_bal,0,'EXE_DEF_COM_RET',$desc,'IN','GEN',$provider_id,$customer_id,$mas_plan_id,'NA');
                            $this->savetoCommissionLedger($id,$user_id,$model_commission->customer_plan_id,$upload_date,0,
                                        0,0,$exe_def_com_bal,'EXE_DEF_COM_RET',$desc,'OUT','DEF',$provider_id,$customer_id,$mas_plan_id,'HOLD');
                            $desc='Executive Commission Return for Policy No.'.$model_commission->policy_no.'('.$exe_def_com_bal.' out of'.$exe_claw_total.')';
                            $this->savetoCommissionLedger($id,$user_id,$model_commission->customer_plan_id,$upload_date,0,
                                                    0,0,$return_frm_exe,'EXE_COM_RET',$desc,'OUT','GEN',$provider_id,$customer_id,$mas_plan_id,'NA');
                            $this->savetoCommissionLedger($id,User::getCompany(),$model_commission->customer_plan_id,$upload_date,0,
                                                    0,$return_frm_exe,0,'EXE_COM_RET',$desc,'IN','GEN',$provider_id,$customer_id,$mas_plan_id,'NA');                        
                        }
                        /*$desc='Executive Commission Return for Policy No.'.$model_commission->policy_no.' ('.$exec_com.' % of '.$net_amount.')';
                            $this->savetoCommissionLedger($id,$user_id,$model_commission->customer_plan_id,$upload_date,$exec_com,
                                                        $net_amount,0,$exec_com_amount,'EXE_COM_RET',$desc,'OUT','GEN',$provider_id,$customer_id,$mas_plan_id,'NA');
                            $this->savetoCommissionLedger($id,User::getCompany(),$model_commission->customer_plan_id,$upload_date,$exec_com,
                                                        $net_amount,$exec_com_amount,0,'EXE_COM_RET',$desc,'IN','GEN',$provider_id,$customer_id,$mas_plan_id,'NA');
                            $desc='Executive Deferment Commission Return for Policy No.'.$model_commission->policy_no.' ('.$exec_defer_com.' % of '.$net_amount.')';
                            $this->savetoCommissionLedger($id,User::getCompany(),$model_commission->customer_plan_id,$upload_date,$exec_defer_com,
                                                        $net_amount,$exec_defer_com_amount,0,'EXE_DEF_COM_RET',$desc,'IN','GEN',$provider_id,$customer_id,$mas_plan_id,'NA');
                            $this->savetoCommissionLedger($id,$user_id,$model_commission->customer_plan_id,$upload_date,$exec_defer_com,
                                                    $net_amount,0,$exec_defer_com_amount,'EXE_DEF_COM_RET',$desc,'OUT','DEF',$provider_id,$customer_id,$mas_plan_id,'HOLD');
                        */
                        //update totals to executive                        
                        User::model()->updateByPK($user_id, array('account_total_amount' =>$account_balance,'account_deferement_amount' =>$account_defer,'updated_by'=>Yii::app()->user->id,'updated_date_time'=>date('Y-m-d H:i:s')));
                    }
                    
                    //update totals to user company
                        $model_comp= User::model()->findbyPK(User::getCompany());
                        $account_balance=$model_comp->account_total_amount+$exec_com_amount+$exec_defer_com_amount;;
                        $account_defer=$model_comp->account_deferement_amount-$exec_defer_com_amount;
                        User::model()->updateByPK(User::getCompany(), array('account_total_amount' =>$account_balance,'account_deferement_amount' =>$account_defer,'updated_by'=>Yii::app()->user->id,'updated_date_time'=>date('Y-m-d H:i:s')));
                    //executive total commission including deferment amount
                    $total_exe_comm_amount =$exec_com_amount+$exec_defer_com_amount;
                    /*added to another table start*/
                    //Quarterly commision- 3% of commision of executive commission
                    
                    if($upload_type=='NB'){
                        $exec_quar_com = $mas_commission->executive_quarter_sale_commission;
                        $exec_quar_com_amount=$total_exe_comm_amount*$exec_quar_com/100;
                        $exec_quar_com_amount=number_format($exec_quar_com_amount, 6, '.', '');
                        $desc='Executive Quarterly Commission Return for Policy No.'.$model_commission->policy_no.' ('.$exec_quar_com.' % of '.$total_exe_comm_amount.')';
                        $this->savetoExecutiveHoldCommissionLedger($id,User::getCompany(),$model_commission->customer_plan_id,$upload_date,$exec_quar_com,
                                                    $total_exe_comm_amount,$exec_quar_com_amount,0,'EXE_QUA_COM_RET',$desc,'IN','GEN',$provider_id,$customer_id,$mas_plan_id,'NA',$user_id);
                        $this->savetoExecutiveHoldCommissionLedger($id,$user_id,$model_commission->customer_plan_id,$upload_date,$exec_quar_com,
                                                    $total_exe_comm_amount,0,$exec_quar_com_amount,'EXE_QUA_COM_RET',$desc,'OUT','QUA',$provider_id,$customer_id,$mas_plan_id,'HOLD',$user_id);
                        //annual commission- 3% of commision of executive commission
                        $exec_ann_com = $mas_commission->executive_annual_sale_commission;
                        $exec_ann_com_amount=$total_exe_comm_amount*$exec_ann_com/100;
                        $exec_ann_com_amount=number_format($exec_ann_com_amount, 6, '.', '');
                        $desc='Executive Annual Commission Return for Policy No.'.$model_commission->policy_no.' ('.$exec_ann_com.' % of '.$total_exe_comm_amount.')';
                        $this->savetoExecutiveHoldCommissionLedger($id,User::getCompany(),$model_commission->customer_plan_id,$upload_date,$exec_ann_com,
                                                    $total_exe_comm_amount,$exec_ann_com_amount,0,'EXE_ANN_COM_RET',$desc,'IN','GEN',$provider_id,$customer_id,$mas_plan_id,'NA',$user_id);
                        $this->savetoExecutiveHoldCommissionLedger($id,$user_id,$model_commission->customer_plan_id,$upload_date,$exec_ann_com,
                                                    $total_exe_comm_amount,0,$exec_ann_com_amount,'EXE_ANN_COM_RET',$desc,'OUT','ANN',$provider_id,$customer_id,$mas_plan_id,'HOLD',$user_id);
                    }
                    /* added to another table end*/
                    //save commision amount of managers to commision ledger 
                    $assistant_manger =$model_commission->customerdetails->executive->assistant_manager_id;
                    $manager =$model_commission->customerdetails->executive->manager_id;
                    if($manager=='0'){
                        $manager = $user_id;
                    }
                    if($assistant_manger >0){
                        $ass_manager_com = $mas_commission->assistant_manager_commission;
                        $ass_manager_amount=$total_exe_comm_amount*$ass_manager_com/100;
                        $ass_manager_amount=number_format($ass_manager_amount, 6, '.', '');
                        $desc='Executive Assistant Manager Commission Return for Policy No.'.$model_commission->policy_no.' ('.$ass_manager_com.' % of '.$total_exe_comm_amount.')';
                        $this->savetoCommissionLedger($id,User::getCompany(),$model_commission->customer_plan_id,$upload_date,$ass_manager_com,
                                                $total_exe_comm_amount,$ass_manager_amount,0,'ASS_MAN_COM_RET',$desc,'IN','GEN',$provider_id,$customer_id,$mas_plan_id,'NA');
                        $this->savetoCommissionLedger($id,$assistant_manger,$model_commission->customer_plan_id,$upload_date,$ass_manager_com,
                                                $total_exe_comm_amount,0,$ass_manager_amount,'ASS_MAN_COM_RET',$desc,'OUT','GEN',$provider_id,$customer_id,$mas_plan_id,'NA');
                        /*added to another table start*/
                        if($upload_type=='NB'){
                            //Quarterly commision- 3% of commision of assistant manager commission-- start
                            $ass_manager_qua_com = $mas_commission->ass_manager_quarter_sale_commission;
                            $ass_manager_quarter_amount=$ass_manager_amount*$ass_manager_qua_com/100;
                            $ass_manager_quarter_amount=number_format($ass_manager_quarter_amount, 6, '.', '');
                            $desc='Assistant Manager Quarterly Commission Return for Policy No.'.$model_commission->policy_no.' ('.$ass_manager_qua_com.' % of '.$ass_manager_amount.')';
                            $this->savetoExecutiveHoldCommissionLedger($id,User::getCompany(),$model_commission->customer_plan_id,$upload_date,$ass_manager_qua_com,
                                                        $ass_manager_amount,$ass_manager_quarter_amount,0,'ASS_MAN_QUA_COM_RET',$desc,'IN','GEN',$provider_id,$customer_id,$mas_plan_id,'NA',$user_id);
                            $this->savetoExecutiveHoldCommissionLedger($id,$assistant_manger,$model_commission->customer_plan_id,$upload_date,$ass_manager_qua_com,
                                                        $ass_manager_amount,0,$ass_manager_quarter_amount,'ASS_MAN_QUA_COM_RET',$desc,'OUT','QUA',$provider_id,$customer_id,$mas_plan_id,'HOLD',$user_id);
                            //Quarterly commision- 3% of commision of assistant manager commission-- end
                            //annual commision- 3% of commision of assistant manager commission-- start
                            $ass_manager_ann_com = $mas_commission->ass_manager_annual_sale_commission;
                            $ass_manager_annual_amount=$ass_manager_amount*$ass_manager_ann_com/100;
                            $ass_manager_annual_amount=number_format($ass_manager_annual_amount, 6, '.', '');
                            $desc='Assistant Manager Annual Commission Return for Policy No.'.$model_commission->policy_no.' ('.$ass_manager_ann_com.' % of '.$ass_manager_amount.')';
                            $this->savetoExecutiveHoldCommissionLedger($id,User::getCompany(),$model_commission->customer_plan_id,$upload_date,$ass_manager_ann_com,
                                                        $ass_manager_amount,$ass_manager_annual_amount,0,'ASS_MAN_ANN_COM_RET',$desc,'IN','GEN',$provider_id,$customer_id,$mas_plan_id,'NA',$user_id);
                            $this->savetoExecutiveHoldCommissionLedger($id,$assistant_manger,$model_commission->customer_plan_id,$upload_date,$ass_manager_ann_com,
                                                        $ass_manager_amount,0,$ass_manager_annual_amount,'ASS_MAN_ANN_COM_RET',$desc,'OUT','ANN',$provider_id,$customer_id,$mas_plan_id,'HOLD',$user_id);
                            //annual commision- 3% of commision of assistant manager commission-- end
                            
                        }
                        /* added to another table end*/
                        $manager_com = $mas_commission->manager_with_assitant_commission;
                        $manager_amount=$total_exe_comm_amount*$manager_com/100;
                        $manager_amount=number_format($manager_amount, 6, '.', '');
                        $desc='Executive Manager Commission Return for Policy No.'.$model_commission->policy_no.' ('.$manager_com.' % of '.$total_exe_comm_amount.')';
                        $this->savetoCommissionLedger($id,User::getCompany(),$model_commission->customer_plan_id,$upload_date,$manager_com,
                                                $total_exe_comm_amount,$manager_amount,0,'MAN_COM_RET',$desc,'IN','GEN',$provider_id,$customer_id,$mas_plan_id,'NA');
                        $this->savetoCommissionLedger($id,$manager,$model_commission->customer_plan_id,$upload_date,$manager_com,
                                                $total_exe_comm_amount,0,$manager_amount,'MAN_COM_RET',$desc,'OUT','GEN',$provider_id,$customer_id,$mas_plan_id,'NA');
                        /*added to another table start*/
                        if($upload_type=='NB'){
                            //Quarterly commision- 3% of commision of manager commission-- start
                            $manager_qua_com = $mas_commission->manager_quarter_sale_commission;
                            $manager_quarter_amount=$manager_amount*$manager_qua_com/100;
                            $manager_quarter_amount=number_format($manager_quarter_amount, 6, '.', '');
                            $desc='Manager Quarterly Commission Return for Policy No.'.$model_commission->policy_no.' ('.$manager_qua_com.' % of '.$manager_amount.')';
                            $this->savetoExecutiveHoldCommissionLedger($id,User::getCompany(),$model_commission->customer_plan_id,$upload_date,$manager_qua_com,
                                                        $manager_amount,$manager_quarter_amount,0,'MAN_QUA_COM_RET',$desc,'IN','GEN',$provider_id,$customer_id,$mas_plan_id,'NA',$user_id);
                            $this->savetoExecutiveHoldCommissionLedger($id,$manager,$model_commission->customer_plan_id,$upload_date,$manager_qua_com,
                                                        $manager_amount,0,$manager_quarter_amount,'MAN_QUA_COM_RET',$desc,'OUT','QUA',$provider_id,$customer_id,$mas_plan_id,'HOLD',$user_id);
                            //Quarterly commision- 3% of commision of manager commission-- end
                            //annual commision- 3% of commision of manager commission-- start
                            $manager_ann_com = $mas_commission->manager_annual_sale_commission;
                            $manager_annual_amount=$manager_amount*$manager_ann_com/100;
                            $manager_annual_amount=number_format($manager_annual_amount, 6, '.', '');
                            $desc='Manager Annual Commission Return for Policy No.'.$model_commission->policy_no.' ('.$manager_ann_com.' % of '.$manager_amount.')';
                            $this->savetoExecutiveHoldCommissionLedger($id,User::getCompany(),$model_commission->customer_plan_id,$upload_date,$manager_ann_com,
                                                        $manager_amount,$manager_annual_amount,0,'MAN_ANN_COM_RET',$desc,'IN','GEN',$provider_id,$customer_id,$mas_plan_id,'NA',$user_id);
                            $this->savetoExecutiveHoldCommissionLedger($id,$manager,$model_commission->customer_plan_id,$upload_date,$manager_ann_com,
                                                        $manager_amount,0,$manager_annual_amount,'MAN_ANN_COM_RET',$desc,'OUT','ANN',$provider_id,$customer_id,$mas_plan_id,'HOLD',$user_id);
                            //annual commision- 3% of commision of manager commission-- end
                            
                        }
                        /* added to another table end*/
                        //update totals to assistant manager
                        $model_am= User::model()->findbyPK($assistant_manger);
                        $account_balance=$model_am->account_total_amount-$ass_manager_amount;
                        User::model()->updateByPK($assistant_manger, array('account_total_amount' =>$account_balance,'updated_by'=>Yii::app()->user->id,'updated_date_time'=>date('Y-m-d H:i:s')));
                        
                        //update totals to manager
                        $model_mr= User::model()->findbyPK($manager);
                        $account_balance=$model_mr->account_total_amount-$manager_amount;
                        User::model()->updateByPK($manager, array('account_total_amount' =>$account_balance,'updated_by'=>Yii::app()->user->id,'updated_date_time'=>date('Y-m-d H:i:s')));
                        //update totals to user company
                        $model_comp= User::model()->findbyPK(User::getCompany());
                        $account_balance=$model_comp->account_total_amount+$manager_amount+$ass_manager_amount;
                        User::model()->updateByPK(User::getCompany(), array('account_total_amount' =>$account_balance,'updated_by'=>Yii::app()->user->id,'updated_date_time'=>date('Y-m-d H:i:s')));

                    }else{
                        $manager_com = $mas_commission->manager_total_commision;
                        $manager_amount=$total_exe_comm_amount*$manager_com/100;
                        $manager_amount=number_format($manager_amount, 6, '.', '');
                        $desc='Executive Manager Commission Return for Policy No.'.$model_commission->policy_no.' ('.$manager_com.' % of '.$total_exe_comm_amount.')';
                        $this->savetoCommissionLedger($id,User::getCompany(),$model_commission->customer_plan_id,$upload_date,$manager_com,
                                                $total_exe_comm_amount,$manager_amount,0,'MAN_COM_RET',$desc,'IN','GEN',$provider_id,$customer_id,$mas_plan_id,'NA');
                        $this->savetoCommissionLedger($id,$manager,$model_commission->customer_plan_id,$upload_date,$manager_com,
                                                $total_exe_comm_amount,0,$manager_amount,'MAN_COM_RET',$desc,'OUT','GEN',$provider_id,$customer_id,$mas_plan_id,'NA');
                        /*added to another table start*/
                        if($upload_type=='NB'){
                            //Quarterly commision- 3% of commision of manager commission-- start
                            $manager_qua_com = $mas_commission->manager_quarter_sale_commission;
                            $manager_quarter_amount=$manager_amount*$manager_qua_com/100;
                            $manager_quarter_amount=number_format($manager_quarter_amount, 6, '.', '');
                            $desc='Manager Quarterly Commission Return for Policy No.'.$model_commission->policy_no.' ('.$manager_qua_com.' % of '.$manager_amount.')';
                            $this->savetoExecutiveHoldCommissionLedger($id,User::getCompany(),$model_commission->customer_plan_id,$upload_date,$manager_qua_com,
                                                        $manager_amount,$manager_quarter_amount,0,'MAN_QUA_COM_RET',$desc,'IN','GEN',$provider_id,$customer_id,$mas_plan_id,'NA',$user_id);
                            $this->savetoExecutiveHoldCommissionLedger($id,$manager,$model_commission->customer_plan_id,$upload_date,$manager_qua_com,
                                                        $manager_amount,0,$manager_quarter_amount,'MAN_QUA_COM_RET',$desc,'OUT','QUA',$provider_id,$customer_id,$mas_plan_id,'HOLD',$user_id);
                            //Quarterly commision- 3% of commision of manager commission-- end
                            //annual commision- 3% of commision of manager commission-- start
                            $manager_ann_com = $mas_commission->manager_annual_sale_commission;
                            $manager_annual_amount=$manager_amount*$manager_ann_com/100;
                            $manager_annual_amount=number_format($manager_annual_amount, 6, '.', '');
                            $desc='Manager Annual Commission Return for Policy No.'.$model_commission->policy_no.' ('.$manager_ann_com.' % of '.$manager_amount.')';
                            $this->savetoExecutiveHoldCommissionLedger($id,User::getCompany(),$model_commission->customer_plan_id,$upload_date,$manager_ann_com,
                                                        $manager_amount,$manager_annual_amount,0,'MAN_ANN_COM_RET',$desc,'IN','GEN',$provider_id,$customer_id,$mas_plan_id,'NA',$user_id);
                            $this->savetoExecutiveHoldCommissionLedger($id,$manager,$model_commission->customer_plan_id,$upload_date,$manager_ann_com,
                                                        $manager_amount,0,$manager_annual_amount,'MAN_ANN_COM_RET',$desc,'OUT','ANN',$provider_id,$customer_id,$mas_plan_id,'HOLD',$user_id);
                            //annual commision- 3% of commision of manager commission-- end
                            
                        }
                        /* added to another table end*/
                        //update totals to manager
                        $model_mr= User::model()->findbyPK($manager);
                        $account_balance=$model_mr->account_total_amount-$manager_amount;
                        User::model()->updateByPK($manager, array('account_total_amount' =>$account_balance,'updated_by'=>Yii::app()->user->id,'updated_date_time'=>date('Y-m-d H:i:s')));
                        //update totals to user company
                        $model_comp= User::model()->findbyPK(User::getCompany());
                        $account_balance=$model_comp->account_total_amount+$manager_amount;
                        User::model()->updateByPK(User::getCompany(), array('account_total_amount' =>$account_balance,'updated_by'=>Yii::app()->user->id,'updated_date_time'=>date('Y-m-d H:i:s')));

                    }
            }
        }
            
        return true;
                
    }    
    //addtoCommissionLedger-end
    ////savetoCommissionLedger-start
    public function savetoCommissionLedger($id,$user_id,$cus_plan_id,$transaction_date,$percentage,
                                            $total_amount,$in_amount,$out_amount,$type,$desc,$in_or_out,
                                            $user_account,$provider_id,$customer_id,$mas_plan_id,$status) {
        $model_ledger = new CommissionLedger();
        $model_ledger->commision_upload_id=$id;
        $model_ledger->user_id=$user_id;
        $model_ledger->cus_plan_id=$cus_plan_id;
        $model_ledger->transaction_date=$transaction_date;
        $model_ledger->posted_date=date('Y-m-d');
        $model_ledger->percentage=$percentage;
        $model_ledger->total_amount=$total_amount;
        $model_ledger->in_or_out=$in_or_out;
        $model_ledger->in_amount=$in_amount;
        $model_ledger->out_amount=$out_amount;
        $model_ledger->type=$type;
        $model_ledger->description=$desc;
        $model_ledger->user_account=$user_account;
        $model_ledger->provider_id=$provider_id;
        $model_ledger->customer_id=$customer_id;
        $model_ledger->mas_plan_id=$mas_plan_id;
        $model_ledger->status=$status;        
        $model_ledger->created_by  =Yii::app()->user->id; 
        $model_ledger->created_date_time=date('Y-m-d H:i:s');
        $model_ledger->save(false);     
        return true;
    }    
    //savetoCommissionLedger-end
    ////savetoCommissionLedger-start
    public function savetoExecutiveHoldCommissionLedger($id,$user_id,$cus_plan_id,$transaction_date,$percentage,
                                            $total_amount,$in_amount,$out_amount,$type,$desc,$in_or_out,
                                            $user_account,$provider_id,$customer_id,$mas_plan_id,$status,$executive_id=0) {
        $model_ledger = new ExecutiveHoldCommission();
        $model_ledger->commision_upload_id=$id;
        $model_ledger->user_id=$user_id;
        $model_ledger->cus_plan_id=$cus_plan_id;
        $model_ledger->transaction_date=$transaction_date;
        $model_ledger->posted_date=date('Y-m-d');
        $model_ledger->percentage=$percentage;
        $model_ledger->total_amount=$total_amount;
        $model_ledger->in_or_out=$in_or_out;
        $model_ledger->in_amount=$in_amount;
        $model_ledger->out_amount=$out_amount;
        $model_ledger->type=$type;
        $model_ledger->description=$desc;
        $model_ledger->user_account=$user_account;
        $model_ledger->provider_id=$provider_id;
        $model_ledger->customer_id=$customer_id;
        $model_ledger->mas_plan_id=$mas_plan_id;
        $model_ledger->executive_id=$executive_id;
        $model_ledger->status=$status;        
        $model_ledger->created_by  =Yii::app()->user->id; 
        $model_ledger->created_date_time=date('Y-m-d H:i:s');
        $model_ledger->save(false);     
        return true;
    }    
    //savetoCommissionLedger-end
    public function actionGetlistforCalculation() {
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $status = $_POST['status'];
        $provider_id = $_POST['provider_id'];
        $model = new CommissionUploaded();
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'provider_name',
            2 => 'commission_date',
            3 => 'created_by',
            4 => 'created_date_time',
            5 => '',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        //$orderBy = $filterColumn . " " . $filterOrder;

        $orderBy = "t.id ASC";
        /******** First Loading Without Search********/
//        $condition = 't.commission_calculated="N"';
        $condition = '1=1';
        if($provider_id>0){
            $condition.= ' AND t.provider_id="'.$provider_id.'"';
        } 
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " AND (t.provider_name LIKE '%" . $searchString . "%' )";
        }             
        $count = $model->count(array('condition' => $condition,'group'=>'provider_id,commission_date'));
        $model = $model->findAll(array('condition' => $condition,'group'=>'provider_id,commission_date', 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m=1;
        $model_com_max = CommissionUploaded::model()->find(array('select'=>'max(id) as id'));
        $model_com_max_1 = CommissionUploaded::model()->findbyPK($model_com_max->id);
        $model_id_value = CommissionUploaded::model()->find(array('condition'=>'commission_date="'.$model_com_max_1->commission_date.'" and provider_id="'.$model_com_max_1->provider_id.'"'));
        $company_code = Yii::app()->user->company_code;
        $arr_company_details = MasCompany::model()->find(array('condition' => 'company_code="' . $company_code . '"'));
        $prev_date = $arr_company_details->commission_locked_date;

        foreach ($model as $row) {
            $div='';
            $commission_date='';$delete_flag =1;
            $created_date_time='';
            if($row['commission_date']<$prev_date && $prev_date!='0000-00-00'){
                $delete_flag =0;
            }
            if($row['commission_date']!='' && $row['commission_date']!='0000-00-00'){
                $commission_date=date_format(date_create($row['commission_date']),'d/m/Y');
            }
            if($row['created_date_time']!='' && $row['created_date_time']!='0000-00-00'){
                $created_date_time=date_format(date_create($row['created_date_time']),'d/m/Y');
            }
            $model_commission_calculated = CommissionUploaded::model()->findAll(array('condition'=>'commission_calculated="Y" AND commission_date="'.$row['commission_date'].'" and provider_id="'.$row['provider_id'].'"'));
            $model_csv_download = CommissionUploaded::model()->findAll(array('condition'=>'commission_calculated="N" AND commission_date="'.$row['commission_date'].'" and provider_id="'.$row['provider_id'].'"'));
            if(!empty($model_csv_download)){
                $div.= '<button class="btn btn-primary btn-xs" title="Commission List" onclick="loadPopupModal(\'commission/viewlist&id=' . $row['id'] . '\',\'' . $row['provider_name'] . ' : ' .$commission_date. '\',\'xl\')"><i class="fa fa-money"></i></button>&nbsp;';
            }else{   
               // $div.= '<button class="btn btn-primary btn-xs" title="Edit Commission List" onclick="loadPopupModal(\'commission/editlist&id=' . $row['id'] . '\',\'' . $row['provider_name'] . ' : ' .$commission_date. '\',\'xl\')"><i class="fa fa-edit"></i></button>&nbsp;';
                $div.= '<a href="?r=commissiondownload/downloadexecutivefile&providerid=' . $row['provider_id'] . '&commission_date=' . $row['commission_date'] . '" title="Download Executive Document" target="_blank"><button class="btn btn-primary btn-xs"><i class="fa fa-download"></i></button></a>&nbsp;';            
                $div.= '<a href="?r=commissiondownload/downloadmanagerfile&providerid=' . $row['provider_id'] . '&commission_date=' . $row['commission_date'] . '" title="Download Manager Document" target="_blank"><button class="btn btn-primary btn-xs"><i class="fa fa-download"></i></button></a>&nbsp;';            
            }
            $div.= '<button class="btn btn-primary btn-xs" title="View Commission List" onclick="loadPopupModal(\'commission/viewcommissionlist&id=' . $row['id'] . '\',\'' . $row['provider_name'] . ' : ' .$commission_date. '\',\'xl\')"><i class="fa fa-eye"></i></button>&nbsp;';
            //Delete
            if(empty($model_commission_calculated)){
                $div.= '&nbsp;<a href="javascript:void(0);" title="Delete Commission File" onclick="deletecommissionfile('.$row['id'].');"><button class="btn btn-primary btn-xs"><i class="fa fa-trash"></i></button></a>&nbsp;';
            }else{
                $commission_year=date('Y-m-d',  strtotime($row['commission_date']));
                $model_quarter_calculated = UserTarget::model()->findAll(array('condition'=>'calculated="Y" AND ((start_date>="' . $row['commission_date'] . '" AND end_date<="' . $row['commission_date'] . '") OR (start_date<="' . $row['commission_date'] . '" AND end_date>="' . $row['commission_date'] . '"))'));
                $model_annual_calculated = UserTarget::model()->findAll(array('condition'=>'calculated="Y" AND target_year="'.$commission_year.'"'));
                if(empty($model_quarter_calculated) && empty($model_annual_calculated) && $delete_flag==1){
                    $div.= '&nbsp;<a href="javascript:void(0);" title="Delete Commission" onclick="deletecalculatedcommission('.$row['id'].');"><button class="btn btn-primary btn-xs"><i class="fa fa-trash"></i></button></a>&nbsp;'; 
                }
            }
            if($row['master_commission_file']!=''){
                $div.= '&nbsp;<a href="?r=commission/downloadcommissionfile&id=' . $row['id'] . '" title="Download Provider Commission File"><button class="btn btn-primary btn-xs"><i class="fa fa-download"></i></button></a>&nbsp;';
            }
            $rowData[] = array($m, $row['provider_name'],$commission_date, $row['userdetails']['fullname'],$created_date_time, '<div class="btn-wrap text-center">' . $div . '</div>');
            $m++;
        }

        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionViewList() {
        $id = (int) Yii::app()->request->getParam('id');
        $model_commission_upload = CommissionUploaded::model()->findbyPK($id);
        $model_commission_details = CommissionUploaded::model()->findAll(array('condition' => 'commission_calculated="N" and commission_date="'.$model_commission_upload->commission_date.'" and provider_id="'.$model_commission_upload->provider_id.'"'));
        //Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
        $this->render('commission_list', array('model_commission_details' => $model_commission_details,));
    }
    public function actionCalculateCommision() {
        $commission_uploaded=$_POST['arraycid'];
        foreach ($commission_uploaded as $value) {
            $status=$this->addtoCommissionLedger($value);
            if($status==1){
                CommissionUploaded::model()->updateByPK($value, array('commission_calculated'=>'Y'));
            }
        }
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
    }
    public function actionEditList() {
        $id = (int) Yii::app()->request->getParam('id');
        $model_commission_upload = CommissionUploaded::model()->findbyPK($id);
        $model_commission_details = CommissionUploaded::model()->findAll(array('condition' => 'commission_calculated="Y" and commission_date="'.$model_commission_upload->commission_date.'" and provider_id="'.$model_commission_upload->provider_id.'"'));
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
        $this->render('edit_commission_list', array('model_commission_details' => $model_commission_details,));
    }
    public function actiondownloadcommissionfile() {
        $id = (int) Yii::app()->request->getParam('id'); 
        $model_commission = CommissionUploaded::model()->findByPk($id);
        $path = Yii::getPathOfAlias('webroot') . "/uploads/providercommission/" . $model_commission->master_commission_file;
        header("Content-type:application/octet-stream"); //for txt file
        header("Content-Type: application/download");
        header('Content-Disposition: attachment; filename="' . basename($path) . '"');
        header('Content-Length: ' . filesize($path));
        readfile($path);
        Yii::app()->end();
    }
    public function actionViewcommissionList() {
        $id = (int) Yii::app()->request->getParam('id');
        $model_commission_upload = CommissionUploaded::model()->findbyPK($id);
        $model_commission_details = CommissionUploaded::model()->findAll(array('condition' => 'commission_date="'.$model_commission_upload->commission_date.'" and provider_id="'.$model_commission_upload->provider_id.'"'));
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
        $this->render('view_commission_list', array('model_commission_details' => $model_commission_details,));
    }
    public function actionDeletecommissionfile() {
        $_id= (int) Yii::app()->request->getParam('id');
        $model_commission = CommissionUploaded::model()->findByPk($_id);
        $commission_date=$model_commission->commission_date;
        $provider_id=$model_commission->provider_id;
        CommissionUploaded::model()->deleteAll(array('condition' =>'commission_date="'.$commission_date.'" and provider_id="'.$provider_id.'"'));
        $model_commission_file = CommissionUploaded::model()->findAll(array('condition'=>'commission_date="'.$commission_date.'" and provider_id="'.$provider_id.'"'));
        if(empty($model_commission_file)){
            $data['status'] = 'success';
        }else{
            $data['status'] = 'error';
        }
        echo CJSON::encode($data);
    }
    public function actionDeletecalculatedCommission() {
        $id=$_POST['id'];
        $model_commission_upload = CommissionUploaded::model()->findbyPK($id);
        $model_commission_details = CommissionUploaded::model()->findAll(array('condition' => 'commission_date="'.$model_commission_upload->commission_date.'" and provider_id="'.$model_commission_upload->provider_id.'"'));
        foreach ($model_commission_details as $value) {
            $status=$this->deleteCommissionLedger($value->id);
            if($status==1){
                CommissionUploaded::model()->deleteByPk($value->id);
            }
        }
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
    }
        //addtoCommissionLedger-start
    public function deleteCommissionLedger($id) {
        $model_commission = new CommissionUploaded();
        if($id>0){
            $model_commission = $model_commission->findByPK($id);
            $upload_amount    = $model_commission->commission_amount;
            $user_id          = $model_commission->customerdetails->cust_executive_id;
            $icp_months       = $model_commission->customerplan->icp_months;
            $upload_type=$model_commission->type;
            $scheme_id        = User::model()->findByPK($user_id)->commission_scheme_id;
            $mas_commission   = MasterCommissionSchemes::model()->findByPK($scheme_id);
            if($upload_amount>0){
                //delete provider given whole amount from commision ledger
                $this->deletefromCommissionLedger($id,'PRO_ISSUE','IN','GEN','NA');  
                
                //delete general vat from commision ledger                        
                $vat_percent=$model_commission->customerplan->masplandetails->general_vat;
                $vat_amount=$upload_amount*$vat_percent/100;
                $vat_amount=number_format($vat_amount, 6, '.', '');
                $this->deletefromCommissionLedger($id,'VAT_OUT','OUT','GEN','NA'); 
                //save amount deducting vat to commision ledger            
                $net_amount=$upload_amount-$vat_amount;
                $this->deletefromCommissionLedger($id,'VAT_IN','IN','VAT','NA'); 
                //update totals to user company
                $model_comp= User::model()->findbyPK(User::getCompany());
                $amount_exclude_vat=$upload_amount-$vat_amount;
                $account_balance=$model_comp->account_total_amount-$amount_exclude_vat;
                $account_vat=$model_comp->account_vat_amount-$vat_amount;
                User::model()->updateByPK(User::getCompany(), array('account_total_amount' =>$account_balance,'account_vat_amount' =>$account_vat,'updated_by'=>Yii::app()->user->id,'updated_date_time'=>date('Y-m-d H:i:s')));
                //delete commision amount of executive from commision ledger 
                    $exec_defer_com_amount=0;
                    if($icp_months<12 || $upload_type!='NB'){ //if not a deferment plan 
                        //executive commission
                        $exec_com = $mas_commission->executive_commission_without_deferment;
                        $exec_com_amount=$net_amount*$exec_com/100;
                        $exec_com_amount=number_format($exec_com_amount, 6, '.', '');
                        $this->deletefromCommissionLedger($id,'EXE_COM','OUT','GEN','NA');                       
                        $this->deletefromCommissionLedger($id,'EXE_COM','IN','GEN','NA');
                 
                    }else{
                        //executive commission
                        $exec_com = $mas_commission->executive_commission_with_deferment;
                        $exec_com_amount=$net_amount*$exec_com/100;
                        $exec_com_amount=number_format($exec_com_amount, 6, '.', '');
                        $this->deletefromCommissionLedger($id,'EXE_COM','OUT','GEN','NA');
                        $this->deletefromCommissionLedger($id,'EXE_COM','IN','GEN','NA');
                        //deferment commission
                        $exec_defer_com = $mas_commission->excecutive_deferment_commission;
                        $exec_defer_com_amount=$net_amount*$exec_defer_com/100;
                        $exec_defer_com_amount=number_format($exec_defer_com_amount, 6, '.', '');
                        $this->deletefromCommissionLedger($id,'EXE_DEF_COM','OUT','GEN','NA');
                        $modelDefermentDetails = CommissionLedger::model()->find(array('condition'=>'commision_upload_id="'.$id.'" AND type="EXE_DEF_COM" AND in_or_out="IN" AND user_account="DEF" AND status="USED"'));
                        
                        if(empty($modelDefermentDetails)){
                        $this->deletefromCommissionLedger($id,'EXE_DEF_COM','IN','DEF','HOLD');
                        }else{
                            $model_commission=CommissionUploaded::model()->findByPk($id);
                            $desc='Executive Deferment Commission Return for Policy No.'.$model_commission->policy_no.'due to deletion of file';
                            
                            $this->savetoCommissionLedger($modelDefermentDetails->commision_upload_id,$modelDefermentDetails->user_id,$modelDefermentDetails->cus_plan_id,
                                    date('Y-m-d'),$modelDefermentDetails->percentage,$modelDefermentDetails->total_amount,0 ,$modelDefermentDetails->in_amount,
                                    'EXE_DEF_COM_RET',$desc,'OUT','DEF',$modelDefermentDetails->provider_id,$modelDefermentDetails->customer_id,
                                    $modelDefermentDetails->mas_plan_id,'HOLD');
                            $this->deletefromCommissionLedger($id,'EXE_DEF_COM','IN','DEF','USED');
                            
                    }
                    }
                    //update totals to executive
                        $model_exe= User::model()->findbyPK($user_id);
                        $account_balance=$model_exe->account_total_amount-$exec_com_amount;
                        $account_defer=$model_exe->account_deferement_amount-$exec_defer_com_amount;
                        User::model()->updateByPK($user_id, array('account_total_amount' =>$account_balance,'account_deferement_amount' =>$account_defer,'updated_by'=>Yii::app()->user->id,'updated_date_time'=>date('Y-m-d H:i:s')));

                    //update totals to user company
                        $model_comp= User::model()->findbyPK(User::getCompany());
                        $account_balance=$model_comp->account_total_amount+$exec_com_amount+$exec_defer_com_amount;;
                        $account_defer=$model_comp->account_deferement_amount-$exec_defer_com_amount;
                        User::model()->updateByPK(User::getCompany(), array('account_total_amount' =>$account_balance,'account_deferement_amount' =>$account_defer,'updated_by'=>Yii::app()->user->id,'updated_date_time'=>date('Y-m-d H:i:s')));

                    //executive total commission including deferment amount
                    $total_exe_comm_amount =$exec_com_amount+$exec_defer_com_amount;
                    /*delete from another table start*/
                    //delete Quarterly commision- 3% of commision of executive commission
                    if($upload_type=='NB'){
                        $exec_quar_com = $mas_commission->executive_quarter_sale_commission;
                        $exec_quar_com_amount=$total_exe_comm_amount*$exec_quar_com/100;
                        $exec_quar_com_amount=number_format($exec_quar_com_amount, 6, '.', '');
                        $this->deletefromExecutiveHoldCommissionLedger($id,'EXE_QUA_COM','OUT','GEN','NA');
                        $this->deletefromExecutiveHoldCommissionLedger($id,'EXE_QUA_COM','IN','QUA','HOLD');
                        //delete annual commission- 3% of commision of executive commission
                        $exec_ann_com = $mas_commission->executive_annual_sale_commission;
                        $exec_ann_com_amount=$total_exe_comm_amount*$exec_ann_com/100;
                        $exec_ann_com_amount=number_format($exec_ann_com_amount, 6, '.', '');
                        $this->deletefromExecutiveHoldCommissionLedger($id,'EXE_ANN_COM','OUT','GEN','NA');
                        $this->deletefromExecutiveHoldCommissionLedger($id,'EXE_ANN_COM','IN','ANN','HOLD');
                    }
                    /* added to another table end*/
                    //delete commision amount of managers to commision ledger 
                    
                    $assistant_manger =$model_commission->customerdetails->executive->assistant_manager_id;
                    $manager =$model_commission->customerdetails->executive->manager_id;
                    if($manager=='0'){
                        $manager = $user_id;
                    }
                    $ass_manager_quarter_amount=$ass_manager_annual_amount=0;                        
                    $manager_quarter_amount=$manager_annual_amount=0;
                    if($assistant_manger >0){
                        $ass_manager_com = $mas_commission->assistant_manager_commission;
                        $ass_manager_amount=$total_exe_comm_amount*$ass_manager_com/100;
                        $ass_manager_amount=number_format($ass_manager_amount, 6, '.', '');
                        $this->deletefromCommissionLedger($id,'ASS_MAN_COM','OUT','GEN','NA');
                        $this->deletefromCommissionLedger($id,'ASS_MAN_COM','IN','GEN','NA');                     
                       /*delete from another table start*/
                        if($upload_type=='NB'){
                            //Quarterly commision- 3% of commision of assistant manager commission-- start
                            $ass_manager_qua_com = $mas_commission->ass_manager_quarter_sale_commission;
                            $ass_manager_quarter_amount=$ass_manager_amount*$ass_manager_qua_com/100;
                            $ass_manager_quarter_amount=number_format($ass_manager_quarter_amount, 6, '.', '');
                            $this->deletefromExecutiveHoldCommissionLedger($id,'ASS_MAN_QUA_COM','OUT','GEN','NA');
                            $this->deletefromExecutiveHoldCommissionLedger($id,'ASS_MAN_QUA_COM','IN','QUA','HOLD');
                            //Quarterly commision- 3% of commision of assistant manager commission-- end
                            //annual commision- 3% of commision of assistant manager commission-- start
                            $ass_manager_ann_com = $mas_commission->ass_manager_annual_sale_commission;
                            $ass_manager_annual_amount=$ass_manager_amount*$ass_manager_ann_com/100;
                            $this->deletefromExecutiveHoldCommissionLedger($id,'ASS_MAN_ANN_COM','OUT','GEN','NA');
                            $this->deletefromExecutiveHoldCommissionLedger($id,'ASS_MAN_ANN_COM','IN','ANN','HOLD');
                            //annual commision- 3% of commision of assistant manager commission-- end
                            
                        }
                        /* delete from another table end*/
                        $manager_com = $mas_commission->manager_with_assitant_commission;
                        $manager_amount=$total_exe_comm_amount*$manager_com/100;
                        $manager_amount=number_format($manager_amount, 6, '.', '');
                        $this->deletefromCommissionLedger($id,'MAN_COM','OUT','GEN','NA');  
                        $this->deletefromCommissionLedger($id,'MAN_COM','IN','GEN','NA');  
                        /*delete from another table start*/
                        if($upload_type=='NB'){
                            //Quarterly commision- 3% of commision of manager commission-- start
                            $manager_qua_com = $mas_commission->manager_quarter_sale_commission;
                            $manager_quarter_amount=$manager_amount*$manager_qua_com/100;
                            $manager_quarter_amount=number_format($manager_quarter_amount, 6, '.', '');
                            $this->deletefromExecutiveHoldCommissionLedger($id,'MAN_QUA_COM','OUT','GEN','NA');
                            $this->deletefromExecutiveHoldCommissionLedger($id,'MAN_QUA_COM','IN','QUA','HOLD');                           
                            //Quarterly commision- 3% of commision of manager commission-- end
                            //annual commision- 3% of commision of manager commission-- start
                            $manager_ann_com = $mas_commission->manager_annual_sale_commission;
                            $manager_annual_amount=$manager_amount*$manager_ann_com/100;
                            $manager_annual_amount=number_format($manager_annual_amount, 6, '.', '');
                            $this->deletefromExecutiveHoldCommissionLedger($id,'MAN_ANN_COM','OUT','GEN','NA');
                            $this->deletefromExecutiveHoldCommissionLedger($id,'MAN_ANN_COM','IN','ANN','HOLD');      
                            //annual commision- 3% of commision of manager commission-- end
                            
                        }
                        /* added to another table end*/
                        //update totals to assistant manager
                        $model_am= User::model()->findbyPK($assistant_manger);
                        $account_balance=$model_am->account_total_amount-$ass_manager_amount;
                        User::model()->updateByPK($assistant_manger, array('account_total_amount' =>$account_balance,'updated_by'=>Yii::app()->user->id,'updated_date_time'=>date('Y-m-d H:i:s')));
                        
                        //update totals to manager
                        $model_mr= User::model()->findbyPK($manager);
                        $account_balance=$model_mr->account_total_amount-$manager_amount;
                        User::model()->updateByPK($manager, array('account_total_amount' =>$account_balance,'updated_by'=>Yii::app()->user->id,'updated_date_time'=>date('Y-m-d H:i:s')));
                        //update totals to user company
                        $model_comp= User::model()->findbyPK(User::getCompany());
                        $account_balance=$model_comp->account_total_amount+$manager_amount+$ass_manager_amount;
                        User::model()->updateByPK(User::getCompany(), array('account_total_amount' =>$account_balance,'updated_by'=>Yii::app()->user->id,'updated_date_time'=>date('Y-m-d H:i:s')));

                    }else{
                        $manager_com = $mas_commission->manager_total_commision;
                        $manager_amount=$total_exe_comm_amount*$manager_com/100;
                        $manager_amount=number_format($manager_amount, 6, '.', '');
                        $this->deletefromCommissionLedger($id,'MAN_COM','OUT','GEN','NA');   
                        $this->deletefromCommissionLedger($id,'MAN_COM','IN','GEN','NA');                          
                        /*delete from another table start*/                                    
                        if($upload_type=='NB'){
                            //Quarterly commision- 3% of commision of manager commission-- start
                            $manager_qua_com = $mas_commission->manager_quarter_sale_commission;
                            $manager_quarter_amount=$manager_amount*$manager_qua_com/100;
                            $manager_quarter_amount=number_format($manager_quarter_amount, 6, '.', '');
                            $this->deletefromExecutiveHoldCommissionLedger($id,'MAN_QUA_COM','OUT','GEN','NA');
                            $this->deletefromExecutiveHoldCommissionLedger($id,'MAN_QUA_COM','IN','QUA','HOLD');                     
                            //Quarterly commision- 3% of commision of manager commission-- end
                            //annual commision- 3% of commision of manager commission-- start
                            $manager_ann_com = $mas_commission->manager_annual_sale_commission;
                            $manager_annual_amount=$manager_amount*$manager_ann_com/100;
                            $manager_annual_amount=number_format($manager_annual_amount, 6, '.', '');
                            $this->deletefromExecutiveHoldCommissionLedger($id,'MAN_ANN_COM','OUT','GEN','NA');
                            $this->deletefromExecutiveHoldCommissionLedger($id,'MAN_ANN_COM','IN','ANN','HOLD');         
                            //annual commision- 3% of commision of manager commission-- end
                            
                        }
                        /* delete from another table end*/
                        //update totals to manager
                        $model_mr= User::model()->findbyPK($manager);
                        $account_balance=$model_mr->account_total_amount-$manager_amount;
                        User::model()->updateByPK($manager, array('account_total_amount' =>$account_balance,'updated_by'=>Yii::app()->user->id,'updated_date_time'=>date('Y-m-d H:i:s')));
                        //update totals to user company
                        $model_comp= User::model()->findbyPK(User::getCompany());
                        $account_balance=$model_comp->account_total_amount+$manager_amount;
                        User::model()->updateByPK(User::getCompany(), array('account_total_amount' =>$account_balance,'updated_by'=>Yii::app()->user->id,'updated_date_time'=>date('Y-m-d H:i:s')));
                    }                                 
            }else{
                $upload_amount=-$upload_amount;
                //delete provider given whole amount from commision ledger
                $this->deletefromCommissionLedger($id,'PRO_RETURN','OUT','GEN','NA');                 
                $vat_percent=$model_commission->customerplan->masplandetails->general_vat;
                $vat_amount=$upload_amount*$vat_percent/100;
                $vat_amount=number_format($vat_amount, 6, '.', '');
                //delete general vat from commision ledger           
                $this->deletefromCommissionLedger($id,'VAT_IN','IN','GEN','NA');     
                //save amount deducting vat to commision ledger            
                $net_amount=$upload_amount-$vat_amount;
                $this->deletefromCommissionLedger($id,'VAT_OUT','OUT','VAT','NA');     
                //update totals to user company                            
                $model_comp= User::model()->findbyPK(User::getCompany());
                $account_balance=$model_comp->account_total_amount+$upload_amount-$vat_amount;
                $account_vat=$model_comp->account_vat_amount+$vat_amount;
                User::model()->updateByPK(User::getCompany(), array('account_total_amount' =>$account_balance,'account_vat_amount' =>$account_vat,'updated_by'=>Yii::app()->user->id,'updated_date_time'=>date('Y-m-d H:i:s')));
                //delete commision amount return of executive from commision ledger 
                    $exec_defer_com_amount=0;
                    if($icp_months<12 || $upload_type!='NB'){//if not a deferment plan add full commission to excecutive account
                        //executive commission
                        $exec_com = $mas_commission->executive_commission_without_deferment;
                        $exec_com_amount=$net_amount*$exec_com/100;
                        $exec_com_amount=number_format($exec_com_amount, 6, '.', '');
                        $this->deletefromCommissionLedger($id,'EXE_COM_RET','IN','GEN','NA');  
                        $this->deletefromCommissionLedger($id,'EXE_COM_RET','OUT','GEN','NA');                         
                        //update totals to executive
                        $model_exe= User::model()->findbyPK($user_id);
                        $account_balance=$model_exe->account_total_amount+$exec_com_amount;
                        $account_defer=$model_exe->account_deferement_amount+$exec_defer_com_amount;
                        User::model()->updateByPK($user_id, array('account_total_amount' =>$account_balance,'account_deferement_amount' =>$account_defer,'updated_by'=>Yii::app()->user->id,'updated_date_time'=>date('Y-m-d H:i:s')));
                    }else{
                        //executive commission holded in deferment account
                        $exe_cond ='type="EXE_DEF_COM" and in_or_out="IN" AND cus_plan_id="'.$model_commission->customer_plan_id.'" AND user_id="'.$user_id.'" AND status="HOLD"';
                        $exe_def_com_bal= CommissionLedger::model()->find(array('select'=>'SUM(in_amount) AS in_amount','condition'=>$exe_cond))->in_amount;
                        //executive commission
                        $exec_com = $mas_commission->executive_commission_with_deferment;
                        $exec_com_amount=$net_amount*$exec_com/100;
                        $exec_com_amount=number_format($exec_com_amount, 6, '.', '');
                        //deferment commission                        
                        $exec_defer_com = $mas_commission->excecutive_deferment_commission;
                        $exec_defer_com_amount=$net_amount*$exec_defer_com/100;
                        $exec_defer_com_amount=number_format($exec_defer_com_amount, 6, '.', '');
                        //totalamount returned on clawback
                        $exe_claw_total =$exec_com_amount+$exec_defer_com_amount;
                        $model_exe= User::model()->findbyPK($user_id);
                        if($exe_def_com_bal>=$exe_claw_total){
                            $account_balance=$model_exe->account_total_amount;
                            $account_defer=$model_exe->account_deferement_amount+$exe_claw_total;
                            $this->deletefromCommissionLedger($id,'EXE_DEF_COM_RET','IN','GEN','NA');  
                            $modelDefermentDetails = CommissionLedger::model()->find(array('condition'=>'commision_upload_id="'.$id.'" AND type="EXE_DEF_COM_RET" AND in_or_out="OUT" AND user_account="DEF" AND status="USED"'));
                            if(empty($modelDefermentDetails)){
                            $this->deletefromCommissionLedger($id,'EXE_DEF_COM_RET','OUT','DEF','HOLD');  
                            }
                            else{
                                $model_commission=CommissionUploaded::model()->findByPk($id);
                                $desc='Executive Deferment Commission for Policy No.'.$model_commission->policy_no.'due to deletion of clawback file';

                                $this->savetoCommissionLedger($modelDefermentDetails->commision_upload_id,$modelDefermentDetails->user_id,$modelDefermentDetails->cus_plan_id,
                                        date('Y-m-d'),$modelDefermentDetails->percentage,$modelDefermentDetails->total_amount,$modelDefermentDetails->out_amount ,0,
                                        'EXE_DEF_COM',$desc,'IN','DEF',$modelDefermentDetails->provider_id,$modelDefermentDetails->customer_id,
                                        $modelDefermentDetails->mas_plan_id,'HOLD');
                                $this->deletefromCommissionLedger($id,'EXE_DEF_COM_RET','OUT','DEF','USED');

                            }                                 
                        }else{
                            $return_frm_exe= $exe_claw_total-$exe_def_com_bal;
                            $account_balance=$model_exe->account_total_amount+$return_frm_exe;
                            $account_defer=$model_exe->account_deferement_amount+$exe_def_com_bal;    
                            $this->deletefromCommissionLedger($id,'EXE_DEF_COM_RET','IN','GEN','NA');  
                            $modelDefermentDetails = CommissionLedger::model()->find(array('condition'=>'commision_upload_id="'.$id.'" AND type="EXE_DEF_COM_RET" AND in_or_out="OUT" AND user_account="DEF" AND status="USED"'));
                            if(empty($modelDefermentDetails)){
                            $this->deletefromCommissionLedger($id,'EXE_DEF_COM_RET','OUT','DEF','HOLD');  
                            }
                            else{
                                $model_commission=CommissionUploaded::model()->findByPk($id);
                                $desc='Executive Deferment Commission for Policy No.'.$model_commission->policy_no.'due to deletion of clawback file';

                                $this->savetoCommissionLedger($modelDefermentDetails->commision_upload_id,$modelDefermentDetails->user_id,$modelDefermentDetails->cus_plan_id,
                                        date('Y-m-d'),$modelDefermentDetails->percentage,$modelDefermentDetails->total_amount,$modelDefermentDetails->out_amount ,0,
                                        'EXE_DEF_COM',$desc,'IN','DEF',$modelDefermentDetails->provider_id,$modelDefermentDetails->customer_id,
                                        $modelDefermentDetails->mas_plan_id,'HOLD');
                                $this->deletefromCommissionLedger($id,'EXE_DEF_COM_RET','OUT','DEF','USED');

                            }      
                            $this->deletefromCommissionLedger($id,'EXE_DEF_COM_RET','OUT','DEF','HOLD');  
                            $this->deletefromCommissionLedger($id,'EXE_COM_RET','OUT','GEN','NA');  
                            $this->deletefromCommissionLedger($id,'EXE_COM_RET','IN','GEN','NA');                         
                        }
                        //update totals to executive                        
                        User::model()->updateByPK($user_id, array('account_total_amount' =>$account_balance,'account_deferement_amount' =>$account_defer,'updated_by'=>Yii::app()->user->id,'updated_date_time'=>date('Y-m-d H:i:s')));
                    }
                    
                    //update totals to user company
                        $model_comp= User::model()->findbyPK(User::getCompany());
                        $account_balance=$model_comp->account_total_amount-$exec_com_amount-$exec_defer_com_amount;;
                        $account_defer=$model_comp->account_deferement_amount+$exec_defer_com_amount;
                        User::model()->updateByPK(User::getCompany(), array('account_total_amount' =>$account_balance,'account_deferement_amount' =>$account_defer,'updated_by'=>Yii::app()->user->id,'updated_date_time'=>date('Y-m-d H:i:s')));
                    //executive total commission including deferment amount
                    $total_exe_comm_amount =$exec_com_amount+$exec_defer_com_amount;
                    /*deleted from another table start*/
                    //Quarterly commision- 3% of commision of executive commission
                    if($upload_type=='NB'){
                        $exec_quar_com = $mas_commission->executive_quarter_sale_commission;
                        $exec_quar_com_amount=$total_exe_comm_amount*$exec_quar_com/100; 
                        $exec_quar_com_amount=number_format($exec_quar_com_amount, 6, '.', '');
                        $this->deletefromExecutiveHoldCommissionLedger($id,'EXE_QUA_COM_RET','IN','GEN','NA'); 
                        $this->deletefromExecutiveHoldCommissionLedger($id,'EXE_QUA_COM_RET','OUT','QUA','HOLD');             
                        //annual commission- 3% of commision of executive commission
                        $exec_ann_com = $mas_commission->executive_annual_sale_commission;
                        $exec_ann_com_amount=$total_exe_comm_amount*$exec_ann_com/100;
                        $exec_ann_com_amount=number_format($exec_ann_com_amount, 6, '.', '');
                        $this->deletefromExecutiveHoldCommissionLedger($id,'EXE_ANN_COM_RET','IN','GEN','NA');      
                        $this->deletefromExecutiveHoldCommissionLedger($id,'EXE_ANN_COM_RET','OUT','ANN','HOLD');      
                    }
                    /* deleted from another table end*/
                    //save commision amount of managers to commision ledger 
                    $assistant_manger =$model_commission->customerdetails->executive->assistant_manager_id;
                    $manager =$model_commission->customerdetails->executive->manager_id;
                    if($manager=='0'){
                        $manager = $user_id;
                    }
                    if($assistant_manger >0){
                        $ass_manager_com = $mas_commission->assistant_manager_commission;
                        $ass_manager_amount=$total_exe_comm_amount*$ass_manager_com/100;
                        $ass_manager_amount=number_format($ass_manager_amount, 6, '.', '');
                        $this->deletefromCommissionLedger($id,'ASS_MAN_COM_RET','IN','GEN','NA');  
                        $this->deletefromCommissionLedger($id,'ASS_MAN_COM_RET','OUT','GEN','NA');                         
                       /*deleted from another table start*/
                        if($upload_type=='NB'){
                            //Quarterly commision- 3% of commision of assistant manager commission-- start
                            $ass_manager_qua_com = $mas_commission->ass_manager_quarter_sale_commission;
                            $ass_manager_quarter_amount=$ass_manager_amount*$ass_manager_qua_com/100;
                            $ass_manager_quarter_amount=number_format($ass_manager_quarter_amount, 6, '.', '');
                            $this->deletefromExecutiveHoldCommissionLedger($id,'ASS_MAN_QUA_COM_RET','IN','GEN','NA');    
                            $this->deletefromExecutiveHoldCommissionLedger($id,'ASS_MAN_QUA_COM_RET','OUT','QUA','HOLD');    
                            //Quarterly commision- 3% of commision of assistant manager commission-- end                      
                            //annual commision- 3% of commision of assistant manager commission-- start
                            $ass_manager_ann_com = $mas_commission->ass_manager_annual_sale_commission;
                            $ass_manager_annual_amount=$ass_manager_amount*$ass_manager_ann_com/100;
                            $ass_manager_annual_amount=number_format($ass_manager_annual_amount, 6, '.', '');
                            $this->deletefromExecutiveHoldCommissionLedger($id,'ASS_MAN_ANN_COM_RET','IN','GEN','NA');   
                            $this->deletefromExecutiveHoldCommissionLedger($id,'ASS_MAN_ANN_COM_RET','OUT','ANN','HOLD');   
                            //annual commision- 3% of commision of assistant manager commission-- end                       
                        }
                        /* deleted from another table end*/
                        $manager_com = $mas_commission->manager_with_assitant_commission;
                        $manager_amount=$total_exe_comm_amount*$manager_com/100;
                        $manager_amount=number_format($manager_amount, 6, '.', '');
                        $this->deletefromCommissionLedger($id,'MAN_COM_RET','IN','GEN','NA');  
                        $this->deletefromCommissionLedger($id,'MAN_COM_RET','OUT','GEN','NA');  
                        /*deleted from another table start*/
                        if($upload_type=='NB'){
                            //Quarterly commision- 3% of commision of manager commission-- start
                            $manager_qua_com = $mas_commission->manager_quarter_sale_commission;
                            $manager_quarter_amount=$manager_amount*$manager_qua_com/100;
                            $manager_quarter_amount=number_format($manager_quarter_amount, 6, '.', '');
                            $this->deletefromExecutiveHoldCommissionLedger($id,'MAN_QUA_COM_RET','IN','GEN','NA');    
                            $this->deletefromExecutiveHoldCommissionLedger($id,'MAN_QUA_COM_RET','OUT','QUA','HOLD');    
                            //Quarterly commision- 3% of commision of manager commission-- end
                            //annual commision- 3% of commision of manager commission-- start
                            $manager_ann_com = $mas_commission->manager_annual_sale_commission;
                            $manager_annual_amount=$manager_amount*$manager_ann_com/100;
                            $manager_annual_amount=number_format($manager_annual_amount, 6, '.', '');
                            $this->deletefromExecutiveHoldCommissionLedger($id,'MAN_ANN_COM_RET','IN','GEN','NA');
                            $this->deletefromExecutiveHoldCommissionLedger($id,'MAN_ANN_COM_RET','OUT','ANN','HOLD');
                            //annual commision- 3% of commision of manager commission-- end
                            
                        }
                        /* added to another table end*/
                        //update totals to assistant manager
                        $model_am= User::model()->findbyPK($assistant_manger);
                        $account_balance=$model_am->account_total_amount+$ass_manager_amount;
                        User::model()->updateByPK($assistant_manger, array('account_total_amount' =>$account_balance,'updated_by'=>Yii::app()->user->id,'updated_date_time'=>date('Y-m-d H:i:s')));
                        
                        //update totals to manager
                        $model_mr= User::model()->findbyPK($manager);
                        $account_balance=$model_mr->account_total_amount+$manager_amount;
                        User::model()->updateByPK($manager, array('account_total_amount' =>$account_balance,'updated_by'=>Yii::app()->user->id,'updated_date_time'=>date('Y-m-d H:i:s')));
                        //update totals to user company
                        $model_comp= User::model()->findbyPK(User::getCompany());
                        $account_balance=$model_comp->account_total_amount-$manager_amount-$ass_manager_amount;
                        User::model()->updateByPK(User::getCompany(), array('account_total_amount' =>$account_balance,'updated_by'=>Yii::app()->user->id,'updated_date_time'=>date('Y-m-d H:i:s')));

                    }else{
                        $manager_com = $mas_commission->manager_total_commision;
                        $manager_amount=$total_exe_comm_amount*$manager_com/100;
                        $manager_amount=number_format($manager_amount, 6, '.', '');
                        $this->deletefromCommissionLedger($id,'MAN_COM_RET','IN','GEN','NA');  
                        $this->deletefromCommissionLedger($id,'MAN_COM_RET','OUT','GEN','NA');  
                        /*deleted from another table start*/
                        if($upload_type=='NB'){
                            //Quarterly commision- 3% of commision of manager commission-- start
                            $manager_qua_com = $mas_commission->manager_quarter_sale_commission;
                            $manager_quarter_amount=$manager_amount*$manager_qua_com/100;
                            $manager_quarter_amount=number_format($manager_quarter_amount, 6, '.', '');
                            $this->deletefromExecutiveHoldCommissionLedger($id,'MAN_QUA_COM_RET','IN','GEN','NA');     
                            $this->deletefromExecutiveHoldCommissionLedger($id,'MAN_QUA_COM_RET','OUT','QUA','HOLD');     
                            //Quarterly commision- 3% of commision of manager commission-- end
                            //annual commision- 3% of commision of manager commission-- start
                            $manager_ann_com = $mas_commission->manager_annual_sale_commission;
                            $manager_annual_amount=$manager_amount*$manager_ann_com/100;
                            $manager_annual_amount=number_format($manager_annual_amount, 6, '.', '');
                            $this->deletefromExecutiveHoldCommissionLedger($id,'MAN_ANN_COM_RET','IN','GEN','NA');     
                            $this->deletefromExecutiveHoldCommissionLedger($id,'MAN_ANN_COM_RET','OUT','ANN','HOLD');     
                          //annual commision- 3% of commision of manager commission-- end
                            
                        }
                        /* added to another table end*/
                        //update totals to manager
                        $model_mr= User::model()->findbyPK($manager);
                        $account_balance=$model_mr->account_total_amount+$manager_amount;
                        User::model()->updateByPK($manager, array('account_total_amount' =>$account_balance,'updated_by'=>Yii::app()->user->id,'updated_date_time'=>date('Y-m-d H:i:s')));
                        //update totals to user company
                        $model_comp= User::model()->findbyPK(User::getCompany());
                        $account_balance=$model_comp->account_total_amount-$manager_amount;
                        User::model()->updateByPK(User::getCompany(), array('account_total_amount' =>$account_balance,'updated_by'=>Yii::app()->user->id,'updated_date_time'=>date('Y-m-d H:i:s')));

                    }
            }
        }
            
        return true;
                
    }  
    //deletefromCommissionLedger-start
    public function deletefromCommissionLedger($id,$type,$in_or_out,$user_account,$status) {
        CommissionLedger::model()->deleteAll('commision_upload_id=:refer_id AND type=:type_id AND in_or_out=:in_or_out AND user_account=:user_account AND status=:status', array(':refer_id' => $id,':type_id' => $type,':in_or_out' => $in_or_out,':user_account' => $user_account,':status' => $status));     
        return true;
    }    
    //deletefromCommissionLedger-end
    //deletefromCommissionLedger-start
    public function deletefromExecutiveHoldCommissionLedger($id,$type,$in_or_out,$user_account,$status) {
        ExecutiveHoldCommission::model()->deleteAll('commision_upload_id=:refer_id AND type=:type_id AND in_or_out=:in_or_out AND user_account=:user_account AND status=:status', array(':refer_id' => $id,':type_id' => $type,':in_or_out' => $in_or_out,':user_account' => $user_account,':status' => $status));     
        return true;
    }    
    //deletefromCommissionLedger-end
                }