<?php

class ActivityController extends Controller
{
	public function accessRules() {
        return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                    'actions' => array('login', 'error', 'logout'),
                    'users' => array('*'),
                    ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                    'actions' => array('Create','saveCalls','GetActivityList','saveAppointment','saveVisit','saveFactApplicationPresentationReview','SaveApproveFactFind',
                                        'loadactivityPage','Upload','GetDocumentList','editdocumentdetails','Calendar','Calenderdetails','saveActivityDocument',
                                        'downloaddocument','deletedocument','getcallbackdetails','Deleteactivitydetails','factfind','GetfactfindList',
                                        'ApproveFactfind','SaveRejectFactFind','deletefactfind',
                                        'downloaddocuments'),
                    'expression' => '$user->isMember()',
                    ),
                array('deny', // deny all users
                    'users' => array('*'),
                    ),
                );
    }
    public function filters()
    {
        return array(
            'accessControl', // perform access control for CRUD operations
            );
    }
    /**
     * This is the default 'index' action that is invoked
     * when an action is not explicitly requested by users.
     */
    public function actionCreate() {
        $customer_id= (int) Yii::app()->request->getParam('customer_id');
        //Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
        Yii::app()->clientScript->scriptMap = array('jquery.js' => false, 'jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
        //Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false , 'jquery-2.1.4.min.js' => false);
        $this->render('activity_form',array('customer_id'=>$customer_id));
    }
    //Code to save calls-start
    public function actionsaveCalls() {
        if (isset($_POST['Activity'])) {
            $model = new Activity();
            if ((int) @$_POST['Activity']['id'] > 0) {
                $model->id = (int) $_POST['Activity']['id'];
                $model = $model->findByPK($model->id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_datetime = date('Y-m-d H:i:s');
            }else{
                $model->created_by = Yii::app()->user->id;
                $model->created_datetime = date('Y-m-d H:i:s');
            }
            $model->attributes = $_POST['Activity'];
            if ($_POST['Activity']['call_date'] != '0000-00-00' && $_POST['Activity']['call_date'] != '' && $_POST['Activity']['call_time'] != '00:00:00' && $_POST['Activity']['call_time'] != '') {
                $call_date=$_POST['Activity']['call_date'].' '.$_POST['Activity']['call_time'];
                $call_date=str_replace('/', '-',$call_date);
                $call_date=date("Y-m-d H:i:s", strtotime($call_date)); 
                $model->call_or_plan_date_time = $call_date;
            }
            if ($_POST['Activity']['callback_date'] != '0000-00-00' && $_POST['Activity']['callback_date'] != '' && $_POST['Activity']['callback_time'] != '00:00:00' && $_POST['Activity']['callback_time'] != '') {
                $callback_date=$_POST['Activity']['callback_date'].' '.$_POST['Activity']['callback_time'];
                $callback_date=str_replace('/', '-',$callback_date);
                $callback_date=date("Y-m-d H:i:s", strtotime($callback_date));
                $model->call_back_or_actual_date = $callback_date;
            }
             $model->activity_notes = $_POST['Activity']['activity_notes']; 
             $model->fact_find_status =2;
            if ($model->validate()) {
                $model->save();
                $jsonData['customer_id'] =$model->customer_id;
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    //Code to save calls-ends
    //Start Activity List
    public function actionGetActivityList(){
        $model=new Activity();
        $draw    = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $id= $_POST['id'];
        $customer_id= $_POST['customer_id'];
        $type= $_POST['type'];
        $columns = array(
            0 =>'id',
            1 =>'type_of_activity',
            2 =>'call_or_plan_date_time',
            3 =>'call_back_or_actual_date',
            4 =>'activity_notes',
            5=>'created_by',
            6=>'created_datetime',
            7=>'',
            8=>''
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy   = $filterColumn." ".$filterOrder;
        $condition = "A.customer_id='".$customer_id."'"; 
        $condition_1 = "E.customer_id='".$customer_id."'"; 
        if (isset(Yii::app()->user->havePermissionOn['activity_welcome']) ) { 
            
        }else{
            $condition.= " AND A.type_of_activity!='12'"; 
        }
        if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
        {
          $searchString = $_POST['search']['value'];
          $condition.=" AND (A.activity_notes LIKE '%".$searchString."%')";
        }
        if($type>0 && $type!='CR'){
            $condition.= ' AND A.type_of_activity="'.$type.'"';
            $sql_activity ='select A.id as id,A.customer_id AS customer_id,A.type_of_activity AS type_of_activity,A.call_or_plan_date_time AS call_or_plan_date_time,A.call_back_or_actual_date AS call_back_or_actual_date,
                A.activity_notes AS activity_notes,A.created_by AS created_by,A.created_datetime AS created_datetime,"0" as executive_id,"0" as request_executive_id,"AY" AS type,isActive AS status from crm_activity A  where '.$condition.' order by call_or_plan_date_time desc';              
        }else if($type=='CR'){
            $sql_activity ='select E.id as id,E.customer_id AS customer_id,"","","","",E.created_by as created_by,E.created_date_time as created_date_time,E.executive_id as executive_id,E.request_executive_id as request_executive_id,"CR" AS type,"Y" AS status from crm_executive_request E where '.$condition_1.' order by created_date_time desc';  
        }else{
            $sql_activity ='select A.id as id,A.customer_id AS customer_id,A.type_of_activity AS type_of_activity,A.call_or_plan_date_time AS call_or_plan_date_time,A.call_back_or_actual_date AS call_back_or_actual_date,
                A.activity_notes AS activity_notes,A.created_by AS created_by,A.created_datetime AS created_datetime,"0" as executive_id,"0" as request_executive_id,"AY" AS type,isActive AS status from crm_activity A  where '.$condition.'
                union 
                select E.id as id,E.customer_id AS customer_id,"","","","",E.created_by as created_by,E.created_date_time as created_date_time,E.executive_id as executive_id,E.request_executive_id as request_executive_id,"CR" AS type,"Y" AS status from crm_executive_request E where '.$condition_1.' order by call_or_plan_date_time desc';               
        }
        
        $model=Yii::app()->db->createCommand($sql_activity)->queryAll(); 
        $count=count($model);
        //$count = $model->count(array('condition'=>$condition));
        //$model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));
        
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData=array();
        $m=1;        
        foreach ($model as $row)
        {
            $button_string=""; 
            $call_or_plan_date_time="-";
            $call_back_or_actual_date="-";
            $created_datetime="";
            $activity_type='';
            if($row['type']=='AY'){
                $activity_type=Activity::gettype($row['type_of_activity']);
                if($row['call_or_plan_date_time']!='' && $row['call_or_plan_date_time']!='0000-00-00 00:00:00'){
                $call_or_plan_date_time=date("d/m/Y H:i",strtotime($row['call_or_plan_date_time']));
                }
                if($row['type_of_activity']!=1){
                    if($row['call_back_or_actual_date']!='' && $row['call_back_or_actual_date']!='0000-00-00 00:00:00'){
                        $call_back_or_actual_date=date("d/m/Y H:i",strtotime($row['call_back_or_actual_date']));
                    }
                }
                if($row['created_datetime']!='' && $row['created_datetime']!='0000-00-00 00:00:00'){
                    $created_datetime=date("d/m/Y H:i",strtotime($row['created_datetime']));
                }
                $activity_notes='';
                if($row['type_of_activity']==4){
                    $activity_notes_array=  explode(',', $row['activity_notes']);    
                    $activity_notes='';
                    foreach ($activity_notes_array as $value_1) {
                        $activity_notes.=$value_1.'</br>';
                    }
                }else{
                    $activity_notes=$row['activity_notes'];   
                }
                if ($row['type_of_activity']==2 || $row['type_of_activity']==3) {
                    $button_string.= '<button class="btn btn-primary btn-xs" title="Edit" onclick="editactivitydetails(' . $row['type_of_activity'] . ',' . $row['id'] . ');"><i class="fa fa-edit"></i></button>&nbsp;';       
                }
                $model_provider_info=ProviderSendReceiveInfo::model()->findAll(array('condition'=>'activity_id="'.$row['id'].'"'));

                if($row['status']=='Y' && empty($model_provider_info) && ((int) Yii::app()->user->havePermissionOn["activity_delete"])){
                    $button_string.= '<button class="btn btn-primary btn-xs" title="Delete" onclick="deleteactivitydetails(' . $row['id']. ');"><i class="fa fa-trash"></i></button>&nbsp;';       
                }
            }else if($row['type']=='CR'){
                $activity_type='Change Request for Executive';
                $model_new_executive= User::model()->findByPk($row['request_executive_id']);
                $model_ch_executive= ExecutiveRequest::model()->findByPk($row['id']);
                $msg='';
                if($model_ch_executive->status==0){
                    $msg='Waiting for approval.';
                }else if($model_ch_executive->status==1){
                    $msg='The Request was approved on '.date("d/m/Y H:i",strtotime($model_ch_executive->approved_date_time)).' by '.$model_ch_executive->addedby->fullname.'.';
                }else if($model_ch_executive->status==2){
                    $msg='The Request was rejected on '.date("d/m/Y H:i",strtotime($model_ch_executive->approved_date_time)).' by '.$model_ch_executive->addedby->fullname.'.';
                }else if($model_ch_executive->status==3){
                    $msg='The Request was put on hold.';
                }
                $activity_notes='Change Request given by '.$model_new_executive->fullname.'.'.$msg;
                if($model_ch_executive->created_date_time!='' && $model_ch_executive->created_date_time!='0000-00-00 00:00:00'){
                    $created_datetime=date("d/m/Y h:i:s a",strtotime($model_ch_executive->created_date_time));
                }
            }
            $model_user= User::model()->findByPk($row['created_by']);
            $name=$model_user->fullname;
            $rowData[]=array($m,$activity_type,$call_or_plan_date_time,$call_back_or_actual_date,$activity_notes,$name,$created_datetime,$button_string,$row['status']);
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
     //End Activity List
    //Code to save Appointment details-Start
    public function actionsaveAppointment() {
        if (isset($_POST['Activity'])) {
            $model = new Activity();
            if ((int) @$_POST['Activity']['id'] > 0) {
                $model->id = (int) $_POST['Activity']['id'];
                $model = $model->findByPK($model->id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_datetime = date('Y-m-d H:i:s');
            }else{
                $model->created_by = Yii::app()->user->id;
                $model->created_datetime = date('Y-m-d H:i:s');
            }
            $model->attributes = $_POST['Activity'];
            if ($_POST['Activity']['plan_date'] != '0000-00-00' && $_POST['Activity']['plan_date'] != '' && $_POST['Activity']['plan_time'] != '00:00:00' && $_POST['Activity']['plan_time'] != '') {
                $plan_date=$_POST['Activity']['plan_date'].' '.$_POST['Activity']['plan_time'];
                $plan_date=str_replace('/', '-',$plan_date);
                $plan_date=date("Y-m-d H:i:s", strtotime($plan_date)); 
                $model->call_or_plan_date_time = $plan_date;
            }
            if ($_POST['Activity']['actual_date'] != '0000-00-00' && $_POST['Activity']['actual_date'] != '' && $_POST['Activity']['actual_time'] != '00:00:00' && $_POST['Activity']['actual_time'] != '') {
                $actual_date=$_POST['Activity']['actual_date'].' '.$_POST['Activity']['actual_time'];
                $actual_date=str_replace('/', '-',$actual_date);
                $actual_date=date("Y-m-d H:i:s", strtotime($actual_date)); 
                $model->call_back_or_actual_date = $actual_date;
            }
            $model->duration = $_POST['Activity']['duration'];
            $model->activity_notes = $_POST['Activity']['activity_notes'];   
            $model->fact_find_status =2;
            if ($model->validate()) {
                $model->save();
                $jsonData['customer_id'] =$model->customer_id;
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    //Code to save Appointment details-End
    //Code to save Appointment details-Joint Field Visit
    public function actionsaveVisit() {
        if (isset($_POST['Activity'])) {
            $model = new Activity();
            if ((int) @$_POST['Activity']['id'] > 0) {
                $model->id = (int) $_POST['Activity']['id'];
                $model = $model->findByPK($model->id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_datetime = date('Y-m-d H:i:s');
            }else{
                $model->created_by = Yii::app()->user->id;
                $model->created_datetime = date('Y-m-d H:i:s');
            }
            $model->attributes = $_POST['Activity'];
            if ($_POST['Activity']['plan_date_1'] != '0000-00-00' && $_POST['Activity']['plan_date_1'] != '' && $_POST['Activity']['plan_time_1'] != '00:00:00' && $_POST['Activity']['plan_time_1'] != '') {
                $plan_date=$_POST['Activity']['plan_date_1'].' '.$_POST['Activity']['plan_time_1'];
                $plan_date=str_replace('/', '-',$plan_date);
                $plan_date=date("Y-m-d H:i:s", strtotime($plan_date)); 
                $model->call_or_plan_date_time = $plan_date;
            }
            if ($_POST['Activity']['actual_date_1'] != '0000-00-00' && $_POST['Activity']['actual_date_1'] != '' && $_POST['Activity']['actual_time_1'] != '00:00:00' && $_POST['Activity']['actual_time_1'] != '') {
                $actual_date=$_POST['Activity']['actual_date_1'].' '.$_POST['Activity']['actual_time_1'];
                $actual_date=str_replace('/', '-',$actual_date);
                $actual_date=date("Y-m-d H:i:s", strtotime($actual_date)); 
                $model->call_back_or_actual_date = $actual_date;
            }
            $model->duration = $_POST['Activity']['duration'];
            $model->activity_notes = $_POST['Activity']['activity_notes']; 
            if(isset($_POST['Activity']['manager_id']) && count($_POST['Activity']['manager_id']) > 0){
                    $model->manager_id = implode(',',$_POST['Activity']['manager_id']);
                }else{
                    $model->manager_id = "";
                }
            if ($model->validate()) {
                $model->save();
                $jsonData['customer_id'] =$model->customer_id;
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }
       //Code to save Joint Field Visit details-Ends
       //Code to save Fact find/Application/Presentation/Review details-Start
    public function actionsaveFactApplicationPresentationReview() {
        if (isset($_POST['Activity'])) {
            $model = new Activity();
            if ((int) @$_POST['Activity']['id'] > 0) {
                $model->id = (int) $_POST['Activity']['id'];
                $model = $model->findByPK($model->id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_datetime = date('Y-m-d H:i:s');
            }else{
                $model->created_by = Yii::app()->user->id;
                $model->created_datetime = date('Y-m-d H:i:s');
            }
            $model->attributes = $_POST['Activity'];
            $type_of_activity = $_POST['Activity']['type_of_activity'];
            $plan_id = $_POST['Activity']['plan_id'];
            //Fact Find Date-Start
            if ($_POST['Activity']['actual_date_2'] != '0000-00-00' && $_POST['Activity']['actual_date_2'] != '' && $_POST['Activity']['actual_time_2'] != '00:00:00' && $_POST['Activity']['actual_time_2'] != '') {
                $actual_date=$_POST['Activity']['actual_date_2'].' '.$_POST['Activity']['actual_time_2'];
                $actual_date=str_replace('/', '-',$actual_date);
                $actual_date=date("Y-m-d H:i:s", strtotime($actual_date)); 
                $model->call_back_or_actual_date = $actual_date;
                $model->fact_find_status =1;
            }
            //Fact Find Date-End
            //Presentation Date-Start
            if ($_POST['Activity']['actual_date_3'] != '0000-00-00' && $_POST['Activity']['actual_date_3'] != '' && $_POST['Activity']['actual_time_3'] != '00:00:00' && $_POST['Activity']['actual_time_3'] != '') {
                $actual_date=$_POST['Activity']['actual_date_3'].' '.$_POST['Activity']['actual_time_3'];
                $actual_date=str_replace('/', '-',$actual_date);
                $actual_date=date("Y-m-d H:i:s", strtotime($actual_date)); 
                $model->call_back_or_actual_date = $actual_date;
                $model->fact_find_status =2;
            }
            //Presentation Date-End
            //Application Date-Start
            if ($_POST['Activity']['actual_date_4'] != '0000-00-00' && $_POST['Activity']['actual_date_4'] != '' && $_POST['Activity']['actual_time_4'] != '00:00:00' && $_POST['Activity']['actual_time_4'] != '') {
                $actual_date=$_POST['Activity']['actual_date_4'].' '.$_POST['Activity']['actual_time_4'];
                $actual_date=str_replace('/', '-',$actual_date);
                $actual_date=date("Y-m-d H:i:s", strtotime($actual_date)); 
                $model->call_back_or_actual_date = $actual_date;
                $model->fact_find_status =2;
            }
            //Application Date-End
            //Welcome Call-Start
            if ($_POST['Activity']['actual_date_7'] != '0000-00-00' && $_POST['Activity']['actual_date_7'] != '') {
                $actual_date=str_replace('/', '-',$_POST['Activity']['actual_date_7']);
                $actual_date=date("Y-m-d", strtotime($actual_date)); 
                $model->call_back_or_actual_date = $actual_date;
                $model->fact_find_status =2;
            }
            //Welcome Call-End
              //Review Date-Start
            if ($_POST['Activity']['actual_date_5'] != '0000-00-00' && $_POST['Activity']['actual_date_5'] != '' && $_POST['Activity']['actual_time_5'] != '00:00:00' && $_POST['Activity']['actual_time_5'] != '') {
                $actual_date=$_POST['Activity']['actual_date_5'].' '.$_POST['Activity']['actual_time_5'];
                $actual_date=str_replace('/', '-',$actual_date);
                $actual_date=date("Y-m-d H:i:s", strtotime($actual_date)); 
                $model->call_back_or_actual_date = $actual_date;
                $model->fact_find_status =2;
            }
            //Review Date-End
             //verify Date-Start
//            if ($_POST['Activity']['actual_date_6'] != '0000-00-00' && $_POST['Activity']['actual_date_6'] != '' && $_POST['Activity']['actual_time_6'] != '00:00:00' && $_POST['Activity']['actual_time_6'] != '') {
//                $actual_date=$_POST['Activity']['actual_date_6'].' '.$_POST['Activity']['actual_time_6'];
//                $actual_date=str_replace('/', '-',$actual_date);
//                $actual_date=date("Y-m-d H:i:s", strtotime($actual_date)); 
//                $model->call_back_or_actual_date = $actual_date;
//                $model->plan_id = $_POST['Activity']['plan_id_1']; 
//            }
            //verify Date-End
            if ($_POST['Activity']['actual_date_6'] != '0000-00-00' && $_POST['Activity']['actual_date_6'] != '') {
                $actual_date=$_POST['Activity']['actual_date_6'];
                $actual_date=str_replace('/', '-',$actual_date);
                $actual_date=date("Y-m-d", strtotime($actual_date)); 
                $model->call_back_or_actual_date = $actual_date;
                $model->plan_id = $_POST['Activity']['plan_id_1']; 
                $model->fact_find_status =2;
            }
            $model->activity_notes = $_POST['Activity']['activity_notes']; 
            if ($model->validate()) {
                $model->save();
                if($type_of_activity==6){
                    CustomerPlanDetails::model()->updateByPk($plan_id, array('application_send_status' => 'Y'));
                }
                $jsonData['customer_id'] =$model->customer_id;
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    //Code to save Fact find/Application/Presentation details-Ends
    //Edit Page Showing-Starts
    public function actionloadactivityPage() {
        $frm = Yii::app()->request->getparam("frm");
        $type = Yii::app()->request->getparam("type");
        $id= Yii::app()->request->getparam("id");
        $model=new Activity();
        if($id>0){
            $model=$model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
        if($type==2){
            $this->render('activity_appointment', array('model' => $model,'frm'=>$frm));
        }else if($type==3){
            $this->render('activity_joint_visit', array('model' => $model,'frm'=>$frm));
        }           
    }
    //Edit Page Showing-Ends
    //Start Document List
    public function actionGetDocumentList(){
        $model=new ActivityDocument();
        $draw    = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $id= $_POST['id'];
        $customer_id= $_POST['customer_id'];
        $columns = array(
            0 =>'id',
            1 =>'document_name',
            2=>'created_by',
            3=>'created_date_time',
            4=>''
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy   = $filterColumn." ".$filterOrder;
        $condition = 't.customer_id="'.$customer_id.'"';               
        if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
        {
          $searchString = $_POST['search']['value'];
          $condition.=" AND (document_name LIKE '%".$searchString."%')";
        }
        $count = $model->count(array('condition'=>$condition));
        $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData=array();
        $m=1;
        foreach ($model as $row)
        {
            $button_string="";                  
            $created_datetime="";
            if($row['created_date_time']!='' && $row['created_date_time']!='0000-00-00 00:00:00'){
                $created_datetime=date("d/m/Y h:i:s a",strtotime($row->created_date_time));
            }
            
            $button_string.= '<button class="btn btn-primary btn-xs" title="Edit" onclick="editdocumentdetails('.$row['id'] . ');return false;"><i class="fa fa-edit"></i></button>&nbsp;';       
            $button_string.= '<a href="?r=activity/downloaddocument&id='.$row['id'].'" title="Download Document" target="_blank" class="btn btn-primary btn-xs"><i class="fa fa-download"></i></a>&nbsp;';
            if($row->customerdetails->cust_executive_id!=Yii::app()->user->id){
                $button_string .=' <a href ="javascript:void(0);" class="btn btn-danger btn-xs" title="Delete Document" onclick="deletedocument(' . $row['id'] . ')"><i class="fa fa-trash-o "></i></a>' ;
            }

            $rowData[]=array($m,$row['documentname']['document_name'],$row['document_name'],$row->addedby->fullname,$created_datetime,$button_string);
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
     //End Document List
    public function actionsaveActivityDocument() {
        if (isset($_POST['ActivityDocument'])) {
            $model = new ActivityDocument();
            if ((int) @$_POST['ActivityDocument']['id'] > 0) {
                $model->id = (int) $_POST['ActivityDocument']['id'];
                $model = $model->findByPK($model->id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d H:i:s');
            }else{
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d H:i:s');
            }
            $model->attributes = $_POST['ActivityDocument'];
            if ($model->validate()) {
                $model->save();
                $jsonData['customer_id'] =$model->customer_id;
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    public function actiondownloaddocument() {
        $id = Yii::app()->request->getParam('id');
        $document = ActivityDocument::model()->findByPk($id);
        $file =$document->document_file;  
        $arr_doc_val = explode(',', $file);
        if (count($arr_doc_val) > 1) {
            $zip = new ZipArchive();
            $zip_file_path = "uploads/documents/document.zip";
            if ($zip->open($zip_file_path, 1 ? ZIPARCHIVE::OVERWRITE : ZIPARCHIVE::CREATE) === TRUE) {
                for ($i = 0; $i < count($arr_doc_val); $i++) {
                    $path = "uploads/documents/" . $arr_doc_val[$i];
                    // Add the files to the .zip file
                    $zip->addFile($path, $arr_doc_val[$i]);
                }
                // Closing the zip file
                $zip->close();
            }
            header("Content-type:application/zip"); //for pdf file
            header('Content-Disposition: attachment; filename="' . basename($zip_file_path) . '"');
            header('Content-Length: ' . filesize($zip_file_path));
            readfile($zip_file_path);
            Yii::app()->end();
        } else {
            $path =  "uploads/documents/" . $file;
            header("Content-type:application/octet-stream"); //for txt file
            header("Content-Type: application/download");
            header('Content-Disposition: attachment; filename="' . basename($path) . '"');
            header('Content-Length: ' . filesize($path));
            readfile($path);
            Yii::app()->end();
        }
    }
    //Document Edit
    public function actioneditdocumentdetails() {
        $id= Yii::app()->request->getparam("id");
        $model=new ActivityDocument();
        if($id>0){
            $model=$model->findByPk($id);
        }
        $jsonData['id'] =$model->id;
        $jsonData['customer_id'] =$model->customer_id;
        $jsonData['document_name'] =$model->document_name;
        $jsonData['document_file'] =$model->document_file;
        $jsonData['document_type'] =$model->document_type;
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
               
    }
    public function actiondeletedocument() {
        $id = $_POST['id'];
        $model =ActivityDocument::model()->findByPk($id);
        $doc_file=$model->document_file;
        $arr_doc_val = explode(',', $doc_file);      
        $status=0;
        print_r($arr_doc_val);
        if (count($arr_doc_val) > 1) {
             // print_r($arr_doc_val); die;
            foreach ($arr_doc_val as $value) {
                $path = "uploads/documents/".$value; 
                if (unlink($path)) {
                    $status=1;
                }
            }
            if ($status==1) {
                ActivityDocument::model()->deleteByPk($id);
                $jsonData['status'] = 'success';
            }else{
                $jsonData['status'] = 'error';
            }
            
        }else{
            $path = "uploads/documents/".$doc_file; 
            if (unlink($path)) {
                ActivityDocument::model()->deleteByPk($id);
                $jsonData['status'] = 'success';
            }else{
                $jsonData['status'] = 'error';
            }
        }
        echo CJSON::encode($jsonData);
    }
    public function actiongetcallbackdetails() {
        $id= Yii::app()->request->getparam("id");
        $current_date_time=date("Y-m-d H:i:s", strtotime("+15 minutes"));
        //$current_date_time=date("Y-m-d H:i");
        $model_activity = Activity::model()->findAll(array('condition' =>'type_of_activity="1" and created_by="'.$id.'" and call_back_or_actual_date="'.$current_date_time.'"'));
        $activity_details="";        
        if(!empty($model_activity)){            
            foreach ($model_activity as $key => $value) {
                if($value->call_back_or_actual_date!='' && $value->call_back_or_actual_date!='0000-00-00 00:00:00'){
                    $call_back_or_actual_date=date("d/m/Y H:i",strtotime($value->call_back_or_actual_date));
                    $activity_details.='Call Back '.$value->customerdetails->Fullname.' at '.$call_back_or_actual_date.'<br/>';
                }
            }     
        }
        $jsonData['call_back'] =$activity_details;
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
               
    }
    public function actionDeleteactivitydetails() {
        $id= Yii::app()->request->getparam("id");
        Activity::model()->updateByPk($id, array('isActive' =>'N'));
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
               
    }
    public function actionfactfind() {
        $this->render('factfind_list');
    }
    public function actionGetfactfindList() {
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $executive_id = $_POST['executive_id'];
        $model = new Activity();
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'customerdetails.cust_first_name',
            2 => 't.created_by',
            3 => 'call_back_or_actual_date',
            4 => '',
            5 => '',
            6 => 'customerdetails.cust_executive_id',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        /******** First Loading Without Search********/
        $condition = 'customerdetails.isActive="Y" AND type_of_activity="4" AND fact_find_status="1"';
        if($executive_id>0){
            $condition.= ' AND customerdetails.cust_executive_id="'.$executive_id.'"';
        }
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition.= " AND (customerdetails.cust_first_name LIKE '%" . $searchString . "%' OR customerdetails.cust_middle_name LIKE '%" . $searchString . "%' OR customerdetails.cust_last_name LIKE '%" . $searchString . "%')";
        }    
        $count = $model->with('customerdetails')->count(array('condition' => $condition));
        $model = $model->with('customerdetails')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m=1;
        foreach ($model as $row) {
            
            $div= '<button class="btn btn-primary btn-xs" title="Approve" onclick="loadPopupModal(\'activity/approvefactfind&id=' . $row['id'] . '\',\'Approve Fact Find\',\'xl\')"><i class="fa fa-thumbs-up"></i></button>';               
            if($row['call_back_or_actual_date']!='' && $row['call_back_or_actual_date']!='0000-00-00 00:00:00'){
                $call_back_or_actual_date=date("d/m/Y H:i",strtotime($row['call_back_or_actual_date']));
            }
            $model_activity_document = ActivityDocument::model()->findAll(array('condition' =>'document_from="1" and customer_id="'.$row['customer_id'].'" and document_type="3"'));
            if(!empty($model_activity_document)){
                $div.= '&nbsp;<a href="?r=activity/downloaddocuments&id=' . $row['customer_id'] . '" title="Download" target="_blank"><button class="btn btn-primary btn-xs" title="Download" ><i class="fa fa-download"></i></button></a>';
            }
            $div.= ' <button class="btn btn-danger btn-xs" title="Delete" onclick="deleteFactFind('.$row['id'].')"><i class="fa fa-trash"></i></button>';               
            $manager_id=$row['customerdetails']['executive']['manager_id'];
            $for_color='';
            if($manager_id==9){
                //John Thomas
                $for_color=1;
            }else if($manager_id==2){
                //Raxon
                $for_color=2;
            }
            $rowData[] = array($m, $row['customerdetails']['cust_first_name'] . " " . $row['customerdetails']['cust_middle_name'] . " " . $row['customerdetails']['cust_last_name'],$row->customerdetails->executive->fullname,$call_back_or_actual_date,'<div class="btn-wrap text-center">' . $div . '</div>',$for_color,$row['customerdetails']['cust_executive_id']);
            $m++;
        }

        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionApproveFactfind() {
        $id = (int) Yii::app()->request->getParam('id');
        $model = new Activity();
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        //Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
        Yii::app()->clientScript->scriptMap = array('jquery.js' => false, 'jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
        $this->render('approve_fact_find', array('model' => $model));
    }
    public function actionSaveApproveFactFind() {
        if (isset($_POST['Activity'])) {
            $model = new Activity();
            if ((int) @$_POST['Activity']['id'] > 0) {
                $model->id = (int) $_POST['Activity']['id'];
                $model = $model->findByPK($model->id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_datetime = date('Y-m-d H:i:s');                
            }
            $model->fact_find_note = $_POST['Activity']['fact_find_note'];
            $model->fact_find_approval=Yii::app()->user->id;
            $model->fact_find_status =2;
            $actual_date='';
            if ($_POST['Activity']['factfind_date'] != '0000-00-00' && $_POST['Activity']['factfind_date'] != '' && $_POST['Activity']['factfind_time'] != '00:00:00' && $_POST['Activity']['factfind_time'] != '') {
                $actual_date=$_POST['Activity']['factfind_date'].' '.$_POST['Activity']['factfind_time'];
                $actual_date=str_replace('/', '-',$actual_date);
                $actual_date=date("Y-m-d H:i:s", strtotime($actual_date)); 
                $model->fact_find_approved_date=date("Y-m-d", strtotime(str_replace('/', '-',$_POST['Activity']['factfind_date']))); 
                $model->call_back_or_actual_date = $actual_date;
            }
            if ($model->validate()) {
                $model->save();
                $model_fact = new Activity();
                $model_fact->customer_id =$model->customer_id;
                $model_fact->type_of_activity =8;
                $model_fact->activity_notes=$model->fact_find_note;
                $model_fact->call_back_or_actual_date = $actual_date;
                $model_fact->fact_find_status =2;
                $model_fact->created_by = Yii::app()->user->id;
                $model_fact->created_datetime = date('Y-m-d H:i:s');
                $model_fact->save();
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    public function actiondownloaddocuments() {
        $id = Yii::app()->request->getParam('id');
        $model_activity_document = ActivityDocument::model()->findAll(array('select'=>'document_file','condition' =>'document_from="1" and customer_id="'.$id.'" and document_type="3"'));
        $arr_doc_val=array();
        foreach ($model_activity_document as $key => $value) {
            $arr_doc_val[$key]=$value->document_file; 
        }
        if (count($arr_doc_val) > 1) {
            $zip = new ZipArchive();
            $zip_file_path = Yii::getPathOfAlias('webroot') . "/uploads/documents/document.zip";
            if ($zip->open($zip_file_path, 1 ? ZIPARCHIVE::OVERWRITE : ZIPARCHIVE::CREATE) === TRUE) {
                for ($i = 0; $i < count($arr_doc_val); $i++) {
                    $path = "uploads/documents/" . $arr_doc_val[$i];
                    // Add the files to the .zip file
                    $zip->addFile($path, $arr_doc_val[$i]);
                }
                // Closing the zip file
                $zip->close();
            }
            header("Content-type:application/zip"); //for pdf file
            header('Content-Disposition: attachment; filename="' . basename($zip_file_path) . '"');
            header('Content-Length: ' . filesize($zip_file_path));
            readfile($zip_file_path);
            Yii::app()->end();
        } else {
            $path = Yii::getPathOfAlias('webroot') . "/uploads/documents/" . $model_activity_document[0]->document_file;
            header("Content-type:application/octet-stream"); //for txt file
            header("Content-Type: application/download");
            header('Content-Disposition: attachment; filename="' . basename($path) . '"');
            header('Content-Length: ' . filesize($path));
            readfile($path);
            Yii::app()->end();
        }
    }
    public function actionSaveRejectFactFind() {
        if (isset($_POST['Activity'])) {
            $model = new Activity();
            if ((int) @$_POST['Activity']['id'] > 0) {
                $model->id = (int) $_POST['Activity']['id'];
                $model = $model->findByPK($model->id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_datetime = date('Y-m-d H:i:s');                
            }
            $model->fact_find_note = $_POST['Activity']['fact_find_note'];
            $model->fact_find_approval=Yii::app()->user->id;
            $model->fact_find_status =3;//reject status
            $model->fact_find_approved_date=''; 
            $model->call_back_or_actual_date = date('Y-m-d H:i:s');
            if ($model->validate()) {
                $model->save();
                $model_fact = new Activity();
                $model_fact->customer_id =$model->customer_id;
                $model_fact->type_of_activity =8;
                $model_fact->activity_notes=$model->fact_find_note;
                $model_fact->call_back_or_actual_date = date('Y-m-d H:i:s');
                $model_fact->fact_find_status =3;
                $model_fact->created_by = Yii::app()->user->id;
                $model_fact->created_datetime = date('Y-m-d H:i:s');
                $model_fact->save(FALSE);
                Yii::import('application.controllers.front.MailController'); 
                $mail_status =MailController::sendmail(1,$model->id);
                $jsonData['status'] = 'success';
                $jsonData['mail_status'] = $mail_status;
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    public function actiondeletefactfind(){
        $id = $_POST['id'];
        if($id>0){
            $model = new Activity();
            $model->deleteByPk($id);
            $jsonData['status'] = 'success';
        }else{
            $jsonData['status'] = 'fail';
        }
        echo CJSON::encode($jsonData);
    }
    
}