<?php

class QuarterlycommissionController extends Controller {

    /**
     * Declares class-based actions.
     */
    public function accessRules() {

        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index','ExecutivecommissionDetails','transferamounttoaccount','getcommissiondetails','savetoCommissionLedger'
                    ),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    /**
     * This is the default 'index' action that is invoked
     * when an action is not explicitly requested by users.
     */
    public function actionIndex() {
        $this->render('index');
    }
    public function actionExecutivecommissionDetails() {
        $id = (int) Yii::app()->request->getParam('id');
        $type = (int) Yii::app()->request->getParam('type');
        $target = (int) Yii::app()->request->getParam('target');
        $model_employee_target = UserTarget::model()->findbyPK($target);
        $condition = "user_id='".$id."' and transaction_date>='".$model_employee_target->start_date."' and transaction_date<='".$model_employee_target->end_date."' and (type='EXE_QUA_COM' OR type='EXE_QUA_COM_RET') and status='HOLD'";
        $model_commission_ledger = ExecutiveHoldCommission::model()->findAll(array('condition' =>$condition,'order'=>'transaction_date asc'));        
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('executive_commission_details', array('id'=>$id,'type'=>$type,'target'=>$target,'model_employee_target' => $model_employee_target,'model_commission_ledger' => $model_commission_ledger), false, false);
    }
    public function actiongetcommissiondetails() {
        $executive_id =$_POST['executive_id'];
        $year =$_POST['year'];
        $this->render('executive_commission', array('executive_id'=>$executive_id,'year'=>$year), false, false);
    }
    public function actiontransferamounttoaccount() {
        $array_commission_id=$_POST['array_commission_id'];
        $exec_id=$_POST['exec_id'];
        $commission_type=$_POST['commission_type']; //1-To executive account,2-To company account
        $target_year=$_POST['target_year'];
        $net_amount=$_POST['total_amount'];
        $commission_amount=$_POST['commission_amount'];
        $target_id=$_POST['target_id_value'];
        $model_target_details  = UserTarget::model()->findbyPK($target_id);
        $type='';
        if($model_target_details->target_id==1){
            $type='Quarter 1';
        }else if($model_target_details->target_id==2){
            $type='Quarter 2';
        }else if($model_target_details->target_id==3){
            $type='Quarter 3';
        }else if($model_target_details->target_id==4){
            $type='Quarter 4';
        }
        $scheme_id        = User::model()->findByPK($exec_id)->commission_scheme_id;
        $mas_commission   = MasterCommissionSchemes::model()->findByPK($scheme_id);
        $exec_quat_com = $mas_commission->executive_quarter_sale_commission;
        $exec_quat_com_amount=$net_amount*$exec_quat_com/100;
        $model_executive= User::model()->findbyPK($exec_id);
        $assistant_manger =$model_executive->assistant_manager_id;
        $manager =$model_executive->manager_id;
        if($manager=='0'){
            $manager = $exec_id;
        }        
        //$model_commission_ledger = ExecutiveHoldCommission::model()->findAll(array('condition' =>$condition,'order'=>'transaction_date asc'));        
        
        if($commission_type==1){
            $desc_ledger='Executive Quarterly Commission for the Year '.$target_year.'-'.$type.' ('.$exec_quat_com.' % of '.$net_amount.')';          
            $out_ledger_id=$this->savetoCommissionLedger(0,User::getCompany(),'0',date('Y-m-d'),$exec_quat_com,
                                        $net_amount,0,$exec_quat_com_amount,'EXE_QUA_COM',$desc_ledger,'OUT','GEN','0','0','0','NA');
            $in_ledger_id=$this->savetoCommissionLedger(0,$exec_id,0,date('Y-m-d'),$exec_quat_com,
                                        $net_amount,$exec_quat_com_amount,0,'EXE_QUA_COM',$desc_ledger,'IN','GEN','0','0','0','NA');
            if($out_ledger_id>0 && $in_ledger_id>0){
                $model_history = new CommissionHistory();
                $model_history->target_id=$target_id;
                $model_history->commision_in_ledger_id=$in_ledger_id;
                $model_history->commision_out_ledger_id=$out_ledger_id;
                $model_history->save();
                $history_id=$model_history->id;
                foreach ($array_commission_id as $value) {
                    $model_hold_ledger = ExecutiveHoldCommission::model()->findbyPK($value);
                    $this->savetoCommissionHistory($history_id,$value,$model_hold_ledger->commision_upload_id,$model_hold_ledger->user_id,$model_hold_ledger->customer_id,$model_hold_ledger->provider_id,
                                            $model_hold_ledger->mas_plan_id,$model_hold_ledger->cus_plan_id,$model_hold_ledger->transaction_date,$model_hold_ledger->percentage,$model_hold_ledger->total_amount,'IN',
                                            $model_hold_ledger->in_amount,0.00,$model_hold_ledger->type,$model_hold_ledger->description,'GEN','NA') ;
                    ExecutiveHoldCommission::model()->updateByPK($value, array('status' => 'USED','updated_by'=>Yii::app()->user->id,'updated_date_time'=>date('Y-m-d H:i:s')));

                    $account_balance=$model_executive->account_total_amount+$model_hold_ledger->in_amount;
                    User::model()->updateByPK($exec_id, array('account_total_amount' =>$account_balance,'updated_by'=>Yii::app()->user->id,'updated_date_time'=>date('Y-m-d H:i:s')));
                    $model_comp= User::model()->findbyPK(User::getCompany());
                    $account_balance=$model_comp->account_total_amount-$model_hold_ledger->in_amount;
                    User::model()->updateByPK(User::getCompany(), array('account_total_amount' =>$account_balance,'updated_by'=>Yii::app()->user->id,'updated_date_time'=>date('Y-m-d H:i:s')));
                
                }                
            }
            else{
                $flag=1;
            }
            if($assistant_manger>0){
                $ass_manager_com = $mas_commission->ass_manager_quarter_sale_commission;
                $ass_man_condition_in = "user_id='".$assistant_manger."' and executive_id='".$exec_id."' and transaction_date>='".$model_target_details->start_date."' and transaction_date<='".$model_target_details->end_date."' and type='ASS_MAN_QUA_COM' and status='HOLD'";
                $model_assman_qua_com_in = ExecutiveHoldCommission::model()->find(array('select' => 'sum(in_amount) as in_amount,sum(total_amount) as total_amount', 'condition' => $ass_man_condition_in));
                $ass_man_condition_out = "user_id='".$assistant_manger."' and executive_id='".$exec_id."' and transaction_date>='".$model_target_details->start_date."' and transaction_date<='".$model_target_details->end_date."' and type='ASS_MAN_QUA_COM_RET' and status='HOLD'";
                $model_assman_qua_com_out = ExecutiveHoldCommission::model()->find(array('select' => 'sum(out_amount) as out_amount,sum(total_amount) as total_amount', 'condition' => $ass_man_condition_out));
                $ass_man_net_amount=$model_assman_qua_com_in->total_amount-$model_assman_qua_com_out->total_amount;
                $ass_man_qua_com = $model_assman_qua_com_in->in_amount-$model_assman_qua_com_out->out_amount;
                $desc_ass_man_ledger='Assistant Manager Quarterly Commission for the Year '.$target_year.'-'.$type.' ('.$ass_manager_com.' % of '.$ass_man_net_amount.')- '.$model_executive->fullname;          
            
                $ass_out_ledger_id=$this->savetoCommissionLedger(0,User::getCompany(),'0',date('Y-m-d'),$ass_manager_com,
                                        $ass_man_net_amount,0,$ass_man_qua_com,'ASS_MAN_QUA_COM',$desc_ass_man_ledger,'OUT','GEN','0','0','0','NA');
                $ass_in_ledger_id=$this->savetoCommissionLedger(0,$assistant_manger,0,date('Y-m-d'),$ass_manager_com,
                                        $ass_man_net_amount,$ass_man_qua_com,0,'ASS_MAN_QUA_COM',$desc_ass_man_ledger,'IN','GEN','0','0','0','NA');
                $ass_man_condition = "user_id='".$assistant_manger."' and executive_id='".$exec_id."' and transaction_date>='".$model_target_details->start_date."' and transaction_date<='".$model_target_details->end_date."' and (type='ASS_MAN_QUA_COM' OR type='ASS_MAN_QUA_COM_RET') and status='HOLD'";
                $model_assman_qua_com =ExecutiveHoldCommission::model()->findAll(array('condition'=>$ass_man_condition));
                if($ass_in_ledger_id >0 && $ass_out_ledger_id>0){
                    $model_ass_history = new CommissionHistory();
                    $model_ass_history->target_id=$target_id;
                    $model_ass_history->commision_in_ledger_id=$ass_in_ledger_id;
                    $model_ass_history->commision_out_ledger_id=$ass_out_ledger_id ;
                    $model_ass_history->created_by=Yii::app()->user->id;
                    $model_ass_history->created_date_time=date('Y-m-d H:i:s');
                    $model_ass_history->save();
                    $ass_history_id=$model_ass_history->id;
                    foreach ($model_assman_qua_com as $avalue) {
                        $model_hold_ledger = ExecutiveHoldCommission::model()->findbyPK($avalue);
                        $this->savetoCommissionHistory($ass_history_id,$avalue,$model_hold_ledger->commision_upload_id,User::getCompany(),$model_hold_ledger->customer_id,$model_hold_ledger->provider_id,
                                                $model_hold_ledger->mas_plan_id,$model_hold_ledger->cus_plan_id,$model_hold_ledger->transaction_date,$model_hold_ledger->percentage,$model_hold_ledger->total_amount,'IN',
                                                $model_hold_ledger->in_amount,$model_hold_ledger->out_amount,$model_hold_ledger->type,$model_hold_ledger->description,'GEN','NA') ;
                        ExecutiveHoldCommission::model()->updateByPK($avalue, array('status' => 'USED','updated_by'=>Yii::app()->user->id,'updated_date_time'=>date('Y-m-d H:i:s')));        
                    
                        $model_assman= User::model()->findbyPK($assistant_manger);
                        $account_balance=$model_assman->account_total_amount+$model_hold_ledger->in_amount;
                        User::model()->updateByPK($assistant_manger, array('account_total_amount' =>$account_balance,'updated_by'=>Yii::app()->user->id,'updated_date_time'=>date('Y-m-d H:i:s')));
                        $model_comp= User::model()->findbyPK(User::getCompany());
                        $account_balance=$model_comp->account_total_amount-$model_hold_ledger->in_amount;
                        User::model()->updateByPK(User::getCompany(), array('account_total_amount' =>$account_balance,'updated_by'=>Yii::app()->user->id,'updated_date_time'=>date('Y-m-d H:i:s')));
                    }
                    
                }
            }
            if($manager>0){
                $manager_com = $mas_commission->manager_quarter_sale_commission;
                $man_condition_in = "user_id='".$manager."' and executive_id='".$exec_id."' and transaction_date>='".$model_target_details->start_date."' and transaction_date<='".$model_target_details->end_date."' and type='MAN_QUA_COM' and status='HOLD'";
                $model_man_qua_com_in = ExecutiveHoldCommission::model()->find(array('select' => 'sum(in_amount) as in_amount,sum(total_amount) as total_amount', 'condition' => $man_condition_in));
                $man_condition_out = "user_id='".$manager."' and executive_id='".$exec_id."' and transaction_date>='".$model_target_details->start_date."' and transaction_date<='".$model_target_details->end_date."' and type='MAN_QUA_COM_RET' and status='HOLD'";
                $model_man_qua_com_out = ExecutiveHoldCommission::model()->find(array('select' => 'sum(out_amount) as out_amount,sum(total_amount) as total_amount', 'condition' => $man_condition_out));
                $man_net_amount=$model_man_qua_com_in->total_amount-$model_man_qua_com_out->total_amount;
                $man_qua_com = $model_man_qua_com_in->in_amount-$model_man_qua_com_out->out_amount;
                $desc_man_ledger='Manager Quarterly Commission for the Year '.$target_year.'-'.$type.' ('.$manager_com.' % of '.$man_net_amount.')- '.$model_executive->fullname;          
            
                $man_out_ledger_id=$this->savetoCommissionLedger(0,User::getCompany(),'0',date('Y-m-d'),$manager_com,
                                        $man_net_amount,0,$man_qua_com,'MAN_QUA_COM',$desc_man_ledger,'OUT','GEN','0','0','0','NA');
                $man_in_ledger_id=$this->savetoCommissionLedger(0,$manager,0,date('Y-m-d'),$manager_com,
                                        $man_net_amount,$man_qua_com,0,'MAN_QUA_COM',$desc_man_ledger,'IN','GEN','0','0','0','NA');
                $man_condition = "user_id='".$manager."' and executive_id='".$exec_id."' and transaction_date>='".$model_target_details->start_date."' and transaction_date<='".$model_target_details->end_date."' and (type='MAN_QUA_COM' OR type='MAN_QUA_COM_RET') and status='HOLD'";
                $model_man_qua_com =ExecutiveHoldCommission::model()->findAll(array('condition'=>$man_condition));
                if($man_out_ledger_id >0 && $man_in_ledger_id>0){
                    $model_man_history = new CommissionHistory();
                    $model_man_history->target_id=$target_id;
                    $model_man_history->commision_in_ledger_id=$man_in_ledger_id;
                    $model_man_history->commision_out_ledger_id=$man_out_ledger_id ;
                    $model_man_history->created_by=Yii::app()->user->id;
                    $model_man_history->created_date_time=date('Y-m-d H:i:s');
                    $model_man_history->save();
                    $man_history_id=$model_man_history->id;
                    foreach ($model_man_qua_com as $mvalue) {
                        $model_hold_ledger = ExecutiveHoldCommission::model()->findbyPK($mvalue);
                        $this->savetoCommissionHistory($man_history_id,$mvalue,$model_hold_ledger->commision_upload_id,User::getCompany(),$model_hold_ledger->customer_id,$model_hold_ledger->provider_id,
                                                $model_hold_ledger->mas_plan_id,$model_hold_ledger->cus_plan_id,$model_hold_ledger->transaction_date,$model_hold_ledger->percentage,$model_hold_ledger->total_amount,'IN',
                                                $model_hold_ledger->in_amount,$model_hold_ledger->out_amount,$model_hold_ledger->type,$model_hold_ledger->description,'GEN','NA') ;
                        ExecutiveHoldCommission::model()->updateByPK($mvalue, array('status' => 'USED','updated_by'=>Yii::app()->user->id,'updated_date_time'=>date('Y-m-d H:i:s')));        
                        $model_man= User::model()->findbyPK($manager);
                        $account_balance=$model_man->account_total_amount+$model_hold_ledger->in_amount;
                        User::model()->updateByPK($manager, array('account_total_amount' =>$account_balance,'updated_by'=>Yii::app()->user->id,'updated_date_time'=>date('Y-m-d H:i:s')));
                        $model_comp= User::model()->findbyPK(User::getCompany());
                        $account_balance=$model_comp->account_total_amount-$model_hold_ledger->in_amount;
                        User::model()->updateByPK(User::getCompany(), array('account_total_amount' =>$account_balance,'updated_by'=>Yii::app()->user->id,'updated_date_time'=>date('Y-m-d H:i:s')));
                    }
                }
            }
        }else{
            $desc_ledger='Executive Quarterly Commission for the Year '.$target_year.'-'.$type.' ('.$exec_quat_com.' % of 0)';          
            $out_ledger_id=$this->savetoCommissionLedger(0,User::getCompany(),'0',date('Y-m-d'),$exec_quat_com,
                                        0,0,0,'EXE_QUA_COM',$desc_ledger,'OUT','GEN','0','0','0','NA');
            $in_ledger_id=$this->savetoCommissionLedger(0,$exec_id,0,date('Y-m-d'),$exec_quat_com,
                                        0,0,0,'EXE_QUA_COM',$desc_ledger,'IN','GEN','0','0','0','NA');
            if($out_ledger_id>0 && $in_ledger_id>0){
                $model_history = new CommissionHistory();
                $model_history->target_id=$target_id;
                $model_history->commision_in_ledger_id=$in_ledger_id;
                $model_history->commision_out_ledger_id=$out_ledger_id;
                $model_history->created_by=Yii::app()->user->id;
                $model_history->created_date_time=date('Y-m-d H:i:s');
                $model_history->save();
                $history_id=$model_history->id;
                foreach ($array_commission_id as $value) {
                    $model_hold_ledger = ExecutiveHoldCommission::model()->findbyPK($value);
                    $this->savetoCommissionHistory($history_id,$value,$model_hold_ledger->commision_upload_id,User::getCompany(),$model_hold_ledger->customer_id,$model_hold_ledger->provider_id,
                                            $model_hold_ledger->mas_plan_id,$model_hold_ledger->cus_plan_id,$model_hold_ledger->transaction_date,$model_hold_ledger->percentage,$model_hold_ledger->total_amount,'IN',
                                            $model_hold_ledger->in_amount,$model_hold_ledger->out_amount,$model_hold_ledger->type,$model_hold_ledger->description,'GEN','NA') ;
                    ExecutiveHoldCommission::model()->updateByPK($value, array('status' => 'H_ANN','updated_by'=>Yii::app()->user->id,'updated_date_time'=>date('Y-m-d H:i:s')));        
                }
            }else{
                $flag=1;
            }
            if($assistant_manger>0){
                $ass_manager_com = $mas_commission->ass_manager_quarter_sale_commission;
                $desc_ass_man_ledger='Assistant Manager Quarterly Commission for the Year '.$target_year.'-'.$type.' ('.$ass_manager_com.' % of 0)- '.$model_executive->fullname;          
            
                $ass_out_ledger_id=$this->savetoCommissionLedger(0,User::getCompany(),'0',date('Y-m-d'),$ass_manager_com,
                                        0,0,0,'ASS_MAN_QUA_COM',$desc_ass_man_ledger,'OUT','GEN','0','0','0','NA');
                $ass_in_ledger_id=$this->savetoCommissionLedger(0,$assistant_manger,0,date('Y-m-d'),$ass_manager_com,
                                        0,0,0,'ASS_MAN_QUA_COM',$desc_ass_man_ledger,'IN','GEN','0','0','0','NA');
                $ass_man_condition = "user_id='".$assistant_manger."' and executive_id='".$exec_id."' and transaction_date>='".$model_target_details->start_date."' and transaction_date<='".$model_target_details->end_date."' and (type='ASS_MAN_QUA_COM' OR type='ASS_MAN_QUA_COM_RET') and status='HOLD'";
                $model_assman_qua_com =ExecutiveHoldCommission::model()->findAll(array('condition'=>$ass_man_condition));
                if($ass_in_ledger_id >0 && $ass_out_ledger_id>0){
                    $model_ass_history = new CommissionHistory();
                    $model_ass_history->target_id=$target_id;
                    $model_ass_history->commision_in_ledger_id=$ass_in_ledger_id;
                    $model_ass_history->commision_out_ledger_id=$ass_out_ledger_id ;
                    $model_ass_history->created_by=Yii::app()->user->id;
                    $model_ass_history->created_date_time=date('Y-m-d H:i:s');
                    $model_ass_history->save();
                    $ass_history_id=$model_ass_history->id;
                    foreach ($model_assman_qua_com as $avalue) {
                        $model_hold_ledger = ExecutiveHoldCommission::model()->findbyPK($avalue);
                        $this->savetoCommissionHistory($ass_history_id,$avalue,$model_hold_ledger->commision_upload_id,User::getCompany(),$model_hold_ledger->customer_id,$model_hold_ledger->provider_id,
                                                $model_hold_ledger->mas_plan_id,$model_hold_ledger->cus_plan_id,$model_hold_ledger->transaction_date,$model_hold_ledger->percentage,$model_hold_ledger->total_amount,'IN',
                                                $model_hold_ledger->in_amount,$model_hold_ledger->out_amount,$model_hold_ledger->type,$model_hold_ledger->description,'GEN','NA') ;
                        ExecutiveHoldCommission::model()->updateByPK($avalue, array('status' => 'H_ANN','updated_by'=>Yii::app()->user->id,'updated_date_time'=>date('Y-m-d H:i:s')));        
                    }
                }
            }
            if($manager>0){
                $manager_com = $mas_commission->manager_quarter_sale_commission;
                $desc_man_ledger='Manager Quarterly Commission for the Year '.$target_year.'-'.$type.' ('.$manager_com.' % of 0)- '.$model_executive->fullname;          
            
                $man_out_ledger_id=$this->savetoCommissionLedger(0,User::getCompany(),'0',date('Y-m-d'),$manager_com,
                                        0,0,0,'MAN_QUA_COM',$desc_man_ledger,'OUT','GEN','0','0','0','NA');
                $man_in_ledger_id=$this->savetoCommissionLedger(0,$manager,0,date('Y-m-d'),$manager_com,
                                        0,0,0,'MAN_QUA_COM',$desc_man_ledger,'IN','GEN','0','0','0','NA');
                $man_condition = "user_id='".$manager."' and executive_id='".$exec_id."' and transaction_date>='".$model_target_details->start_date."' and transaction_date<='".$model_target_details->end_date."' and (type='MAN_QUA_COM' OR type='MAN_QUA_COM_RET') and status='HOLD'";
                $model_man_qua_com =ExecutiveHoldCommission::model()->findAll(array('condition'=>$man_condition));
                if($man_out_ledger_id >0 && $man_in_ledger_id>0){
                    $model_man_history = new CommissionHistory();
                    $model_man_history->target_id=$target_id;
                    $model_man_history->commision_in_ledger_id=$man_in_ledger_id;
                    $model_man_history->commision_out_ledger_id=$man_out_ledger_id ;
                    $model_man_history->created_by=Yii::app()->user->id;
                    $model_man_history->created_date_time=date('Y-m-d H:i:s');
                    $model_man_history->save();
                    $man_history_id=$model_man_history->id;
                    foreach ($model_man_qua_com as $mvalue) {
                        $model_hold_ledger = ExecutiveHoldCommission::model()->findbyPK($mvalue);
                        $this->savetoCommissionHistory($man_history_id,$mvalue,$model_hold_ledger->commision_upload_id,User::getCompany(),$model_hold_ledger->customer_id,$model_hold_ledger->provider_id,
                                                $model_hold_ledger->mas_plan_id,$model_hold_ledger->cus_plan_id,$model_hold_ledger->transaction_date,$model_hold_ledger->percentage,$model_hold_ledger->total_amount,'IN',
                                                $model_hold_ledger->in_amount,$model_hold_ledger->out_amount,$model_hold_ledger->type,$model_hold_ledger->description,'GEN','NA') ;
                        ExecutiveHoldCommission::model()->updateByPK($mvalue, array('status' => 'H_ANN','updated_by'=>Yii::app()->user->id,'updated_date_time'=>date('Y-m-d H:i:s')));        
                    }
                }
            }
        }
        if($flag==0){
            UserTarget::model()->updateByPK($target_id, array('calculated' => 'Y'));
            $jsonData['status'] = 'success';
        }else{
            $jsonData['status'] = 'fail';
        }
        echo CJSON::encode($jsonData);
    }
    ////savetoCommissionLedger-start
    public function savetoCommissionLedger($id,$user_id,$cus_plan_id,$transaction_date,$percentage,
                                            $total_amount,$in_amount,$out_amount,$type,$desc,$in_or_out,
                                            $user_account,$provider_id,$customer_id,$mas_plan_id,$status) {
        $model_ledger = new CommissionLedger();
        $model_ledger->commision_upload_id=$id;
        $model_ledger->user_id=$user_id;
        $model_ledger->cus_plan_id=$cus_plan_id;
        $model_ledger->transaction_date=$transaction_date;
        $model_ledger->posted_date=date('Y-m-d');
        $model_ledger->percentage=$percentage;
        $model_ledger->total_amount=$total_amount;
        $model_ledger->in_or_out=$in_or_out;
        $model_ledger->in_amount=$in_amount;
        $model_ledger->out_amount=$out_amount;
        $model_ledger->type=$type;
        $model_ledger->description=$desc;
        $model_ledger->user_account=$user_account;
        $model_ledger->provider_id=$provider_id;
        $model_ledger->customer_id=$customer_id;
        $model_ledger->mas_plan_id=$mas_plan_id;
        $model_ledger->status=$status;        
        $model_ledger->created_by  =Yii::app()->user->id; 
        $model_ledger->created_date_time=date('Y-m-d H:i:s');
        if($model_ledger->save()){
            return $model_ledger->id;
        }else{
            return 0;
        }
    }    
    //savetoCommissionLedger-end
    ////savetoCommissionHistory-start
    public function savetoCommissionHistory($history_id,$value,$commision_upload_id,$user_id,$customer_id,$provider_id,
                                            $mas_plan_id,$cus_plan_id,$transaction_date,$percentage,$total_amount,$in_or_out,
                                            $in_amount,$out_amount,$type,$description,$account,$status) {
        $model_ledger = new CommissionHistoryDetails();
        $model_ledger->commision_history_id=$history_id;
        $model_ledger->hold_ledger_id=$value;
        $model_ledger->commision_upload_id=$commision_upload_id;
        $model_ledger->user_id=$user_id;
        $model_ledger->customer_id=$customer_id;
        $model_ledger->provider_id=$provider_id;
        $model_ledger->mas_plan_id=$mas_plan_id;
        $model_ledger->cus_plan_id=$cus_plan_id;
        $model_ledger->transaction_date=$transaction_date;
        $model_ledger->posted_date=date('Y-m-d');
        $model_ledger->percentage=$percentage;
        $model_ledger->total_amount=$total_amount;
        $model_ledger->in_or_out=$in_or_out;
        $model_ledger->in_amount=$in_amount;
        $model_ledger->out_amount=$out_amount;
        $model_ledger->type=$type;
        $model_ledger->description=$description;
        $model_ledger->user_account=$account;
        $model_ledger->status=$status;
        $model_ledger->created_by  =Yii::app()->user->id; 
        $model_ledger->created_date_time=date('Y-m-d H:i:s');
        $model_ledger->save(false);  
        return true;
    }    
    //savetoCommissionHistory-end
}
