<?php

class PolicyuploadController extends Controller
{
	public function accessRules() {
        return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                    'actions' => array('login', 'error', 'logout'),
                    'users' => array('*'),
                    ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                    'actions' => array('uploadpolicy','Upload','Downloadformat','SaveUploadCsv','readCSVfile','DownloadErrorCsv','DownloadPaymentmaster'),
                    'expression' => '$user->isMember()',
                    ),
                array('deny', // deny all users
                    'users' => array('*'),
                    ),
                );
    }
    public function filters()
    {
        return array(
            'accessControl', // perform access control for CRUD operations
            );
    }
    /**
     * This is the default 'index' action that is invoked
     * when an action is not explicitly requested by users.
     */
    public function actionuploadPolicy(){	 
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('upload_policy');
    }
        public function actionSaveUploadCsv() {
        $file_name = Yii::app()->request->getParam('filename');         
        $url = Yii::app()->basePath . '/../uploads/policydetails/' . $file_name;
        $error_url = Yii::app()->basePath . '/../uploads/policydetails/error/' . $file_name;
        $file = fopen($url, "r");
        $data = fgetcsv($file);
        $validate=TRUE;
        $error_list = array();
        $policynumber_error = array();
        $customer_list = Yii::app()->controller->readCSVfile("uploads/policydetails/" . $file_name);        
        foreach (array_slice($customer_list, 1) as $i => $data) {
            if($data[0]!=''||$data[1]!=''||$data[2]!=''||$data[3]!=''||$data[4]!=''||$data[5]!=''||$data[6]!=''||$data[7]!=''||$data[8]!='' ||$data[9]!='' ||$data[10]!=''){
            $model_plan[$i] = new CustomerPlanDetails();
            $model_plan[$i]->scenario="excelupload";	
            $mobile_number='';
            $id='';
            if($data[0]!=''){
                $mobile_number= trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[0]), '"'));   
                //$mobile_number_1=  explode('-', $mobile_number);
                $id=$mobile_number;
            }
            $model_plan[$i]->mobile_number =trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[0]), '"'));  
            $model_customer= Customer::model()->findbyPK($id);
            if($model_customer->id>0){
                $model_plan[$i]->customer_id=$model_customer->id;
            }else{
                $model_plan[$i]->customer_id='';
            }
            if($data[1]!=''){
                $provider_name=  strtoupper(trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[1]), '"')));
                //$condition = '((REPLACE(`provider_name`, " ", "") LIKE "%'.str_replace(' ', '', trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[1]), '"'))).'%"))';        
                $model_provider[$i] = Provider::model()->find(array('condition' =>'provider_name="'.$provider_name.'"'));
                $model_plan[$i]->provider_id = $model_provider[$i]->id;
            }else{
                $model_plan[$i]->provider_id = '';
            }
            $model_plan[$i]->provider_name =trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[1]), '"'));  
            if($data[2]!=''){
                $plan_name=  strtoupper(trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[2]), '"')));
                //$condition = '((REPLACE(`plan_name`, " ", "") LIKE "%'.str_replace(' ', '', trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[2]), '"'))).'%"))';        
                $model_provider_plan[$i] = MasProviderPlans::model()->find(array('condition' =>'plan_name="'.$plan_name.'"'));
                $model_plan[$i]->plan_id = $model_provider_plan[$i]->id;
            }else{
                $model_plan[$i]->plan_id = '';
            }
            $model_plan[$i]->plan_name =trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[2]), '"')); 
            if($data[3]!=''){
                //$condition = '((REPLACE(`class_name`, " ", "") LIKE "%'.str_replace(' ', '', trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[3]), '"'))).'%"))';        
                $class_name=  strtoupper(trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[3]), '"')));
                $model_class[$i] = MasClass::model()->find(array('condition' => 'class_name="'.$class_name.'"'));
                $model_plan[$i]->class_ids = $model_class[$i]->id;
            }else{
                $model_plan[$i]->class_ids = '';
            }
            $model_plan[$i]->class_name =trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[3]), '"')); 
            if($data[4]!=''){
                //$condition = '((REPLACE(`subclass_name`, " ", "") LIKE "%'.str_replace(' ', '', trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[4]), '"'))).'%"))';        
                $subclass_name=  strtoupper(trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[4]), '"')));
                $model_sub_class[$i] = MasSubClass::model()->find(array('condition' => 'subclass_name="'.$subclass_name.'"'));
                $model_plan[$i]->subclass_ids = $model_sub_class[$i]->id;
            }else{
                $model_plan[$i]->subclass_ids = '';
            }
            $model_plan[$i]->sub_class_name =trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[4]), '"')); 
            $policy_no='';
            if($data[5]!=''){
                $policy_no= trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[5]), '"'));
                $model_plan[$i]->policy_no =$policy_no;
            }else{                    
                $model_plan[$i]->policy_no = '';
            }     
            $policynumber_error[$i] = $policy_no;
            if($data[6]!=''){
                $model_plan[$i]->start_date =trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[6]), '"'));
                               
            }else{                    
                $model_plan[$i]->start_date = '';
            }
            $amount=0;
            if($data[7]!=''){
                $model_plan[$i]->amount =trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[7]), '"'));
                $amount=trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[7]), '"'));
            }else{                    
                $model_plan[$i]->amount = '';
            }
            if($data[8]!=''){
                //$condition = '((REPLACE(`payment_term`, " ", "") LIKE "%'.str_replace(' ', '', trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[8]), '"'))).'%"))';        
                $payment_term=  strtoupper(trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[8]), '"')));
                $model_payment_term[$i] = MasPlanPaymentTerms::model()->find(array('condition' => 'payment_term="'.$payment_term.'"'));
                $model_plan[$i]->payment_term = $model_payment_term[$i]->id;
                $model_plan[$i]->annualized_premium = $amount*$model_payment_term[$i]->no_of_times  ;
                               
            }else{                    
                $model_plan[$i]->payment_term = '';
                $model_plan[$i]->annualized_premium ='';
            }
            $model_plan[$i]->paymenttermname =trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[8]), '"'));
            if($data[9]!=''){
                $model_plan[$i]->tennure =trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[9]), '"'));
                               
            }else{                    
                $model_plan[$i]->tennure = '';
            }     
            if($data[10]!=''){
                $policy_status =strtoupper(trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[10]), '"')));
                $policy_status_value='';
                if($policy_status=='INFORCE'){
                    $policy_status_value='O';
                }else if($policy_status=='BENEFIT CLAIM'){
                    $policy_status_value='C';
                }else if($policy_status=='PENDING'){
                    $policy_status_value='P';
                }else if($policy_status=='SURRENDER'){
                    $policy_status_value='S';
                }else if($policy_status=='MATURITY'){
                    $policy_status_value='M';
                }else if($policy_status=='LAPSED'){
                    $policy_status_value='L';
                }else if($policy_status=='PAID UP'){
                    $policy_status_value='U';
                }else if($policy_status=='CANCELLED'){
                    $policy_status_value='CN';
                }else if($policy_status=='NEF'){
                    $policy_status_value='N';
                }          
                $model_plan[$i]->policy_status =$policy_status_value;
            }else{                    
                $model_plan[$i]->policy_status = '';
            }     
            $model_plan[$i]->statusname =trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[10]), '"'));
            if($data[11]!=''){
                $model_plan[$i]->issue_date =trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[11]), '"'));
                               
            }else{                    
                $model_plan[$i]->issue_date =$model_plan[$i]->start_date;
            }
            if($data[12]!=''){
                $model_plan[$i]->icp_months =trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[12]), '"'));
                               
            }else{                    
                $model_plan[$i]->icp_months ='';
            }
            if($data[13]!=''){
                $model_plan[$i]->reason =trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[13]), '"'));
                               
            }else{                    
                $model_plan[$i]->reason ='';
            }
            $validate = $model_plan[$i]->validate() && $validate; 
            
            }
        }
        function array_not_unique($raw_array) {
            $dupes = array();
            natcasesort($raw_array);
            reset($raw_array);

            $old_key   = NULL;
            $old_value = NULL;
            foreach ($raw_array as $key => $value) {
                if ($value === NULL) { continue; }
                if (strcasecmp($old_value, $value) === 0) {
                    $dupes[$old_key] = $old_value;
                    $dupes[$key]     = $value;
                }
                $old_value = $value;
                $old_key   = $key;
            }
            return $dupes;
        }
        $policynumber_common = array_not_unique($policynumber_error);        
        if ($validate && empty($policynumber_common)){					
            if (!empty($model_plan)) {
                $uploadcount=0;
                foreach ($model_plan as $s=>$eachModel) {  
                    $eachModel->last_deferment_date=$eachModel->start_date;
                    if ($eachModel->start_date != '' && $eachModel->start_date != '0000-00-00') {
                        $tennure_array=  explode('.', $eachModel->tennure);
                        $eachModel->mature_date=date('Y-m-d', strtotime('+'.$tennure_array[0].' years', strtotime($eachModel->start_date)));
                        if($tennure_array[1]>0){
                            $eachModel->mature_date=date('Y-m-d', strtotime('+'.$tennure_array[1].' months', strtotime($eachModel->start_date)));
                        }
                    }
                    $eachModel->save();
                    Customer::model()->updateByPk($eachModel->customer_id, array('cust_policy_taken' =>'Y'));        
                    $model_payment_term_1=MasPlanPaymentTerms::model()->findbyPK($eachModel->payment_term);
                    $total_installments=$eachModel->tennure*$model_payment_term_1->no_of_times;
                    if($model_payment_term_1->no_of_times>0){
                        $add_mnth =(int)(12/$model_payment_term_1->no_of_times);
                    }else{
                        $add_mnth = 12;
                    }
                    //Installment Save
                    $due_date = $eachModel->start_date;
                    for ($m=0; $m<$total_installments; $m++) {
                        if($m==0){
                            $due_date = $eachModel->start_date;
                        }else{
                            $due_date = date("Y-m-d",strtotime(date("Y-m-d", strtotime($due_date)) . " +".$add_mnth." months"));
                        }
                        $modelPlanInstallment = new CustomerPlanInstallments();
                        $modelPlanInstallment->cus_plan_id=$eachModel->id;
                        $modelPlanInstallment->installment_no=$m+1;
                        $modelPlanInstallment->payment_term_id=$eachModel->payment_term;
                        $modelPlanInstallment->premium_amount=$eachModel->amount;
                        $modelPlanInstallment->payment_due_date=$due_date;
                        $modelPlanInstallment->status='N';
                        $modelPlanInstallment->created_by=Yii::app()->user->id;
                        $modelPlanInstallment->created_date_time=date('Y-m-d H:i:s');
                        $modelPlanInstallment->save(false);
                    }
                    //End Installment save
                    //Policy Installment
                    $modelpolicy= new PolicyInstallmentDetails();
                    $modelpolicy->payment_term_id=$eachModel->payment_term;;
                    $modelpolicy->total_installments  = $total_installments; 
                    $modelpolicy->cus_plan_id  = $eachModel->id; 
                    $modelpolicy->start_date  = $eachModel->start_date;  
                    $modelpolicy->end_date    = date("Y-m-d",strtotime(date("Y-m-d", strtotime($eachModel->start_date)) . " +".$eachModel->tennure." year"));
                    $modelpolicy->save();
                    $uploadcount++;
                }
                $jsonData['status'] = "success";
                $jsonData['uploadcount'] =$uploadcount;
            }	
        } else {			
            if (!empty($model_plan)) {
                foreach ($model_plan as $s => $data_model) {
                    $error_list[$s]['mobile_number'] =$data_model['mobile_number'];
                    $error_list[$s]['provider_name'] =$data_model['provider_name'];
                    $error_list[$s]['plan_name'] =$data_model['plan_name'];
                    $error_list[$s]['class_name']  =$data_model['class_name'];
                    $error_list[$s]['sub_class_name']   =$data_model['sub_class_name'];
                    $error_list[$s]['policy_no']  =$data_model['policy_no'];
                    $error_list[$s]['start_date'] =$data_model['start_date'];
                    $error_list[$s]['amount']    =$data_model['amount'];
                    $error_list[$s]['paymenttermname']      =$data_model['paymenttermname'];
                    $error_list[$s]['tennure']      =$data_model['tennure'];
                    $error_list[$s]['statusname']      =$data_model['statusname'];
                    $error_list[$s]['reason']      =$data_model['reason'];
                    if($data_model->validate()){
                        $error_list[$s]['remarks']     ="correct";
                    }else{
                        $error_list[$s]['remarks']     =$data_model->getErrors();	
                    }
                }
            }	
            $jsonData['status'] = "error";            
	}				
              		 
	$j=0;
        fclose($file);        
        $list = array();        
        if(!empty($error_list)){
            $file_error = fopen($error_url, "w+");
            $list[$j++] = 'Mobile Number(As in the Customer Profile),Provider,Plan Name,Class,SubClass,Policy Number,Start Date,Amount,Payment term,Tenure,Status,Reason,Remarks';
            foreach ($error_list as $i => $error_detail) {			
                if(!empty($error_detail)){
                    if(!empty($error_detail['remarks'])){
                            $error_view[$i] = '';
                        foreach($error_detail['remarks'] as $p => $error_value){						
                                $error_view[$i] .= $error_value[0]." / ";	

                        }
                    }else{
                        $error_view[$i] .= '';
                    }
                    if (in_array($error_detail['policy_no'], $policynumber_common)){
                         $error_view[$i] .= " Policy number Duplicated/";
                    }	                
                    $list[$j++] = $error_detail['mobile_number']. ',' .$error_detail['provider_name']. ',' .$error_detail['plan_name']. ',' .$error_detail['class_name']. ','.$error_detail['sub_class_name']. ',' .$error_detail['policy_no']. ',' .$error_detail['start_date']. ',' .$error_detail['amount']. ',' .$error_detail['paymenttermname'] . ',' .$error_detail['tennure'].',' .$error_detail['statusname'].',' .$error_detail['reason']. ',' .$error_view[$i];
                }
            }
            foreach ($list as $line) {
                fputcsv($file_error, explode(',', $line));
            }
            fclose($file_error);
        }
		

        $jsonData['error_url'] = $error_url;
        $jsonData['filename'] = $file_name;
        $jsonData['link'] = CHtml::link('Download log', array('policyupload/DownloadErrorCsv', 'file_name'=>$file_name), array('target' => '_blank',
            'style'=>'border: 1px solid #686869;padding: 2px 10px;border-radius: 10px;font-size: 10px;background: #a1a1a1;color: #fff;'
            . ''
            ));
        echo CJSON::encode($jsonData);
    }
    public function actionDownloadErrorCsv() {
        $file_name =Yii::app()->request->getParam('file_name');
        $error_url = Yii::app()->basePath . '/../uploads/policydetails/error/' . $file_name;
        return Yii::app()->getRequest()->sendFile('log.csv', @file_get_contents($error_url));
    }
    public function actionDownloadformat() {
        $error_url = Yii::app()->basePath . '/../uploads/policydetails/policyuploadformat.csv';
        return Yii::app()->getRequest()->sendFile('uploadformat.csv', @file_get_contents($error_url));
    }
    public function actionDownloadPaymentmaster() {
        $error_url = Yii::app()->basePath . '/../uploads/policydetails/paymenttype.pdf';
        return Yii::app()->getRequest()->sendFile('paymenttype.pdf', @file_get_contents($error_url));
    }
}