<?php

class MasmaritalstatusController extends Controller
{
	  public function accessRules() {
            return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                  'actions' => array('login', 'error', 'logout'),
                  'users' => array('*'),
                  ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                  'actions' => array('Index','Create','GetList','SaveMaritalstatus','DeleteMaritalstatus','DirectAdd','UploadDropDownImage'),
                  'expression' => '$user->isMember()',
                  ),
                array('deny', // deny all users
                  'users' => array('*'),
                  ),
                );
        }
	public function actionIndex()
	{
		$this->render('index');
	}
          public function actionGetList()
        {
                $model=new MasMaritalStatus();
                $draw    = $_POST['draw'];
                $offset = $_POST['start'];
                $limit  = $_POST['length'];
                $columns = array(
                // datatable column index  => database column name
                   0 =>'marital_status'
                   
                   );
                $filterColumn = $columns[$_POST['order'][0]['column']];
                $filterOrder  = $_POST['order'][0]['dir'];
                $orderBy   = $filterColumn." ".$filterOrder;
                $condition = 't.isActive="Y"';
                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
                {
                  $searchString = $_POST['search']['value'];
                  $condition.=" and (marital_status LIKE '%".$searchString."%')";
                }
                $count = $model->count(array('condition'=>$condition));
                $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));
                $recordsTotal = $count;
                $recordsFiltered = $count;
                $data['draw'] = $draw;
                $data['recordsTotal'] = $recordsTotal;
                $data['recordsFiltered'] = $recordsFiltered;
                $rowData=array();
                $m = 1;
                 foreach ($model as $row)
                {
                    if(!empty($row['marital_logo'])){
                        $marital_logo =$row['marital_logo'];
                    }
                    else{
                        $marital_logo = "no_marital_status_logo.png";
                    }
                    $div =   '<div class="btn-wrap text-center"><button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'masmaritalstatus/create&id='.$row['id'].'\',\'Edit Marital Status\',\'lg\')"><i class="fa fa-pencil"></i></button>';
                    $rowData[]=array($m,$row['marital_status'],CHtml::image(Yii::app()->baseUrl."/uploads/maritalstatus/".$marital_logo),'<div class="btn-wrap text-center">'.$div.'</div>');
                
                    $m++;
                    
                }
                
                
                
                $data['data'] = $rowData;
                echo json_encode($data);
        }
         public function actionCreate()
        {
            $model=new MasMaritalStatus();
            $id = (int) Yii::app()->request->getParam('id');
            if($id>0){
                $model=$model->findByPk($id);
            }
                Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('marital_form', array('model' => $model), false, false);
        }
  
  
        public function actionSaveMaritalstatus()
        {
            $model = new MasMaritalStatus();
            if (isset($_POST['MasMaritalStatus']))
            {
    		$model->created_by = Yii::app()->user->id;
                $model->created_date_time =date('Y-m-d h:i:s');
    		if ((int) @$_POST['MasMaritalStatus']['id'] > 0)
                {   $model->updated_by = Yii::app()->user->id;
                    $model->updated_date_time =date('Y-m-d h:i:s');
                    $id= (int) @$_POST['MasMaritalStatus']['id'];
                    $model=$model->findByPk($id);  
                }
                $model->attributes=$_POST['MasMaritalStatus'];
                if ($model->save())
                {
                        $jsonData['status'] = 'success';
                        $jsonData['frm'] = $_POST['country_form'];
                        $jsonData['id'] = $model->id;
	                echo CJSON::encode($jsonData);
                }
                else
                {
                        $error = CActiveForm::validate($model, '', false);
                        if ($error != '[]')
		               echo $error;
                }
          
            }
        }
        public function actionDeleteMaritalstatus(){
       
		$id = $_POST['id'];
                $model_c = Customer::model()->findAll(array('condition' => 'customer_country = '.$id.' '));
                $model_com = Company::model()->findAll(array('condition' => 'shipping_country = '.$id.' '));
                 if(empty($model_c) && empty($model_com)){
                        $model=new MasMaritalStatus();
                        $model->deleteByPk($id);
                        echo "success";
                 }   
                 else{
                     echo "fail";
                 }
               
    }
    
     public function actionDirectAdd(){
           $from = $_POST['from'];
           $name = $_POST['name'];
           $code = $_POST['code'];
           if($name != '' && $code != ''){
               $modelMarital = new MasMaritalStatus;
               $modelMarital->created_by = Yii::app()->user->id;
               $modelMarital->created_date_time =date('Y-m-d h:i:s');   
               $modelMarital->marital_status = $name;
               
               if($modelHealth->save()){
                    $data  =  MasMaritalStatus::getMaritalStatus();
                    if($from == 'customer'){
                        $model = new Customer;
                        $field_name = 'customer_country';
                    }
                    if($from == 'vendor'){
                        $model = new Vendor;
                        $field_name = 'vendor_country';
                    }
                    $model->$field_name = $modelHealth->id;
                    $drop=CHtml::activedropDownList($model,$field_name, $data,  array('class' => 'tooltipster','data-label'=>'Marital status <span style="color:red;">*</span>'));  
                    $status=array("status" =>"success","drop" => $drop);    
                    echo CJSON::encode($status);
               }else{
                    $error = CActiveForm::validate($modelHealth, '', false);
                        if ($error != '[]')
		               echo $error;
               }
           }
          
            
         }
}