<?php

class MasdocumentController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Create', 'GetList', 'SaveDocument'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex() {
        $this->render('index');
    }
    public function actionGetList() {
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $executive_id = $_POST['executive_id'];
        $model = new MasDocument();
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'document_name',     
            2 => 'view_in',
            3 => '',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        /******** First Loading Without Search********/
        $condition = "1=1";
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " AND (document_name LIKE '%" . $searchString . "%' )";
        }             
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m=1;
        foreach ($model as $row) {
            $div='';
            $type="";
            if($row->view_in==1){
                $type='Activity';
            }else{
                $type='Customer';
            }
            $div .= ' <button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'masdocument/create&id=' . $row['id'] . '\',\'Edit Document\',\'lg\')"><i class="fa fa-pencil"></i></button>&nbsp;';            
           $rowData[] = array($m, $row->document_name,$type, '<div class="btn-wrap text-center">' . $div . '</div>');
            $m++;
        }

        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionCreate() {
        $model = new MasDocument();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('create', array('model' => $model), false, false);
    }
    public function actionSaveDocument() {
        $model = new MasDocument();
        if (isset($_POST['MasDocument'])) {           
            if ((int) @$_POST['MasDocument']['id'] > 0) {
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d h:i:s');
                $id = (int) @$_POST['MasDocument']['id'];
                $model = $model->findByPk($id);
            }else{
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d h:i:s');
             }
            $model->attributes = $_POST['MasDocument'];
            $view_in= $_POST['MasDocument']['view_in'];
            if($view_in==1){
                if(isset($_POST['MasDocument']['usergroup_id']) && count($_POST['MasDocument']['usergroup_id']) > 0){
                    $model->usergroup_id = implode(',',$_POST['MasDocument']['usergroup_id']);
                }
            }else{
                $model->usergroup_id ='';
            }
           if ($model->save()) {
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    public function actionView() {
        $model = new MasterCommissionSchemes();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('view', array('model' => $model), false, false);
    }
}
?>