<?php

class EmiratesController extends Controller
{
	 public function accessRules() {
            return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                  'actions' => array('login', 'error', 'logout'),
                  'users' => array('*'),
                  ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                  'actions' => array('Index','Create','GetList','SaveEmirates','DeleteEmirates','DirectAdd','UploadDropDownImage'),
                  'expression' => '$user->isMember()',
                  ),
                array('deny', // deny all users
                  'users' => array('*'),
                  ),
                );
        }

    public function actionIndex() {
        $this->render('index');
    }

    // Uncomment the following methods and override them if needed

   public function filters()
        {
            return array(
                'accessControl', // perform access control for CRUD operations
                );
        }
        public function actionGetList()
        {
                $model=new MasEmirates();
                $draw    = $_POST['draw'];
                $offset = $_POST['start'];
                $limit  = $_POST['length'];
                $columns = array(
                // datatable column index  => database column name
                   0 =>'emirate_name'
                   
                   );
                $filterColumn = $columns[$_POST['order'][0]['column']];
                $filterOrder  = $_POST['order'][0]['dir'];
                $orderBy   = $filterColumn." ".$filterOrder;
                $condition = 't.isActive="Y"';
                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
                {
                  $searchString = $_POST['search']['value'];
                  $condition.=" and (emirate_name LIKE '%".$searchString."%')";
                }
                $count = $model->count(array('condition'=>$condition));
                $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));
                $recordsTotal = $count;
                $recordsFiltered = $count;
                $data['draw'] = $draw;
                $data['recordsTotal'] = $recordsTotal;
                $data['recordsFiltered'] = $recordsFiltered;
                $rowData=array();
                $m = 1;
                 foreach ($model as $row)
                {
                    $div=   '<div class="btn-wrap text-center"><button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'emirates/create&id='.$row['id'].'\',\'Edit Emirate/State\',\'lg\')"><i class="fa fa-pencil"></i></button>';
                    $rowData[]=array($m,$row['emirate_name'],$row['country']['country_name'],CHtml::image(Yii::app()->baseUrl."/uploads/emirate/".$row['emirate_image'],"",array('style' => 'height: 24px;width: 36px;')),'<div class="btn-wrap text-center">'.$div.'</div>');
                
                    $m++;
                    
                }
                
                $data['data'] = $rowData;
                echo json_encode($data);
        }
         public function actionCreate()
        {
            $model=new MasEmirates();
            $id = (int) Yii::app()->request->getParam('id');
            if($id>0){
                $model=$model->findByPk($id);
            }
                Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('emirates_form', array('model' => $model), false, false);
        }
  
  
        public function actionSaveEmirates()
        {
            $model = new MasEmirates();
            if (isset($_POST['MasEmirates']))
            {
    		$model->created_by = Yii::app()->user->id;
                $model->created_date_time =date('Y-m-d h:i:s');
    		if ((int) @$_POST['MasEmirates']['id'] > 0)
                {   $model->updated_by = Yii::app()->user->id;
                    $model->updated_date_time =date('Y-m-d h:i:s');
                    $id= (int) @$_POST['MasEmirates']['id'];
                    $model=$model->findByPk($id);  
                }
                $model->attributes=$_POST['MasEmirates'];
                if ($model->save())
                {
                        $jsonData['status'] = 'success';
                        $jsonData['frm'] = $_POST['country_form'];
                        $jsonData['id'] = $model->id;
	                echo CJSON::encode($jsonData);
                }
                else
                {
                        $error = CActiveForm::validate($model, '', false);
                        if ($error != '[]')
		               echo $error;
                }
          
            }
        }
        public function actionDeleteCountry(){
       
		$id = $_POST['id'];
                $model_c = Customer::model()->findAll(array('condition' => 'customer_country = '.$id.' '));
                $model_com = Company::model()->findAll(array('condition' => 'shipping_country = '.$id.' '));
                 if(empty($model_c) && empty($model_com)){
                        $model=new MasCountry();
                        $model->deleteByPk($id);
                        echo "success";
                 }   
                 else{
                     echo "fail";
                 }
               
    }
    
     public function actionDirectAdd(){
           $from = $_POST['from'];
           $name = $_POST['name'];
           $code = $_POST['code'];
           if($name != '' && $code != ''){
               $modelEmirates = new MasEmirates;
               $modelEmirates->created_by = Yii::app()->user->id;
               $modelEmirates->created_date_time =date('Y-m-d h:i:s');   
               $modelEmirates->emirate_name = $name;
               
               if($modelEmirates->save()){
                    $data  =  MasEmirates::getEmirates();
                    if($from == 'customer'){
                        $model = new Customer;
                        $field_name = 'customer_country';
                    }
                    if($from == 'vendor'){
                        $model = new Vendor;
                        $field_name = 'vendor_country';
                    }
                    $model->$field_name = $modelEmirates->id;
                    $drop=CHtml::activedropDownList($model,$field_name, $data,  array('class' => 'tooltipster','data-label'=>'Emirates <span style="color:red;">*</span>'));  
                    $status=array("status" =>"success","drop" => $drop);    
                    echo CJSON::encode($status);
               }else{
                    $error = CActiveForm::validate($modelEmirates, '', false);
                        if ($error != '[]')
		               echo $error;
               }
           }
          
            
         }
}