<?php

class DashboardController extends Controller {

    public function accessRules() {

        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('index', 'getNetCalls','GetActivityGraph','ViewGraphDetails','GetGraph','PolicyCount','PolicyValue','MonthlypolicyDetails',
                                    'getpolicydetails','monthlypolicyvaluedetails','CustomerannualisedPremium','CustomertotalPolicy','loadbirthday',
                                    'loadanniversary','creditcardexpiry','paymentduelist','exhaustedcheque','bouncedcheque','ManagerDashboard',
                                    'GetPolicyTargetDetails','GetFactFindDetails','GetAppointmentDetails','GetQuarterlyPolicyTargetDetails','GetQuarterlyFactFindDetails','GetQuarterlyAppointmentDetails','SendBirthdayMailToCustomer','SendChequeMailToCustomer'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {

        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionIndex() {
        $this->render('index');
    }

    public function actiongetNetCalls() {
        $todate = '2019-01-31';
        $from = '2019-01-01';
        $condition = " call_or_plan_date_time >= '" . $from . "' AND call_or_plan_date_time <= '" . $todate . "'";
        $sql = "SELECT `crm_activity`.`created_by`, count(*) as 'num' FROM `crm_activity` join crm_user on (`crm_activity`.`created_by`= crm_user.id) where type_of_activity= 1 AND " . $condition . " GROUP by `crm_activity`.`created_by`";

        $user = Yii::app()->db->createCommand($sql)->queryAll();

        //$model = Activity::model()->findAll($condition);
        $data = array();
        foreach ($user as $value) {
            $data[] = array(
                'name' => User::model()->findByPk($value['created_by'])->getFullname(),
                'value' => $value['num']
            );
        }
        echo json_encode($data);
    }
    /********************  start-arul on 12/1/2019 ********************/
    public function actionGetActivityGraph(){
        
        $year    = Yii::app()->request->getparam("year");  
        $month   = Yii::app()->request->getparam("month");
        $user    = Yii::app()->request->getparam("user");  
        $activities    = Yii::app()->request->getparam("activities"); 
        $type    = Yii::app()->request->getparam("type");   
        $this->render('activity_graph',array('year'=>$year,'month'=>$month,'user'=>$user,'activities'=>$activities,'type'=>$type));
    }
    /********************  End ********************/
    /********************  start-arul on 18/1/2019 ********************/
    public function actionViewGraphDetails(){
        
        $year    = Yii::app()->request->getparam("year");  
        $month   = Yii::app()->request->getparam("month");
        $viewtype= Yii::app()->request->getparam("viewtype"); 
        $type    = Yii::app()->request->getParam("type");  
        $user    = Yii::app()->request->getParam("user"); 
        $this->render('view_graph_details',array('year'=>$year,'month'=>$month,'viewtype'=>$viewtype,'type'=>$type,'user'=>$user));
    }
    /********************  End ********************/
    public function actionGetGraph(){
        $page = Yii::app()->request->getparam("page"); 
        $month = Yii::app()->request->getparam("month");   
        $year = Yii::app()->request->getparam("year");   
        $user = Yii::app()->request->getparam("user"); 
        $this->render($page,array('month'=>$month,'year'=>$year,'user'=>$user));
     }
    public function actionPolicyCount(){  
        $month = Yii::app()->request->getparam("month");   
        $year = Yii::app()->request->getparam("year");   
        $user = Yii::app()->request->getparam("user"); 
        $this->render('policycount_details',array('month'=>$month,'year'=>$year,'user'=>$user));
    }
    public function actionPolicyValue(){ 
        $month = Yii::app()->request->getparam("month");   
        $year = Yii::app()->request->getparam("year");   
        $user = Yii::app()->request->getparam("user"); 
        $this->render('policyvalue_details',array('month'=>$month,'year'=>$year,'user'=>$user));
    }
    public function actionMonthlypolicyDetails(){
        $month = Yii::app()->request->getparam("month");   
        $year = Yii::app()->request->getparam("year"); 
        $user = Yii::app()->request->getparam("user"); 
        $this->render('monthly_policy_details',array('month'=>$month,'year'=>$year,'user'=>$user));
    }
    public function actiongetpolicydetails(){
        $month = Yii::app()->request->getparam("month");   
        $year = Yii::app()->request->getparam("year");  
        $customer_id = Yii::app()->request->getparam("customer_id");  
        $this->render('customer_policy_details',array('month'=>$month,'year'=>$year,'customer_id'=>$customer_id));
    }
    public function actionmonthlypolicyvaluedetails(){
        $month = Yii::app()->request->getparam("month");   
        $year = Yii::app()->request->getparam("year");   
        $user = Yii::app()->request->getparam("user"); 
        $this->render('monthly_policy_amountdetails',array('month'=>$month,'year'=>$year,'user'=>$user));
    }
    public function actionCustomerannualisedPremium(){
        $condition='policy_status="O" AND (cust_executive_id="'.Yii::app()->user->id.'" OR cust_executive_id IN ('.Yii::app()->user->connected_users.')) ';
        $model_annual_premium_details= CustomerPlanDetails::model()->with('customer')->findAll(array('condition' =>$condition,'order'=>'annualized_premium desc'));
        if(!empty($model_annual_premium_details)){
            foreach ($model_annual_premium_details as $i => $value) {
            $table .= '<tr>
                <td>'.($i+1).'</td>
                <td>'.$value->customer->Fullname.'</td>
                <td>'.$value->policy_no.'</td>
                <td class="text-right">'.number_format($value->annualized_premium, 0).'</td>
            </tr>';
            }
        }else{
            $table .= '<tr><td colspan="4"class="text-center">No Data Available</td></tr>'; 
        }
        $jsonData['premiumdetails'] =$table;
        echo CJSON::encode($jsonData);
    }
    public function actionCustomertotalPolicy(){
        $condition='policy_status="O" AND (cust_executive_id="'.Yii::app()->user->id.'" OR cust_executive_id IN ('.Yii::app()->user->connected_users.')) ';
        $model_total_policy_details= CustomerPlanDetails::model()->with('customer')->findAll(array('select'=>'count(t.id) as id','condition' =>$condition,'group'=>'customer_id','order'=>'id desc'));
        if(!empty($model_total_policy_details)){
            foreach ($model_total_policy_details as $i => $value) {
            $table .= '<tr>
                <td>'.($i+1).'</td>
                <td>'.$value->customer->Fullname.'</td>
                <td>'.$value->customer->cust_mobile1.'</td>
                <td class="text-center">'.$value->id.'</td>
            </tr>';
            }
        }else{
            $table .= '<tr><td colspan="4"class="text-center">No Data Available</td></tr>'; 
        }
        $jsonData['policydetails'] =$table;
        echo CJSON::encode($jsonData);
    }
    public function actionloadbirthday(){
        $current_date_15 = date('Y-m-d', strtotime('+15 days', strtotime(date('Y-m-d'))));
        $current_day = date('d');
        $current_day_15 = date('d', strtotime($current_date_15));
        $current_month = date('m');
        $current_month_15 = date('m', strtotime($current_date_15));
        $condition='(cust_executive_id="'.Yii::app()->user->id.'" OR cust_executive_id IN ('.Yii::app()->user->connected_users.')) AND DAY(cust_date_of_birth)>="'.$current_day.'" AND DAY(cust_date_of_birth)<="'.$current_day_15.'" AND MONTH(cust_date_of_birth)="'.$current_month.'" AND MONTH(cust_date_of_birth)="'.$current_month_15.'"';
        $model_customer= Customer::model()->findAll(array('condition' =>$condition,'order'=>'DAY(cust_date_of_birth) asc'));
        if(!empty($model_customer)){    
            foreach ($model_customer as $i => $value) {
                $cust_date_of_birth='';
                    if($value->cust_date_of_birth!='' && $value->cust_date_of_birth!='0000-00-00'){
                        $cust_date_of_birth=date("d/m/Y",strtotime($value->cust_date_of_birth));
                    }
            $table .= '<tr>
                <td>'.($i+1).'</td>
                <td>'.$value->Fullname.'</td>
                <td>'.$value->cust_mobile1.'</td>
                <td>'.$cust_date_of_birth.'</td>
                <td><a href="#20" onclick="sendBirthdayMailToCustomer('.$value->id.');"><i class="fa fa-birthday-cake"></i></a></td>
            </tr>';
            }   
        }else{
           $table .= '<tr><td colspan="5"class="text-center">No Data Available</td></tr>'; 
        }
        $jsonData['birthdaydetails'] =$table;
        echo CJSON::encode($jsonData);
    }
    public function actionloadanniversary(){
        $condition='policy_status="O" AND (cust_executive_id="'.Yii::app()->user->id.'" OR cust_executive_id IN ('.Yii::app()->user->connected_users.')) AND DAY(start_date)>="'.$current_day.'" AND DAY(start_date)<="'.$current_day_15.'" AND MONTH(start_date)="'.$current_month.'" AND MONTH(start_date)="'.$current_month_15.'"';
        $model_plan_details= CustomerPlanDetails::model()->with('customer')->findAll(array('condition' =>$condition,'order'=>'DAY(start_date) asc'));
        if(!empty($model_plan_details)){
            foreach ($model_plan_details as $i => $value) {
                $start_date='';
                if($value->start_date!='' && $value->start_date!='0000-00-00'){
                        $start_date= date("d/m/Y",strtotime($value->start_date));
                    }
                $table .= '<tr>
                    <td>'.($i + 1).'</td>
                    <td>'.$value->customer->Fullname.'</td>
                    <td>'.$value->customer->cust_mobile1.'</td>
                    <td>'.$start_date.'</td>
                </tr>';
            }
        }else{
           $table .= '<tr><td colspan="4"class="text-center">No Data Available</td></tr>'; 
        }
        $jsonData['anniversary'] =$table;
        echo CJSON::encode($jsonData);
    }
    public function actioncreditcardexpiry(){
        $previous_month = date('Y-m-d', strtotime('-3 months', strtotime(date('Y-m-d'))));
        $extended_month = date('Y-m-d', strtotime('+3 months', strtotime(date('Y-m-d'))));
        $condition = 'expiry_date>="'.$previous_month.'" and expiry_date<="'.$extended_month.'" and payment_type="2" and (cus_details.cust_executive_id="' . Yii::app()->user->id . '" OR cus_details.cust_executive_id IN (' . Yii::app()->user->connected_users . '))';                   
        $modal_card_details = CustomerPaymentDetails::model()->with('cus_details')->findAll(array('condition' => $condition,'order'=>'expiry_date asc'));
        if(!empty($modal_card_details)){
            foreach ($modal_card_details as $i => $value) {
                $expiry_date='';
                if($value->expiry_date!='' && $value->expiry_date!='0000-00-00'){
                    $expiry_date= date("d/m/Y",strtotime($value->expiry_date));
                }
                $table .= '<tr>
                    <td>'.($i + 1).'</td>
                    <td>'.$value->cus_details->Fullname.'</td>
                    <td>'.$value->cus_details->cust_mobile1.'</td>
                    <td>'.$value->ac_no.'</td>
                    <td>'.$expiry_date.'</td>
                </tr>';
            }
        }else{
           $table .= '<tr><td colspan="5"class="text-center">No Data Available</td></tr>'; 
        }
        $jsonData['creditcardexpiry'] =$table;
        echo CJSON::encode($jsonData);
    }
    public function actionpaymentduelist(){  
        $current_date_30 = date('Y-m-d', strtotime('+30 days', strtotime(date('Y-m-d'))));
        $condition='cusplandetail.policy_status="O" AND (customer.cust_executive_id="'.Yii::app()->user->id.'" OR customer.cust_executive_id IN ('.Yii::app()->user->connected_users.')) AND payment_due_date<"'.$current_date_30.'"  AND (status="N" OR status="H")';//DAY(payment_due_date)>="'.$current_day.'" AND DAY(payment_due_date)<="'.$current_day_15.'" AND MONTH(payment_due_date)="'.$current_month.'" AND MONTH(payment_due_date)="'.$current_month_15.'" 
        $model_payment_details= CustomerPlanInstallments::model()->with('cusplandetail','cusplandetail.customer')->findAll(array('condition' =>$condition,'order'=>'payment_due_date desc','limit'=>'100'));
        if(!empty($model_payment_details)){
            foreach ($model_payment_details as $i => $value) {
                $payment_due_date='';
                    if($value->payment_due_date!='' && $value->payment_due_date!='0000-00-00'){
                        $payment_due_date=date("d/m/Y",strtotime($value->payment_due_date));
                    }
                $table .= '<tr>
                    <td>'.($i+1).'</td>
                    <td>'.$value->cusplandetail->customer->Fullname.'</td>
                    <td>'.$value->cusplandetail->policy_no.'</td>
                    <td>'.$payment_due_date.'</td>
                    <td>'.$value->installment_no.'</td>
                    <td class="text-right">'.$value->premium_amount.'</td>
                    <td><a href="#20" onclick="SendChequeMailToCustomer('.$value->cusplandetail->customer->id.','.$value->id.')"><i class="fa fa-dollar"></i></a></td>
                </tr>';
            } 
        }else{
           $table .= '<tr><td colspan="7"class="text-center">No Data Available</td></tr>'; 
        }
        $jsonData['paymentduelist'] =$table;
        echo CJSON::encode($jsonData);
    }
    public function actionexhaustedcheque(){     
        $current_date_payment=date('Y-m-d');
        $y=1;
        $model_plan_installment=CustomerPlanInstallments::model()->with('cusplandetail','cusplandetail.customer')->findAll(array('select'=>'*,min(installment_no) as installment_no','condition'=>'cusplandetail.policy_status="O" AND status="N" AND (customer.cust_executive_id="'.Yii::app()->user->id.'" OR customer.cust_executive_id IN ('.Yii::app()->user->connected_users.'))','group'=>'t.cus_plan_id'));
        if(!empty($model_plan_installment)){  
            foreach ($model_plan_installment as $key => $value_payment) {
                $paid_installment=$value_payment->installment_no-1;
                $payment_due_date=$value_payment->payment_due_date;
                if($paid_installment>0){
                    $model_payment_exhausted=CustomerPaymentDetails::model()->with('cus_plan_details')->find(array('condition'=>'installment_no="'.$paid_installment.'" AND payment_type="1" AND cus_plan_id="'.$value_payment->cus_plan_id.'"'));
                    if(!empty($model_payment_exhausted)){
                        $date1_convert = strtotime($current_date_payment);
                        $date2_convert = strtotime($payment_due_date);
                        $diff_days = $date2_convert - $date1_convert;
                        $diff_days = floor($diff_days / (60 * 60 * 24))+1;
                        $model_payment_cheque=CustomerPaymentDetails::model()->with('cus_plan_details')->find(array('condition'=>'installment_no="'.$value_payment->installment_no.'" AND payment_type="1" AND cus_plan_id="'.$value_payment->cus_plan_id.'"'));
                        if(empty($model_payment_cheque) && $diff_days<=45){ 
                            $payment_due_date='';
                            if($value_payment->payment_due_date!='' && $value_payment->payment_due_date!='0000-00-00'){
                                    $payment_due_date=date("d/m/Y",strtotime($value_payment->payment_due_date));
                            }
                        $table .= '<tr>
                            <td>'.($y).'</td>
                            <td>'.$value_payment->cusplandetail->customer->Fullname.'</td>
                            <td>'.$value_payment->cusplandetail->policy_no.'</td>
                            <td>'.$payment_due_date.'</td>
                            <td class="text-center">'.$value_payment->installment_no.'</td>
                            <td class="text-right">'.Yii::app()->numberFormatter->formatCurrency($value_payment->premium_amount,"").'</td>
                        </tr>';
                    $y++;
                        }
                    }
                }
            }
        }else{
           $table .= '<tr><td colspan="6"class="text-center">No Data Available</td></tr>'; 
        }
        $jsonData['exhaustedcheque'] =$table;
        echo CJSON::encode($jsonData);
    }
    public function actionbouncedcheque(){ 
        $condition='cusplandetail.policy_status="O" AND customerpayment.payment_type="1" AND customerpayment.status="3" and (cus_details.cust_executive_id="' . Yii::app()->user->id . '" OR cus_details.cust_executive_id IN (' . Yii::app()->user->connected_users . '))';                   
        $modal_cheque_details = CustomerPlanInstallments::model()->with('customerpayment','customerpayment.cus_details','cusplandetail')->findAll(array('condition' => $condition,'group'=>'t.installment_no'));
        if(!empty($modal_cheque_details)){
            foreach ($modal_cheque_details as $i => $value) {
               // $modal_new_installment = CustomerPlanInstallments::model()->findAll(array('condition' =>'installment_no="'.$value->installment_no.'" and cus_plan_id="'.$value->cus_plan_id.'" and(status="H" OR status="P")'));
               // if(empty($modal_new_installment)){           
                if($value->payment_due_date!='' && $value->payment_due_date!='0000-00-00'){
                    $payment_due_date= date("d/m/Y",strtotime($value->payment_due_date));
                }
                $table .= '<tr>
                    <td>'.($i + 1).'</td>
                    <td>'.$value->customerpayment->cus_details->Fullname.'</td>
                    <td>'.$value->customerpayment->cus_plan_details->policy_no.'</td>
                    <td>'.$value->customerpayment->ac_no.'</td>
                    <td>'.$payment_due_date.'</td>
                    <td>'.$value->installment_no.'</td>
                    <td>'.$value->premium_amount.'</td>
                </tr>';
                //}
            }
        }else{
            $table .= '<tr><td colspan="7"class="text-center">No Data Available</td></tr>'; 
        }
        $jsonData['bouncedcheque'] =$table;
        echo CJSON::encode($jsonData);
    }
    
    public function actionManagerDashboard() {
        $this->render('index_manager');
    }
    
    public function actionGetPolicyTargetDetails(){
        $array_month = array(1 => 'Jan', 2 => 'Feb', 3 => 'Mar', 4 => 'Apr', 5 => 'May', 6 => 'Jun', 7 => 'Jul', 8 => 'Aug', 9 => 'Sep', 10 => 'Oct', 11 => 'Nov', 12 => 'Dec');
        if(isset($_POST['year'])){
            $currentyear = (int) $_POST['year'];
        }
        else{
            $currentyear = (int) date('Y');
        }
        $condition = 'user_group_id=2';
        if(Yii::app()->user->authorised_user!=1){
            $condition.=' AND id='.Yii::app()->user->id;
        }
        
        
        $arr_managers = User::model()->findAll(array('condition'=>$condition));
         //Start-Current Month
         
         if($currentyear==(int) date('Y')){
            $current_month = date('n');
         }
         else{
             $current_month = 12;
         }
         
         $table .= '<thead>
                        <tr>
                            <th>&nbsp;</th>
                            <th>Target/Month</th>';
                            for($i=1;$i<=$current_month;$i++){
                             $table .= '<th>'.$array_month[$i].'</th>';
                            }
                            $table .= '<th>Total</th>
                            <th>Target Total</th>
                            <th>Varience</th>
                            <th>Varience(%)</th>
                        </tr>
                    </thead>
                    <tbody> ';                     
                    
         
         
        foreach($arr_managers as $managers){
            
            $SQL = "SELECT * FROM `view_policy_target` WHERE manager_id=".$managers->id.' AND user_id<>'.$managers->id.' AND designation_id!=0 GROUP BY user_id';
            $arr_target_details = Yii::app()->db->createCommand($SQL)->queryAll();
            
             $table .= '<tr>
                    <td><b>'.$managers->first_name.' '.$managers->last_name.'<b></td>';
                    for($i=1;$i<=$current_month;$i++){
                    $table .= '<td>&nbsp;</td>';
                    }
                    $table .= '<td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                </tr>';
                foreach($arr_target_details as $target_details){
                    $target_per_month = $target_details['target_per_month'];
                    $table .= '<tr>
                    <td>'.$target_details['first_name'].' '.$target_details['last_name'].'</td>
                    <td align="right">'.(int)$target_per_month.'</td>';
                    $total_target = $current_month * $target_per_month;
                    $total_annualized_premium = 0;
                    for($i=1;$i<=$current_month;$i++){
                        $SQL = "SELECT SUM(annualized_premium) as annualized_premium FROM `view_policy_target` WHERE user_id=".$target_details['user_id'].' AND (year(start_date)='.$currentyear.' AND month(start_date)='.$i.') GROUP BY user_id';
                        $arr_premium_details = Yii::app()->db->createCommand($SQL)->queryAll();
                        $annualized_premium = (int) $arr_premium_details[0]['annualized_premium'];
                        if($target_per_month < $annualized_premium){
                            $table .= '<td style="color:green" align="right">'.$annualized_premium.'</td>';
                        }
                        else{
                            $table .= '<td style="color:red" align="right">'.$annualized_premium.'</td>';
                        }
                        $total_annualized_premium+= $arr_premium_details[0]['annualized_premium'];
                    }
                    $varience = $total_annualized_premium - $total_target;
                    
                    $varience_percent = 0;
                    if($total_target > 0)
                    $varience_percent  = round((($varience/$total_target)*100),2);
                    
                    $varience_percent = number_format($varience_percent,"2");
                    
                    $table .= '<td  align="right">'.$total_annualized_premium.'</td>
                    <td align="right">'.(int) $total_target.'</td>
                    <td align="right">'.(int) $varience.'</td>';
                    if($varience < 0){
                        $table .= '<td style="background-color:red;color:white;" align="right">'. $varience_percent.'%</td>';
                    }
                    else{
                        $table .= '<td style="background-color:green;color:white;" align="right">'. $varience_percent.'%</td>';
                    }
                $table .= '</tr>';
                }
                
        }
        $table .= '</tbody>';
        $jsonData['policytarget'] =$table;
        echo CJSON::encode($jsonData);
    }
    
    public function actionGetFactFindDetails(){
         $array_month = array(1 => 'Jan', 2 => 'Feb', 3 => 'Mar', 4 => 'Apr', 5 => 'May', 6 => 'Jun', 7 => 'Jul', 8 => 'Aug', 9 => 'Sep', 10 => 'Oct', 11 => 'Nov', 12 => 'Dec');
        if(isset($_POST['year'])){
            $currentyear = (int) $_POST['year'];
        }
        else{
            $currentyear = (int) date('Y');
        }
        $condition = 'user_group_id=2';
        if(Yii::app()->user->authorised_user!=1){
            $condition.=' AND id='.Yii::app()->user->id;
        }
        $arr_managers = User::model()->findAll(array('condition'=>$condition));
         //Start-Current Month
        if($currentyear==(int) date('Y')){
            $current_month = date('n');
         }
         else{
             $current_month = 12;
         }
         
        
        $table .= '<thead>
                        <tr>
                            <th>&nbsp;</th>
                            <th>Target/Month</th>';
                            for($i=1;$i<=$current_month;$i++){
                             $table .= '<th>'.$array_month[$i].'</th>';
                            }
                            $table .= '<th>Total</th>
                            <th>Target Total</th>
                            <th>Varience</th>
                            <th>Varience(%)</th>
                        </tr>
                    </thead>
                    <tbody>';                       
        
        foreach($arr_managers as $managers){
            
            $SQL = "SELECT * FROM `view_fact_find_details` WHERE manager_id=".$managers->id.' AND user_id<>'.$managers->id.' AND designation_id!=0 GROUP BY user_id';
            $arr_fact_find_details = Yii::app()->db->createCommand($SQL)->queryAll();
            
             $table .= '<tr>
                    <td><b>'.$managers->first_name.' '.$managers->last_name.'<b></td>';
                    for($i=1;$i<=$current_month;$i++){
                    $table .= '<td>&nbsp;</td>';
                    }
                    $table .= '<td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                </tr>';
                foreach($arr_fact_find_details as $fact_find_details){
                    $find_fact_per_month = $fact_find_details['find_fact'];
                    $table .= '<tr>
                    <td>'.$fact_find_details['first_name'].' '.$fact_find_details['last_name'].'</td>
                    <td align="right">'.(int)$find_fact_per_month.'</td>';
                    $total_find_fact = $current_month * $find_fact_per_month;
                    $total_find_fact_count = 0;
                    for($i=1;$i<=$current_month;$i++){
                        $SQL = "SELECT COUNT(*) as find_fact_count FROM `view_fact_find_details` WHERE user_id=".$fact_find_details['user_id'].' AND fact_find_status=2 AND (year(call_back_or_actual_date)='.$currentyear.' AND month(call_back_or_actual_date)='.$i.') GROUP BY user_id';
                        $arr_find_fact_details = Yii::app()->db->createCommand($SQL)->queryAll();
                        $find_fact_count = (int) $arr_find_fact_details[0]['find_fact_count'];
                        if($find_fact_per_month < $find_fact_count){
                            $table .= '<td style="color:green" align="right">'.$find_fact_count.'</td>';
                        }
                        else{
                            $table .= '<td style="color:red" align="right">'.$find_fact_count.'</td>';
                        }
                        $total_find_fact_count+= $arr_find_fact_details[0]['find_fact_count'];
                    }
                    $varience = $total_find_fact_count - $total_find_fact;
                    
                    $varience_percent = 0;
                    if($total_find_fact > 0)
                    $varience_percent  = round((($varience/$total_find_fact)*100),2);
                    
                    $varience_percent = number_format($varience_percent,"2");
                    
                    $table .= '<td  align="right">'.$total_find_fact_count.'</td>
                    <td align="right">'.(int) $total_find_fact.'</td>
                    <td align="right">'.(int) $varience.'</td>';
                    if($varience < 0){
                        $table .= '<td style="background-color:red;color:white;" align="right">'.$varience_percent.'%</td>';
                    }
                    else{
                        $table .= '<td style="background-color:green;color:white;" align="right">'.$varience_percent.'%</td>';
                    }
                $table .= '</tr>';
                }
                
        }
        $table .= '</tbody>';
        $jsonData['factfind'] =$table;
        echo CJSON::encode($jsonData);
    }
    
    public function actionGetAppointmentDetails(){
         $array_month = array(1 => 'Jan', 2 => 'Feb', 3 => 'Mar', 4 => 'Apr', 5 => 'May', 6 => 'Jun', 7 => 'Jul', 8 => 'Aug', 9 => 'Sep', 10 => 'Oct', 11 => 'Nov', 12 => 'Dec');
        if(isset($_POST['year'])){
            $currentyear = (int) $_POST['year'];
        }
        else{
            $currentyear = (int) date('Y');
        }
        $condition = 'user_group_id=2';
        if(Yii::app()->user->authorised_user!=1){
            $condition.=' AND id='.Yii::app()->user->id;
        }
        $arr_managers = User::model()->findAll(array('condition'=>$condition));
         //Start-Current Month
        if($currentyear==(int) date('Y')){
            $current_month = date('n');
         }
         else{
             $current_month = 12;
         }
         
        
         $table .= '<thead>
                        <tr>
                            <th>&nbsp;</th>
                            <th>Target/Month</th>';
                            for($i=1;$i<=$current_month;$i++){
                             $table .= '<th>'.$array_month[$i].'</th>';
                            }
                            $table .= '<th>Total</th>
                            <th>Target Total</th>
                            <th>Varience</th>
                            <th>Varience(%)</th>
                        </tr>
                    </thead>
                    <tbody>';    
        foreach($arr_managers as $managers){
            
            $SQL = "SELECT * FROM `view_appointment_details` WHERE manager_id=".$managers->id.' AND user_id<>'.$managers->id.' AND designation_id!=0 GROUP BY user_id';
            $arr_appointment_details = Yii::app()->db->createCommand($SQL)->queryAll();
            
             $table .= '<tr>
                    <td><b>'.$managers->first_name.' '.$managers->last_name.'<b></td>';
                    for($i=1;$i<=$current_month;$i++){
                    $table .= '<td>&nbsp;</td>';
                    }
                    $table .= '<td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                </tr>';
                foreach($arr_appointment_details as $appointment_details){
                    $appointment_per_month = $appointment_details['appointment'];
                    $table .= '<tr>
                    <td>'.$appointment_details['first_name'].' '.$appointment_details['last_name'].'</td>
                    <td align="right">'.(int)$appointment_per_month.'</td>';
                    $total_appointment = $current_month * $appointment_per_month;
                    $total_appointment_count = 0;
                    for($i=1;$i<=$current_month;$i++){
                        $SQL = "SELECT COUNT(*) as appointment_count FROM `view_appointment_details` WHERE user_id=".$appointment_details['user_id'].' AND (year(call_back_or_actual_date)='.$currentyear.' AND month(call_back_or_actual_date)='.$i.') GROUP BY user_id';
                        $arr_appointment_details = Yii::app()->db->createCommand($SQL)->queryAll();
                        $appointment_count = (int) $arr_appointment_details[0]['appointment_count'];
                        if($appointment_per_month < $appointment_count){
                            $table .= '<td style="color:green" align="right">'.$appointment_count.'</td>';
                        }
                        else{
                            $table .= '<td style="color:red" align="right">'.$appointment_count.'</td>';
                        }
                        $total_appointment_count+= $arr_appointment_details[0]['appointment_count'];
                    }
                    $varience = $total_appointment_count - $total_appointment;
                    
                    $varience_percent = 0;
                    if($total_appointment > 0)
                    $varience_percent  = round((($varience/$total_appointment)*100),2);
                    
                    $varience_percent = number_format($varience_percent,"2");
                    
                    $table .= '<td  align="right">'.$total_appointment_count.'</td>
                    <td align="right">'.(int) $total_appointment.'</td>
                    <td align="right">'.(int) $varience.'</td>';
                    if($varience < 0){
                        $table .= '<td style="background-color:red;color:white;" align="right">'.$varience_percent.'%</td>';
                    }
                    else{
                        $table .= '<td style="background-color:green;color:white;" align="right">'.$varience_percent.'%</td>';
                    }
                $table .= '</tr>';
                }
                
        }
         $table .= '</tbody>';
        $jsonData['appointments'] =$table;
        echo CJSON::encode($jsonData);
    }
    public function actionGetQuarterlyPolicyTargetDetails(){
         $total_quarter=4;
        
      
         //Start-Current Month
         $array_month = array(1 => 'Jan', 2 => 'Feb', 3 => 'Mar', 4 => 'Apr', 5 => 'May', 6 => 'Jun', 7 => 'Jul', 8 => 'Aug', 9 => 'Sep', 10 => 'Oct', 11 => 'Nov', 12 => 'Dec');
        if(isset($_POST['year'])){
            $currentyear = (int) $_POST['year'];
        }
        else{
            $currentyear = (int) date('Y');
        }
        
        if($currentyear==(int) date('Y')){
            $current_month = date('n');
         }
         else{
             $current_month = 12;
         }
         
         $table .= '<thead>
                         <tr>
                            <th>&nbsp;</th>
                            <th>Target/Month</th>
                            <th>Quarter1</th>
                            <th>Quarter2</th>
                            <th>Quarter3</th>
                            <th>Quarter4</th>
                            <th>Total</th>
                            <th>Target Total</th>
                            <th>Varience</th>
                            <th>Varience(%)</th>
                        </tr>
                    </thead>
                    <tbody>';                       
        $condition = 'user_group_id=2';
        if(Yii::app()->user->authorised_user!=1){
            $condition.=' AND id='.Yii::app()->user->id;
        }
          $arr_managers = User::model()->findAll(array('condition'=>$condition));
        foreach($arr_managers as $managers){
            
            $SQL = "SELECT * FROM `view_policy_target` WHERE manager_id=".$managers->id.' AND user_id<>'.$managers->id.' AND designation_id!=0 GROUP BY user_id';
            $arr_target_details = Yii::app()->db->createCommand($SQL)->queryAll();
            
             $table .= '<tr>
                    <td><b>'.$managers->first_name.' '.$managers->last_name.'<b></td>';
                    for($i=1;$i<=$total_quarter;$i++){
                    $table .= '<td>&nbsp;</td>';
                    }
                    $table .= '<td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                </tr>';
                foreach($arr_target_details as $target_details){
                    $target_per_month = $target_details['target_per_month'];
                    $quarter_target = $target_details['target_per_month'] * 3;
                    $table .= '<tr>
                    <td>'.$target_details['first_name'].' '.$target_details['last_name'].'</td>
                    <td align="right">'.(int)$target_per_month.'</td>';
                    $total_target = $current_month * $target_per_month;
                    $total_annualized_premium = 0;
                    
                     
                    for($i=1;$i<=$total_quarter;$i++){
                        if($i==1){
                             $str_quarter ="1,2,3";
                        }
                        elseif($i==2){
                             $str_quarter ="4,5,6";
                        }
                        elseif($i==3){
                             $str_quarter ="7,8,9";
                        }
                        elseif($i==4){
                             $str_quarter ="10,11,12";
                        }
                       
                        
                        $SQL = "SELECT SUM(annualized_premium) as annualized_premium FROM `view_policy_target` WHERE user_id=".$target_details['user_id'].' AND (year(start_date)='.$currentyear.' AND month(start_date) IN ('.$str_quarter.')) GROUP BY user_id';
                        $arr_premium_details = Yii::app()->db->createCommand($SQL)->queryAll();
                        $annualized_premium = (int) $arr_premium_details[0]['annualized_premium'];
                        $table .= '<td>'.$annualized_premium.'</td>';
                        $total_annualized_premium+= $arr_premium_details[0]['annualized_premium'];
                    }
                    $varience = $total_annualized_premium - $total_target;
                    
                    $varience_percent = 0;
                    if($total_target > 0)
                    $varience_percent  = round((($varience/$total_target)*100),2);
                    
                    $varience_percent = number_format($varience_percent,"2");
                    $table .= '<td  align="right">'.$total_annualized_premium.'</td>
                    <td align="right">'.(int) $total_target.'</td>
                    <td align="right">'.(int) $varience.'</td>';
                    if($varience < 0){
                        $table .= '<td style="background-color:red;color:white;" align="right">'. $varience_percent.'%</td>';
                    }
                    else{
                        $table .= '<td style="background-color:green;color:white;" align="right">'. $varience_percent.'%</td>';
                    }
                $table .= '</tr>';
                }
                
        }
         $table .= '</tbody>';
        $jsonData['quarterlypolicytarget'] =$table;
        echo CJSON::encode($jsonData);
    }
    
    public function actionGetQuarterlyFactFindDetails(){
         $total_quarter=4;
         //Start-Current Month
         $array_month = array(1 => 'Jan', 2 => 'Feb', 3 => 'Mar', 4 => 'Apr', 5 => 'May', 6 => 'Jun', 7 => 'Jul', 8 => 'Aug', 9 => 'Sep', 10 => 'Oct', 11 => 'Nov', 12 => 'Dec');
        if(isset($_POST['year'])){
            $currentyear = (int) $_POST['year'];
        }
        else{
            $currentyear = (int) date('Y');
        }
         $table .= '<thead>
                         <tr>
                            <th>&nbsp;</th>
                            <th>Target/Month</th>
                            <th>Quarter1</th>
                            <th>Quarter2</th>
                            <th>Quarter3</th>
                            <th>Quarter4</th>
                            <th>Total</th>
                            <th>Target Total</th>
                            <th>Varience</th>
                            <th>Varience(%)</th>
                        </tr>
                    </thead>
                    <tbody>';                       
        
        
         if($currentyear==(int) date('Y')){
            $current_month = date('n');
         }
         else{
             $current_month = 12;
         }
         
          $condition = 'user_group_id=2';
        if(Yii::app()->user->authorised_user!=1){
            $condition.=' AND id='.Yii::app()->user->id;
        }
         $arr_managers = User::model()->findAll(array('condition'=>$condition));
        foreach($arr_managers as $managers){
            
            $SQL = "SELECT * FROM `view_fact_find_details` WHERE manager_id=".$managers->id.' AND user_id<>'.$managers->id.' AND designation_id!=0 GROUP BY user_id';
            $arr_fact_find_details = Yii::app()->db->createCommand($SQL)->queryAll();
            
             $table .= '<tr>
                    <td><b>'.$managers->first_name.' '.$managers->last_name.'<b></td>';
                    for($i=1;$i<=$total_quarter;$i++){
                    $table .= '<td>&nbsp;</td>';
                    }
                    $table .= '<td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                </tr>';
                foreach($arr_fact_find_details as $fact_find_details){
                    $find_fact_per_month = $fact_find_details['find_fact'];
                    $table .= '<tr>
                    <td>'.$fact_find_details['first_name'].' '.$fact_find_details['last_name'].'</td>
                    <td  align="right">'.(int)$find_fact_per_month.'</td>';
                    $total_find_fact = $current_month * $find_fact_per_month;
                    $total_find_fact_count = 0;
                    
                    
                    for($i=1;$i<=$total_quarter;$i++){
                        if($i==1){
                             $str_quarter ="1,2,3";
                        }
                        elseif($i==2){
                             $str_quarter ="4,5,6";
                        }
                        elseif($i==3){
                             $str_quarter ="7,8,9";
                        }
                        elseif($i==4){
                             $str_quarter ="10,11,12";
                        }
                        $SQL = "SELECT COUNT(*) as find_fact_count FROM `view_fact_find_details` WHERE user_id=".$fact_find_details['user_id'].' AND fact_find_status=2 AND (year(call_back_or_actual_date)='.$currentyear.' AND month(call_back_or_actual_date) IN('.$str_quarter.')) GROUP BY user_id';
                        $arr_find_fact_details = Yii::app()->db->createCommand($SQL)->queryAll();
                        $find_fact_count = (int) $arr_find_fact_details[0]['find_fact_count'];
                        $table .= '<td>'.$find_fact_count.'</td>';
                        $total_find_fact_count+= $arr_find_fact_details[0]['find_fact_count'];
                    }
                    $varience = $total_find_fact_count - $total_find_fact;
                    
                    $varience_percent = 0;
                    if($total_find_fact > 0)
                    $varience_percent = number_format($varience/$total_find_fact,"2");
                    
                    $table .= '<td  align="right">'.$total_find_fact_count.'</td>
                    <td align="right">'.(int) $total_find_fact.'</td>
                    <td align="right">'.(int) $varience.'</td>';
                    if($varience < 0){
                        $table .= '<td style="background-color:red;color:white;" align="right">'.$varience_percent.'%</td>';
                    }
                    else{
                        $table .= '<td style="background-color:green;color:white;" align="right">'.$varience_percent.'%</td>';
                    }
                $table .= '</tr>';
                }
                
        }
         $table .= '</tbody>';
        $jsonData['quarterlyfactfind'] =$table;
        echo CJSON::encode($jsonData);
    }
    
    public function actionGetQuarterlyAppointmentDetails(){
        
        
         //Start-Current Month
         $array_month = array(1 => 'Jan', 2 => 'Feb', 3 => 'Mar', 4 => 'Apr', 5 => 'May', 6 => 'Jun', 7 => 'Jul', 8 => 'Aug', 9 => 'Sep', 10 => 'Oct', 11 => 'Nov', 12 => 'Dec');
        if(isset($_POST['year'])){
            $currentyear = (int) $_POST['year'];
        }
        else{
            $currentyear = (int) date('Y');
        }
         $total_quarter=4;
          $table .= '<thead>
                         <tr>
                            <th>&nbsp;</th>
                            <th>Target/Month</th>
                            <th>Quarter1</th>
                            <th>Quarter2</th>
                            <th>Quarter3</th>
                            <th>Quarter4</th>
                            <th>Total</th>
                            <th>Target Total</th>
                            <th>Varience</th>
                            <th>Varience(%)</th>
                        </tr>
                    </thead>
                    <tbody>';    
                    
                     if($currentyear==(int) date('Y')){
            $current_month = date('n');
         }
         else{
             $current_month = 12;
         }
          $condition = 'user_group_id=2';
        if(Yii::app()->user->authorised_user!=1){
            $condition.=' AND id='.Yii::app()->user->id;
        }
         $arr_managers = User::model()->findAll(array('condition'=>$condition));
        foreach($arr_managers as $managers){
            
            $SQL = "SELECT * FROM `view_appointment_details` WHERE manager_id=".$managers->id.' AND user_id<>'.$managers->id.' AND designation_id!=0 GROUP BY user_id';
            $arr_appointment_details = Yii::app()->db->createCommand($SQL)->queryAll();
            
             $table .= '<tr>
                    <td><b>'.$managers->first_name.' '.$managers->last_name.'<b></td>';
                    for($i=1;$i<=$total_quarter;$i++){
                    $table .= '<td>&nbsp;</td>';
                    }
                    $table .= '<td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                </tr>';
                foreach($arr_appointment_details as $appointment_details){
                    $appointment_per_month = $appointment_details['appointment'];
                    $table .= '<tr>
                    <td>'.$appointment_details['first_name'].' '.$appointment_details['last_name'].'</td>
                    <td  align="right">'.(int)$appointment_per_month.'</td>';
                    $total_appointment = $current_month * $appointment_per_month;
                    $total_appointment_count = 0;
                    
                    for($i=1;$i<=$total_quarter;$i++){
                         if($i==1){
                             $str_quarter ="1,2,3";
                        }
                        elseif($i==2){
                             $str_quarter ="4,5,6";
                        }
                        elseif($i==3){
                             $str_quarter ="7,8,9";
                        }
                        elseif($i==4){
                             $str_quarter ="10,11,12";
                        }
                        $SQL = "SELECT COUNT(*) as appointment_count FROM `view_appointment_details` WHERE user_id=".$appointment_details['user_id'].' AND (year(call_back_or_actual_date)='.$currentyear.' AND month(call_back_or_actual_date) IN('.$str_quarter.')) GROUP BY user_id';
                        $arr_appointment_details = Yii::app()->db->createCommand($SQL)->queryAll();
                        $appointment_count = (int) $arr_appointment_details[0]['appointment_count'];
                        if($appointment_per_month < $appointment_count){
                            $table .= '<td style="color:red" align="right">'.$appointment_count.'</td>';
                        }
                        else{
                            $table .= '<td style="color:green" align="right">'.$appointment_count.'</td>';
                        }
                        $total_appointment_count+= $arr_appointment_details[0]['appointment_count'];
                    }
                    $varience = $total_appointment_count - $total_appointment;
                    
                    $varience_percent = 0;
                    if($total_appointment > 0)
                    $varience_percent  = round((($varience/$total_appointment)*100),2);
                    
                    $varience_percent = number_format($varience_percent,"2");
                    $table .= '<td  align="right">'.$total_appointment_count.'</td>
                    <td align="right">'.(int) $total_appointment.'</td>
                    <td align="right">'.(int) $varience.'</td>';
                    if($varience < 0){
                        $table .= '<td style="background-color:red;color:white;" align="right">'.$varience_percent.'%</td>';
                    }
                    else{
                        $table .= '<td style="background-color:green;color:white;" align="right">'.$varience_percent.'%</td>';
                    }
                $table .= '</tr>';
                }
                
        }
         $table .= '</tbody>';
        $jsonData['quarterlyappointments'] =$table;
        echo CJSON::encode($jsonData);
    }
    
    public function actionSendBirthdayMailToCustomer(){
            $customer_id = $_POST['cust_id'];
            $model = Customer::model()->findByPk($customer_id);
            $customer_name = $model->cust_first_name;
            if(!empty($model->cust_middle_name)){
                $customer_name.=" ".$model->cust_middle_name;
            }
             if(!empty($model->cust_last_name)){
                $customer_name.=" ".$model->cust_last_name;
            }
            $email = $model->cust_email1;
            $mailContent = array();
            $mailContent['title'] = 'Happy Birthday';
            $mailContent['model'] = $model;
            $message = new YiiMailMessage;
            $message->view = 'birthday';
            $message->setBody(array('mailContent' => $mailContent,'customer_name'=>$customer_name), 'text/html');
            
            $message->subject = 'Happy Birthday';
            $message->from = "info@blueskyerp.me";
            //$message->addto($email);
            //$message->addto("arunjv@gmail.com");

            $message->addto("mereenavinod83@gmail.com");
            if(Yii::app()->mail->send($message)){
                $jsonData['status'] ="success";
            }
            else{
                
                $jsonData['status'] ="failed";
            }
            
            
            echo CJSON::encode($jsonData);
            Yii::app()->end();
    }
    
    public function actionSendChequeMailToCustomer(){
            $customer_id = $_POST['cust_id'];
            $model = Customer::model()->findByPk($customer_id);
            $customer_name = $model->cust_first_name;
            if(!empty($model->cust_middle_name)){
                $customer_name.=" ".$model->cust_middle_name;
            }
             if(!empty($model->cust_last_name)){
                $customer_name.=" ".$model->cust_last_name;
            }

            $email = $model->cust_email1;
            $mailContent = array();
            $mailContent['title'] = 'Policy Reminder';
            $mailContent['model'] = $model;
            $message = new YiiMailMessage;
            $message->view = 'cheque';
            $message->setBody(array('mailContent' => $mailContent,'customer_name'=>$customer_name), 'text/html');
            $message->subject = 'Policy Reminder';
            $message->from = "info@blueskyerp.me";
            //$message->addto($email);
            //$message->addto("arunjv@gmail.com");
            $message->addto("mereenavinod83@gmail.com");
            if(Yii::app()->mail->send($message)){
                $jsonData['status'] ="success";
            }
            else{
                
                $jsonData['status'] ="failed";
            }
            
            
            echo CJSON::encode($jsonData);
            Yii::app()->end();
    }
}
