<?php
class CommissionupdateController extends Controller {

    /**
     * Declares class-based actions.
     */
    public function accessRules() {

        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('UpdateCommisionamount'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    /**
     * This is the default 'index' action that is invoked
     * when an action is not explicitly requested by users.
     */
   
    //Changing Calculated-Start
    public function actionUpdateCommisionamount() {
        print_r($_POST); die();
        $commission_uploaded=$_POST['arraycid'];
        foreach ($commission_uploaded as $value) {
            $status=$this->addtoCommissionLedger($value);
            if($status==1){
                CommissionUploaded::model()->updateByPK($value, array('commission_calculated'=>'Y'));
            }
        }
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
    }
    //Changing Calculated-End
    //addtoCommissionLedger-start
    public function addtoCommissionLedger($id) {
        $model_commission = new CommissionUploaded();
        if($id>0){
            $model_commission = $model_commission->findByPK($id);
            $cus_plan_id      = $model_commission->customer_plan_id;
            $upload_amount    = $model_commission->commission_amount;
            $upload_date      = $model_commission->commission_date;
            $user_id          = $model_commission->customerdetails->cust_executive_id;
            $icp_months       = $model_commission->customerplan->icp_months;
            $provider_id =$model_commission->provider_id;
            $customer_id=$model_commission->customer_id;
            $mas_plan_id=$model_commission->customerplan->plan_id;
            $upload_type=$model_commission->type;
            $scheme_id        = User::model()->findByPK($user_id)->commission_scheme_id;
            $mas_commission   = MasterCommissionSchemes::model()->findByPK($scheme_id);
            if($upload_amount>0){
                //save provider given whole amount to commision ledger
                $desc='Commission from '.$model_commission->providerdetails->provider_name.' for  Policy No.'.$model_commission->policy_no;
                $this->savetoCommissionLedger($id, User::getCompany(),$model_commission->customer_plan_id,$upload_date,100,
                                                 $upload_amount,$upload_amount,0,'PRO_ISSUE',$desc,'IN','GEN',$provider_id,$customer_id,$mas_plan_id,'NA');           
                //save general vat to commision ledger            
                $vat_percent=$model_commission->customerplan->masplandetails->general_vat;
                $vat_amount=$upload_amount*$vat_percent/100;
                $desc='VAT for Policy No.'.$model_commission->policy_no.' ('.$vat_percent.' % of '.$upload_amount.')';
                $this->savetoCommissionLedger($id,User::getCompany(),$model_commission->customer_plan_id,$upload_date,$vat_percent,
                                                $upload_amount,0,$vat_amount,'VAT_OUT',$desc,'OUT','GEN',$provider_id,$customer_id,$mas_plan_id,'NA');
                //save amount deducting vat to commision ledger            
                $net_amount=$upload_amount-$vat_amount;
                $this->savetoCommissionLedger($id,User::getCompany(),$model_commission->customer_plan_id,$upload_date,$vat_percent,
                                                $upload_amount,$vat_amount,0,'VAT_IN',$desc,'IN','VAT',$provider_id,$customer_id,$mas_plan_id,'NA');
                //update totals to user company
                $model_comp= User::model()->findbyPK(User::getCompany());
                $account_balance=$model_comp->account_total_amount+$upload_amount-$vat_amount;
                $account_vat=$model_comp->account_vat_amount+$vat_amount;
                User::model()->updateByPK(User::getCompany(), array('account_total_amount' =>$account_balance,'account_vat_amount' =>$account_vat,'updated_by'=>Yii::app()->user->id,'updated_date_time'=>date('Y-m-d H:i:s')));
                //save commision amount of executive to commision ledger 
                    $exec_defer_com_amount=0;
                    if($icp_months<12 || $upload_type!='NB'){//if not a deferment plan add full commission to excecutive account
                        //executive commission
                        $exec_com = $mas_commission->executive_commission_without_deferment;
                        $exec_com_amount=$net_amount*$exec_com/100;
                        $desc='Executive Commission for Policy No.'.$model_commission->policy_no.' ('.$exec_com.' % of '.$net_amount.')';
                        $this->savetoCommissionLedger($id,User::getCompany(),$model_commission->customer_plan_id,$upload_date,$exec_com,
                                                    $net_amount,0,$exec_com_amount,'EXE_COM',$desc,'OUT','GEN',$provider_id,$customer_id,$mas_plan_id,'NA');
                        
                        $this->savetoCommissionLedger($id,$user_id,$model_commission->customer_plan_id,$upload_date,$exec_com,
                                                    $net_amount,$exec_com_amount,0,'EXE_COM',$desc,'IN','GEN',$provider_id,$customer_id,$mas_plan_id,'NA');
                 
                    }else{
                        //executive commission
                        $exec_com = $mas_commission->executive_commission_with_deferment;
                        $exec_com_amount=$net_amount*$exec_com/100;
                        $desc='Executive Commission for Policy No.'.$model_commission->policy_no.' ('.$exec_com.' % of '.$net_amount.')';
                        $this->savetoCommissionLedger($id,User::getCompany(),$model_commission->customer_plan_id,$upload_date,$exec_com,
                                                    $net_amount,0,$exec_com_amount,'EXE_COM',$desc,'OUT','GEN',$provider_id,$customer_id,$mas_plan_id,'NA');
                        $this->savetoCommissionLedger($id,$user_id,$model_commission->customer_plan_id,$upload_date,$exec_com,
                                                    $net_amount,$exec_com_amount,0,'EXE_COM',$desc,'IN','GEN',$provider_id,$customer_id,$mas_plan_id,'NA');
                        //deferment commission
                        $exec_defer_com = $mas_commission->excecutive_deferment_commission;
                        $exec_defer_com_amount=$net_amount*$exec_defer_com/100;
                        $desc='Executive Deferment Commission for Policy No.'.$model_commission->policy_no.' ('.$exec_defer_com.' % of '.$net_amount.')';
                        $this->savetoCommissionLedger($id,User::getCompany(),$model_commission->customer_plan_id,$upload_date,$exec_defer_com,
                                                    $net_amount,0,$exec_defer_com_amount,'EXE_DEF_COM',$desc,'OUT','GEN',$provider_id,$customer_id,$mas_plan_id,'NA');
                        $this->savetoCommissionLedger($id,$user_id,$model_commission->customer_plan_id,$upload_date,$exec_defer_com,
                                                    $net_amount,$exec_defer_com_amount,0,'EXE_DEF_COM',$desc,'IN','DEF',$provider_id,$customer_id,$mas_plan_id,'HOLD');
                    }
                    //update totals to executive
                        $model_exe= User::model()->findbyPK($user_id);
                        $account_balance=$model_exe->account_total_amount+$exec_com_amount;
                        $account_defer=$model_exe->account_deferement_amount+$exec_defer_com_amount;
                        User::model()->updateByPK($user_id, array('account_total_amount' =>$account_balance,'account_deferement_amount' =>$account_defer,'updated_by'=>Yii::app()->user->id,'updated_date_time'=>date('Y-m-d H:i:s')));

                    //update totals to user company
                        $model_comp= User::model()->findbyPK(User::getCompany());
                        $account_balance=$model_comp->account_total_amount-$exec_com_amount-$exec_defer_com_amount;;
                        $account_defer=$model_comp->account_deferement_amount+$exec_defer_com_amount;
                        User::model()->updateByPK(User::getCompany(), array('account_total_amount' =>$account_balance,'account_deferement_amount' =>$account_defer,'updated_by'=>Yii::app()->user->id,'updated_date_time'=>date('Y-m-d H:i:s')));

                    //executive total commission including deferment amount
                    $total_exe_comm_amount =$exec_com_amount+$exec_defer_com_amount;
                    /*added to another table start*/
                    //Quarterly commision- 3% of commision of executive commission
                    if($upload_type=='NB'){
                        $exec_quar_com = $mas_commission->executive_quarter_sale_commission;
                        $exec_quar_com_amount=$total_exe_comm_amount*$exec_quar_com/100;
                        $desc='Executive Quarterly Commission for Policy No.'.$model_commission->policy_no.' ('.$exec_quar_com.' % of '.$total_exe_comm_amount.')';
                        $this->savetoExecutiveHoldCommissionLedger($id,User::getCompany(),$model_commission->customer_plan_id,$upload_date,$exec_quar_com,
                                                    $total_exe_comm_amount,0,$exec_quar_com_amount,'EXE_QUA_COM',$desc,'OUT','GEN',$provider_id,$customer_id,$mas_plan_id,'NA',$user_id);
                        $this->savetoExecutiveHoldCommissionLedger($id,$user_id,$model_commission->customer_plan_id,$upload_date,$exec_quar_com,
                                                    $total_exe_comm_amount,$exec_quar_com_amount,0,'EXE_QUA_COM',$desc,'IN','QUA',$provider_id,$customer_id,$mas_plan_id,'HOLD',$user_id);
                        //annual commission- 3% of commision of executive commission
                        $exec_ann_com = $mas_commission->executive_annual_sale_commission;
                        $exec_ann_com_amount=$total_exe_comm_amount*$exec_ann_com/100;
                        $desc='Executive Annual Commission for Policy No.'.$model_commission->policy_no.' ('.$exec_ann_com.' % of '.$total_exe_comm_amount.')';
                        $this->savetoExecutiveHoldCommissionLedger($id,User::getCompany(),$model_commission->customer_plan_id,$upload_date,$exec_ann_com,
                                                    $total_exe_comm_amount,0,$exec_ann_com_amount,'EXE_ANN_COM',$desc,'OUT','GEN',$provider_id,$customer_id,$mas_plan_id,'NA',$user_id);
                        $this->savetoExecutiveHoldCommissionLedger($id,$user_id,$model_commission->customer_plan_id,$upload_date,$exec_ann_com,
                                                    $total_exe_comm_amount,$exec_ann_com_amount,0,'EXE_ANN_COM',$desc,'IN','ANN',$provider_id,$customer_id,$mas_plan_id,'HOLD',$user_id);
                    }
                    /* added to another table end*/
                    //save commision amount of managers to commision ledger 
                    $assistant_manger =$model_commission->customerdetails->executive->assistant_manager_id;
                    $manager =$model_commission->customerdetails->executive->manager_id;
                    if($manager=='0'){
                        $manager = $user_id;
                    }
                    $ass_manager_quarter_amount=$ass_manager_annual_amount=0;                        
                    $manager_quarter_amount=$manager_annual_amount=0;
                    if($assistant_manger >0){
                        $ass_manager_com = $mas_commission->assistant_manager_commission;
                        $ass_manager_amount=$total_exe_comm_amount*$ass_manager_com/100;
                        $desc='Executive Assistant Manager Commission for Policy No.'.$model_commission->policy_no.' ('.$ass_manager_com.' % of '.$total_exe_comm_amount.')';
                        $this->savetoCommissionLedger($id,User::getCompany(),$model_commission->customer_plan_id,$upload_date,$ass_manager_com,
                                                $total_exe_comm_amount,0,$ass_manager_amount,'ASS_MAN_COM',$desc,'OUT','GEN',$provider_id,$customer_id,$mas_plan_id,'NA');
                        $this->savetoCommissionLedger($id,$assistant_manger,$model_commission->customer_plan_id,$upload_date,$ass_manager_com,
                                                $total_exe_comm_amount,$ass_manager_amount,0,'ASS_MAN_COM',$desc,'IN','GEN',$provider_id,$customer_id,$mas_plan_id,'NA');
                        /*added to another table start*/
                        if($upload_type=='NB'){
                            //Quarterly commision- 3% of commision of assistant manager commission-- start
                            $ass_manager_qua_com = $mas_commission->ass_manager_quarter_sale_commission;
                            $ass_manager_quarter_amount=$ass_manager_amount*$ass_manager_qua_com/100;
                            $desc='Assistant Manager Quarterly Commission for Policy No.'.$model_commission->policy_no.' ('.$ass_manager_qua_com.' % of '.$ass_manager_amount.')';
                            $this->savetoExecutiveHoldCommissionLedger($id,User::getCompany(),$model_commission->customer_plan_id,$upload_date,$ass_manager_qua_com,
                                                        $ass_manager_amount,0,$ass_manager_quarter_amount,'ASS_MAN_QUA_COM',$desc,'OUT','GEN',$provider_id,$customer_id,$mas_plan_id,'NA',$user_id);
                            $this->savetoExecutiveHoldCommissionLedger($id,$assistant_manger,$model_commission->customer_plan_id,$upload_date,$ass_manager_qua_com,
                                                        $ass_manager_amount,$ass_manager_quarter_amount,0,'ASS_MAN_QUA_COM',$desc,'IN','QUA',$provider_id,$customer_id,$mas_plan_id,'HOLD',$user_id);
                            //Quarterly commision- 3% of commision of assistant manager commission-- end
                            //annual commision- 3% of commision of assistant manager commission-- start
                            $ass_manager_ann_com = $mas_commission->ass_manager_annual_sale_commission;
                            $ass_manager_annual_amount=$ass_manager_amount*$ass_manager_ann_com/100;
                            $desc='Assistant Manager Annual Commission for Policy No.'.$model_commission->policy_no.' ('.$ass_manager_ann_com.' % of '.$ass_manager_amount.')';
                            $this->savetoExecutiveHoldCommissionLedger($id,User::getCompany(),$model_commission->customer_plan_id,$upload_date,$ass_manager_ann_com,
                                                        $ass_manager_amount,0,$ass_manager_annual_amount,'ASS_MAN_ANN_COM',$desc,'OUT','GEN',$provider_id,$customer_id,$mas_plan_id,'NA',$user_id);
                            $this->savetoExecutiveHoldCommissionLedger($id,$assistant_manger,$model_commission->customer_plan_id,$upload_date,$ass_manager_ann_com,
                                                        $ass_manager_amount,$ass_manager_annual_amount,0,'ASS_MAN_ANN_COM',$desc,'IN','ANN',$provider_id,$customer_id,$mas_plan_id,'HOLD',$user_id);
                            //annual commision- 3% of commision of assistant manager commission-- end
                            
                        }
                        /* added to another table end*/
                        $manager_com = $mas_commission->manager_with_assitant_commission;
                        $manager_amount=$total_exe_comm_amount*$manager_com/100;
                        $desc='Executive Manager Commission for Policy No.'.$model_commission->policy_no.' ('.$manager_com.' % of '.$total_exe_comm_amount.')';
                        $this->savetoCommissionLedger($id,User::getCompany(),$model_commission->customer_plan_id,$upload_date,$manager_com,
                                                $total_exe_comm_amount,0,$manager_amount,'MAN_COM',$desc,'OUT','GEN',$provider_id,$customer_id,$mas_plan_id,'NA');
                        $this->savetoCommissionLedger($id,$manager,$model_commission->customer_plan_id,$upload_date,$manager_com,
                                                $total_exe_comm_amount,$manager_amount,0,'MAN_COM',$desc,'IN','GEN',$provider_id,$customer_id,$mas_plan_id,'NA');
                        /*added to another table start*/
                        if($upload_type=='NB'){
                            //Quarterly commision- 3% of commision of manager commission-- start
                            $manager_qua_com = $mas_commission->manager_quarter_sale_commission;
                            $manager_quarter_amount=$manager_amount*$manager_qua_com/100;
                            $desc='Manager Quarterly Commission for Policy No.'.$model_commission->policy_no.' ('.$manager_qua_com.' % of '.$manager_amount.')';
                            $this->savetoExecutiveHoldCommissionLedger($id,User::getCompany(),$model_commission->customer_plan_id,$upload_date,$manager_qua_com,
                                                        $manager_amount,0,$manager_quarter_amount,'MAN_QUA_COM',$desc,'OUT','GEN',$provider_id,$customer_id,$mas_plan_id,'NA',$user_id);
                            $this->savetoExecutiveHoldCommissionLedger($id,$manager,$model_commission->customer_plan_id,$upload_date,$manager_qua_com,
                                                        $manager_amount,$manager_quarter_amount,0,'MAN_QUA_COM',$desc,'IN','QUA',$provider_id,$customer_id,$mas_plan_id,'HOLD',$user_id);
                            //Quarterly commision- 3% of commision of manager commission-- end
                            //annual commision- 3% of commision of manager commission-- start
                            $manager_ann_com = $mas_commission->manager_annual_sale_commission;
                            $manager_annual_amount=$manager_amount*$manager_ann_com/100;
                            $desc='Manager Annual Commission for Policy No.'.$model_commission->policy_no.' ('.$manager_ann_com.' % of '.$manager_amount.')';
                            $this->savetoExecutiveHoldCommissionLedger($id,User::getCompany(),$model_commission->customer_plan_id,$upload_date,$manager_ann_com,
                                                        $manager_amount,0,$manager_annual_amount,'MAN_ANN_COM',$desc,'OUT','GEN',$provider_id,$customer_id,$mas_plan_id,'NA',$user_id);
                            $this->savetoExecutiveHoldCommissionLedger($id,$manager,$model_commission->customer_plan_id,$upload_date,$manager_ann_com,
                                                        $manager_amount,$manager_annual_amount,0,'MAN_ANN_COM',$desc,'IN','ANN',$provider_id,$customer_id,$mas_plan_id,'HOLD',$user_id);
                            //annual commision- 3% of commision of manager commission-- end
                            
                        }
                        /* added to another table end*/
                        //update totals to assistant manager
                        $model_am= User::model()->findbyPK($assistant_manger);
                        $account_balance=$model_am->account_total_amount+$ass_manager_amount;
                        User::model()->updateByPK($assistant_manger, array('account_total_amount' =>$account_balance,'updated_by'=>Yii::app()->user->id,'updated_date_time'=>date('Y-m-d H:i:s')));
                        
                        //update totals to manager
                        $model_mr= User::model()->findbyPK($manager);
                        $account_balance=$model_mr->account_total_amount+$manager_amount;
                        User::model()->updateByPK($manager, array('account_total_amount' =>$account_balance,'updated_by'=>Yii::app()->user->id,'updated_date_time'=>date('Y-m-d H:i:s')));
                        //update totals to user company
                        $model_comp= User::model()->findbyPK(User::getCompany());
                        $account_balance=$model_comp->account_total_amount-$manager_amount-$ass_manager_amount;
                        User::model()->updateByPK(User::getCompany(), array('account_total_amount' =>$account_balance,'updated_by'=>Yii::app()->user->id,'updated_date_time'=>date('Y-m-d H:i:s')));

                    }else{
                        $manager_com = $mas_commission->manager_total_commision;
                        $manager_amount=$total_exe_comm_amount*$manager_com/100;
                        $desc='Executive Manager Commission for Policy No.'.$model_commission->policy_no.' ('.$manager_com.' % of '.$total_exe_comm_amount.')';
                        $this->savetoCommissionLedger($id,User::getCompany(),$model_commission->customer_plan_id,$upload_date,$manager_com,
                                                $total_exe_comm_amount,0,$manager_amount,'MAN_COM',$desc,'OUT','GEN',$provider_id,$customer_id,$mas_plan_id,'NA');
                        $this->savetoCommissionLedger($id,$manager,$model_commission->customer_plan_id,$upload_date,$manager_com,
                                                $total_exe_comm_amount,$manager_amount,0,'MAN_COM',$desc,'IN','GEN',$provider_id,$customer_id,$mas_plan_id,'NA');
                        /*added to another table start*/
                        if($upload_type=='NB'){
                            //Quarterly commision- 3% of commision of manager commission-- start
                            $manager_qua_com = $mas_commission->manager_quarter_sale_commission;
                            $manager_quarter_amount=$manager_amount*$manager_qua_com/100;
                            $desc='Manager Quarterly Commission for Policy No.'.$model_commission->policy_no.' ('.$manager_qua_com.' % of '.$manager_amount.')';
                            $this->savetoExecutiveHoldCommissionLedger($id,User::getCompany(),$model_commission->customer_plan_id,$upload_date,$manager_qua_com,
                                                        $manager_amount,0,$manager_quarter_amount,'MAN_QUA_COM',$desc,'OUT','GEN',$provider_id,$customer_id,$mas_plan_id,'NA',$user_id);
                            $this->savetoExecutiveHoldCommissionLedger($id,$manager,$model_commission->customer_plan_id,$upload_date,$manager_qua_com,
                                                        $manager_amount,$manager_quarter_amount,0,'MAN_QUA_COM',$desc,'IN','QUA',$provider_id,$customer_id,$mas_plan_id,'HOLD',$user_id);
                            //Quarterly commision- 3% of commision of manager commission-- end
                            //annual commision- 3% of commision of manager commission-- start
                            $manager_ann_com = $mas_commission->manager_annual_sale_commission;
                            $manager_annual_amount=$manager_amount*$manager_ann_com/100;
                            $desc='Manager Annual Commission for Policy No.'.$model_commission->policy_no.' ('.$manager_ann_com.' % of '.$manager_amount.')';
                            $this->savetoExecutiveHoldCommissionLedger($id,User::getCompany(),$model_commission->customer_plan_id,$upload_date,$manager_ann_com,
                                                        $manager_amount,0,$manager_annual_amount,'MAN_ANN_COM',$desc,'OUT','GEN',$provider_id,$customer_id,$mas_plan_id,'NA',$user_id);
                            $this->savetoExecutiveHoldCommissionLedger($id,$manager,$model_commission->customer_plan_id,$upload_date,$manager_ann_com,
                                                        $manager_amount,$manager_annual_amount,0,'MAN_ANN_COM',$desc,'IN','ANN',$provider_id,$customer_id,$mas_plan_id,'HOLD',$user_id);
                            //annual commision- 3% of commision of manager commission-- end
                            
                        }
                        /* added to another table end*/
                        //update totals to manager
                        $model_mr= User::model()->findbyPK($manager);
                        $account_balance=$model_mr->account_total_amount+$manager_amount;
                        User::model()->updateByPK($manager, array('account_total_amount' =>$account_balance,'updated_by'=>Yii::app()->user->id,'updated_date_time'=>date('Y-m-d H:i:s')));
                        //update totals to user company
                        $model_comp= User::model()->findbyPK(User::getCompany());
                        $account_balance=$model_comp->account_total_amount-$manager_amount;
                        User::model()->updateByPK(User::getCompany(), array('account_total_amount' =>$account_balance,'updated_by'=>Yii::app()->user->id,'updated_date_time'=>date('Y-m-d H:i:s')));

                    }
                    
                
            }else{
                $upload_amount=-$upload_amount;
                //save provider given whole amount to commision ledger
                $desc='Commission Return to '.$model_commission->providerdetails->provider_name.' for  Policy No.'.$model_commission->policy_no;
                $this->savetoCommissionLedger($id, User::getCompany(),$model_commission->customer_plan_id,$upload_date,100,
                                                 $upload_amount,0,$upload_amount,'PRO_RETURN',$desc,'OUT','GEN',$provider_id,$customer_id,$mas_plan_id,'NA');           
                $vat_percent=$model_commission->customerplan->masplandetails->general_vat;
                $vat_amount=$upload_amount*$vat_percent/100;
                $desc='VAT Return for Policy No.'.$model_commission->policy_no.' ('.$vat_percent.' % of '.$upload_amount.')';
                //save general vat to commision ledger            
                $this->savetoCommissionLedger($id,User::getCompany(),$model_commission->customer_plan_id,$upload_date,$vat_percent,
                                                $upload_amount,$vat_amount,0,'VAT_IN',$desc,'IN','GEN',$provider_id,$customer_id,$mas_plan_id,'NA');
                //save amount deducting vat to commision ledger            
                $net_amount=$upload_amount-$vat_amount;
                $this->savetoCommissionLedger($id,User::getCompany(),$model_commission->customer_plan_id,$upload_date,$vat_percent,
                                                $upload_amount,0,$vat_amount,'VAT_OUT',$desc,'OUT','VAT',$provider_id,$customer_id,$mas_plan_id,'NA');
                //update totals to user company
                $model_comp= User::model()->findbyPK(User::getCompany());
                $account_balance=$model_comp->account_total_amount-$upload_amount+$vat_amount;
                $account_vat=$model_comp->account_vat_amount-$vat_amount;
                User::model()->updateByPK(User::getCompany(), array('account_total_amount' =>$account_balance,'account_vat_amount' =>$account_vat,'updated_by'=>Yii::app()->user->id,'updated_date_time'=>date('Y-m-d H:i:s')));
                //save commision amount return of executive to commision ledger 
                    $exec_defer_com_amount=0;
                    if($icp_months<12 || $upload_type!='NB'){//if not a deferment plan add full commission to excecutive account
                        //executive commission
                        $exec_com = $mas_commission->executive_commission_without_deferment;
                        $exec_com_amount=$net_amount*$exec_com/100;
                        $desc='Executive Commission Return for Policy No.'.$model_commission->policy_no.' ('.$exec_com.' % of '.$net_amount.')';
                        $this->savetoCommissionLedger($id,User::getCompany(),$model_commission->customer_plan_id,$upload_date,$exec_com,
                                                    $net_amount,$exec_com_amount,0,'EXE_COM_RET',$desc,'IN','GEN',$provider_id,$customer_id,$mas_plan_id,'NA');
                        
                        $this->savetoCommissionLedger($id,$user_id,$model_commission->customer_plan_id,$upload_date,$exec_com,
                                                    $net_amount,0,$exec_com_amount,'EXE_COM_RET',$desc,'OUT','GEN',$provider_id,$customer_id,$mas_plan_id,'NA');
                 
                    }else{
                        //executive commission
                        $exec_com = $mas_commission->executive_commission_with_deferment;
                        $exec_com_amount=$net_amount*$exec_com/100;
                        $desc='Executive Commission Return for Policy No.'.$model_commission->policy_no.' ('.$exec_com.' % of '.$net_amount.')';
                        $this->savetoCommissionLedger($id,$user_id,$model_commission->customer_plan_id,$upload_date,$exec_com,
                                                    $net_amount,0,$exec_com_amount,'EXE_COM_RET',$desc,'OUT','GEN',$provider_id,$customer_id,$mas_plan_id,'NA');
                        $this->savetoCommissionLedger($id,User::getCompany(),$model_commission->customer_plan_id,$upload_date,$exec_com,
                                                    $net_amount,$exec_com_amount,0,'EXE_COM_RET',$desc,'IN','GEN',$provider_id,$customer_id,$mas_plan_id,'NA');
                        //deferment commission
                        $exec_defer_com = $mas_commission->excecutive_deferment_commission;
                        $exec_defer_com_amount=$net_amount*$exec_defer_com/100;
                        $desc='Executive Deferment Commission Return for Policy No.'.$model_commission->policy_no.' ('.$exec_defer_com.' % of '.$net_amount.')';
                        $this->savetoCommissionLedger($id,User::getCompany(),$model_commission->customer_plan_id,$upload_date,$exec_defer_com,
                                                    $net_amount,$exec_defer_com_amount,0,'EXE_DEF_COM_RET',$desc,'IN','GEN',$provider_id,$customer_id,$mas_plan_id,'NA');
                        $this->savetoCommissionLedger($id,$user_id,$model_commission->customer_plan_id,$upload_date,$exec_defer_com,
                                                    $net_amount,0,$exec_defer_com_amount,'EXE_DEF_COM_RET',$desc,'OUT','DEF',$provider_id,$customer_id,$mas_plan_id,'HOLD');
                    }
                    //update totals to executive
                        $model_exe= User::model()->findbyPK($user_id);
                        $account_balance=$model_exe->account_total_amount-$exec_com_amount;
                        $account_defer=$model_exe->account_deferement_amount-$exec_defer_com_amount;
                        User::model()->updateByPK($user_id, array('account_total_amount' =>$account_balance,'account_deferement_amount' =>$account_defer,'updated_by'=>Yii::app()->user->id,'updated_date_time'=>date('Y-m-d H:i:s')));

                    //update totals to user company
                        $model_comp= User::model()->findbyPK(User::getCompany());
                        $account_balance=$model_comp->account_total_amount+$exec_com_amount+$exec_defer_com_amount;;
                        $account_defer=$model_comp->account_deferement_amount-$exec_defer_com_amount;
                        User::model()->updateByPK(User::getCompany(), array('account_total_amount' =>$account_balance,'account_deferement_amount' =>$account_defer,'updated_by'=>Yii::app()->user->id,'updated_date_time'=>date('Y-m-d H:i:s')));
                    //executive total commission including deferment amount
                    $total_exe_comm_amount =$exec_com_amount+$exec_defer_com_amount;
                    /*added to another table start*/
                    //Quarterly commision- 3% of commision of executive commission
                    
                    if($upload_type=='NB'){
                        $exec_quar_com = $mas_commission->executive_quarter_sale_commission;
                        $exec_quar_com_amount=$total_exe_comm_amount*$exec_quar_com/100;
                        $desc='Executive Quarterly Commission Return for Policy No.'.$model_commission->policy_no.' ('.$exec_quar_com.' % of '.$total_exe_comm_amount.')';
                        $this->savetoExecutiveHoldCommissionLedger($id,User::getCompany(),$model_commission->customer_plan_id,$upload_date,$exec_quar_com,
                                                    $total_exe_comm_amount,$exec_quar_com_amount,0,'EXE_QUA_COM_RET',$desc,'IN','GEN',$provider_id,$customer_id,$mas_plan_id,'NA',$user_id);
                        $this->savetoExecutiveHoldCommissionLedger($id,$user_id,$model_commission->customer_plan_id,$upload_date,$exec_quar_com,
                                                    $total_exe_comm_amount,0,$exec_quar_com_amount,'EXE_QUA_COM_RET',$desc,'OUT','QUA',$provider_id,$customer_id,$mas_plan_id,'HOLD',$user_id);
                        //annual commission- 3% of commision of executive commission
                        $exec_ann_com = $mas_commission->executive_annual_sale_commission;
                        $exec_ann_com_amount=$total_exe_comm_amount*$exec_ann_com/100;
                        $desc='Executive Annual Commission Return for Policy No.'.$model_commission->policy_no.' ('.$exec_ann_com.' % of '.$total_exe_comm_amount.')';
                        $this->savetoExecutiveHoldCommissionLedger($id,User::getCompany(),$model_commission->customer_plan_id,$upload_date,$exec_ann_com,
                                                    $total_exe_comm_amount,$exec_ann_com_amount,0,'EXE_ANN_COM_RET',$desc,'IN','GEN',$provider_id,$customer_id,$mas_plan_id,'NA',$user_id);
                        $this->savetoExecutiveHoldCommissionLedger($id,$user_id,$model_commission->customer_plan_id,$upload_date,$exec_ann_com,
                                                    $total_exe_comm_amount,0,$exec_ann_com_amount,'EXE_ANN_COM_RET',$desc,'OUT','ANN',$provider_id,$customer_id,$mas_plan_id,'HOLD',$user_id);
                    }
                    /* added to another table end*/
                    //save commision amount of managers to commision ledger 
                    $assistant_manger =$model_commission->customerdetails->executive->assistant_manager_id;
                    $manager =$model_commission->customerdetails->executive->manager_id;
                    if($manager=='0'){
                        $manager = $user_id;
                    }
                    if($assistant_manger >0){
                        $ass_manager_com = $mas_commission->assistant_manager_commission;
                        $ass_manager_amount=$total_exe_comm_amount*$ass_manager_com/100;
                       
                        $desc='Executive Assistant Manager Commission Return for Policy No.'.$model_commission->policy_no.' ('.$ass_manager_com.' % of '.$total_exe_comm_amount.')';
                        $this->savetoCommissionLedger($id,User::getCompany(),$model_commission->customer_plan_id,$upload_date,$ass_manager_com,
                                                $total_exe_comm_amount,$ass_manager_amount,0,'ASS_MAN_COM_RET',$desc,'IN','GEN',$provider_id,$customer_id,$mas_plan_id,'NA');
                        $this->savetoCommissionLedger($id,$assistant_manger,$model_commission->customer_plan_id,$upload_date,$ass_manager_com,
                                                $total_exe_comm_amount,0,$ass_manager_amount,'ASS_MAN_COM_RET',$desc,'OUT','GEN',$provider_id,$customer_id,$mas_plan_id,'NA');
                        /*added to another table start*/
                        if($upload_type=='NB'){
                            //Quarterly commision- 3% of commision of assistant manager commission-- start
                            $ass_manager_qua_com = $mas_commission->ass_manager_quarter_sale_commission;
                            $ass_manager_quarter_amount=$ass_manager_amount*$ass_manager_qua_com/100;
                            $desc='Assistant Manager Quarterly Commission Return for Policy No.'.$model_commission->policy_no.' ('.$ass_manager_qua_com.' % of '.$ass_manager_amount.')';
                            $this->savetoExecutiveHoldCommissionLedger($id,User::getCompany(),$model_commission->customer_plan_id,$upload_date,$ass_manager_qua_com,
                                                        $ass_manager_amount,$ass_manager_quarter_amount,0,'ASS_MAN_QUA_COM_RET',$desc,'IN','GEN',$provider_id,$customer_id,$mas_plan_id,'NA',$user_id);
                            $this->savetoExecutiveHoldCommissionLedger($id,$assistant_manger,$model_commission->customer_plan_id,$upload_date,$ass_manager_qua_com,
                                                        $ass_manager_amount,0,$ass_manager_quarter_amount,'ASS_MAN_QUA_COM_RET',$desc,'OUT','QUA',$provider_id,$customer_id,$mas_plan_id,'HOLD',$user_id);
                            //Quarterly commision- 3% of commision of assistant manager commission-- end
                            //annual commision- 3% of commision of assistant manager commission-- start
                            $ass_manager_ann_com = $mas_commission->ass_manager_annual_sale_commission;
                            $ass_manager_annual_amount=$ass_manager_amount*$ass_manager_ann_com/100;
                            $desc='Assistant Manager Annual Commission Return for Policy No.'.$model_commission->policy_no.' ('.$ass_manager_ann_com.' % of '.$ass_manager_amount.')';
                            $this->savetoExecutiveHoldCommissionLedger($id,User::getCompany(),$model_commission->customer_plan_id,$upload_date,$ass_manager_ann_com,
                                                        $ass_manager_amount,$ass_manager_annual_amount,0,'ASS_MAN_ANN_COM_RET',$desc,'IN','GEN',$provider_id,$customer_id,$mas_plan_id,'NA',$user_id);
                            $this->savetoExecutiveHoldCommissionLedger($id,$assistant_manger,$model_commission->customer_plan_id,$upload_date,$ass_manager_ann_com,
                                                        $ass_manager_amount,0,$ass_manager_annual_amount,'ASS_MAN_ANN_COM_RET',$desc,'OUT','ANN',$provider_id,$customer_id,$mas_plan_id,'HOLD',$user_id);
                            //annual commision- 3% of commision of assistant manager commission-- end
                            
                        }
                        /* added to another table end*/
                        $manager_com = $mas_commission->manager_with_assitant_commission;
                        $manager_amount=$total_exe_comm_amount*$manager_com/100;
                        $desc='Executive Manager Commission Return for Policy No.'.$model_commission->policy_no.' ('.$manager_com.' % of '.$total_exe_comm_amount.')';
                        $this->savetoCommissionLedger($id,User::getCompany(),$model_commission->customer_plan_id,$upload_date,$manager_com,
                                                $total_exe_comm_amount,$manager_amount,0,'MAN_COM_RET',$desc,'IN','GEN',$provider_id,$customer_id,$mas_plan_id,'NA');
                        $this->savetoCommissionLedger($id,$manager,$model_commission->customer_plan_id,$upload_date,$manager_com,
                                                $total_exe_comm_amount,0,$manager_amount,'MAN_COM_RET',$desc,'OUT','GEN',$provider_id,$customer_id,$mas_plan_id,'NA');
                        /*added to another table start*/
                        if($upload_type=='NB'){
                            //Quarterly commision- 3% of commision of manager commission-- start
                            $manager_qua_com = $mas_commission->manager_quarter_sale_commission;
                            $manager_quarter_amount=$manager_amount*$manager_qua_com/100;
                            $desc='Manager Quarterly Commission Return for Policy No.'.$model_commission->policy_no.' ('.$manager_qua_com.' % of '.$manager_amount.')';
                            $this->savetoExecutiveHoldCommissionLedger($id,User::getCompany(),$model_commission->customer_plan_id,$upload_date,$manager_qua_com,
                                                        $manager_amount,$manager_quarter_amount,0,'MAN_QUA_COM_RET',$desc,'IN','GEN',$provider_id,$customer_id,$mas_plan_id,'NA',$user_id);
                            $this->savetoExecutiveHoldCommissionLedger($id,$manager,$model_commission->customer_plan_id,$upload_date,$manager_qua_com,
                                                        $manager_amount,0,$manager_quarter_amount,'MAN_QUA_COM_RET',$desc,'OUT','QUA',$provider_id,$customer_id,$mas_plan_id,'HOLD',$user_id);
                            //Quarterly commision- 3% of commision of manager commission-- end
                            //annual commision- 3% of commision of manager commission-- start
                            $manager_ann_com = $mas_commission->manager_annual_sale_commission;
                            $manager_annual_amount=$manager_amount*$manager_ann_com/100;
                            $desc='Manager Annual Commission Return for Policy No.'.$model_commission->policy_no.' ('.$manager_ann_com.' % of '.$manager_amount.')';
                            $this->savetoExecutiveHoldCommissionLedger($id,User::getCompany(),$model_commission->customer_plan_id,$upload_date,$manager_ann_com,
                                                        $manager_amount,$manager_annual_amount,0,'MAN_ANN_COM_RET',$desc,'IN','GEN',$provider_id,$customer_id,$mas_plan_id,'NA',$user_id);
                            $this->savetoExecutiveHoldCommissionLedger($id,$manager,$model_commission->customer_plan_id,$upload_date,$manager_ann_com,
                                                        $manager_amount,0,$manager_annual_amount,'MAN_ANN_COM_RET',$desc,'OUT','ANN',$provider_id,$customer_id,$mas_plan_id,'HOLD',$user_id);
                            //annual commision- 3% of commision of manager commission-- end
                            
                        }
                        /* added to another table end*/
                        //update totals to assistant manager
                        $model_am= User::model()->findbyPK($assistant_manger);
                        $account_balance=$model_am->account_total_amount-$ass_manager_amount;
                        User::model()->updateByPK($assistant_manger, array('account_total_amount' =>$account_balance,'updated_by'=>Yii::app()->user->id,'updated_date_time'=>date('Y-m-d H:i:s')));
                        
                        //update totals to manager
                        $model_mr= User::model()->findbyPK($manager);
                        $account_balance=$model_mr->account_total_amount-$manager_amount;
                        User::model()->updateByPK($manager, array('account_total_amount' =>$account_balance,'updated_by'=>Yii::app()->user->id,'updated_date_time'=>date('Y-m-d H:i:s')));
                        //update totals to user company
                        $model_comp= User::model()->findbyPK(User::getCompany());
                        $account_balance=$model_comp->account_total_amount+$manager_amount+$ass_manager_amount;
                        User::model()->updateByPK(User::getCompany(), array('account_total_amount' =>$account_balance,'updated_by'=>Yii::app()->user->id,'updated_date_time'=>date('Y-m-d H:i:s')));

                    }else{
                        $manager_com = $mas_commission->manager_total_commision;
                        $manager_amount=$total_exe_comm_amount*$manager_com/100;
                        $desc='Executive Manager Commission Return for Policy No.'.$model_commission->policy_no.' ('.$manager_com.' % of '.$total_exe_comm_amount.')';
                        $this->savetoCommissionLedger($id,User::getCompany(),$model_commission->customer_plan_id,$upload_date,$manager_com,
                                                $total_exe_comm_amount,$manager_amount,0,'MAN_COM_RET',$desc,'IN','GEN',$provider_id,$customer_id,$mas_plan_id,'NA');
                        $this->savetoCommissionLedger($id,$manager,$model_commission->customer_plan_id,$upload_date,$manager_com,
                                                $total_exe_comm_amount,0,$manager_amount,'MAN_COM_RET',$desc,'OUT','GEN',$provider_id,$customer_id,$mas_plan_id,'NA');
                        /*added to another table start*/
                        if($upload_type=='NB'){
                            //Quarterly commision- 3% of commision of manager commission-- start
                            $manager_qua_com = $mas_commission->manager_quarter_sale_commission;
                            $manager_quarter_amount=$manager_amount*$manager_qua_com/100;
                            $desc='Manager Quarterly Commission Return for Policy No.'.$model_commission->policy_no.' ('.$manager_qua_com.' % of '.$manager_amount.')';
                            $this->savetoExecutiveHoldCommissionLedger($id,User::getCompany(),$model_commission->customer_plan_id,$upload_date,$manager_qua_com,
                                                        $manager_amount,$manager_quarter_amount,0,'MAN_QUA_COM_RET',$desc,'IN','GEN',$provider_id,$customer_id,$mas_plan_id,'NA',$user_id);
                            $this->savetoExecutiveHoldCommissionLedger($id,$manager,$model_commission->customer_plan_id,$upload_date,$manager_qua_com,
                                                        $manager_amount,0,$manager_quarter_amount,'MAN_QUA_COM_RET',$desc,'OUT','QUA',$provider_id,$customer_id,$mas_plan_id,'HOLD',$user_id);
                            //Quarterly commision- 3% of commision of manager commission-- end
                            //annual commision- 3% of commision of manager commission-- start
                            $manager_ann_com = $mas_commission->manager_annual_sale_commission;
                            $manager_annual_amount=$manager_amount*$manager_ann_com/100;
                            $desc='Manager Annual Commission Return for Policy No.'.$model_commission->policy_no.' ('.$manager_ann_com.' % of '.$manager_amount.')';
                            $this->savetoExecutiveHoldCommissionLedger($id,User::getCompany(),$model_commission->customer_plan_id,$upload_date,$manager_ann_com,
                                                        $manager_amount,$manager_annual_amount,0,'MAN_ANN_COM_RET',$desc,'IN','GEN',$provider_id,$customer_id,$mas_plan_id,'NA',$user_id);
                            $this->savetoExecutiveHoldCommissionLedger($id,$manager,$model_commission->customer_plan_id,$upload_date,$manager_ann_com,
                                                        $manager_amount,0,$manager_annual_amount,'MAN_ANN_COM_RET',$desc,'OUT','ANN',$provider_id,$customer_id,$mas_plan_id,'HOLD',$user_id);
                            //annual commision- 3% of commision of manager commission-- end
                            
                        }
                        /* added to another table end*/
                        //update totals to manager
                        $model_mr= User::model()->findbyPK($manager);
                        $account_balance=$model_mr->account_total_amount-$manager_amount;
                        User::model()->updateByPK($manager, array('account_total_amount' =>$account_balance,'updated_by'=>Yii::app()->user->id,'updated_date_time'=>date('Y-m-d H:i:s')));
                        //update totals to user company
                        $model_comp= User::model()->findbyPK(User::getCompany());
                        $account_balance=$model_comp->account_total_amount+$manager_amount;
                        User::model()->updateByPK(User::getCompany(), array('account_total_amount' =>$account_balance,'updated_by'=>Yii::app()->user->id,'updated_date_time'=>date('Y-m-d H:i:s')));

                    }
            }
        }
            
        return true;
                
    }    
    //addtoCommissionLedger-end
    ////savetoCommissionLedger-start
    public function savetoCommissionLedger($id,$user_id,$cus_plan_id,$transaction_date,$percentage,
                                            $total_amount,$in_amount,$out_amount,$type,$desc,$in_or_out,
                                            $user_account,$provider_id,$customer_id,$mas_plan_id,$status) {
        $model_ledger = new CommissionLedger();
        $model_ledger->commision_upload_id=$id;
        $model_ledger->user_id=$user_id;
        $model_ledger->cus_plan_id=$cus_plan_id;
        $model_ledger->transaction_date=$transaction_date;
        $model_ledger->posted_date=date('Y-m-d');
        $model_ledger->percentage=$percentage;
        $model_ledger->total_amount=$total_amount;
        $model_ledger->in_or_out=$in_or_out;
        $model_ledger->in_amount=$in_amount;
        $model_ledger->out_amount=$out_amount;
        $model_ledger->type=$type;
        $model_ledger->description=$desc;
        $model_ledger->user_account=$user_account;
        $model_ledger->provider_id=$provider_id;
        $model_ledger->customer_id=$customer_id;
        $model_ledger->mas_plan_id=$mas_plan_id;
        $model_ledger->status=$status;        
        $model_ledger->created_by  =Yii::app()->user->id; 
        $model_ledger->created_date_time=date('Y-m-d H:i:s');
        $model_ledger->save(false);     
        return true;
    }    
    //savetoCommissionLedger-end
    ////savetoCommissionLedger-start
    public function savetoExecutiveHoldCommissionLedger($id,$user_id,$cus_plan_id,$transaction_date,$percentage,
                                            $total_amount,$in_amount,$out_amount,$type,$desc,$in_or_out,
                                            $user_account,$provider_id,$customer_id,$mas_plan_id,$status,$executive_id=0) {
        $model_ledger = new ExecutiveHoldCommission();
        $model_ledger->commision_upload_id=$id;
        $model_ledger->user_id=$user_id;
        $model_ledger->cus_plan_id=$cus_plan_id;
        $model_ledger->transaction_date=$transaction_date;
        $model_ledger->posted_date=date('Y-m-d');
        $model_ledger->percentage=$percentage;
        $model_ledger->total_amount=$total_amount;
        $model_ledger->in_or_out=$in_or_out;
        $model_ledger->in_amount=$in_amount;
        $model_ledger->out_amount=$out_amount;
        $model_ledger->type=$type;
        $model_ledger->description=$desc;
        $model_ledger->user_account=$user_account;
        $model_ledger->provider_id=$provider_id;
        $model_ledger->customer_id=$customer_id;
        $model_ledger->mas_plan_id=$mas_plan_id;
        $model_ledger->executive_id=$executive_id;
        $model_ledger->status=$status;        
        $model_ledger->created_by  =Yii::app()->user->id; 
        $model_ledger->created_date_time=date('Y-m-d H:i:s');
        $model_ledger->save(false);     
        return true;
    }    
    //savetoCommissionLedger-end   
}
