<?php

class UserController extends Controller {

    public function init() {
        parent::init();
        $this->initAjaxCsrfToken();
    }

    // this function will work to post csrf token.
    protected function initAjaxCsrfToken() {

        Yii::app()->clientScript->registerScript('AjaxCsrfToken', ' $.ajaxSetup({
                         data: {"' . Yii::app()->request->csrfToken . '": "' . Yii::app()->request->csrfToken . '"},
                         cache:false
                    });', CClientScript::POS_HEAD);
    }


    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Create', 'GetList', 'SaveUsers', 'DeleteUsers','ConnectedUsers','SaveConnectedUsers','Upload','CreateBalance','SaveAccountBalance'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex() {
        $_GET  = filter_input_array(INPUT_GET, FILTER_SANITIZE_STRING);
        if(count($_GET) > 0){
            $this->render('index');
        }else{
            $this->renderPartial('../index_error');
        }
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionGetList() {
        $_POST = filter_input_array(INPUT_POST, FILTER_SANITIZE_STRING);
        if (count($_POST) > 0) {
        $model = new User();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'username',
            1 => 'first_name',
            2 => 'designation',
            3 => 'user_group_id',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.isActive="Y" ';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " and (username LIKE '%" . $searchString . "%' OR first_name LIKE '%" . $searchString . "%' OR designation_details.designation LIKE '%" . $searchString . "%' OR user_group_id LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('designation_details')->count(array('condition' => $condition));
        $model = $model->with('designation_details')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 'username'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;

        foreach ($model as $row) {
            $div = '';
            $div .= ' <button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'user/create&id=' . $row['id'] . '\',\'Users\',\'xl\')"><i class="fa fa-pencil"></i></button>';
            if(((int) Yii::app()->user->havePermissionOn["admin_users_addconnected_users"])){
                $div .= ' <button class="btn btn-primary btn-xs" title="Connected Users" onclick="loadPopupModal(\'user/ConnectedUsers&id=' . $row['id'] . '\',\' Connected Users\',\'lg\')"><i class="fa fa-users"></i></button>';
            }
            $rowData[] = array($m,
                $row['username'],
                $row['first_name'] . " " . $row['last_name'],
                $row['designation_details']['designation'],
                $row->userGroup->group_name,
                '<div class="btn-wrap text-center">' . $div . '</div>');

            $m++;
        }

        $data['data'] = $rowData;
        echo json_encode($data);
    } else{
        $this->renderPartial('../index_error');
         
     }    
    }

    public function actionCreate() {
        $model = new User();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('users_form', array('model' => $model), false, false);
    }
    public function actionCreateBalance() {
        $model = new User();
        $model = $model->findAll();
        
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('users_balance_form', array('model' => $model), false, false);
    }
    public function actionSaveUsers() {
        $_POST  = filter_input_array(INPUT_POST, FILTER_SANITIZE_STRING);
        if(isset($_POST) && count($_POST) > 0){
        $model = new User();
        if (isset($_POST['User'])) {
            $old_password='';
            $scenario ='';
            if ((int) @$_POST['User']['id'] > 0) {
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d h:i:s');
                $id = (int) @$_POST['User']['id'];
                $model = $model->findByPk($id);
                $old_password=$model->password;
                $scenario = 'update';
            } else {
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d h:i:s');
                $model->scenario = 'add';
                $scenario = 'add';
                $model->password_last_updated=date('Y-m-d');
            }
            $model->attributes = $_POST['User'];
            $model->profile_photo = $_POST['User']['profile_photo'];
            $model->level = '1';
            $model->company_id = Yii::app()->user->master_user_company_id;
            $manager_self = $_POST['User']['manager_self'];
            $asst_manager_self = $_POST['User']['asstmanager_self'];        
            if (isset($_POST['User']['password']) && $_POST['User']['password'] != '') {
                //START Code modified on 08-04-2016 for secured password
                $salt = '$2a$10$1qAz2wSx3eDc4rFv5tGb5t';
                $model->password = crypt($_POST['User']['password'], $salt);
                //END Code modified on 08-04-2016 for secured password
            }
            if ($model->validate()) {
                $model->save();
                $new_password=$model->password;
                if($old_password!=$new_password){
                    User::model()->updateByPK($model->id, array('password_1'=>$model->password,'password_2'=>$model->password_1,'password_3'=>$model->password_2,'password_last_updated'=>date('Y-m-d')));
                }
                if($manager_self==1){
                    User::model()->updateByPK($model->id, array('manager_id'=>$model->id));
                }
                if($asst_manager_self==1){
                    User::model()->updateByPK($model->id, array('assistant_manager_id'=>$model->id));
                }
                
                $jsonData['status'] = 'success';
                $jsonData['frm'] = $_POST['users_form'];
                $jsonData['id'] = $model->id;
                $jsonData['scenario'] =$scenario;
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    else{
        $this->renderPartial('../index_error');
    }  
    }

    public function actionDeleteUsers() {
        $id = $_POST['id'];
        $model = new User();
        $model->deleteByPk($id);
        echo "success";
    }
    
    public function actionConnectedUsers() {
        $model = new User();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
            $model->connected_users= explode(',', $model->connected_users);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('connected_users', array('model' => $model), false, false);
    }
    public function actionSaveConnectedUsers() {
        $model = new User();
        $id = (int) @$_POST['User']['id'];
        $connected_users = implode(',', $_POST['User']['connected_users']);
        $model->updateByPk($id, array('connected_users' =>$connected_users));
        $jsonData['status'] = 'success';
        $jsonData['frm'] = $connected_users;
        $jsonData['id'] = $id;
        echo CJSON::encode($jsonData);

    }
    public function actionSaveAccountBalance() {
        $_POST  = filter_input_array(INPUT_POST, FILTER_SANITIZE_STRING);
        if(isset($_POST) && count($_POST) > 0){
        if ((isset($_POST['User']))) {
            $validate = true;
            date_default_timezone_set("Asia/Dubai");
            foreach ($_POST['User'] as $i => $items) {
                    $model_user[$n] = new User();
                    if ($items['id'] > 0) {
                        $model_user[$i] = $model_user[$n]->findByPK($items['id']);
                        $model_user[$i]->account_total_amount =$items['account_total_amount'];
                        $model_user[$i]->account_deferement_amount =$items['account_deferement_amount'];
                        $validate = $model_user[$i]->validate() && $validate;
                    }
            }
            if (!empty($model_user)) {
                if ($validate) {
                    if (!empty($model_user)) {
                        foreach ($model_user as $eachModel) {
                            $eachModel->save();
                        }
                    }                    
                    $jsonData['status'] = 'success';
                    echo CJSON::encode($jsonData);
                } else {
                    $error1 = json_decode(CActiveForm::validateTabular($model_user, '', false), true);
                    $error = CJSON::encode($error1);
                    if ($error != '[]')
                        echo $error;
                }
            }else {
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            }
        }
    }
    else{
        $this->renderPartial('../index_error');
    }  
    }

}

?>
