<?php

class TargetController extends Controller {


    public function init() {
        parent::init();
        $this->initAjaxCsrfToken();
    }

    // this function will work to post csrf token.
    protected function initAjaxCsrfToken() {

        Yii::app()->clientScript->registerScript('AjaxCsrfToken', ' $.ajaxSetup({
                         data: {"' . Yii::app()->request->csrfToken . '": "' . Yii::app()->request->csrfToken . '"},
                         cache:false
                    });', CClientScript::POS_HEAD);
    }

    /**
     * Declares class-based actions.
     */
    public function accessRules() {

        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index','GettargetList','Create','SaveTarget','Edit'
                    ),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    /**
     * This is the default 'index' action that is invoked
     * when an action is not explicitly requested by users.
     */
    public function actionIndex() {
        $_GET  = filter_input_array(INPUT_GET, FILTER_SANITIZE_STRING);
        if(count($_GET) > 0){
            $this->render('index');
        }else{
            $this->renderPartial('../index_error');
        }
    }
    public function actionGettargetList() {
         $_POST = filter_input_array(INPUT_POST, FILTER_SANITIZE_STRING);
        if (count($_POST) > 0) {
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $executive_id = $_POST['executive_id'];
        $executive_year = $_POST['executive_year'];
        $model = new UserTarget();
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'userdetails.first_name',
            2 => 'userdetails.designation',
            3 => 'target_id',
            4 => 'start_date',
            5 => 'end_date',
            6 => 'target_amount',
            7 => '',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        //$orderBy = $filterColumn . " " . $filterOrder;

        $orderBy = 'userdetails.first_name ASC';
        /******** First Loading Without Search********/
        $condition = "t.isActive='Y'";
        if($executive_id>0){
            $condition.= ' AND t.user_id="'.$executive_id.'"';
        } 
        if($executive_year>0){
            $condition.= '  AND t.target_year="'.$executive_year.'"';
        } 
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " AND (CONCAT(userdetails.first_name,'',userdetails.last_name) LIKE '%" . $searchString . "%' OR CONCAT(userdetails.first_name,' ',userdetails.last_name) LIKE '%" . $searchString . "%' OR userdetails.first_name LIKE '%" . $searchString . "%' OR userdetails.last_name LIKE '%" . $searchString . "%')";
        }             
        $count = $model->with('userdetails')->count(array('condition' => $condition));
        $model = $model->with('userdetails')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m=1;
        foreach ($model as $row) {
            $div='';
            $type='';
            if($row->target_id==1){
                $type='Quarter 1';
            }else if($row->target_id==2){
                $type='Quarter 2';
            }else if($row->target_id==3){
                $type='Quarter 3';
            }else if($row->target_id==4){
                $type='Quarter 4';
            }else if($row->target_id==5){
                $type='Annual';
            }
            $start_date='';
            $end_date='';
            if($row['start_date']!='' && $row['start_date']!='0000-00-00'){
                $start_date=date("d/m/Y",strtotime($row['start_date']));
            }
            if($row['end_date']!='' && $row['end_date']!='0000-00-00'){
                $end_date=date("d/m/Y",strtotime($row['end_date']));
            }
            if($row['calculated']=='N'){
                $div .= ' <button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'target/edit&id=' . $row['id'] . '\',\'Edit Target\',\'lg\')"><i class="fa fa-pencil"></i></button>';
            }
            $rowData[] = array($m, $row->userdetails->fullname,$row->userdetails->designation_details->designation,$type,$row->target_amount,$row->target_year, '<div class="btn-wrap text-center">' . $div . '</div>');
            $m++;
        }

        $data['data'] = $rowData;
        echo json_encode($data);
        }else{
             $this->renderPartial('../index_error');
        }
    }
    public function actionCreate() {
        $model = array(new UserTarget());
        $model_target = new UserTarget();
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('create', array('model' => $model,'model_target' => $model_target), false, false);
    }
    public function actionSaveTarget() {   
        $_POST  = filter_input_array(INPUT_POST, FILTER_SANITIZE_STRING);
        if(isset($_POST) && count($_POST) > 0){     
        $validate = true;
        if (isset($_POST['UserTarget'])) {
            foreach ($_POST['UserTarget'] as $i => $items) {
                $modal_target[$i] = new UserTarget();
                if ($items['id'] > 0) {
                    $modal_target[$i] = $modal_target[$i]->findByPK($items['id']);
                    $modal_target[$i]->updated_by = Yii::app()->user->id;
                    $modal_target[$i]->updated_date_time = date('Y-m-d h:i:s');
                }else{
                    $modal_target[$i]->created_by = Yii::app()->user->id;
                    $modal_target[$i]->created_date_time = date('Y-m-d h:i:s');
                }
                $modal_target[$i]->target_id = $items['target_id'];
                $modal_target[$i]->user_id = $_POST['executive_user_id'];
                $modal_target[$i]->target_year = $items['target_year'];
                $modal_target[$i]->target_amount = $items['target_amount'];
                if($items['target_id']==1){
                    $modal_target[$i]->start_date =$items['target_year'].'-01-01';
                    $modal_target[$i]->end_date  =$items['target_year'].'-03-31';
                }else if($items['target_id']==2){
                    $modal_target[$i]->start_date =$items['target_year'].'-04-01';
                    $modal_target[$i]->end_date  =$items['target_year'].'-06-30';
                }else if($items['target_id']==3){
                    $modal_target[$i]->start_date =$items['target_year'].'-07-01';
                    $modal_target[$i]->end_date  =$items['target_year'].'-09-30';
                }else if($items['target_id']==4){
                    $modal_target[$i]->start_date =$items['target_year'].'-10-01';
                    $modal_target[$i]->end_date  =$items['target_year'].'-12-31';
                }else if($items['target_id']==5){
                    $modal_target[$i]->start_date =$items['target_year'].'-01-01';
                    $modal_target[$i]->end_date  =$items['target_year'].'-12-31';
                }
//                if (isset($items['start_date']) && $items['start_date']!= '') {
//                    $items['start_date']= str_replace('/', '-',$items['start_date']);
//                     $modal_target[$i]->start_date = date("Y-m-d", strtotime($items['start_date']));
//                }
//                if (isset($items['end_date']) && $items['end_date']!= '') {
//                    $items['end_date']= str_replace('/', '-',$items['end_date']);
//                     $modal_target[$i]->end_date = date("Y-m-d", strtotime($items['end_date']));
//                }
                $validate= $modal_target[$i]->validate() && $validate;
                
            }
             if ($validate) {
                if (!empty($modal_target)) {
                    foreach ($modal_target as $eachModel) {
                        $eachModel->save();
                    }
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            }else {
                $error_1 = json_decode(CActiveForm::validate($modal_target, '', false), true);
                $error = CJSON::encode(array_merge_recursive($error_1));
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    else{
        $this->renderPartial('../index_error');
    }  
    }
    public function actionEdit() {
        $model = new UserTarget();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('edit', array('model' => $model), false, false);
    }
}
