<?php

class MasproviderplansController extends Controller {
    public function init() {
        parent::init();
        $this->initAjaxCsrfToken();
    }
 
    // this function will work to post csrf token.
    protected function initAjaxCsrfToken() {
 
        Yii::app()->clientScript->registerScript('AjaxCsrfToken', ' $.ajaxSetup({
                         data: {"' . Yii::app()->request->csrfToken . '": "' . Yii::app()->request->csrfToken . '"},
                         cache:false
                    });', CClientScript::POS_HEAD);
    } 
    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Create', 'GetList', 'Save', 'Delete','Geticpvalue'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex() {
        $_GET  = filter_input_array(INPUT_GET, FILTER_SANITIZE_STRING);
        //echo $_GET; exit;
        if(count($_GET) > 0){
            $this->render('index');
        }else{
            $this->renderPartial('../index_error');
        }
    }


    public function actionGetList() {
        $_POST = filter_input_array(INPUT_POST, FILTER_SANITIZE_STRING);
        if (count($_POST) > 0) { 
        $model = new MasProviderPlans();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'plan_name',
            1 => 'plan_name',
            2 => 'plan_name',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.isActive="Y"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition.=" and (plan_name LIKE '%" . $searchString . "%' OR provider.provider_name LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('provider')->count(array('condition' => $condition));
        $model = $model->with('provider')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            if (!empty($row['marital_logo'])) {
                $marital_logo = $row['marital_logo'];
            } else {
                $marital_logo = "no_marital_status_logo.png";
            }
            $div = '<div class="btn-wrap text-center"><button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'Masproviderplans/create&id=' . $row['id'] . '\',\'Edit\',\'lg\')"><i class="fa fa-pencil"></i></button>';
            $rowData[] = array($m, $row['plan_name'], $row['provider']['provider_name'], '<div class="btn-wrap text-center">' . $div . '</div>');

            $m++;
        }



        $data['data'] = $rowData;
        echo json_encode($data);
    }else{
        $this->renderPartial('../index_error');
    }
    }

    public function actionCreate() {
        $model = new MasProviderPlans();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('masproviderplans_form', array('model' => $model), false, false);
    }

    public function actionSave() {
        $_POST  = filter_input_array(INPUT_POST, FILTER_SANITIZE_STRING);
        if(isset($_POST) && count($_POST) > 0){
        $model = new MasProviderPlans();
        if (isset($_POST['MasProviderPlans'])) {           
            if ((int) @$_POST['MasProviderPlans']['id'] > 0) {
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d h:i:s');
                $id = (int) @$_POST['MasProviderPlans']['id'];
                $model = $model->findByPk($id);
            }else{
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d h:i:s');
            }
            $model->attributes = $_POST['MasProviderPlans'];
            $model->plan_name = strtoupper($_POST['MasProviderPlans']['plan_name']);
            $model->general_vat = $_POST['MasProviderPlans']['general_vat'];
            if ($model->save()) {
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
        else{
            $this->renderPartial('../index_error');
       } 
    }
    }

    public function actionDelete() {

        $id = $_POST['id'];

        $model = new MasProviderPlans();
        $model->deleteByPk($id);
        echo "success";
    }
    public function actionGeticpvalue() {
        $plan_id            = $_POST['plan_id'];
        $model_provider  = MasProviderPlans::model()->findbyPK($plan_id);
        $jsonData['icpvalue'] = $model_provider->icp_months;
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
    }


}
