<?php

class MashealthstatusController extends Controller
{

    public function init() {
        parent::init();
        $this->initAjaxCsrfToken();
    }

    // this function will work to post csrf token.
    protected function initAjaxCsrfToken() {

        Yii::app()->clientScript->registerScript('AjaxCsrfToken', ' $.ajaxSetup({
                         data: {"' . Yii::app()->request->csrfToken . '": "' . Yii::app()->request->csrfToken . '"},
                         cache:false
                    });', CClientScript::POS_HEAD);
    }
    
    public function accessRules() {
            return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                  'actions' => array('login', 'error', 'logout'),
                  'users' => array('*'),
                  ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                  'actions' => array('Index','Create','GetList','SaveHealth','DeleteHealth','DirectAdd','UploadDropDownImage'),
                  'expression' => '$user->isMember()',
                  ),
                array('deny', // deny all users
                  'users' => array('*'),
                  ),
                );
        }
	public function actionIndex()
	{
        $_GET  = filter_input_array(INPUT_GET, FILTER_SANITIZE_STRING);
        if(count($_GET) > 0){
            $this->render('index');
        }else{
            $this->renderPartial('../index_error');
        }
	}
          public function actionGetList()
        {
                $_POST = filter_input_array(INPUT_POST, FILTER_SANITIZE_STRING);
                 if (count($_POST) > 0) {
                $model=new MasHealthStatus();
                $draw    = $_POST['draw'];
                $offset = $_POST['start'];
                $limit  = $_POST['length'];
                $columns = array(
                // datatable column index  => database column name
                   0 =>'health_status'
                   
                   );
                $filterColumn = $columns[$_POST['order'][0]['column']];
                $filterOrder  = $_POST['order'][0]['dir'];
                $orderBy   = $filterColumn." ".$filterOrder;
                $condition = 't.isActive="Y"';
                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
                {
                  $searchString = $_POST['search']['value'];
                  $condition.=" and (health_status LIKE '%".$searchString."%')";
                }
                $count = $model->count(array('condition'=>$condition));
                $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));
                $recordsTotal = $count;
                $recordsFiltered = $count;
                $data['draw'] = $draw;
                $data['recordsTotal'] = $recordsTotal;
                $data['recordsFiltered'] = $recordsFiltered;
                $rowData=array();
                $m = 1;
                foreach ($model as $row)
                {
                    if(!empty($row['health_logo'])){
                        $health_logo =$row['health_logo'];
                    }
                    else{
                        $health_logo = "no_health_logo.png";
                    }
                     
                    $div=   '<div class="btn-wrap text-center"><button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'mashealthstatus/create&id='.$row['id'].'\',\'Edit Health Status\',\'lg\')"><i class="fa fa-pencil"></i></button>';
                    $rowData[]=array($m,$row['health_status'],CHtml::image(Yii::app()->baseUrl."/uploads/health/".$health_logo),'<div class="btn-wrap text-center">'.$div.'</div>');
                
                    $m++;
                    
                }
                
                
                
//                
//                foreach ($model as $row)
//                {
//                    $rowData[]=array($m,$row['country_name'],$row['country_code'],
//              '<div class="btn-wrap text-center"><button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'country/create&id='.$row['id'].'\',\'Edit Currency\',\'lg\')"><i class="fa fa-pencil"></i></button> '
//             .'<a href ="#" class="btn btn-danger btn-xs" onclick="deleteCountry('.$row['id'].')"><i class="fa fa-trash-o "></i></a></div>');
//                    $m++;
//                }
                $data['data'] = $rowData;
                echo json_encode($data);
            } else{
                $this->renderPartial('../index_error');
                 
             }    
        }
         public function actionCreate()
        {
            $model=new MasHealthStatus();
            $id = (int) Yii::app()->request->getParam('id');
            if($id>0){
                $model=$model->findByPk($id);
            }
                Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('health_form', array('model' => $model), false, false);
        }
  
  
        public function actionSaveHealth()
        {
            $_POST  = filter_input_array(INPUT_POST, FILTER_SANITIZE_STRING);
            if(isset($_POST) && count($_POST) > 0){
            $model = new MasHealthStatus();
            if (isset($_POST['MasHealthStatus']))
            {
    		$model->created_by = Yii::app()->user->id;
                $model->created_date_time =date('Y-m-d h:i:s');
    		if ((int) @$_POST['MasHealthStatus']['id'] > 0)
                {   $model->updated_by = Yii::app()->user->id;
                    $model->updated_date_time =date('Y-m-d h:i:s');
                    $id= (int) @$_POST['MasHealthStatus']['id'];
                    $model=$model->findByPk($id);  
                }
                $model->attributes=$_POST['MasHealthStatus'];
                if ($model->save())
                {
                        $jsonData['status'] = 'success';
                        $jsonData['frm'] = $_POST['country_form'];
                        $jsonData['id'] = $model->id;
	                echo CJSON::encode($jsonData);
                }
                else
                {
                        $error = CActiveForm::validate($model, '', false);
                        if ($error != '[]')
		               echo $error;
                }
          
            }
        }
        else{
            $this->renderPartial('../index_error');
        }
        }
        public function actionDeleteHealth(){
       
		$id = $_POST['id'];
                $model_c = Customer::model()->findAll(array('condition' => 'customer_country = '.$id.' '));
                $model_com = Company::model()->findAll(array('condition' => 'shipping_country = '.$id.' '));
                 if(empty($model_c) && empty($model_com)){
                        $model=new MasHealthStatus();
                        $model->deleteByPk($id);
                        echo "success";
                 }   
                 else{
                     echo "fail";
                 }
               
    }
    
     

	
}