<?php

class MascountryController extends Controller {


    public function init() {
        parent::init();
        $this->initAjaxCsrfToken();
    }

    // this function will work to post csrf token.
    protected function initAjaxCsrfToken() {

        Yii::app()->clientScript->registerScript('AjaxCsrfToken', ' $.ajaxSetup({
                         data: {"' . Yii::app()->request->csrfToken . '": "' . Yii::app()->request->csrfToken . '"},
                         cache:false
                    });', CClientScript::POS_HEAD);
    }

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Create', 'GetList', 'SaveCountry', 'DeleteCountry', 'DirectAdd', 'UploadDropDownImage', 'getcountrytelcode'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex() {
        $_GET  = filter_input_array(INPUT_GET, FILTER_SANITIZE_STRING);
        if(count($_GET) > 0){
            $this->render('index');
        }else{
            $this->renderPartial('../index_error');
        }
    }

    // Uncomment the following methods and override them if needed

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionGetList() {
        $_POST = filter_input_array(INPUT_POST, FILTER_SANITIZE_STRING);
        if (count($_POST) > 0) {
        $model = new MasCountry();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'country_name',
            1 => 'country_code',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.isActive="Y"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " and (country_name LIKE '%" . $searchString . "%' OR country_code LIKE '%" . $searchString . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $div = ''; {
                $div .= '<div class="btn-wrap text-center"><button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'Mascountry/create&id=' . $row['id'] . '\',\'Edit Country\',\'lg\')"><i class="fa fa-pencil"></i></button>';
            }
            //if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["mas_country_delete"])){
            // $div .=  '<a href ="#" class="btn btn-danger btn-xs" onclick="deleteCountry('.$row['id'].')"><i class="fa fa-trash-o "></i></a>';
            //}
            $rowData[] = array($m, $row['country_name'], $row['country_code'], $row['phone_code'], $row['show_country_list'], CHtml::image(Yii::app()->baseUrl . "/uploads/flag/" . $row['flag_name'], "", array('style' => 'height: 24px;width: 36px;')), '<div class="btn-wrap text-center">' . $div . '</div>');

            $m++;
        }

        $data['data'] = $rowData;
        echo json_encode($data);
    } else{
        $this->renderPartial('../index_error');
         
     } 

    }

    public function actionCreate() {
        $model = new MasCountry();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('country_form', array('model' => $model), false, false);
    }

    public function actionSaveCountry() {
        $_POST  = filter_input_array(INPUT_POST, FILTER_SANITIZE_STRING);
        if(isset($_POST) && count($_POST) > 0){
        $model = new MasCountry();
        if (isset($_POST['MasCountry'])) {
            $model->created_by = Yii::app()->user->id;
            $model->created_datetime = date('Y-m-d h:i:s');
            if ((int) @$_POST['MasCountry']['id'] > 0) {
                $model->updated_by = Yii::app()->user->id;
                $model->updated_datetime = date('Y-m-d h:i:s');
                $id = (int) @$_POST['MasCountry']['id'];
                $model = $model->findByPk($id);
            }
            $model->attributes = $_POST['MasCountry'];
            if ($model->save()) {
                $jsonData['status'] = 'success';
                $jsonData['frm'] = $_POST['country_form'];
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }
        else{
            $this->renderPartial('../index_error');
        }
    }

    public function actionDeleteCountry() {

        $id = $_POST['id'];
        $model_c = Customer::model()->findAll(array('condition' => 'customer_country = ' . $id . ' '));
        $model_com = Company::model()->findAll(array('condition' => 'shipping_country = ' . $id . ' '));
        if (empty($model_c) && empty($model_com)) {
            $model = new MasCountry();
            $model->deleteByPk($id);
            echo "success";
        } else {
            echo "fail";
        }
    }

    public function actionDirectAdd() {
        $from = $_POST['from'];
        $name = $_POST['name'];
        $code = $_POST['code'];
        if ($name != '' && $code != '') {
            $modelCountry = new MasCountry;
            $modelCountry->created_by = Yii::app()->user->id;
            $modelCountry->created_datetime = date('Y-m-d h:i:s');
            $modelCountry->country_name = $name;
            $modelCountry->country_code = $code;
            if ($modelCountry->save()) {
                $data = MasCountry::getCountry();
                if ($from == 'customer') {
                    $model = new Customer;
                    $field_name = 'customer_country';
                }
                if ($from == 'vendor') {
                    $model = new Vendor;
                    $field_name = 'vendor_country';
                }
                $model->$field_name = $modelCountry->id;
                $drop = CHtml::activedropDownList($model, $field_name, $data, array('class' => 'tooltipster', 'data-label' => 'Country <span style="color:red;">*</span>'));
                $status = array("status" => "success", "drop" => $drop);
                echo CJSON::encode($status);
            } else {
                $error = CActiveForm::validate($modelCountry, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actiongetcountrytelcode() {
        $id = Yii::app()->request->getparam("id");
        $model_country = MasCountry::model()->findbyPk($id);
        if (!empty($model_country)) {
            $jsonData['phone_code'] = $model_country->phone_code . '-';
        }
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
    }

}
