<?php

class LeadController extends Controller
{
    public function init() {
        parent::init();
        $this->initAjaxCsrfToken();
    }

    // this function will work to post csrf token.
    protected function initAjaxCsrfToken() {

        Yii::app()->clientScript->registerScript('AjaxCsrfToken', ' $.ajaxSetup({
                         data: {"' . Yii::app()->request->csrfToken . '": "' . Yii::app()->request->csrfToken . '"},
                         cache:false
                    });', CClientScript::POS_HEAD);
    }
	public function accessRules() {
        return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                    'actions' => array('login', 'error', 'logout'),
                    'users' => array('*'),
                    ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                    'actions' => array('index','Create','saveCustomer','GetList','checkmobilenumberexist','View','uploadlead','Upload',
                                        'Downloadformat','SaveUploadCsv','readCSVfile','DownloadErrorCsv','ViewuploadLead','saveuploadedleads'),
                    'expression' => '$user->isMember()',
                    ),
                array('deny', // deny all users
                    'users' => array('*'),
                    ),
                );
    }
    public function filters()
    {
        return array(
            'accessControl', // perform access control for CRUD operations
            );
    }
    /**
     * This is the default 'index' action that is invoked
     * when an action is not explicitly requested by users.
     */
    public function actionIndex() {
        $_GET  = filter_input_array(INPUT_GET, FILTER_SANITIZE_STRING);
        //echo $_GET; exit;
        if(count($_GET) > 0){
            $this->render('index');
        }else{
            $this->renderPartial('../index_error');
        }
        
       
    }
     //Start Lead List
    public function actionGetList(){
        $_POST = filter_input_array(INPUT_GET, FILTER_SANITIZE_STRING);
        if (count($_POST) > 0) { 
        $model=new LeadCustomer();
        $draw    = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $columns = array(
            0 =>'id',
            1 =>'customer_first_name',
            2 =>'customer_mobile_number',
            3 =>'customer_source_prospect',
            4=>'referred_by',
            5 =>'call_back_date_time',
            6=>'',
            7=>''
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
       // $orderBy   = $filterColumn." ".$filterOrder;
        $orderBy = "call_back_date_time desc";
        $condition= 'DATE(lead_conversion_date)="0000-00-00"';
        if(Yii::app()->user->id!=1){
            $condition.= ' AND created_by="'.Yii::app()->user->id.'"';
        }
        /*else{
            $condition ='1=1';
        }*/
        if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
        {
          $searchString = $_POST['search']['value'];
          $condition.=" AND (customer_first_name LIKE '%".$searchString."%' OR customer_middle_name LIKE '%".$searchString."%' OR customer_last_name LIKE '%".$searchString."%' OR customer_mobile_number LIKE '%".$searchString."%')";
        }
        $count = $model->count(array('condition'=>$condition));
        $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData=array();
        $m=1;
        foreach ($model as $row)
        {
            $button_string="";     
            $created_datetime="";
            $callback_date='';$lead_conversion_date="";
            if($row['created_date_time']!='' && $row['created_date_time']!='0000-00-00 00:00:00'){
                $created_datetime=date("d/m/Y h:i:s a",strtotime($row->created_date_time));
            }
            if($row['lead_conversion_date']!='' && $row['lead_conversion_date']!='0000-00-00 00:00:00'){
                $lead_conversion_date=date("d/m/Y h:i:s a",strtotime($row->lead_conversion_date));
            }
//            if($row['call_back_date_time']!='' && $row['call_back_date_time']!='0000-00-00 00:00:00'){
//                $callback_date=date("d/m/Y H:i:s",strtotime($row['call_back_date_time']));
//            }
            if ($row['lead_conversion_date']=='0000-00-00 00:00:00') {
                $button_string.= '<button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'lead/create&id=' . $row['id'] . '\',\'' . $row['id'] . ' : ' . $row->fullname. '\',\'lg\')"><i class="fa fa-edit"></i></button>&nbsp;';       
                $model_customer_exist = Customer::model()->find(array('condition' =>'cust_mobile1="'.$row['customer_mobile_number'].'"'));
                if(empty($model_customer_exist)){
                    $button_string.= '<button class="btn btn-primary btn-xs" title="Convert to Customer" onclick="loadPopupModal(\'customer/converttocustomer&id=' . $row['id'] . '\',\'' . $row['id'] . ' : ' . $row->fullname. '\',\'xl\')"><i class="fa fa-retweet"></i></button>&nbsp;';  
                    $button_string .='<button class="btn btn-primary btn-xs" title ="Add Activity" onclick="loadPopupModal(\'leadactivity/create&customer_id=' . $row['id'] . '\',\'' . $row['id'] . ' : ' . $row->fullname. ' - Activities ' . '\',\'xl\')"><i class="fa fa-certificate"></i></button>&nbsp;';
                }

            }else{
                $button_string .='<button class="btn btn-primary btn-xs" title ="View Activity" onclick="loadPopupModal(\'leadactivity/create&customer_id=' . $row['id'] . '\',\'' . $row['id'] . ' : ' . $row->fullname. ' - Activities ' . '\',\'xl\')"><i class="fa fa-certificate"></i></button>&nbsp;';
            }
            $button_string.= '<button class="btn btn-primary btn-xs" title="View" onclick="loadPopupModal(\'lead/view&id=' . $row['id'] . '\',\'' . $row['id'] . ' : ' . $row->fullname. '\',\'lg\')"><i class="fa fa-eye"></i></button>&nbsp;';     

            $customer_source_prospect='';
            if($row['customer_source_prospect']==1){
                $customer_source_prospect='Referral';
            }else if($row['customer_source_prospect']==2){
                $customer_source_prospect='Network';
            }else if($row['customer_source_prospect']==3){
                $customer_source_prospect='Website';
            }else if($row['customer_source_prospect']==4){
                $customer_source_prospect='Advertisement';
            }
            $current_date_time=date("Y-m-d H:i");
            $call_back_or_actual_date='';
            $model_activity = Activity::model()->find(array('condition' =>'type_of_activity="1" and lead_customer_id="'.$row['id'].'" and call_back_or_actual_date>="'.$current_date_time.'"','order'=>'call_back_or_actual_date asc'));
            if($model_activity->call_back_or_actual_date!='' && $model_activity->call_back_or_actual_date!='0000-00-00 00:00:00'){
                $call_back_or_actual_date=date("d/m/Y H:i",strtotime($model_activity->call_back_or_actual_date));
            }
            $rowData[]=array($m,$row->fullname,$row['customer_mobile_number'],$customer_source_prospect,$row['referred_by'],$call_back_or_actual_date,$lead_conversion_date,$button_string);
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }else{
        $this->renderPartial('../index_error');
    }
}
     //End Lead List
    public function actionCreate() {
        $id= (int) Yii::app()->request->getParam('id');
        $model=new LeadCustomer(); 
        if ($id > 0) {
            $model=$model->findByPk($id);
            if($model['call_back_date_time']!='' && $model['call_back_date_time']!='0000-00-00 00:00:00'){
                $model->call_back_date_time=date("d/m/Y H:i:s",strtotime($model->call_back_date_time));
            }
            
        }
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
        $this->render('create',array('model'=>$model));
    }
    //Code to save calls-start
    public function actionsaveCustomer() {
        if (isset($_POST['LeadCustomer'])) {
            $model = new LeadCustomer();
            if ((int) @$_POST['LeadCustomer']['id'] > 0) {
                $model->id = (int) $_POST['LeadCustomer']['id'];
                $model = $model->findByPK($model->id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d h:i:s');
            }else{
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d h:i:s');
            }
            $model->attributes = $_POST['LeadCustomer'];  
            if ($_POST['LeadCustomer']['mobile_number'] != '') {
                $model->customer_mobile_number=$_POST['LeadCustomer']['mobile_code'].''.$_POST['LeadCustomer']['mobile_number'];
            }
            if ($_POST['LeadCustomer']['customer_email'] != '') {
                $model->customer_email=$_POST['LeadCustomer']['customer_email'];
            }
//            if ($_POST['LeadCustomer']['call_back_date_time'] != '') {
//                $model->call_back_date_time=str_replace('/', '-',$_POST['LeadCustomer']['call_back_date_time']);
//                $model->call_back_date_time = date("Y-m-d H:i:s", strtotime($model->call_back_date_time));
//            }
            $model->remarks=$_POST['LeadCustomer']['remarks'];
            if ($model->validate()) {
                $model->save();
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    //Code to save lead-ends
    //Check mobile number exist-Start
    public function actioncheckmobilenumberexist() {
        $tel_code=Yii::app()->request->getParam('tel_code');
        $mobile=Yii::app()->request->getParam('mobile');
        $mobile_number=$tel_code.''.$mobile;
        $model_customer_exist = Customer::model()->find(array('condition' =>'cust_mobile1="'.$mobile_number.'" AND cust_executive_id !="'.Yii::app()->user->id.'"'));
        if(empty($model_customer_exist)){
            $jsonData['status'] = 'success';
        }else{
            $jsonData['customer_name'] =$model_customer_exist->fullname;
            $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }
    //Check mobile number exist-End
    //View-start
     public function actionView() {
        $id= (int) Yii::app()->request->getParam('id');
        $model=new LeadCustomer(); 
        if ($id > 0) {
            $model=$model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
        $this->render('view',array('model'=>$model));
    }
    //View-End
     public function actionuploadlead(){	 
        $model=new LeadCustomer();
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('upload_lead', array('model' => $model), false, true);
    }
    public function actionSaveUploadCsv() {
        $file_name = Yii::app()->request->getParam('filename');         
        $url = Yii::app()->basePath . '/../uploads/leadcustomer/' . $file_name;
        $error_url = Yii::app()->basePath . '/../uploads/leadcustomer/error/' . $file_name;
        $file = fopen($url, "r");
        $data = fgetcsv($file);
        $validate=TRUE;
        $error_list = array();
        $mobile_error = array();
        $lead_list = Yii::app()->controller->readCSVfile("uploads/leadcustomer/" . $file_name);
        foreach (array_slice($lead_list, 1) as $i => $data) {
            if($data[0]!=''||$data[1]!=''||$data[2]!=''||$data[3]!=''||$data[4]!=''||$data[5]!=''||$data[6]!=''||$data[7]!=''||$data[8]!='' ||$data[9]!=''){
            $model_lead_customer[$i] = new LeadCustomer();
            $model_lead_customer[$i]->scenario="excelupload";		
            if($data[0]!=''){
                $model_lead_customer[$i]->customer_first_name = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[0]), '"'));
                               
            }else{                    
                $model_lead_customer[$i]->customer_first_name = '';
            }
            if($data[1]!=''){
                $model_lead_customer[$i]->customer_middle_name = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[1]), '"'));
                               
            }else{                    
                $model_lead_customer[$i]->customer_middle_name = '';
            }
            if($data[2]!=''){
                $model_lead_customer[$i]->customer_last_name = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[2]), '"'));
                               
            }else{                    
                $model_lead_customer[$i]->customer_last_name = '';
            }
            $country_code='';
            if($data[3]!=''){
                $country_value=trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[3])));       
                $model_country_code= MasCountry::model()->find(array('condition' => 'country_code="'.$country_value.'"'));               
                $model_lead_customer[$i]->customer_country_id = $model_country_code->id;
                $country_code=$model_country_code->phone_code;
                $model_lead_customer[$i]->country =$country_value;
            }else{
                $model_lead_customer[$i]->customer_country_id = '';
            }           
            $mobile_number='';
            if($data[4]!=''){
                $mobile_number= trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[4]), '"'));
                $model_lead_customer[$i]->customer_mobile_number =$country_code."-".$mobile_number;      
                $model_lead_customer[$i]->mobile_number =$mobile_number;
            }else{                    
                $model_lead_customer[$i]->customer_mobile_number = '';
            }
            $mobile_error[$i] = $mobile_number;
            if($data[5]!=''){
                $model_lead_customer[$i]->customer_email =trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[5]), '"'));
                               
            }else{                    
                $model_lead_customer[$i]->customer_email = '';
            }
            if($data[6]!=''){
                $customer_source_prospect =trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[6]), '"'));
                $source='';
                if($customer_source_prospect=='Referral'){
                    $source=1;
                }else if($customer_source_prospect=='Network'){
                    $source=2;
                }else if($customer_source_prospect=='Website'){
                    $source=3;
                }else if($customer_source_prospect=='Advertisement'){
                    $source=4;
                }
                $model_lead_customer[$i]->customer_source_prospect=$source;
                $model_lead_customer[$i]->source =$customer_source_prospect;               
            }else{                    
                $model_lead_customer[$i]->customer_source_prospect = '';
            }
            
            if($data[7]!=''){
                $model_lead_customer[$i]->call_back_date_time =trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[7]), '"'));
                               
            }else{                    
                $model_lead_customer[$i]->call_back_date_time = '';
            }
            if($data[8]!=''){
                $model_lead_customer[$i]->referred_by =trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[8]), '"'));
                               
            }else{                    
                $model_lead_customer[$i]->referred_by = '';
            }             
            $model_lead_customer[$i]->status =1;
            $model_lead_customer[$i]->remarks = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[9]), '"')); 
            $model_lead_customer[$i]->created_by= Yii::app()->user->id;  
            $model_lead_customer[$i]->created_date_time = date('Y-m-d h:i:s');            
            $validate = $model_lead_customer[$i]->validate() && $validate;
            }
        }
        function array_not_unique($raw_array) {
            $dupes = array();
            natcasesort($raw_array);
            reset($raw_array);

            $old_key   = NULL;
            $old_value = NULL;
            foreach ($raw_array as $key => $value) {
                if ($value === NULL) { continue; }
                if (strcasecmp($old_value, $value) === 0) {
                    $dupes[$old_key] = $old_value;
                    $dupes[$key]     = $value;
                }
                $old_value = $value;
                $old_key   = $key;
            }
            return $dupes;
        }

        $mobilenumber_common = array_not_unique($mobile_error);
        if ($validate && empty($mobilenumber_common)) {					
            if (!empty($model_lead_customer)) {
//                foreach ($model_lead_customer as $eachModel) {                            
//                    $eachModel->save(false);
//                }
                Yii::app()->session['uploaded_lead'] =$model_lead_customer;
                $jsonData['status'] = "success";
            }	
        } else {			
            if (!empty($model_lead_customer)) {
                foreach ($model_lead_customer as $s => $data_model) {
                    $error_list[$s]['customer_first_name'] =$data_model['customer_first_name'];
                    $error_list[$s]['customer_middle_name'] =$data_model['customer_middle_name'];
                    $error_list[$s]['customer_last_name'] =$data_model['customer_last_name'];
                    $error_list[$s]['customer_country_id']  =$data_model['country'];
                    $error_list[$s]['customer_mobile_number']   =$data_model['mobile_number'];
                    $error_list[$s]['customer_email']  =$data_model['customer_email'];
                    $error_list[$s]['customer_source_prospect'] =$data_model['source'];
                    $error_list[$s]['call_back_date_time']    =$data_model['call_back_date_time'];
                    $error_list[$s]['referred_by']      =$data_model['referred_by'];
                    $error_list[$s]['notes']      =$data_model['remarks'];
                    if($data_model->validate()){
                        $error_list[$s]['remarks']     ="correct";
                    }else{
                        $error_list[$s]['remarks']     =$data_model->getErrors();	
                    }
                }
            }	
            $jsonData['status'] = "error";
	}				
              		 
	$j=0;
        fclose($file);
        $list = array(); 
        if(!empty($error_list)){
            $file_error = fopen($error_url, "w+");
            $list[$j++] = 'First Name,Middle Name,Last Name,Country Code,Mobile Number(Without Country Code),Email,Source,Follow up date(yyyy-mm-dd hh:mm),Referred By,Notes';
            foreach ($error_list as $i => $error_detail) {			
                if(!empty($error_detail)){
                    if(!empty($error_detail['remarks'])){
                            $error_view[$i] = '';
                        foreach($error_detail['remarks'] as $p => $error_value){						
                                $error_view[$i] .= $error_value[0]." / ";	

                        }
                    }else{
                        $error_view[$i] .= '';
                    }
                    if (in_array($error_detail['customer_mobile_number'], $mobilenumber_common)){
                        $error_view[$i] .= " Mobile number Duplicated/";
                    }	else {
                        $error_view[$i] .= '';
                    }
                    $list[$j++] = $error_detail['customer_first_name']. ',' .$error_detail['customer_middle_name']. ',' .$error_detail['customer_last_name']. ',' .$error_detail['customer_country_id']. ','.$error_detail['customer_mobile_number']. ',' .$error_detail['customer_email']. ',' .$error_detail['customer_source_prospect']. ',' .$error_detail['call_back_date_time']. ',' .$error_detail['referred_by'] . ',' .$error_detail['notes']. ',' .$error_view[$i];
                }
            }
            foreach ($list as $line) {
                fputcsv($file_error, explode(',', $line));
            }
            fclose($file_error);
        }
		

        $jsonData['error_url'] = $error_url;
        $jsonData['filename'] = $file_name;
        $jsonData['link'] = CHtml::link('Download log', array('lead/DownloadErrorCsv', 'file_name'=>$file_name), array('target' => '_blank',
            'style'=>'border: 1px solid #686869;padding: 2px 10px;border-radius: 10px;font-size: 10px;background: #a1a1a1;color: #fff;'
            . ''
            ));
        echo CJSON::encode($jsonData);
    }
    public function actionDownloadErrorCsv() {
        $file_name =Yii::app()->request->getParam('file_name');
        $error_url = Yii::app()->basePath . '/../uploads/leadcustomer/error/' . $file_name;
        return Yii::app()->getRequest()->sendFile('log.csv', @file_get_contents($error_url));
    }
    public function actionDownloadformat() {
        $error_url = Yii::app()->basePath . '/../uploads/leadcustomer/leadupload_format.csv';
        return Yii::app()->getRequest()->sendFile('uploadformat.csv', @file_get_contents($error_url));
    }
    public function actionViewuploadLead() {
        $model_lead_customer=Yii::app()->session['uploaded_lead'];
        $model_lead=new LeadCustomer();
        $this->render('view_uploaded_csv',array('model_lead_customer'=>$model_lead_customer,'model_lead'=>$model_lead));
    }
    public function actionsaveuploadedleads() {        
        $validate = true;
        if (isset($_POST['LeadCustomer'])) {
            foreach ($_POST['LeadCustomer'] as $i => $items) {
                $model_lead[$i] = new LeadCustomer();
                if ($items['id'] > 0) {
                    $model_lead[$i] = $model_lead[$i]->findByPK($items['id']);
                    $model_lead[$i]->updated_by = Yii::app()->user->id;
                    $model_lead[$i]->updated_date_time = date('Y-m-d h:i:s');
                }else{
                    $model_lead[$i]->created_by = Yii::app()->user->id;
                    $model_lead[$i]->created_date_time = date('Y-m-d h:i:s');
                }
                $model_lead[$i]->customer_first_name = $items['customer_first_name'];
                $model_lead[$i]->customer_middle_name = $_POST['customer_middle_name'];
                $model_lead[$i]->customer_last_name = $items['customer_last_name'];
                $model_lead[$i]->customer_country_id = $items['customer_country_id'];
                $model_lead[$i]->customer_mobile_number = $items['customer_mobile_number'];
                $model_lead[$i]->customer_email = $items['customer_email'];
                $model_lead[$i]->customer_source_prospect = $items['customer_source_prospect'];
                $model_lead[$i]->referred_by = $items['referred_by'];
                $model_lead[$i]->call_back_date_time = $items['call_back_date_time'];
                $model_lead[$i]->remarks = $items['remarks'];
                $validate= $model_lead[$i]->validate() && $validate;
                
            }
             if ($validate) {
                if (!empty($model_lead)) {
                    foreach ($model_lead as $eachModel) {
                        $eachModel->save();
                    }
                }
                unset(Yii::app()->session['uploaded_lead']); 
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            }else {
                $error_1 = json_decode(CActiveForm::validate($model_lead, '', false), true);
                $error = CJSON::encode(array_merge_recursive($error_1));
                if ($error != '[]')
                    echo $error;
            }
        }
    }
}