<?php

class CustomerController extends Controller {

    /**
     * Declares class-based actions.
     */
     
      public function init() {
        parent::init();
        $this->initAjaxCsrfToken();
    }

    // this function will work to post csrf token.
    protected function initAjaxCsrfToken() {

        Yii::app()->clientScript->registerScript('AjaxCsrfToken', ' $.ajaxSetup({
                         data: {"' . Yii::app()->request->csrfToken . '": "' . Yii::app()->request->csrfToken . '"},
                         cache:false
                    });', CClientScript::POS_HEAD);
    }
     
     
    public function accessRules() {

        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Create', 'GetCustomerList', 'SaveCustomer', 'SaveDependant', 'GetDependantList', 'isUnique',
                    'SavePlanDetails', 'GetPlanDetailsList', 'AddEditPlan', 'AddEditDependant', 'GetPaymentdetailslist', 'AddEditPayment',
                    'getPlanComboProvider','SavePaymentdetails','GetSelectedPlanDetails','ConverttoCustomer','checkmobilenumberexist',
                    'ChangeexecutveRequest','CopyLastPayment','getprioritydetails','GetDocumentList','saveCustomerDocument','Upload',
                    'PlanChangePayterm','SavePlanPaytermDetails','IncrementPlanInstallment','DecrementPlanInstallment','getPremiumDateFromInstallment',
                    'saveIncremetedPlan','saveDecremetedPlan','GetSelectedPaytermDetails','GetSelectedInstallmentAmount','viewplandetails','updatePlan',
                    'UpdatePlandetails','SaveCustomerdetails','indexnew','GetCustomerList1','GetCustomerListNew'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    /**
     * This is the default 'index' action that is invoked
     * when an action is not explicitly requested by users.
     */
    public function actionIndex() {
        //$this->render('index');
         $_GET  = filter_input_array(INPUT_GET, FILTER_SANITIZE_STRING);
        //echo $_GET; exit;
        if(count($_GET) > 0){
            $this->render('index');
        }else{
            $this->renderPartial('../index_error');
        }
    }

    public function actionCreate() {
        $id = (int) Yii::app()->request->getParam('id');
         $frm = Yii::app()->request->getParam('frm');
        $model = new Customer();
        $modelDocument = new ActivityDocument();
        $modelPriorities = new CustomerPriorities();
        $modelDependants = new CustomerDependants();
        $modelPlanDetails = new CustomerPlanDetails();
        $modelPaymentDetails = new CustomerPaymentDetails();
        $modelDetails = array(new CustomerOtherDetails());
        if ($id > 0) {
            $model = $model->findByPk($id);
            //Get priority details
            $modelPriorities = $modelPriorities->find(array('condition' => 'isActive="Y" and customer_id=' . $id));

            if (empty($modelPriorities)) {
                $modelPriorities = new CustomerPriorities();
            }
            //end priority details
            //Get priority details
            $modelDetails = CustomerOtherDetails::model()->findAll(array('condition' => 'customer_id="'.$id.'"'));
            if (empty($modelDetails)) {
                $modelDetails = array(new CustomerOtherDetails());
            }
            //Get Customer Age
            $customer_dob = $model->cust_date_of_birth;
            $customer_age = (date('Y') - date('Y', strtotime($customer_dob)));
            $model->cust_age = $customer_age;

            if ($model->cust_date_of_birth != '0000-00-00') {
                $model->cust_date_of_birth = date("d/m/Y", strtotime($model->cust_date_of_birth));
            }
            //End Customer age
            //Get Spouse Age
            $spouse_dob = $model->cust_spouse_date_of_birth;
            if($spouse_dob!='0000-00-00'){
                $spouse_age = (date('Y') - date('Y', strtotime($spouse_dob)))-1;
                $model->cust_spouse_age = $spouse_age;
            }else{
                $model->cust_spouse_age = '';
            }
            if ($model->cust_spouse_date_of_birth != '0000-00-00') {
                $model->cust_spouse_date_of_birth = date("d/m/Y", strtotime($model->cust_spouse_date_of_birth));
            }
            //End Spouse age
        }
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
        //Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
        $this->render('create', array('model' => $model,'modelDetails' => $modelDetails, 'modelPriorities' => $modelPriorities, 'modelDependants' => $modelDependants, 'modelPaymentDetails' => $modelPaymentDetails, 'modelPlanDetails' => $modelPlanDetails,'modelDocument'=>$modelDocument,'frm'=>$frm));
    }

    public function actionGetCustomerList1() {
        $_POST = filter_input_array(INPUT_POST, FILTER_SANITIZE_STRING);
        if (count($_POST) > 0) {
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $status = $_POST['status'];
        $policy_taken = $_POST['policy_taken'];
        $model = new Customer();
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'cust_first_name',
            2 => 'customer_address',
            3 => 'customer_city',
            4 => 'customer_phone_no',
            
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;

        //$orderBy = "t.cust_first_name ASC";
        $current_date=date('Y-m-d'); 
        /******** First Loading Without Search********/
        $condition = 't.isActive="Y" AND (cust_executive_id="'.Yii::app()->user->id.'" OR cust_executive_id IN ('.Yii::app()->user->connected_users.'))';
        
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition = "t.isActive='Y' AND 
                            (((t.cust_executive_id='".Yii::app()->user->id."' OR cust_executive_id IN (".Yii::app()->user->connected_users."))
                                AND ( t.cust_first_name LIKE '%" . $searchString . "%' 
                                OR t.cust_middle_name LIKE '%" . $searchString . "%'
                                OR t.cust_last_name LIKE '%" . $searchString . "%' OR t.id LIKE '%" . $searchString . "%' 
                                OR t.cust_phone_no LIKE '%" . $searchString . "%' 
                                OR t.cust_mobile1 LIKE '%" . $searchString . "%' OR t.cust_email1 LIKE '%" . $searchString . "%' OR t.id LIKE '%" . $searchString . "%' OR plandetails.policy_no LIKE '%" . $searchString . "%')
                             )OR(t.cust_mobile1 = '" . $searchString . "' AND cust_policy_taken='N' AND cust_locked_date<'".$current_date."')
                            )";
        }
        if($status>0){
            $condition.= ' AND t.cust_status="'.$status.'"';
        }
        if($policy_taken!=''){
            $condition.= ' AND t.cust_policy_taken="'.$policy_taken.'"';
        }        
        $count = $model->with('plandetails')->count(array('condition' => $condition));
        $model = $model->with('plandetails')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset,'group'=>'t.id DESC', 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m=1;
        $connected_user=  explode(',', Yii::app()->user->connected_users);
        foreach ($model as $row) {
            $dob = $row['cust_date_of_birth'];
            $age = (date('Y') - date('Y', strtotime($dob)));
            $div='';
            if(Yii::app()->user->id==$row['cust_executive_id'] || in_array($row['cust_executive_id'],$connected_user)){
                if(((int) Yii::app()->user->havePermissionOn["prospects_customers_edit"])){
                    $div.= '<button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'customer/create&id=' . $row['id'] . '\',\'' . $row['id'] . ' : ' . $row['cust_first_name'] . ' ' . $row['cust_middle_name'] . ' ' . $row['cust_last_name'] . '\',\'xl\')"><i class="fa fa-edit"></i></button>';
                }
                if(!((int) Yii::app()->user->havePermissionOn["prospects_customers_edit"])){
                    $div.= '<button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'customer/create&frm=view&id=' . $row['id'] . '\',\'' . $row['id'] . ' : ' . $row['cust_first_name'] . ' ' . $row['cust_middle_name'] . ' ' . $row['cust_last_name'] . '\',\'xl\')"><i class="fa fa-eye"></i></button>';
                }
                $div .= ' <a  href="?r=reportpdf/customerdetails&id=' . $row['id'] . '" class="btn btn-primary btn-xs" title="Print Details" target="_blank"><i class="fa fa-file-pdf-o" aria-hidden="true"></i></a> ';
                //if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["customer_activity"])){
                $div .= ' <button class="btn btn-primary btn-xs" title ="Add Activity" onclick="loadPopupModal(\'activity/create&customer_id=' . $row['id'] . '\',\'' . $row['id'] . ' : ' . $row['cust_first_name'] . " " . $row['cust_middle_name'] . " " . $row['cust_last_name'] . ' - Activities ' . '\',\'xl\')"><i class="fa fa-certificate"></i></button>';
                //}
//                if(((int) Yii::app()->user->havePermissionOn["prospects_customers_send_view"])){
//                $div .= ' <button class="btn btn-primary btn-xs" title ="Send Info Provider" onclick="loadPopupModal(\'providerinfo/createsend&customer_id=' . $row['id'] . '\',\'' . $row['fullname'] . ' - Send Info Provider ' . '\',\'xl\')"><i class="fa fa-hand-o-right"></i></button>';
//                }
//                if(((int) Yii::app()->user->havePermissionOn["prospects_customers_receive_view"])){
//                $div .= ' <button class="btn btn-primary btn-xs" title ="Information from Provider" onclick="loadPopupModal(\'providerinfo/createreceive&customer_id=' . $row['id'] . '\',\'' . $row['fullname'] . ' - Information from Provider ' . '\',\'xl\')"><i class="fa fa-arrow-circle-o-left"></i></button>';
//                }
            }else if(($row->cust_locked_date<$current_date) && (Yii::app()->user->id!=$row['cust_executive_id']) && $row->cust_executive_change_request=="N"){
                $div= '<button class="btn btn-primary btn-xs" title="Activity Details" onclick="loadPopupModal(\'executive/activity&customer_id=' . $row['id'] . '&executive=' . $row['cust_executive_id'] . '\',\'Activity\',\'lg\')"><i class="fa fa-certificate"></i></button>&nbsp;';   
                $div .=' <a href ="javascript:void(0);" class="btn btn-primary btn-xs" title="Request For Executive Change" onclick="changerequest(' . $row['id'] . ')"><i class="fa fa-share"></i></a>' ;
            }else if($row->cust_executive_change_request=="Y"){
                $div= '<button class="btn btn-primary btn-xs" title="Activity Details" onclick="loadPopupModal(\'executive/activity&customer_id=' . $row['id'] . '&executive=' . $row['cust_executive_id'] . '\',\'Activity\',\'lg\')"><i class="fa fa-certificate"></i></button>&nbsp;';   
                $div .='Change Request sent';
            }
            $current_date_time=date("Y-m-d H:i");
            $call_back_or_actual_date='';
            $model_activity = Activity::model()->find(array('condition' =>'type_of_activity="1" and customer_id="'.$row['id'].'" and call_back_or_actual_date>"'.$current_date_time.'"','order'=>'call_back_or_actual_date asc'));
            if($model_activity->call_back_or_actual_date!='' && $model_activity->call_back_or_actual_date!='0000-00-00 00:00:00'){
                $call_back_or_actual_date=date("d/m/Y H:i",strtotime($model_activity->call_back_or_actual_date));
            }
            //$customer_code='GR-'.$row['id'];
            $rowData[] = array('<div class="text-center">' . $row['id'] . '</div>', $row['cust_first_name'] . " " . $row['cust_middle_name'] . " " . $row['cust_last_name'], $row['cust_mobile1'], $row['cust_email1'], $age, $row['emirates']['emirate_name'], $row['nationality']['country_name'],$call_back_or_actual_date ,'<div class="btn-wrap text-center">' . $div . '</div>',$row->cust_status,$row->cust_policy_taken);
            $m++;
        }

        $data['data'] = $rowData;
        echo json_encode($data);
       } else{
           $this->renderPartial('../index_error');
            
        }
    }

    public function actionSaveCustomer() {
        $_POST  = filter_input_array(INPUT_POST, FILTER_SANITIZE_STRING);
        if(isset($_POST) && count($_POST) > 0){
        $model = new Customer();
        $modelPriorities = new CustomerPriorities();

        if (isset($_POST['Customer'])) {
            if ($_POST['Customer']['id'] > 0) {
                $id = $_POST['Customer']['id'];
                $model = $model->findByPK($id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d h:i:s');
                $scene = 'update';
            } else {
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d h:i:s');
                $model->cust_locked_date = date('Y-m-d', strtotime('+90 days', strtotime(date('Y-m-d'))));
                $scene = 'new';
            }

            $model->attributes = $_POST['Customer'];
            $model->cust_first_name = preg_replace("/[^a-zA-Z0-9\s]/", "", $_POST['Customer']['cust_first_name']);
            $model->cust_middle_name = preg_replace("/[^a-zA-Z0-9\s]/", "", $_POST['Customer']['cust_middle_name']);
            $model->cust_last_name = preg_replace("/[^a-zA-Z0-9\s]/", "", $_POST['Customer']['cust_last_name']);
            if ($_POST['Customer']['mobile_number'] != '') {
                $model->cust_mobile1=$_POST['Customer']['mobile_code'].''.$_POST['Customer']['mobile_number'];
            }
            if ($_POST['Customer']['cust_date_of_birth'] != '') {
                $model->cust_date_of_birth = str_replace('/', '-', $_POST['Customer']['cust_date_of_birth']);
                $model->cust_date_of_birth = date("Y-m-d", strtotime($model->cust_date_of_birth));
            }

            if (isset($_POST['Customer']['cust_spouse_date_of_birth']) && $_POST['Customer']['cust_spouse_date_of_birth'] != '') {
                $model->cust_spouse_date_of_birth = str_replace('/', '-', $_POST['Customer']['cust_spouse_date_of_birth']);
                $model->cust_spouse_date_of_birth = date("Y-m-d", strtotime($model->cust_spouse_date_of_birth));
            }
            if (isset($_POST['Customer']['transferred_date']) && $_POST['Customer']['transferred_date'] != '') {
                $model->transferred_date = str_replace('/', '-', $_POST['Customer']['transferred_date']);
                $model->transferred_date = date("Y-m-d", strtotime($model->transferred_date));
            }
            $model->cust_notes =  $_POST['Customer']['cust_notes'];
            $valid = $model->validate();
            $fact_find=0;
            if ($_POST['CustomerPriorities']['id'] > 0) {
                $modelPriorities = $modelPriorities->findByPK($_POST['CustomerPriorities']['id']);
                $modelPriorities->updated_by = Yii::app()->user->id;
                $modelPriorities->updated_date_time = date('Y-m-d h:i:s');
                $welfare = $modelPriorities->fa_welfare_priority;
                $education = $modelPriorities->ch_education_priority;
                $dream = $modelPriorities->asp_dream_priority;
                $finance = $modelPriorities->ret_finance_priority;
                $new_welfare = $_POST['CustomerPriorities']['fa_welfare_priority'];
                $new_education = $_POST['CustomerPriorities']['ch_education_priority'];
                $new_dream = $_POST['CustomerPriorities']['asp_dream_priority'];
                $new_finance = $_POST['CustomerPriorities']['ret_finance_priority'];
                if(($new_welfare!='' && $new_education!='' && $new_dream!='' && $new_finance!='') && ($welfare!=$new_welfare || $education!=$new_education || $dream!=$new_dream || $finance!=$new_finance)){
                    $modelPriorities->end_date= date('Y-m-d', strtotime('-1 days', strtotime(date('Y-m-d'))));
                    $modelPriorities->isActive='N';
                    $modelPriorities->save();
                    $modelPriorities = new CustomerPriorities(); 
                    $modelPriorities->created_by = Yii::app()->user->id;
                    $modelPriorities->created_date_time = date('Y-m-d H:i:s');
                    $modelPriorities->start_date=date('Y-m-d');
                    $fact_find=1;
                }
                
            }else{
                $modelPriorities->created_by = Yii::app()->user->id;
                $modelPriorities->created_date_time = date('Y-m-d H:i:s');
                $modelPriorities->start_date=date('Y-m-d');
                $fact_find=1;
            }
            $modelPriorities->attributes = $_POST['CustomerPriorities'];
            $valid = $valid && $modelPriorities->validate();
            if ($valid) {
                $model->save();
                //Updating lead details when coming from lead-Start
                $lead_id= $_POST['lead_id'];
                if($lead_id>0){
                    Activity::model()->updateAll(array('customer_id' =>$model->id), 'lead_customer_id="'.$lead_id.'"');
                    LeadCustomer::model()->updateByPK($lead_id, array('lead_conversion_date' =>date('Y-m-d')));
                }
                //End
                $modelPriorities->customer_id = $model->id;               
                $modelPriorities->save();                
                if($fact_find==1){
                    $model_fact_find = new Activity();
                    $model_fact_find->created_by = Yii::app()->user->id;
                    $model_fact_find->created_datetime = date('Y-m-d h:i:s');
                    $model_fact_find->call_back_or_actual_date =date("Y-m-d H:i:s");
                    $model_fact_find->customer_id=$model->id;
                    $model_fact_find->type_of_activity=4;
                    $model_fact_find->activity_notes='Family and Welfare-'.$modelPriorities->fa_welfare_priority.',Children University Education-'.$modelPriorities->ch_education_priority.',Aspiration and Dreams-'.$modelPriorities->asp_dream_priority.',Financial Freedom at Retirement-'.$modelPriorities->ret_finance_priority;
                    $model_fact_find->save();
                    //Activity Document
                    $model_fact_find_document = new ActivityDocument();
                    $model_fact_find_document->created_by = Yii::app()->user->id;
                    $model_fact_find_document->created_date_time = date('Y-m-d H:i:s');
                    $model_fact_find_document->customer_id=$model->id;
                    $model_fact_find_document->document_name ='Fact Find Document';
                    $model_fact_find_document->document_file=$_POST['factfind_document_file'];
                    $model_fact_find_document->document_type=3;
                    $model_fact_find_document->document_from=1;
                    $model_fact_find_document->save();
                }
                $jsonData['status'] = 'success';
                $jsonData['id'] = $model->id;
                $jsonData['first_name'] = $model->cust_first_name;
                $jsonData['middle_name'] = $model->cust_middle_name;
                $jsonData['last_name'] = $model->cust_last_name;

                echo CJSON::encode($jsonData);
            } else {
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                $error2 = json_decode(CActiveForm::validateTabular($modelPriorities, '', false), true);
                $error = CJSON::encode(array_merge_recursive($error1, $error2));
                if ($error != '[]')
                    echo $error;
            }
        } }
    else{
        $this->renderPartial('../index_error');
    }
    }

    /*     * **************** START save dependant details ************************************************ */

    public function actionSaveDependant() {

        $modelDependants = new CustomerDependants();

        $customer_id = $_POST['customer_id'];
        $dependant_name = $_POST['dependant_name'];
        $relationship = $_POST['relationship'];
        $date_of_birth = $_POST['dependant_date_of_birth'];
        $id = $_POST['id'];
        if ($id > 0) {
            $modelDependants = $modelDependants->findByPk($id);
        }
        $modelDependants->customer_id = $customer_id;
        $modelDependants->dependant_name = $dependant_name;
        $modelDependants->relationship = $relationship;
        $modelDependants->dependant_date_of_birth = $date_of_birth;
        $modelDependants->attributes = $modelDependants;

        if ($date_of_birth != '') {
            $modelDependants->dependant_date_of_birth = str_replace('/', '-', $date_of_birth);
            $modelDependants->dependant_date_of_birth = date("Y-m-d", strtotime($modelDependants->dependant_date_of_birth));
        }

        $valid = $modelDependants->validate();

        if ($valid) {

            $modelDependants->save();
            $jsonData['status'] = 'success';
            $jsonData['id'] = $modelDependants->id;
            echo CJSON::encode($jsonData);
        } else {
            $error1 = json_decode(CActiveForm::validate($modelDependants, '', false), true);
            $error = CJSON::encode($error1);
            if ($error != '[]')
                echo $error;
        }
    }

    /*     * ***************** END save dependant details ********************************************* */

    /*     * ************ GET dependant List ********************************************************** */

    public function actionGetDependantList() {
        $customer_id = (int) Yii::app()->request->getParam('customer_id');
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $model = new CustomerDependants();
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'dependant_name',
            2 => 'relationship',
            3 => 'dependant_date_of_birth',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];

        $orderBy = "t.dependant_name ASC";
        $condition = '1=1';
        if($customer_id>0)
        $condition = 't.customer_id=' . $customer_id;
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " AND (dependant_name LIKE '%" . $searchString . "%' )";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $i = 1;
        foreach ($model as $row) {
            $dob = $row['dependant_date_of_birth'];
            $age = (date('Y') - date('Y', strtotime($dob)))-1;

            $div = '<button class="btn btn-primary btn-xs" title="Edit" onclick="addEditDependantDetails(' . $row['id'] . ');return false;"><i class="fa fa-edit"></i></button>';
            $rowData[] = array($i, $row['dependant_name'], $row['relationship'], date('d/m/Y', strtotime($row['dependant_date_of_birth'])), $age, '<div class="btn-wrap text-center">' . $div . '</div>');
            $i++;
        }

        $data['data'] = $rowData;
        echo json_encode($data);
    }

    /*     * ************************************* End Dependant List ************************************************ */

    /*     * ******************* STRT Add Edit Dependant Details ************************************************* */

    public function actionAddEditDependant() {
        $id = (int) Yii::app()->request->getParam('plan_id');
        $customer_id = (int) Yii::app()->request->getParam('customer_id');
        $modelDependants = new CustomerDependants();
        if ($id > 0) {
            $modelDependants = $modelDependants->findByPk($id);
            $dob = $modelDependants->dependant_date_of_birth;
            $age = (date('Y') - date('Y', strtotime($dob)))-1;
            $modelDependants->dependant_date_of_birth = date('d/m/Y', strtotime($modelDependants->dependant_date_of_birth));
            $modelDependants->dependant_age = $age;
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
        $this->render('add_edit_dependants', array('modelDependants' => $modelDependants));
    }

    /*     * ******************* END Add Edit Dependant Details ************************************************* */

    /*     * **************** START save plan details ************************************************ */

    public function actionSavePlanDetails() {

        $modelPlanDetails = new CustomerPlanDetails();
        $flag=0;
        $id = $_POST['id'];
        $customer_id = $_POST['customer_id'];
        $provider_id = $_POST['provider_id'];
        $plan_id = $_POST['plan_id'];
        $amount = $_POST['amount'];
        $payment_term_id = $_POST['payment_term_id'];
        $annualized_premium = $_POST['annualized_premium'];
        $tennure = $_POST['tennure'];
        $start_date = $_POST['start_date'];
        $class_ids = $_POST['class_ids'];
        $subclass_ids = $_POST['subclass_ids'];
        $policy_no = $_POST['policy_no'];
        $status = $_POST['status'];
        $reason = $_POST['reason'];
        $issuedate = $_POST['issuedate'];
        $premium_term = $_POST['premium_term'];
        $policy_basis = $_POST['policy_basis'];
        $expected_gr = $_POST['expected_gr'];
        $icp_month = $_POST['icp_month'];
        $modelpolicy= new PolicyInstallmentDetails();
        if ($id > 0) {
            $modelPlanDetails = $modelPlanDetails->findByPk($id);
            $modelpolicy= PolicyInstallmentDetails::model()->find(array('condition'=>'cus_plan_id='.$id,'order'=>'id DESC'));
        }
        if(empty($modelpolicy)){
            $modelpolicy = new PolicyInstallmentDetails();
        }
        $modelpolicy->payment_term_id=$payment_term_id;
        $modelPlanDetails->customer_id = $customer_id;
        $modelPlanDetails->provider_id = $provider_id;
        $modelPlanDetails->plan_id = $plan_id;
        $modelPlanDetails->amount = $amount;
        $modelPlanDetails->payment_term = $payment_term_id;
        $modelPlanDetails->annualized_premium = $annualized_premium;
        $modelPlanDetails->tennure = $tennure;
        $modelPlanDetails->start_date = $start_date;
        $modelPlanDetails->class_ids = $class_ids;
        $modelPlanDetails->policy_no = $policy_no;
        $modelPlanDetails->subclass_ids = $subclass_ids;
        if($status!=''){
 			$modelPlanDetails->policy_status = $status;
        }else if($policy_no!="" && $start_date!=""){
            $modelPlanDetails->policy_status = 'O';
        }
        else{
            $modelPlanDetails->policy_status = $status;
        }
        $modelPlanDetails->reason = $reason;
        $modelPlanDetails->icp_months = $icp_month;
        $modelPlanDetails->expected_gr = $expected_gr;
        $modelPlanDetails->policy_basis_type = $policy_basis;
        $modelPlanDetails->premium_payment_term = $premium_term;
        if ($start_date != '') {
            $modelPlanDetails->start_date = str_replace('/', '-', $start_date);
            $modelPlanDetails->start_date = date("Y-m-d", strtotime($modelPlanDetails->start_date));
            $tennure_array=  explode('.', $tennure);
            $modelPlanDetails->mature_date=date('Y-m-d', strtotime('+'.$tennure_array[0].' years', strtotime($modelPlanDetails->start_date)));
            if($tennure_array[1]>0){
                $modelPlanDetails->mature_date=date('Y-m-d', strtotime('+'.$tennure_array[1].' months', strtotime($modelPlanDetails->mature_date)));
            }
        }
        if ($issuedate != '') {
            $modelPlanDetails->issue_date = str_replace('/', '-', $issuedate);
            $modelPlanDetails->issue_date = date("Y-m-d", strtotime($modelPlanDetails->issue_date));
        }else{
            $modelPlanDetails->issue_date = $modelPlanDetails->start_date;
        }
        $modelPlanDetails->attributes = $modelPlanDetails;

        $valid = $modelPlanDetails->validate();

        if ($valid) {
            if((int)$modelPlanDetails->id==0){
                $modelPlanDetails->last_deferment_date=$modelPlanDetails->start_date;
                $modelPlanDetails->last_deferment_date_previous=$modelPlanDetails->start_date;
            }
            $modelPlanDetails->save();
            $total_installments=$tennure*$modelPlanDetails->payterm_details->no_of_times;
            //delete previous installment entries
            CustomerPlanInstallments::model()->deleteAll('cus_plan_id=:refer_id', array(':refer_id' => $modelPlanDetails->id));
            //added installment entries of plan
            for($i=0;$i<$total_installments;$i++){
                if($modelPlanDetails->payterm_details->no_of_times>0){
                    $add_mnth =(int)(12/$modelPlanDetails->payterm_details->no_of_times);
                }else{
                    $add_mnth = 12;
                }
                if($i==0){
                    $due_date = $modelPlanDetails->start_date;
                }else{
                    $due_date = date("Y-m-d",strtotime(date("Y-m-d", strtotime($due_date)) . " +".$add_mnth." months"));
                }
                $modelPlanInstallment = new CustomerPlanInstallments();
                $modelPlanInstallment->cus_plan_id=$modelPlanDetails->id;
                $modelPlanInstallment->installment_no=$i+1;
                $modelPlanInstallment->payment_term_id=$modelPlanDetails->payment_term;
                $modelPlanInstallment->premium_amount=$modelPlanDetails->amount;
                $modelPlanInstallment->payment_due_date=$due_date;
                $modelPlanInstallment->status='N';
                $modelPlanInstallment->created_by=Yii::app()->user->id;
                $modelPlanInstallment->created_date_time=date('Y-m-d H:i:s');
                $modelPlanInstallment->save(false);
            }
            //added installment changes to plan            
            $modelpolicy->total_installments  = $total_installments; 
            $modelpolicy->cus_plan_id  = $modelPlanDetails->id; 
            $modelpolicy->start_date  = $modelPlanDetails->start_date;  
            $modelpolicy->end_date    = date("Y-m-d",strtotime(date("Y-m-d", strtotime($modelPlanDetails->start_date)) . " +".$tennure." year"));
            $modelpolicy->save();
            Customer::model()->updateByPk($customer_id, array('cust_policy_taken' => "Y"));        
            $jsonData['status'] = 'success';
            $jsonData['id'] = $modelPlanDetails->id;
            echo CJSON::encode($jsonData);
        } else {
            $error1 = json_decode(CActiveForm::validate($modelPlanDetails, '', false), true);
            $error = CJSON::encode($error1);
            if ($error != '[]')
                echo $error;
        }
    }

    /*     * ***************** END save plan details ********************************************* */

    /*     * ************ GET plan List ********************************************************** */

    public function actionGetPlanDetailsList() {
        $customer_id = (int) Yii::app()->request->getParam('customer_id');
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $model = new CustomerPlanDetails();
        $status='';
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'provider_id',
            2 => 'masplandetails.plan_name',
            3 => 'amount',
            4 => 'payment_term',
            5 => 'annualized_premium',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];

        $orderBy = "t.provider_id ASC";
        $condition = 't.customer_id=' . $customer_id;
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " AND (providerdetails.provider_name LIKE '%" . $searchString . "%' OR masplandetails.plan_name LIKE '%" . $searchString . "%' OR amount LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('providerdetails', 'masplandetails')->count(array('condition' => $condition));
        $model = $model->with('providerdetails', 'masplandetails')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $i = 1;
        foreach ($model as $row) {
            $div='';
            //$payment_term = "";
            switch ($row['payment_term']) {
                case "1":
                    $payment_term = "Monthly";
                    break;
                case "2":
                    $payment_term = "Bi-Monthly";
                    break;
                case "3":
                    $payment_term = "Quarterly";
                    break;
                case "4":
                    $payment_term = "Half-Yearly";
                    break;
                case "5":
                    $payment_term = "Yearly";
                    break;
                default:
                    $payment_term = "";
                    break;
            }

            $mod_pay = CustomerPaymentDetails::model()->find(array('condition'=>'cus_plan_id='.$row['id']));
            if(empty($mod_pay)){
                $div .= '<button type="button" class="btn btn-primary btn-xs" title="Edit" onclick="addEditPlanDetails(' . $row['id'] . ');return false;"><i class="fa fa-edit"></i></button>';
            }else{
                $div .= '<button type="button" class="btn btn-primary btn-xs" title="View Policy Details" onclick="viewplandetails(' . $row['id'] . ');return false;"><i class="fa fa-eye"></i></button>&nbsp;';
                $div .= '<button type="button" class="btn btn-primary btn-xs" title="Edit Policy Details" onclick="updateplandetails(' . $row['id'] . ');return false;"><i class="fa fa-edit"></i></button>&nbsp;';         
                $div .= '<button type="button" class="btn btn-primary btn-xs" title="Change Payment Term" onclick="ChangePayterm('.$row['id'].');return false;"><i class="fa fa-arrow-circle-o-right"></i></button>';
                $div.= ' <button type="button" class="btn btn-primary btn-xs" title="Increment Installment" onclick="IncrementInstallment('.$row['id'].');return false;"><i class="fa fa-arrow-up"></i></button>';
                $div.= ' <button type="button" class="btn btn-primary btn-xs" title="Decrement Installment" onclick="DecrementInstallment('.$row['id'].');return false;"><i class="fa fa-arrow-down"></i></button>';
            }
            $start_date='';
            if($row['start_date']!='0000-00-00'){
                $start_date= date('d/m/Y', strtotime($row['start_date']));
            }
            $status = CustomerPlanDetails::getStatusName($row['policy_status']);
            $rowData[] = array($i,$row['policy_no'], $row['providerdetails']['provider_name'], $row['masplandetails']['plan_name'], $row['amount'], $payment_term, $row['tennure'],$row['annualized_premium'],$start_date,$status, '<div class="btn-wrap text-center">' . $div . '</div>');
            $i++;
        }

        $data['data'] = $rowData;
        echo json_encode($data);
    }

    /*     * ************************************* End Plan List ************************************************ */


    /*     * ******************* STRT Add Edit Plan Details ************************************************* */

    public function actionAddEditPlan() {


        $id = (int) Yii::app()->request->getParam('plan_id');
        $customer_id = (int) Yii::app()->request->getParam('customer_id');
        $modelPlanDetails = new CustomerPlanDetails();
        if ($id > 0) {
            $modelPlanDetails = $modelPlanDetails->findByPk($id);
            if($modelPlanDetails->start_date!='0000-00-00'){
                $modelPlanDetails->start_date   = date('d/m/Y', strtotime($modelPlanDetails->start_date));
            }else{
                 $modelPlanDetails->start_date   = '';
            }
            if($modelPlanDetails->issue_date!='0000-00-00'){
                $modelPlanDetails->issue_date   = date('d/m/Y', strtotime($modelPlanDetails->issue_date));
            }else{
                 $modelPlanDetails->issue_date   = '';
            }
            $modelPlanDetails->class_ids    = explode(',', $modelPlanDetails->class_ids);
            $modelPlanDetails->subclass_ids = explode(',', $modelPlanDetails->subclass_ids);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
        $this->render('add_edit_plan', array('modelPlanDetails' => $modelPlanDetails));
    }

    /*     * ******************* END Add Edit Plan Details ************************************************* */
    /*     * ******************* STRT Plan-ChangePayterm ************************************************* */

    public function actionPlanChangePayterm() {


        $id = (int) Yii::app()->request->getParam('plan_id');
        $customer_id = (int) Yii::app()->request->getParam('customer_id');
        $modelPlanDetails = new CustomerPlanDetails();
        if ($id > 0) {
            $modelPlanDetails = $modelPlanDetails->findByPk($id);
            if($modelPlanDetails->start_date!='0000-00-00'){
                $modelPlanDetails->start_date   = date('d/m/Y', strtotime($modelPlanDetails->start_date));
            }else{
                 $modelPlanDetails->start_date   = '';
            }
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
        $this->render('change_plan_payterm', array('modelPlanDetails' => $modelPlanDetails));
    }

    /*     * ******************* END Plan-ChangePayterm ************************************************* */
    
    /*     * ************ GET Payment List ********************************************************** */

    public function actionGetPaymentdetailslist() {
        $customer_id = (int) Yii::app()->request->getParam('customer_id');
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $model = new CustomerPaymentDetails();
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 'cus_plan_details.policy_no',
            2 => 'masplandetails.plan_name',
            3 => 't.payment_type',
            4 => 't.pay_date',
            5 => 't.pay_amount',
            6 => 't.status',
            7 => 't.id'
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];

        //$orderBy        = $filterColumn." ".$filterOrder;
        $orderBy = 't.id DESC';
        $condition = 't.customer_id=' . $customer_id;
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " AND (masplandetails.plan_name LIKE '%" . $searchString . "%' OR pay_amount LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('cus_plan_details', 'cus_plan_details.masplandetails')->count(array('condition' => $condition));
        $model = $model->with('cus_plan_details', 'cus_plan_details.masplandetails')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $i = 1;
        foreach ($model as $row) {
            $div = '';
            if($row['status']=='2'){
                $div .= '<button class="btn btn-primary btn-xs" title="Edit" onclick="addEditPaymentDetails(' . $row['id'] . ');return false;"><i class="fa fa-edit"></i></button>';
            }else{
                $div .= '<button class="btn btn-primary btn-xs" title="View" onclick="addEditPaymentDetails(' . $row['id'] . ');return false;"><i class="fa fa-eye"></i></button>';
            }
            if($row['status']=='3'){
                $div .= '&nbsp;<button class="btn btn-primary btn-xs" title="Add/Pay" onclick="addEditPaymentDetails(' . $row['id'] . ');return false;"><i class="fa fa-money"></i></button>';
            }
            $rowData[] = array($i, $row['cus_plan_details']['policy_no'],$row['cus_plan_details']['masplandetails']['plan_name'], CustomerPaymentDetails::getPaymentType($row['payment_type']),$row['ac_no'], date('d/m/Y', strtotime($row['pay_date'])), $row['installment_no'], '<div class="text-right">'.$row['pay_amount'].'</div>',CustomerPaymentDetails::getPaymentStatus($row['status']), '<div class="btn-wrap text-center">' . $div . '</div>',$row['status']);
            $i++;
        }

        $data['data'] = $rowData;
        echo json_encode($data);
    }

    /*     * ************************************* End Payment List ************************************************ */


    /*     * ******************* STRT Add Edit Payment Details ************************************************* */

    public function actionAddEditPayment() {


        $id = (int) Yii::app()->request->getParam('payment_id');
        $customer_id = (int) Yii::app()->request->getParam('customer_id');
        $modelPaymentDetails = new CustomerPaymentDetails();
        $model = new Customer();
        if($customer_id>0){
            $model = Customer::model()->findByPK($customer_id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
        if ($id > 0) {
            $modelPaymentDetails = $modelPaymentDetails->findByPk($id);
            $modelPaymentDetails->pay_date = date('d/m/Y', strtotime($modelPaymentDetails->pay_date));
            if($modelPaymentDetails->realization_date !="0000-00-00")
            $modelPaymentDetails->realization_date = date('d/m/Y', strtotime($modelPaymentDetails->realization_date));
            else {
                $modelPaymentDetails->realization_date = $modelPaymentDetails->pay_date ;           
            }
            if($modelPaymentDetails->expiry_date !="0000-00-00")
            $modelPaymentDetails->expiry_date = date('d/m/Y', strtotime($modelPaymentDetails->expiry_date));
            $modelPaymentDetails->installment_no = explode(',', $modelPaymentDetails->installment_no); 
            $this->render('edit_payment', array('modelPaymentDetails' => $modelPaymentDetails,'model'=>$model));
        }else{
            $this->render('add_edit_payment', array('modelPaymentDetails' => $modelPaymentDetails,'model'=>$model));
        }
        
    }

    /*     * ******************* END Add Edit Payment Details ************************************************* */

    /*     * ******************* START isUnique ************************************************* */

    public function actionisUnique() {
        $id = Yii::app()->request->getParam('id');
        $cust_mobile1 = Yii::app()->request->getParam('num');
        $cust_mobile1 = str_replace(' ', '', $cust_mobile1);
        $cust_mobile1 = str_replace('+', '', $cust_mobile1);
        $cust_mobile1 = str_replace('-', '', $cust_mobile1);
        $condition = " t.cust_mobile1 ='" . $cust_mobile1 . "' ";
        if ($id != "") {
            $condition .= " AND t.id !=" . $id;
        }
        $model = Customer::model()->findAll($condition);
        $data = array();
        if ($model == null) {
            $data["status"] = 'success';
        } else {
            $data["status"] = 'error';
            $data["name"] = $model[0]->cust_first_name . " " . $model[0]->cust_first_name;
            $data["id"] = $model[0]->id;
        }
        echo json_encode($data);
    }

    /*     * ******************* END isUnique ************************************************* */
    /*     * ******************* STRT get Plan Combo based on Provider ************************************************* */

    public function actiongetPlanComboProvider() {

        $provider_id = $_POST['provider_id'];
        $data = array();
        $arr_provider_plans=array();
        $modelPlan = new CustomerPlanDetails();
        if ($provider_id > 0) {
            $arr_provider_plans=MasProviderPlans::getPlansByProvider($provider_id);
        }
        $data["status"] = 'success';
        $data["div"] ='<li class="col-sm-3">';    
        $data["div"].=CHtml::activeDropdownList($modelPlan, 'plan_id',$arr_provider_plans, array('class' => 'tooltipster','onchange'=>'seticpvalue(this.value);', 'title' => 'Plan Name', 'empty' => '--Select--', 'data-label' => 'Plan Name <span style="color:red;">*</span>'));
        $data["div"].=' </li>';
        echo json_encode($data);
    }
    /*     * ******************* End get Plan Combo based on Provider ************************************************* */
    /*     * **************** START save Payment details ************************************************ */

    public function actionSavePaymentdetails() {
        date_default_timezone_set("Asia/Dubai");
        $modelPayDetails = new CustomerPaymentDetails();

        $id = $_POST['id'];
        $customer_id = $_POST['customer_id'];
        $status = $_POST['status'];
        $plan_id = $_POST['plan_id'];
        $amount = $_POST['amount'];
        $payment_type = $_POST['payment_type'];
        $bank_name   = $_POST['bank_name'];
        $ac_no = $_POST['ac_no'];
        $installment_no = $_POST['installment_no'];
        $pay_date = $_POST['pay_date'];
        $real_date= $_POST['real_date'];
        $expiry_date=$_POST['expiry_date'];
        if ($id > 0) {
            $modelPayDetails = $modelPayDetails->findByPk($id);
            $modelPayDetails->updated_by = Yii::app()->user->id;
            $modelPayDetails->updated_date_time = date('Y-m-d H:i:s');
            $modelPayDetails->status = $status;
        
        }else{            
            $modelPayDetails->status = '2';
            $modelPayDetails->created_by = Yii::app()->user->id;
            $modelPayDetails->created_date_time = date('Y-m-d H:i:s');
        }
        $modelPayDetails->customer_id = $customer_id;
        $modelPayDetails->cus_plan_id = $plan_id;
        $modelPayDetails->pay_amount = $amount;
        $modelPayDetails->payment_type = $payment_type;
        $modelPayDetails->bank_name = $bank_name;
        $modelPayDetails->installment_no = $installment_no;
        $modelPayDetails->pay_date = $pay_date;
        $modelPayDetails->ac_no = $ac_no;
        $modelPlan= CustomerPlanDetails::model()->findByPk($plan_id);
        $modelPayDetails->pay_term_id = $modelPlan->payment_term;
        
        if ($pay_date != '') {
            $modelPayDetails->pay_date = str_replace('/', '-', $pay_date);
            $modelPayDetails->pay_date = date("Y-m-d", strtotime($modelPayDetails->pay_date));
        }
        if ($real_date != '') {
            $modelPayDetails->realization_date = str_replace('/', '-', $real_date);
            $modelPayDetails->realization_date = date("Y-m-d", strtotime($modelPayDetails->realization_date));
        }else{
            $modelPayDetails->realization_date ='';
        }
        if ($expiry_date != '') {
            $modelPayDetails->expiry_date = str_replace('/', '-', $expiry_date);
            $modelPayDetails->expiry_date = date("Y-m-d", strtotime($modelPayDetails->expiry_date));
        }else{
            $modelPayDetails->expiry_date ='';
        }        
        $valid = $modelPayDetails->validate();

        if ($valid) {
            $modelPayDetails->save();
            $model_inst=CustomerPlanInstallments::model()->findAll(array('condition'=>'cus_plan_id='.$modelPayDetails->cus_plan_id.' AND installment_no IN ('.$modelPayDetails->installment_no.') AND (status="N" OR status="H")'));
            if(!empty($model_inst)){
                foreach ($model_inst as $each_inst){
                    if($modelPayDetails->status == '2'){
                        if($each_inst->status=='N'){
                            $status='H';
                            $date =$modelPayDetails->pay_date;
                            CustomerPlanInstallments::model()->updateByPk($each_inst->id, array('status' => $status,'cus_payment_id'=>$modelPayDetails->id,'paid_date'=>$date));
                    
                        }
                    }else if($modelPayDetails->status == '1'){
                        if($each_inst->status=='H'){
                            $status='P';                        
                            $date =$modelPayDetails->realization_date;
                            if($each_inst->cusplandetail->icp_months>12){
                                $this->defermentcalculation($each_inst->id,$modelPayDetails->id);
                            }
                            CustomerPlanInstallments::model()->updateByPk($each_inst->id, array('status' => $status,'cus_payment_id'=>$modelPayDetails->id,'paid_date'=>$date));
                        }
                    }else if($modelPayDetails->status == '3'){
                        $status='H';
                        $date =$modelPayDetails->pay_date;
                        CustomerPlanInstallments::model()->updateByPk($each_inst->id, array('status' => $status,'cus_payment_id'=>$modelPayDetails->id,'paid_date'=>$date));
                    }else if($modelPayDetails->status == '4'){
                        if($each_inst->status=='H'){
                            $status='C';                        
                            $date =$modelPayDetails->pay_date;
                            $cus_new_instal= new CustomerPlanInstallments();
                            $cus_new_instal->cus_plan_id=$each_inst->cus_plan_id;
                            $cus_new_instal->installment_no=$each_inst->installment_no;
                            $cus_new_instal->payment_term_id=$each_inst->payment_term_id;
                            $cus_new_instal->premium_amount=$each_inst->premium_amount;
                            $cus_new_instal->payment_due_date=$each_inst->payment_due_date;
                            $cus_new_instal->status='N';
                            $cus_new_instal->created_by=Yii::app()->user->id;
                            $cus_new_instal->created_date_time=date('Y-m-d H:i:s');
                            $cus_new_instal->save(false);
                            CustomerPlanInstallments::model()->updateByPk($each_inst->id, array('status' => $status,'cus_payment_id'=>$modelPayDetails->id,'paid_date'=>$date));
                        }
                    }            
                }
            }
            $jsonData['status'] = 'success';
            $jsonData['id'] = $modelPayDetails->id;
            echo CJSON::encode($jsonData);
        } else {
            $error1 = json_decode(CActiveForm::validate($modelPayDetails, '', false), true);
            $error = CJSON::encode($error1);
            if ($error != '[]')
                echo $error;
        }
    }

    /*     * ***************** END save payment details ********************************************* */
    ////savetoCommissionLedger-start
    public function defermentcalculation($installment_id,$cus_payment_id) {                       
        $model_installment              = CustomerPlanInstallments::model()->findByPk($installment_id);
        $model_cus_pay                  = CustomerPaymentDetails::model()->findByPk($cus_payment_id);
        $last_deferment_calculated_date = $model_installment->cusplandetail->last_deferment_date;
        $premium_due_date               = $model_installment->payment_due_date;
        $terms=12/$model_installment->cusplandetail->payterm_details->no_of_times;
        $premium_due_date_end = date("Y-m-d", strtotime("+".$terms." month", strtotime($model_installment->payment_due_date)));
        $model_installment_pending=CustomerPlanInstallments::model()->findAll(array('condition'=>'t.cus_plan_id='.$model_installment->cus_plan_id.' AND payment_due_date>="'.$last_deferment_calculated_date.'" AND payment_due_date<="'.$premium_due_date.'" AND (status="N" OR status="H")'));    
        $realization_date               = $model_cus_pay->realization_date;
        $ts1 = strtotime($last_deferment_calculated_date);
        $ts2 = strtotime($premium_due_date_end);
        $year1 = date('Y', $ts1);
        $year2 = date('Y', $ts2);
        $month1 = date('m', $ts1);
        $month2 = date('m', $ts2);
        $no_of_months_between = (($year2 - $year1) * 12) + ($month2 - $month1)+1;
        if($no_of_months_between>12 && empty($model_installment_pending)){
            $commission_model=CommissionLedger::model()->findAll(array('condition'=>'t.cus_plan_id='.$model_installment->cusplandetail->id.' AND (t.type= "EXE_DEF_COM" OR t.type="EXE_DEF_COM_RET") AND status="HOLD"','order'=>'t.id ASC'));
            $net_amount=0;
            $user_id=$model_installment->cusplandetail->customer->cust_executive_id;                    
            $provider_id=$model_installment->cusplandetail->provider_id;
            $customer_id=$model_installment->cusplandetail->customer_id;
            $mas_plan_id=  $model_installment->cusplandetail->plan_id;      
            if(!empty($commission_model)){
                foreach($commission_model as $each){
                    if($each->in_or_out=='IN'){
                        $total_amount+=$each->total_amount;
                        $net_amount+=$each->in_amount;
                    }else{
                        $net_amount-=$each->out_amount;
                        $total_amount-=$each->total_amount;
                    }
                    CommissionLedger::model()->updateByPk($each->id,array('status'=>'USED'));
                }
                //write to commision ledger transfer from def account to gen acc
                $scheme_id        = User::model()->findByPK($user_id)->commission_scheme_id;
                $mas_commission   = MasterCommissionSchemes::model()->findByPK($scheme_id);
                $percentage= $mas_commission->executive_commission_with_deferment;
                $desc='Executive Deferment Commission  for Policy No.'.$model_installment->cusplandetail->policy_no.' Calculated Upto '.$premium_due_date.' ('.$percentage.' % of '.$total_amount.')';
                $this->savetoCommissionLedger(0,$user_id,$model_installment->cusplandetail->id,$realization_date,$percentage,
                                            $total_amount,0,$net_amount,'EXE_DEF_COM',$desc,'OUT',
                                            'DEF',$provider_id,$customer_id,$mas_plan_id,'NA');
                $this->savetoCommissionLedger(0,$user_id,$model_installment->cusplandetail->id,$realization_date,$percentage,
                                            $total_amount,$net_amount,0,'EXE_DEF_COM',$desc,'IN',
                                            'GEN',$provider_id,$customer_id,$mas_plan_id,'NA');
                //update totals to executive
                $model_exe= User::model()->findbyPK($user_id);
                $account_balance=$model_exe->account_total_amount+$net_amount;
                $account_defer=$model_exe->account_deferement_amount-$net_amount;
                User::model()->updateByPK($user_id, array('account_total_amount' =>$account_balance,'account_deferement_amount' =>$account_defer,'updated_by'=>Yii::app()->user->id,'updated_date_time'=>date('Y-m-d H:i:s')));

                //update totals to user company
                $model_comp= User::model()->findbyPK(User::getCompany());
                $account_defer=$model_comp->account_deferement_amount-$net_amount;
                User::model()->updateByPK(User::getCompany(), array('account_deferement_amount' =>$account_defer,'updated_by'=>Yii::app()->user->id,'updated_date_time'=>date('Y-m-d H:i:s')));

            }
            CustomerPlanDetails::model()->updateByPk($model_installment->cusplandetail->id, array('last_deferment_date' => $premium_due_date,'last_deferment_date_previous' => $last_deferment_calculated_date));        

        }
        return true;
    }    
    //savetoCommissionLedger-end
    ////savetoCommissionLedger-start
    public function savetoCommissionLedger($id,$user_id,$cus_plan_id,$transaction_date,$percentage,
                                            $total_amount,$in_amount,$out_amount,$type,$desc,$in_or_out,
                                            $user_account,$provider_id,$customer_id,$mas_plan_id,$status) {
        $model_ledger = new CommissionLedger();
        $model_ledger->commision_upload_id=$id;
        $model_ledger->user_id=$user_id;
        $model_ledger->cus_plan_id=$cus_plan_id;
        $model_ledger->transaction_date=$transaction_date;
        $model_ledger->posted_date=date('Y-m-d');
        $model_ledger->percentage=$percentage;
        $model_ledger->total_amount=$total_amount;
        $model_ledger->in_or_out=$in_or_out;
        $model_ledger->in_amount=$in_amount;
        $model_ledger->out_amount=$out_amount;
        $model_ledger->type=$type;
        $model_ledger->description=$desc;
        $model_ledger->user_account=$user_account;
        $model_ledger->provider_id=$provider_id;
        $model_ledger->customer_id=$customer_id;
        $model_ledger->mas_plan_id=$mas_plan_id;
        $model_ledger->status=$status;        
        $model_ledger->created_by  =Yii::app()->user->id; 
        $model_ledger->created_date_time=date('Y-m-d H:i:s');
        $model_ledger->save(false);     
        return true;
    }    
    //savetoCommissionLedger-end
    /*     * ******************* STRT get Selected Plan Details ************************************************* */

    public function actionGetSelectedPlanDetails(){

        $plan_id = $_POST['plan_id'];
        $data = $arr_installments=$arr_ins=array();
        $modelPlan = new CustomerPlanDetails();
        if ($plan_id > 0) {
            $modelPlan=$modelPlan->findByPk($plan_id);
            $modelinstallment = CustomerPlanInstallments::model()->findAll(array('condition'=>'cus_plan_id='.$plan_id.'  AND status="N"','order'=>'installment_no ASC'));
            if(!empty($modelinstallment)){
                foreach($modelinstallment as $eachpay){
                    $arr_ins[]= $eachpay->installment_no;
                }
                $arr_installments=array_combine($arr_ins,$arr_ins);
            }          
        }
        $modelpay = new CustomerPaymentDetails();
        $data["ins"] =$arr_ins;    
        $data["tennure"] =$modelPlan->tennure;    
        $data["no_of_times"] =$modelPlan->payterm_details->no_of_times;    
        $data["total_installments"] =$total_installments;    
        $data["installment_no"] ='<li class="col-sm-2">';    
        $data["installment_no"].=CHtml::activeDropdownList($modelpay, 'installment_no',$arr_installments, array('class' => 'tooltipster', 'title' => 'Installments',  'data-label' => 'Installments <span style="color:red;">*</span>','onchange'=>'calculate_installmentamount();','multiple'=>TRUE));
        $data["installment_no"].=' </li>';
        $data["status"] = 'success';
        $data["amount"] =$modelPlan->amount;    
        echo json_encode($data);
    }
    /*     * ******************* End get Selected Plan Details ************************************************* */
    //Prospect to customer conversion
    public function actionConverttoCustomer() {
        $id= Yii::app()->request->getparam('id');
        $model_lead= LeadCustomer::model()->findbyPK($id);
        $model = new Customer();
        $modelPriorities = new CustomerPriorities();
        $modelDependants = new CustomerDependants();
        $modelPlanDetails = new CustomerPlanDetails();
        $modelPaymentDetails = new CustomerPaymentDetails();
        $modelDocument = new ActivityDocument();
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
        $this->render('create', array('model_lead' => $model_lead,
            'model' => $model,
            'modelDocument' => $modelDocument,
            'modelPriorities' => $modelPriorities,
            'modelDependants' => $modelDependants,
            'modelPlanDetails' => $modelPlanDetails,
            'modelPaymentDetails' => $modelPaymentDetails,), false, true);
    }
    //End
     //Check mobile number exist-Start
    public function actioncheckmobilenumberexist() {
        $tel_code=Yii::app()->request->getParam('tel_code');
        $mobile=Yii::app()->request->getParam('mobile');
        $id=Yii::app()->request->getParam('id');
        $mobile_number=$tel_code.''.$mobile;
        $current_date=  date('Y-m-d');
        $model_customer_policy_exist = Customer::model()->find(array('condition' =>'cust_mobile1="'.$mobile_number.'" and cust_policy_taken="Y"'));
        $model_customer_exist = Customer::model()->find(array('condition' =>'cust_mobile1="'.$mobile_number.'" and cust_policy_taken="N"'));
        $model_customer_check = Customer::model()->find(array('condition' =>'cust_mobile1="'.$mobile_number.'" and id="'.$id.'"'));
        $model_customer_check_1 = Customer::model()->find(array('condition' =>'cust_mobile1="'.$mobile_number.'"'));
        $executive_id=$model_customer_exist->cust_executive_id;
        $current_login_id=Yii::app()->user->id;
        $model_user_details= User::model()->findByPk(Yii::app()->user->id);
        if($model_user_details->consultant_edit=='N'){
            if(empty($model_customer_policy_exist) && empty($model_customer_exist)){
                $jsonData['status'] = 'success';
            }else if((!empty($model_customer_policy_exist)) && $executive_id!=$current_login_id){
                $jsonData['executive_name'] =$model_customer_policy_exist->executive->fullname;
                $jsonData['customer_name'] =$model_customer_policy_exist->Fullname;
                $jsonData['mobile'] =$model_customer_policy_exist->cust_mobile1;
                $jsonData['status'] = 'policyexist';
            }else if ((strtotime($current_date)<=strtotime($model_customer_exist->cust_locked_date)) && $executive_id!=$current_login_id) {
                $jsonData['executive_name'] =$model_customer_exist->executive->fullname;
                $jsonData['customer_name'] =$model_customer_exist->Fullname;
                $jsonData['mobile'] =$model_customer_exist->cust_mobile1;
                $jsonData['lockdate'] =date_format(date_create($model_customer_exist->cust_locked_date),'d/m/Y');
                $jsonData['status'] = 'locked';
            }else if ((strtotime($current_date)>strtotime($model_customer_exist->cust_locked_date)) && $executive_id!=$current_login_id && $model_customer_exist->cust_executive_change_request=="N") {
                $jsonData['executive_name'] =$model_customer_exist->executive->fullname;
                $jsonData['customer_name'] =$model_customer_exist->Fullname;
                $jsonData['mobile'] =$model_customer_exist->cust_mobile1;
                $jsonData['id'] =$model_customer_exist->id;
                $jsonData['lockdate'] =date_format(date_create($model_customer_exist->cust_locked_date),'d/m/Y');
                $jsonData['status'] = 'release';
            }else if ((strtotime($current_date)>strtotime($model_customer_exist->cust_locked_date)) && $executive_id!=$current_login_id && $model_customer_exist->cust_executive_change_request=="Y") {
                $jsonData['executive_name'] =$model_customer_exist->executive->fullname;
                $jsonData['customer_name'] =$model_customer_exist->Fullname;
                $jsonData['mobile'] =$model_customer_exist->cust_mobile1;
                $jsonData['status'] = 'changerequest';
            }else if(!empty ($model_customer_check) && $id>0){
                $jsonData['status'] = 'sameexecutiveediting';
            }else if(!empty ($model_customer_check_1) ){
                $jsonData['status'] = 'sameexecutiveaddnew';
            }
        }else{
            $jsonData['status'] = 'success';
        }
        echo CJSON::encode($jsonData);
    }
    //Check mobile number exist-End
    public function actionChangeexecutveRequest() {
        $id=Yii::app()->request->getParam('id');
        $model = new ExecutiveRequest();
        $model_customer= Customer::model()->findbyPK($id);
        $model->customer_id =$model_customer->id;
        $model->executive_id =$model_customer->cust_executive_id;
        $model->request_executive_id =Yii::app()->user->id;
        $model->last_locked_date=$model_customer->cust_locked_date;
        $model->created_by = Yii::app()->user->id;
        $model->created_date_time = date('Y-m-d h:i:s');
        $model->save();
        Customer::model()->updateByPK($id, array('cust_executive_change_request' =>'Y'));
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
            
    }
    /*     * ******************* STRT Add Edit Payment Details ************************************************* */

    public function actionCopyLastPayment() {
        $customer_id = (int) Yii::app()->request->getParam('customer_id');
        $modelPaymentDetails = new CustomerPaymentDetails();
        $model = new Customer();
        if($customer_id>0){
            $model = Customer::model()->findByPK($customer_id);
            $modellastPaymentDetails = $modelPaymentDetails->find(array('condition'=>'customer_id="'.$customer_id.'"','order'=>'id DESC'));
            $modelprevPlan= CustomerPlanDetails::model()->with('payterm_details')->findByPk($modellastPaymentDetails->cus_plan_id);
            $modelPaymentDetails->payment_type=$modellastPaymentDetails->payment_type;
            $modelPaymentDetails->customer_id=$modellastPaymentDetails->customer_id;
            $modelPaymentDetails->pay_amount=$modellastPaymentDetails->pay_amount;
            $modelPaymentDetails->bank_name=$modellastPaymentDetails->bank_name;
            $modelPaymentDetails->ac_no=$modellastPaymentDetails->ac_no+1;
            if($modellastPaymentDetails->status==3 || $modellastPaymentDetails->status==4){
                $modelPaymentDetails->installment_no=$modellastPaymentDetails->installment_no;
            }else{
                $modelPaymentDetails->installment_no=$modellastPaymentDetails->installment_no+1;
            }
            $modelPaymentDetails->cus_plan_id=$modellastPaymentDetails->cus_plan_id;
            //$modelPaymentDetails->installment_no=$modellastPaymentDetails->installment_no+1;
            $terms=12/$modelprevPlan->payterm_details->no_of_times;
            $modelPaymentDetails->pay_date = date("d/m/Y", strtotime("+".$terms." month", strtotime($modellastPaymentDetails->pay_date)));
            $modelPaymentDetails->installment_no = explode(',', $modelPaymentDetails->installment_no);  
        }        
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
        $this->render('add_edit_payment', array('modelPaymentDetails' => $modelPaymentDetails,'model'=>$model));
    }

    /*     * ******************* END Add Edit Payment Details ************************************************* */
    /*     * ******************* Priority Details List-Start************************************************* */
    
    public function actiongetprioritydetails() {
        $id= Yii::app()->request->getparam("priority");
        $model=new CustomerPriorities();
        if($id>0){
            $model=$model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
        $this->render('customer_priority_details', array('modelPriorities' => $model));
                   
    }
    /*     * ******************* Priority Details List_end ************************************************* */
     //Start Document List
    public function actionGetDocumentList(){
        $model=new ActivityDocument();
        $draw    = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $customer_id= $_POST['customer_id'];
        $columns = array(
            0 =>'id',
            1 =>'document_name',
            2=>'created_by',
            3=>'created_date_time',
            4=>''
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy   = $filterColumn." ".$filterOrder;
        $condition = 't.customer_id="'.$customer_id.'" AND document_from="2"';               
        if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
        {
          $searchString = $_POST['search']['value'];
          $condition.=" AND (document_name LIKE '%".$searchString."%')";
        }
        $count = $model->count(array('condition'=>$condition));
        $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData=array();
        $m=1;
        foreach ($model as $row)
        {
            $button_string="";                  
            $created_datetime="";
            if($row['created_date_time']!='' && $row['created_date_time']!='0000-00-00 00:00:00'){
                $created_datetime=date("d/m/Y h:i:s a",strtotime($row->created_date_time));
            }
            
            //$button_string.= '<button class="btn btn-primary btn-xs" title="Edit" onclick="editdocumentdetails('.$row['id'] . ');return false;"><i class="fa fa-edit"></i></button>&nbsp;';       
            $button_string.= '<a href="?r=activity/downloaddocument&id='.$row['id'].'" title="Download Document" target="_blank" class="btn btn-primary btn-xs"><i class="fa fa-download"></i></a>&nbsp;';
            if($row->customerdetails->cust_executive_id!=Yii::app()->user->id){
                $button_string .=' <a href ="javascript:void(0);" class="btn btn-danger btn-xs" title="Delete Document" onclick="deletedocument(' . $row['id'] . ')"><i class="fa fa-trash-o "></i></a>' ;
            }
            $rowData[]=array($m,$row->documentname->document_name,$row['document_name'],$row->addedby->fullname,$created_datetime,$button_string);
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
     //End Document List
    public function actionsaveCustomerDocument() {        
        if (isset($_POST['ActivityDocument'])) {
            $model = new ActivityDocument();
            if ((int) @$_POST['ActivityDocument']['id'] > 0) {
                $model->id = (int) $_POST['ActivityDocument']['id'];
                $model = $model->findByPK($model->id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d h:i:s');
            }else{
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d h:i:s');
            }
            $model->attributes = $_POST['ActivityDocument'];
            $model->document_type = $_POST['ActivityDocument']['document_type'];
            $model->document_from = 2;
            if ($model->validate()) {
                $model->save();
                $jsonData['customer_id'] =$model->customer_id;
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    /*************save change in premium_amount*******************/
    /*     * ******************* STRT Plan-IncrementPlanInstallment ************************************************* */

    public function actionIncrementPlanInstallment() {


        $id = (int) Yii::app()->request->getParam('plan_id');
        $customer_id = (int) Yii::app()->request->getParam('customer_id');
        $modelPlanDetails = new CustomerPlanDetails();
        if ($id > 0) {
            $modelPlanDetails = $modelPlanDetails->findByPk($id);
            if($modelPlanDetails->start_date!='0000-00-00'){
                $modelPlanDetails->start_date   = date('d/m/Y', strtotime($modelPlanDetails->start_date));
            }else{
                 $modelPlanDetails->start_date   = '';
            }
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
        $this->render('increment_plan_installment', array('modelPlanDetails' => $modelPlanDetails));
    }

    /*     * ******************* END Plan-IncrementPlanInstallment ************************************************* */
    /*     * ******************* STRT Plan-DecrementPlanInstallment ************************************************* */

    public function actionDecrementPlanInstallment() {


        $id = (int) Yii::app()->request->getParam('plan_id');
        $customer_id = (int) Yii::app()->request->getParam('customer_id');
        $modelPlanDetails = new CustomerPlanDetails();
        if ($id > 0) {
            $modelPlanDetails = $modelPlanDetails->findByPk($id);
            if($modelPlanDetails->start_date!='0000-00-00'){
                $modelPlanDetails->start_date   = date('d/m/Y', strtotime($modelPlanDetails->start_date));
            }else{
                 $modelPlanDetails->start_date   = '';
            }
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
        $this->render('decrement_plan_installment', array('modelPlanDetails' => $modelPlanDetails));
    }

    /*     * ******************* END Plan-DecrementPlanInstallment ************************************************* */
    public function actionGetPremiumDateFromInstallment(){
        $plan_id        = $_POST['plan_id'];
        $ins_no         = $_POST['ins_no'];
        $other_error    = array();
        $model_ins = CustomerPlanInstallments::model()->find(array('condition'=>'cus_plan_id='.$plan_id.' AND installment_no='.$ins_no,'order'=>'payment_due_date Desc'));
        if(!empty($model_ins)){
            $jsonData['due_date'] = date('d/m/Y', strtotime($model_ins->payment_due_date));
            $jsonData['status'] = 'success';
            echo CJSON::encode($jsonData);
        }
        else{
            $other_error[] = 'Installment No not exists';
            $error = CJSON::encode(array_merge_recursive($other_error));
            if ($error != '[]')
                echo $error;
        }
        
    }
    public function actionSaveDecremetedPlan(){
        $plan_id        = $_POST['plan_id'];
        $dec_amount     = $_POST['dec_amount'];
        $amount         = $_POST['amount'];
        $inst_no        = $_POST['inst_no'];
        $other_error    = array();
        $modelPlan      = CustomerPlanDetails::model()->findByPk($plan_id);
        $new_premium    = $modelPlan->amount-$dec_amount;
        $mod_ins        = CustomerPlanInstallments::model()->findAll(array('condition'=>'cus_plan_id='.$plan_id.' AND installment_no >='.$inst_no.' AND (status ="H") ','order'=>'payment_due_date Desc'));
        $model_fromins  = CustomerPlanInstallments::model()->find(array('condition'=>'cus_plan_id='.$plan_id.' AND installment_no='.$ins_no,'order'=>'payment_due_date Desc'));
        if(empty($mod_ins)&&!empty($model_fromins)){
            $model_rem_inst=CustomerPlanInstallments::model()->findAll(array('condition'=>'cus_plan_id='.$plan_id.' AND installment_no >='.$inst_no.' AND (status ="N") ','order'=>'payment_due_date Desc'));
            if(!empty($model_rem_inst)){
                $old_inst_no=0;
                foreach($model_rem_inst as $each_installment){
                    if($old_inst_no!=$each_installment->installment_no){
                        $each_installment->premium_amount=$new_premium;
                        $each_installment->status='N';
                        $each_installment->updated_by=Yii::app()->user->id;
                        $each_installment->updated_date_time=date('Y-m-d H:i:s');
                        $each_installment->save(false);
                        $old_inst_no=$each_installment->installment_no;
                    }else{
                        $each_installment->deleteByPk($each_installment->id);
                    }
                }
                $modelPlan->amount =$new_premium;
                $modelPlan->save(false);
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            }else{
                 $other_error[] = 'No Remaining Payments are there for this plan';
                $error = CJSON::encode(array_merge_recursive($other_error));
                if ($error != '[]')
                    echo $error;
            }
            
        }else{
            if(empty($model_fromins))
            $other_error[] = 'Installment No not exists';
            if(empty($mod_ins))
            $other_error[] = 'Inprocess Payments are there for this plan. Please Cancel it Before Decrementing Premium';
            $error = CJSON::encode(array_merge_recursive($other_error));
            if ($error != '[]')
                echo $error;
        }
             
    }
    /*************save change in premium_amount*******************/
    /*************save change in premium_amount*******************/
    public function actionSaveIncremetedPlan(){
        $plan_id        = $_POST['plan_id'];
        $inc_amount     = $_POST['inc_amount'];
        $amount         = $_POST['amount'];
        $inst_no        = $_POST['inst_no'];
        $other_error    = array();
        $modelPlan      = CustomerPlanDetails::model()->findByPk($plan_id);
        $new_premium    = $modelPlan->amount+$inc_amount;
        $mod_ins        = CustomerPlanInstallments::model()->findAll(array('condition'=>'cus_plan_id='.$plan_id.' AND installment_no >='.$inst_no.'  AND (status ="H") ','order'=>'payment_due_date Desc'));
        $model_rem_inst = CustomerPlanInstallments::model()->findAll(array('condition'=>'cus_plan_id='.$plan_id.' AND installment_no >='.$inst_no.' AND (status ="N") ','order'=>'payment_due_date Desc'));
        if(!empty($mod_ins)|| !empty($model_rem_inst)){
            if(!empty($mod_ins)){
                foreach($mod_ins as $each_installment){
                    $modelPlanInstallment = new CustomerPlanInstallments();
                    $modelPlanInstallment->cus_plan_id=$modelPlan->id;
                    $modelPlanInstallment->installment_no=$each_installment->installment_no;
                    $modelPlanInstallment->payment_term_id=$each_installment->payment_term_id;
                    $modelPlanInstallment->premium_amount=$inc_amount;
                    $modelPlanInstallment->payment_due_date=$each_installment->payment_due_date;
                    $modelPlanInstallment->status='N';
                    $modelPlanInstallment->created_by=Yii::app()->user->id;
                    $modelPlanInstallment->created_date_time=date('Y-m-d H:i:s');
                    $modelPlanInstallment->save(false);
                }
            }
            if(!empty($model_rem_inst)){
                foreach($model_rem_inst as $each_installment){
                    $each_installment->premium_amount=$new_premium;
                    $each_installment->status='N';
                    $each_installment->updated_by=Yii::app()->user->id;
                    $each_installment->updated_date_time=date('Y-m-d H:i:s');
                    $each_installment->save(false);
                }
            }  
            $modelPlan->amount =$new_premium;
            $modelPlan->save(false);
                
            $jsonData['status'] = 'success';
            echo CJSON::encode($jsonData);
        }else{
            $other_error[] = 'No Remaining Payments are there for this plan';
            $error = CJSON::encode(array_merge_recursive($other_error));
            if ($error != '[]')
                echo $error;
        }
             
    }
    /*************save change in Payterm*******************/
    public function actionSavePlanPaytermDetails(){
        $plan_id        = $_POST['plan_id'];
        $payment_term   = $_POST['payment_term'];
        $arr_payment_term = explode('#',$_POST['payment_term']);
        $payment_term_id = $arr_payment_term[0];
        $payment_term_months = $arr_payment_term[1];
        $other_error=array();
        $modelPlan= CustomerPlanDetails::model()->findByPk($plan_id);
        if($modelPlan->payment_term !=$payment_term_id){
            $mod_ins = CustomerPlanInstallments::model()->find(array('condition'=>'cus_plan_id='.$plan_id.' AND (status ="H" OR status ="P") ','order'=>'payment_due_date Desc'));
            if(!empty($mod_ins)){
                $last_installment_date=$mod_ins->payment_due_date; 
                $last_installment_no = $mod_ins->installment_no;
                $add_mnth=(12/($modelPlan->annualized_premium/$mod_ins->premium_amount));        
            }else{
                $last_installment_date=$modelPlan->start_date; 
                $add_mnth=0;        
            }
            $next_installment_date = date("Y-m-d",strtotime(date("Y-m-d", strtotime($last_installment_date)) . " +".$add_mnth." months"));
            $policy_end_date    = date("Y-m-d",strtotime(date("Y-m-d", strtotime($modelPlan->start_date)) ." +".$modelPlan->tennure." year"));
            $ts1 = strtotime($next_installment_date);
            $ts2 = strtotime($policy_end_date);
            $year1 = date('Y', $ts1);
            $year2 = date('Y', $ts2);
            $month1 = date('m', $ts1);
            $month2 = date('m', $ts2);
            $no_of_months_remaining = (($year2 - $year1) * 12) + ($month2 - $month1);
            $next_installment_no=$last_installment_no+1;
            $new_premium=$modelPlan->annualized_premium/$payment_term_months;
            $remaining_installments= $no_of_months_remaining/(12/$payment_term_months);
            //update customer plan with newly added payment term and premium-start
            CustomerPlanDetails::model()->updateByPk($plan_id, array('amount' => $new_premium,'payment_term'=>$payment_term_id));
            //update customer plan with newly added payment term and premium-end 
            //update last policy installment as inactive-start
            $modelpolicyold= PolicyInstallmentDetails::model()->find(array('condition'=>'cus_plan_id='.$plan_id,'order'=>'id DESC'));
            $modelpolicyold->end_date=$last_installment_date;
            $modelpolicyold->isActive = 'N'; 
            $modelpolicyold->paid_installment_count = $last_installment_no; 
            $modelpolicyold->save(FALSE);
            //update last policy installment as inactive-end
            //add new policy installment-start
            $modelpolicy= new PolicyInstallmentDetails();
            $modelpolicy->total_installments  = $remaining_installments; 
            $modelpolicy->cus_plan_id  = $plan_id; 
            $modelpolicy->start_date  = $next_installment_date;  
            $modelpolicy->end_date    = $policy_end_date;
            $modelpolicy->isActive = 'Y'; 
            $modelpolicy->save(false);
            //add new policy installment-end
            //delete previous installment entries with status N
            CustomerPlanInstallments::model()->deleteAll('cus_plan_id=:refer_id AND status="N"', array(':refer_id' => $modelPlan->id));
            //added installment entries of plan
            $month_gap =(12/$payment_term_months);
            for($i=0;$i<((int)$remaining_installments);$i++){                
                if($i==0){
                    $due_date = $next_installment_date;
                }else{
                    $due_date = date("Y-m-d",strtotime(date("Y-m-d", strtotime($due_date)) . " +".$month_gap." months"));
                }
                $modelPlanInstallment = new CustomerPlanInstallments();
                $modelPlanInstallment->cus_plan_id=$modelPlan->id;
                $modelPlanInstallment->installment_no=$next_installment_no+$i;
                $modelPlanInstallment->payment_term_id=$payment_term_id;
                $modelPlanInstallment->premium_amount=$new_premium;
                $modelPlanInstallment->payment_due_date=$due_date;
                $modelPlanInstallment->status='N';
                $modelPlanInstallment->created_by=Yii::app()->user->id;
                $modelPlanInstallment->created_date_time=date('Y-m-d H:i:s');
                $modelPlanInstallment->save(false);
            }
            if($remaining_installments!=((int)$remaining_installments)){
                $last_premium=($remaining_installments-((int)$remaining_installments))*$new_premium;
                $last_due_date = date("Y-m-d",strtotime(date("Y-m-d", strtotime($due_date)) . " +".$month_gap." months"));                
                $modelPlanInstallment = new CustomerPlanInstallments();
                $modelPlanInstallment->cus_plan_id=$modelPlan->id;
                $modelPlanInstallment->installment_no=$next_installment_no+$i;
                $modelPlanInstallment->payment_term_id=$payment_term_id;
                $modelPlanInstallment->premium_amount=$last_premium;
                $modelPlanInstallment->payment_due_date=$last_due_date;
                $modelPlanInstallment->status='N';
                $modelPlanInstallment->created_by=Yii::app()->user->id;
                $modelPlanInstallment->created_date_time=date('Y-m-d H:i:s');
                $modelPlanInstallment->save(false);
            }
            //added installment changes to plan 
            $jsonData['status'] = 'success';
            echo CJSON::encode($jsonData);
        }else{
            $other_error[] = 'Payment Term Already Changed';
            $error = CJSON::encode(array_merge_recursive($other_error));
            if ($error != '[]')
                echo $error;
        }
    }
    /*************save change in Payterm end*******************/
    /*************= Payterm detal*******************/
    public function actionGetselectedpaytermDetails(){
        $plan_id        = $_POST['plan_id'];
        $payment_term   = $_POST['payment_term'];
        $arr_payment_term = explode('#',$_POST['payment_term']);
        $payment_term_id = $arr_payment_term[0];
        $payment_term_months = $arr_payment_term[1];
        $modelPlan= CustomerPlanDetails::model()->findByPk($plan_id);
        $mod_ins = CustomerPlanInstallments::model()->find(array('condition'=>'cus_plan_id='.$plan_id.' AND (status ="H" OR status ="P") ','order'=>'payment_due_date Desc'));
        if(!empty($mod_ins)){
            $last_installment_date=$mod_ins->payment_due_date; 
            $last_installment_no = $mod_ins->installment_no;
            $add_mnth=(12/($modelPlan->annualized_premium/$mod_ins->premium_amount));        
        }else{
            $last_installment_date=$modelPlan->start_date; 
            $add_mnth=0;        
        }
        $next_installment_date = date("Y-m-d",strtotime(date("Y-m-d", strtotime($last_installment_date)) . " +".$add_mnth." months"));
        $policy_end_date    = date("Y-m-d",strtotime(date("Y-m-d", strtotime($modelPlan->start_date)) ." +".$modelPlan->tennure." year"));
        $ts1 = strtotime($next_installment_date);
        $ts2 = strtotime($policy_end_date);
        $year1 = date('Y', $ts1);
        $year2 = date('Y', $ts2);
        $month1 = date('m', $ts1);
        $month2 = date('m', $ts2);
        $no_of_months_remaining = (($year2 - $year1) * 12) + ($month2 - $month1);
        $next_installment_no=$last_installment_no+1;
        $new_premium=$modelPlan->annualized_premium/$payment_term_months;
        $remaining_installments= $no_of_months_remaining/(12/$payment_term_months);
        $jsonData['message'] ='USD '.$new_premium.' is due on '.$next_installment_date.'(Installment is No('.$next_installment_no.'). Remaining Installments  -'.$remaining_installments;
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
    }
    /*************save change in Payterm*******************/
    /************ Start GetSelectedInstallmentAmount ***********/
    public function actionGetSelectedInstallmentAmount() {
        $plan_id            = $_POST['plan_id'];
        $installment_no     = $_POST['installment_no']; 
        $amount             = 0;
        $model_installment  = CustomerPlanInstallments::model()->findAll(array('condition'=>'t.cus_plan_id ='.$plan_id.' AND t.installment_no IN ('.$installment_no.') AND t.status="N"','order'=>'t.id DESC'));
        foreach($model_installment as $each){
            $amount +=$each->premium_amount;
        }
        $jsonData['amount'] = $amount;
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
    }
     /*     * ******************* STaRT View Plan Details ************************************************* */

    public function actionViewplanDetails() {


        $id = (int) Yii::app()->request->getParam('plan_id');
        $customer_id = (int) Yii::app()->request->getParam('customer_id');
        $modelPlanDetails = new CustomerPlanDetails();
        if ($id > 0) {
            $modelPlanDetails = $modelPlanDetails->findByPk($id);
            if($modelPlanDetails->start_date!='0000-00-00'){
                $modelPlanDetails->start_date   = date('d/m/Y', strtotime($modelPlanDetails->start_date));
            }else{
                 $modelPlanDetails->start_date   = '';
            }
            if($modelPlanDetails->issue_date!='0000-00-00'){
                $modelPlanDetails->issue_date   = date('d/m/Y', strtotime($modelPlanDetails->issue_date));
            }else{
                 $modelPlanDetails->issue_date   = '';
            }
            $modelPlanDetails->class_ids    = explode(',', $modelPlanDetails->class_ids);
            $modelPlanDetails->subclass_ids = explode(',', $modelPlanDetails->subclass_ids);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
        $this->render('view_plan', array('modelPlanDetails' => $modelPlanDetails));
    }

    /*     * ******************* END View Plan Details ************************************************* */
    /*     * ******************* STaRT Update Plan Details ************************************************* */

    public function actionUpdatePlandetails() {
        $id = (int) Yii::app()->request->getParam('plan_id');
        $customer_id = (int) Yii::app()->request->getParam('customer_id');
        $modelPlanDetails = new CustomerPlanDetails();
        if ($id > 0) {
            $modelPlanDetails = $modelPlanDetails->findByPk($id);
            if($modelPlanDetails->start_date!='0000-00-00'){
                $modelPlanDetails->start_date   = date('d/m/Y', strtotime($modelPlanDetails->start_date));
            }else{
                 $modelPlanDetails->start_date   = '';
            }
            if($modelPlanDetails->issue_date!='0000-00-00'){
                $modelPlanDetails->issue_date   = date('d/m/Y', strtotime($modelPlanDetails->issue_date));
            }else{
                 $modelPlanDetails->issue_date   = '';
            }
            $modelPlanDetails->class_ids    = explode(',', $modelPlanDetails->class_ids);
            $modelPlanDetails->subclass_ids = explode(',', $modelPlanDetails->subclass_ids);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
        $this->render('update_plan_details', array('modelPlanDetails' => $modelPlanDetails));
    }
    public function actionupdatePlan() {
        $id = $_POST['id'];
        $status = $_POST['status'];
        $reason = $_POST['reason'];
        $icp_month = $_POST['icp_month'];
        CustomerPlanDetails::model()->updateByPK($id, array('icp_months' =>$icp_month,'reason'=>$reason,'policy_status'=>$status));
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
    }

    /*     * ******************* END Update Plan Details ************************************************* */
    public function actionSaveCustomerdetails() {
        if ((isset($_POST['CustomerOtherDetails'])) && ($_POST['CustomerOtherDetails'][0]['loan_type']!='')){ 
            $valid=true;
            foreach ($_POST['CustomerOtherDetails'] as $i => $items) {
                if($items['id']>0){
                    $model_details[$i] = CustomerOtherDetails::model()->findByPK($items['id']);   
                }else{
                    $model_details[$i] = new CustomerOtherDetails();   
                }   
                $model_details[$i]->loan_type = $items['loan_type'];
                $model_details[$i]->customer_id = $_POST['Customer']['id'];
                $model_details[$i]->note = $items['note'];
                if ($items['expiry_date'] != '' && $items['expiry_date'] != '0000-00-00') {
                    $items['expiry_date'] = str_replace('/', '-', $items['expiry_date']);
                    $model_details[$i]->expiry_date = date("Y-m-d", strtotime($items['expiry_date']));      
                }
                $valid=$model_details[$i]->validate() && $valid; 
            }
            if($valid){
                if (!empty($model_details)) {
                    foreach ($model_details as $eachModel) {
                        $eachModel->save();
                    }
                }
                $jsonData['status'] = 'success';
                $jsonData['id'] = $_POST['Customer']['id'];
                $model = Customer::model()->findByPk($_POST['Customer']['id']);
                $jsonData['first_name'] = $model->cust_first_name;
                $jsonData['middle_name'] = $model->cust_middle_name;
                $jsonData['last_name'] = $model->cust_last_name;
                echo CJSON::encode($jsonData);
            }else{
                $error = json_decode(CActiveForm::validateTabular($model_details, '', false), true);
                $error = CJSON::encode($error);
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    public function actionGetCustomerList() {
        $_POST = filter_input_array(INPUT_POST, FILTER_SANITIZE_STRING);
        if (count($_POST) > 0) { 
        
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $status = $_POST['status'];
        $policy_taken = $_POST['policy_taken'];
        $model = new Customer();
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'cust_first_name',
            2 => 'customer_address',
            3 => 'customer_city',
            4 => 'customer_phone_no',
            5 => 'cust_email1',
           
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;

        //$orderBy = "t.cust_first_name ASC";
        $current_date=date('Y-m-d'); 
        /******** First Loading Without Search********/
        $condition = 'isActive="Y" AND (cust_executive_id="'.Yii::app()->user->id.'" OR cust_executive_id IN ('.Yii::app()->user->connected_users.'))';
        
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $policy_search='';
            $SCOUNT ="Select GROUP_CONCAT(t.id) AS p_id from crm_customer t 
		        left join crm_mas_emirates e on(t.cust_emirate_id=e.id) 
		        left join crm_mas_country c on(t.cust_nationality_id=c.id)
		        left join crm_customer_plan_details a on(t.id=a.customer_id) 
		        where a.policy_no LIKE '%" . $searchString . "%'";  
		    $p_id_array= Yii::app()->db->createCommand($SCOUNT)->queryRow();
		    $p_ids= $p_id_array['p_id'];
		    if($p_ids!=''){
		        	$policy_search=' OR (id IN ('.$p_ids.'))';
		    }
            $condition = "isActive='Y' AND 
                            (((cust_executive_id='".Yii::app()->user->id."' OR cust_executive_id IN (".Yii::app()->user->connected_users."))
                                AND (cust_first_name LIKE '%" . $searchString . "%' 
                                OR cust_middle_name LIKE '%" . $searchString . "%'
                                OR cust_last_name LIKE '%" . $searchString . "%' OR id LIKE '%" . $searchString . "%' 
                                OR cust_phone_no LIKE '%" . $searchString . "%' 
                                OR cust_mobile1 LIKE '%" . $searchString . "%' 
                                OR cust_email1 LIKE '%" . $searchString . "%'
                                ".$policy_search." )
                             )OR(cust_mobile1 = '" . $searchString . "' AND cust_policy_taken='N' AND cust_locked_date<'".$current_date."')
                            )";
                            //echo $condition;
        }
        if($status>0){
            $condition.= ' AND cust_status="'.$status.'"';
        }
        if($policy_taken!=''){
            $condition.= ' AND cust_policy_taken="'.$policy_taken.'"';
        }        
        /*$sql_activity ="CREATE OR REPLACE VIEW view_customer_details AS select t.cust_first_name AS cust_first_name,t.cust_middle_name AS cust_middle_name,t.cust_last_name AS cust_last_name,
t.cust_mobile1 AS cust_mobile1,t.cust_phone_no as cust_phone_no,t.cust_executive_id AS cust_executive_id,t.id AS id,t.cust_date_of_birth as cust_date_of_birth,
t.cust_email1 AS cust_email1,t.cust_policy_taken AS cust_policy_taken,t.cust_locked_date AS cust_locked_date,
t.cust_status AS cust_status,t.isActive as isActive,GROUP_CONCAT(a.policy_no) as policy_no,e.emirate_name as emirate_name,c.country_name as nationality 
from crm_customer t 
left join crm_customer_plan_details a on(t.id=a.customer_id) 
left join crm_mas_emirates e on(t.cust_emirate_id=e.id) 
left join crm_mas_country c on(t.cust_nationality_id=c.id)
group By t.id";              
        Yii::app()->db->createCommand($sql_activity)->execute(); */
        /*$model=Yii::app()->db->createCommand("select * from view_customer_details where $condition order by cust_first_name asc")->queryAll();

        $count=count($model);*/
       // $count = $model->count(array('condition' => $condition));
        //$model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));

$sql_activity ="CREATE OR REPLACE VIEW view_customer_details AS select t.cust_first_name AS cust_first_name,t.cust_middle_name AS cust_middle_name,t.cust_last_name AS cust_last_name,
t.cust_mobile1 AS cust_mobile1,t.cust_phone_no as cust_phone_no,t.cust_executive_id AS cust_executive_id,t.id AS id,t.cust_date_of_birth as cust_date_of_birth,
t.cust_email1 AS cust_email1,t.cust_policy_taken AS cust_policy_taken,t.cust_locked_date AS cust_locked_date,
t.cust_status AS cust_status,t.isActive as isActive,e.emirate_name as emirate_name,c.country_name as nationality 
from crm_customer t 
left join crm_mas_emirates e on(t.cust_emirate_id=e.id) 
left join crm_mas_country c on(t.cust_nationality_id=c.id)
group By t.id";              
        Yii::app()->db->createCommand($sql_activity)->execute();
        $SQL_CNT = "SELECT COUNT(id) FROM view_customer_details WHERE ".$condition;
        $count=Yii::app()->db->createCommand($SQL_CNT)->queryScalar();
        $SQL = "SELECT * FROM view_customer_details WHERE $condition ORDER BY cust_first_name ASC LIMIT $offset,$limit";
        //echo $SQL;
        //exit;
        $model=Yii::app()->db->createCommand($SQL)->queryAll();

        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m=1;
        $connected_user=  explode(',', Yii::app()->user->connected_users);
        foreach ($model as $row) {
            $dob = $row['cust_date_of_birth'];
            $age = (date('Y') - date('Y', strtotime($dob)));
            $div='';
            if(Yii::app()->user->id==$row['cust_executive_id'] || in_array($row['cust_executive_id'],$connected_user)){
                if(((int) Yii::app()->user->havePermissionOn["prospects_customers_edit"]) || $row['cust_policy_taken']=='N'){
                    $div.= '<button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'customer/create&id=' . $row['id'] . '\',\'' . $row['id'] . ' : ' . $row['cust_first_name'] . ' ' . $row['cust_middle_name'] . ' ' . $row['cust_last_name'] . '\',\'xl\')"><i class="fa fa-edit"></i></button>';
                }
                
                 if(!((int) Yii::app()->user->havePermissionOn["prospects_customers_edit"])){
                    $div.= '<button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'customer/create&frm=view&id=' . $row['id'] . '\',\'' . $row['id'] . ' : ' . $row['cust_first_name'] . ' ' . $row['cust_middle_name'] . ' ' . $row['cust_last_name'] . '\',\'xl\')"><i class="fa fa-eye"></i></button>';
                }
                
                $div .= ' <a  href="?r=reportpdf/customerdetails&id=' . $row['id'] . '" class="btn btn-primary btn-xs" title="Print Details" target="_blank"><i class="fa fa-file-pdf-o" aria-hidden="true"></i></a> ';
                //if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["customer_activity"])){
                $div .= ' <button class="btn btn-primary btn-xs" title ="Add Activity" onclick="loadPopupModal(\'activity/create&customer_id=' . $row['id'] . '\',\'' . $row['id'] . ' : ' . $row['cust_first_name'] . " " . $row['cust_middle_name'] . " " . $row['cust_last_name'] . ' - Activities ' . '\',\'xl\')"><i class="fa fa-certificate"></i></button>';
                //}
//                if(((int) Yii::app()->user->havePermissionOn["prospects_customers_send_view"])){
//                $div .= ' <button class="btn btn-primary btn-xs" title ="Send Info Provider" onclick="loadPopupModal(\'providerinfo/createsend&customer_id=' . $row['id'] . '\',\'' . $row['fullname'] . ' - Send Info Provider ' . '\',\'xl\')"><i class="fa fa-hand-o-right"></i></button>';
//                }
//                if(((int) Yii::app()->user->havePermissionOn["prospects_customers_receive_view"])){
//                $div .= ' <button class="btn btn-primary btn-xs" title ="Information from Provider" onclick="loadPopupModal(\'providerinfo/createreceive&customer_id=' . $row['id'] . '\',\'' . $row['fullname'] . ' - Information from Provider ' . '\',\'xl\')"><i class="fa fa-arrow-circle-o-left"></i></button>';
//                }
            }else if(($row->cust_locked_date<$current_date) && (Yii::app()->user->id!=$row['cust_executive_id']) && $row->cust_executive_change_request=="N"){
                $div= '<button class="btn btn-primary btn-xs" title="Activity Details" onclick="loadPopupModal(\'executive/activity&customer_id=' . $row['id'] . '&executive=' . $row['cust_executive_id'] . '\',\'Activity\',\'lg\')"><i class="fa fa-certificate"></i></button>&nbsp;';   
                $div .=' <a href ="javascript:void(0);" class="btn btn-primary btn-xs" title="Request For Executive Change" onclick="changerequest(' . $row['id'] . ')"><i class="fa fa-share"></i></a>' ;
            }else if($row->cust_executive_change_request=="Y"){
                $div= '<button class="btn btn-primary btn-xs" title="Activity Details" onclick="loadPopupModal(\'executive/activity&customer_id=' . $row['id'] . '&executive=' . $row['cust_executive_id'] . '\',\'Activity\',\'lg\')"><i class="fa fa-certificate"></i></button>&nbsp;';   
                $div .='Change Request sent';
            }
            $current_date_time=date("Y-m-d H:i");
            $call_back_or_actual_date='';
            $model_activity = Activity::model()->find(array('condition' =>'type_of_activity="1" and customer_id="'.$row['id'].'" and call_back_or_actual_date>"'.$current_date_time.'"','order'=>'call_back_or_actual_date asc'));
            if($model_activity->call_back_or_actual_date!='' && $model_activity->call_back_or_actual_date!='0000-00-00 00:00:00'){
                $call_back_or_actual_date=date("d/m/Y H:i",strtotime($model_activity->call_back_or_actual_date));
            }
            //$customer_code='GR-'.$row['id'];
            $rowData[] = array('<div class="text-center">' . $row['id'] . '</div>', $row['cust_first_name'] . " " . $row['cust_middle_name'] . " " . $row['cust_last_name'], $row['cust_mobile1'], $row['cust_email1'], $age, $row['emirate_name'], $row['nationality'],$call_back_or_actual_date ,'<div class="btn-wrap text-center">' . $div . '</div>',$row['cust_status'],$row['cust_policy_taken']);
            $m++;
        }

        $data['data'] = $rowData;
        echo json_encode($data);
        }else{
            $this->renderPartial('../index_error');
        }
    }
    
     public function actionIndexNew() {
        $this->render('index1');
    }
    
    public function actionGetCustomerListNew() {
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $status = $_POST['status'];
        $policy_taken = $_POST['policy_taken'];
        $model = new Customer();
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'cust_first_name',
            2 => 'customer_address',
            3 => 'customer_city',
            4 => 'customer_phone_no',
            
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;

        //$orderBy = "t.cust_first_name ASC";
        $current_date=date('Y-m-d'); 
        /******** First Loading Without Search********/
        //$condition = 't.isActive="Y" AND (cust_executive_id="'.Yii::app()->user->id.'" OR cust_executive_id IN ('.Yii::app()->user->connected_users.'))';
        $condition = 't.isActive="Y" AND (cust_executive_id="'.Yii::app()->user->id.'")';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
           /* $condition = "t.isActive='Y' AND 
                            (((t.cust_executive_id='".Yii::app()->user->id."' OR cust_executive_id IN (".Yii::app()->user->connected_users."))
                                AND ( t.cust_first_name LIKE '%" . $searchString . "%' 
                                OR t.cust_middle_name LIKE '%" . $searchString . "%'
                                OR t.cust_last_name LIKE '%" . $searchString . "%' OR t.id LIKE '%" . $searchString . "%' 
                                OR t.cust_phone_no LIKE '%" . $searchString . "%' 
                                OR t.cust_mobile1 LIKE '%" . $searchString . "%' OR t.cust_email1 LIKE '%" . $searchString . "%' OR t.id LIKE '%" . $searchString . "%' OR plandetails.policy_no LIKE '%" . $searchString . "%')
                             )OR(t.cust_mobile1 = '" . $searchString . "' AND cust_policy_taken='N' AND cust_locked_date<'".$current_date."')
                            )";*/
        }
        if($status>0){
            $condition.= ' AND t.cust_status="'.$status.'"';
        }
        if($policy_taken!=''){
            $condition.= ' AND t.cust_policy_taken="'.$policy_taken.'"';
        }        
        /*$count = $model->with('plandetails')->count(array('condition' => $condition));
        $model = $model->with('plandetails')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));*/
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m=1;
        $connected_user=  explode(',', Yii::app()->user->connected_users);
        foreach ($model as $row) {
            $dob = $row['cust_date_of_birth'];
            $age = (date('Y') - date('Y', strtotime($dob)));
            $div='';
           /* if(Yii::app()->user->id==$row['cust_executive_id']/* || in_array($row['cust_executive_id'],$connected_user)){
                if(((int) Yii::app()->user->havePermissionOn["prospects_customers_edit"])){
                    $div.= '<button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'customer/create&id=' . $row['id'] . '\',\'' . $row['id'] . ' : ' . $row['cust_first_name'] . ' ' . $row['cust_middle_name'] . ' ' . $row['cust_last_name'] . '\',\'xl\')"><i class="fa fa-edit"></i></button>';
                }
                $div .= ' <a  href="?r=reportpdf/customerdetails&id=' . $row['id'] . '" class="btn btn-primary btn-xs" title="Print Details" target="_blank"><i class="fa fa-file-pdf-o" aria-hidden="true"></i></a> ';
                $div .= ' <button class="btn btn-primary btn-xs" title ="Add Activity" onclick="loadPopupModal(\'activity/create&customer_id=' . $row['id'] . '\',\'' . $row['id'] . ' : ' . $row['cust_first_name'] . " " . $row['cust_middle_name'] . " " . $row['cust_last_name'] . ' - Activities ' . '\',\'xl\')"><i class="fa fa-certificate"></i></button>';
            }else if(($row->cust_locked_date<$current_date) && (Yii::app()->user->id!=$row['cust_executive_id']) && $row->cust_executive_change_request=="N"){
                $div= '<button class="btn btn-primary btn-xs" title="Activity Details" onclick="loadPopupModal(\'executive/activity&customer_id=' . $row['id'] . '&executive=' . $row['cust_executive_id'] . '\',\'Activity\',\'lg\')"><i class="fa fa-certificate"></i></button>&nbsp;';   
                $div .=' <a href ="javascript:void(0);" class="btn btn-primary btn-xs" title="Request For Executive Change" onclick="changerequest(' . $row['id'] . ')"><i class="fa fa-share"></i></a>' ;
            }else if($row->cust_executive_change_request=="Y"){
                $div= '<button class="btn btn-primary btn-xs" title="Activity Details" onclick="loadPopupModal(\'executive/activity&customer_id=' . $row['id'] . '&executive=' . $row['cust_executive_id'] . '\',\'Activity\',\'lg\')"><i class="fa fa-certificate"></i></button>&nbsp;';   
                $div .='Change Request sent';
            }*/
            $current_date_time=date("Y-m-d H:i");
            $call_back_or_actual_date='';
            /*$model_activity = Activity::model()->find(array('condition' =>'type_of_activity="1" and customer_id="'.$row['id'].'" and call_back_or_actual_date>"'.$current_date_time.'"','order'=>'call_back_or_actual_date asc'));
            if($model_activity->call_back_or_actual_date!='' && $model_activity->call_back_or_actual_date!='0000-00-00 00:00:00'){
                $call_back_or_actual_date=date("d/m/Y H:i",strtotime($model_activity->call_back_or_actual_date));
            }*/
            $rowData[] = array('<div class="text-center">' . $row['id'] . '</div>', $row['cust_first_name'] . " " . $row['cust_middle_name'] . " " . $row['cust_last_name'], $row['cust_mobile1'], $row['cust_email1'], $age, $row['emirates']['emirate_name'], $row['nationality']['country_name'],$call_back_or_actual_date ,'<div class="btn-wrap text-center">' . $div . '</div>',$row->cust_status,$row->cust_policy_taken);
            $m++;
        }

        $data['data'] = $rowData;
        echo json_encode($data);
    }

}