<?php

class ColourschemeController extends Controller{
    public function init() {
        parent::init();
        $this->initAjaxCsrfToken();
    }
 
    // this function will work to post csrf token.
    protected function initAjaxCsrfToken() {
 
        Yii::app()->clientScript->registerScript('AjaxCsrfToken', ' $.ajaxSetup({
                         data: {"' . Yii::app()->request->csrfToken . '": "' . Yii::app()->request->csrfToken . '"},
                         cache:false
                    });', CClientScript::POS_HEAD);
    }
        public function accessRules() {
        return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                    'actions' => array('login', 'error', 'logout'),
                    'users' => array('*'),
                    ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                    'actions' => array('Index','Create','Save','GetList'),
                    'expression' => '$user->isMember()',
                    ),
                array('deny', // deny all users
                    'users' => array('*'),
                    ),
                );
         }
    
        public function filters()
        {
        return array(
            'accessControl', // perform access control for CRUD operations
            );
        }
        
        public function actionIndex() {
            $_GET  = filter_input_array(INPUT_GET, FILTER_SANITIZE_STRING);
            //echo $_GET; exit;
            if(count($_GET) > 0){
                $this->render('index');
            }else{
                $this->renderPartial('../index_error');
            }
        }
        public function actionGetList()
         {
            $_POST = filter_input_array(INPUT_POST, FILTER_SANITIZE_STRING);
            if (count($_POST) > 0) { 
            $model=new MasColourScheme();
                $draw    = $_POST['draw'];
                $offset = $_POST['start'];
                $limit  = $_POST['length'];
                $columns = array(
                // datatable column index  => database column name
                   0 => 'id',
                   1 => 'item',
                   2 => 'colour',
                   );
                $filterColumn = $columns[$_POST['order'][0]['column']];
                $filterOrder  = $_POST['order'][0]['dir'];
                $orderBy   = $filterColumn." ".$filterOrder;
                $condition = '1=1';
                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
                {
                  $searchString = $_POST['search']['value'];
                  $condition.=" and item LIKE '%".$searchString."%'";
                }
                $count = $model->count(array('condition'=>$condition));
                $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>'item'));
                $recordsTotal = $count;
                $recordsFiltered = $count;
                $data['draw'] = $draw;
                $data['recordsTotal'] = $recordsTotal;
                $data['recordsFiltered'] = $recordsFiltered;
                $rowData=array();
                $m=1;
                foreach ($model as $row)
                {
                    $div = '';
                    $div =   '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'colourscheme/create&id='.$row['id'].'\',\''.$row['item'].'\',\'md\')"><i class="fa fa-pencil"></i></button>';
                    $rowData[]=array($row['id'],$row['item'],$row['colour'],'<div class="btn-wrap text-center">'.$div.'</div>');
                    $m++;
                }
                $data['data'] = $rowData;
                echo json_encode($data);
            }else{
                $this->renderPartial('../index_error');
            }
    }
    public function actionCreate()
    {
        $model=new MasColourScheme(); 
        $id=(int) Yii::app()->request->getParam('id');
        if($id>0){
            $model=$model->findByPk($id);
        }
             Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('create', array('model' => $model), false, true);
    }
    public function actionSave()
        {
            $_POST  = filter_input_array(INPUT_POST, FILTER_SANITIZE_STRING);
        if(isset($_POST) && count($_POST) > 0){
            $model = new MasColourScheme();
            if (isset($_POST['MasColourScheme']))
            {
    		
    		if ((int) @$_POST['MasColourScheme']['id'] > 0)
                {
                    $id= (int) @$_POST['MasColourScheme']['id'];
                    $model=$model->findByPk($id); 
                }
                $model->attributes=$_POST['MasColourScheme'];
               
                if($model->save())
                {
                        $jsonData['status'] = 'success';
                        $jsonData['frm'] = $_POST['create'];
                        $jsonData['id'] = $model->id;
	                echo CJSON::encode($jsonData);
                      
                }
                else
                {
                        $error = CActiveForm::validate($model, '', false);
                        if ($error != '[]')
		               echo $error;
                }
              

            }
        }
        else{
            $this->renderPartial('../index_error');
       } 
    }
}