<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'user-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
    ));
?>
    <ul class="nav nav-tabs company-nav-tabs nav-tab-theme">
		<li class="active"><a href="#usertab1" data-toggle="tab">General</a></li>
		<li><a href="#employeetab2" data-toggle="tab" onclick="">Salary Details</a></li>
    </ul>
    <div class="tab-content">
        <div class="tab-pane active" id="usertab1">
            <ul class="clearfix form-ul material">
    		
                <?php if($model->id!=="")
                {
                $val="";    
                ?>
                <li class="col-sm-6">
                       <?php echo $form->passwordField($model, 'password',array('data-label'=>'Password *','value'=>$val)); ?>
                       <?php echo $form->error($model,'password'); ?>
                </li>
                <li class="col-sm-6">
                       <?php echo $form->passwordField($model, 'confirm_password',array('data-label'=>'Confirm Password *','value'=>$val)); ?>
                       <?php echo $form->error($model,'confirm_password'); ?>
                </li>
                <?php } ?>
               
            <?php echo $form->hiddenField($model,'id'); ?>

            </ul>
        </div>
        <div class="tab-pane" id="employeetab2" >
            <div id="sal_details">
                <ul class="clearfix form-ul material">
                    <li class="col-sm-4">
                        <?php echo $form->textField($model_employee, 'total_monthly_salary', array('data-label'=>'Monthly Salary','onkeypress'=>'return isNumberKey(event);','onkeyup'=>'calculateSalary(this.value);','onblur'=>'calculateSalary(this.value);')); ?>
                        <?php echo $form->error($model_employee, 'total_monthly_salary'); ?>
                    </li> 
                    <li class="col-sm-4">
                       <?php echo $form->textField($model_employee, 'salary_per_day', array('data-label'=>'Salary Per Day','readonly'=>true)); ?>
                       <?php echo $form->error($model_employee, 'salary_per_day'); ?>
                    </li> 
                    <li class="col-sm-4">
                       <?php echo $form->textField($model_employee, 'salary_per_hour', array('data-label'=>'Salary Per Hour','readonly'=>true)); ?>
                       <?php echo $form->error($model_employee, 'salary_per_hour'); ?>
                    </li>
                </ul>
            </div>
        </div>
      
    

<div class="modal-footer">
        <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
        <?php
                $url = Yii::app()->createUrl('Users/SaveUser');
                echo CHtml::ajaxSubmitButton('Save', $url, array(
                            'dataType' => 'json',
                            'type' => 'post',
                            'success' => 'function(data) {
                                    if(data.status=="success"){ 
                                    $("#loader").hide();
                                         t8.success("User Saved Successfully!");
                                         location.reload();
                                    } else { 
                                    $("#loader").hide();
                                         $.each(data, function(key, val) {
                                                $("#user-form #"+key+"_em_").text(val).show(); 
                                                t8.error(""+val+""); 
                                            }); 
                                    } 
                                    }',
                            'beforeSend' => 'function(){
                                $("#loader").show();
                                $("#user-form.company-save-btn").prop("disabled", true);
                                
                                $("#user-form.company-save-btn").addClass("btn_loding").removeClass("btn btn-primary"); $(".errorMessage").hide(); }'
                                
                    ), array('id' => 'mybtn' . rand(), 'class' => 'company-save-btn btn btn-theme'));
           
    ?>
    </div>
</div>
<?php $this->endWidget(); ?>
<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("calculateSalary",  "function calculateSalary(salary){

		var exchange_rate  = 1;
		var salary_per_day = (salary * 1 * 12)/365;
		
		var salary_per_hour = salary_per_day/8;
		$('#EmployeeDetails_salary_per_day').addClass('filled');
                $('#EmployeeDetails_salary_per_hour').addClass('filled');
		$('#EmployeeDetails_salary_per_day').val(salary_per_day.toFixed(2));
		$('#EmployeeDetails_salary_per_hour').val(salary_per_hour.toFixed(2));
   
};", CClientScript::POS_HEAD);?>



