<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'advertise-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
        ));
?>
<ul class="nav nav-tabs job-nav-tabs nav-tab-theme">
    <li class="nav-item">
        <a href="#feature_tab1" class="nav-link" data-toggle ="tab" id="company_link_2">
            Features
        </a>
    </li>
</ul>
<div id="feature_div">
    <?php
    $condition = "t.edition_id = " . $edition_id;
    $model_feature_array = ResearchPlanPicksFeature::model()->findAll(["condition" => $condition, "order" => "feature_name"]);
    ?>
    <table id="feature_table" style="width: 100%" class="table table-responsive table-primary contact-detail">
        <thead>
            <tr >
                <th>Feature</th>
                <th>Type</th>
                <th>Description</th>
                <th>Research Manager</th>
                <th>Sales person</th>
                <th class="text-center">
                    <a class="btn btn-sm btn-theme " href="javascript:void(0);" onclick="loadPopupModal('research/AddFeature&edition_id=<?= $edition_id ?>', 'Add New Feature', 'lg')">
                        <i class="fa fa-plus"></i>
                    </a>
                </th>
            </tr>
        </thead>
        <tbody>
            <?php
            foreach ($model_feature_array as $key => $model_feature) {
                //$model_feature = new ResearchPlanPicksFeature();
                ?>
                <tr id="tr-feature-<?= $model_feature->id ?>" >
                    <td>
                        <?php echo $form->hiddenField($model_feature, "[$key]id"); ?>
                        <?php echo $model_feature->feature_name ?>
                    </td>
                    <td>
                        <?php echo $model_feature->featuretype->feature_name ?>
                    </td>
                    <td>
                        <?php echo $model_feature->feature_description ?>
                    </td>
                    <td>
                        <?php echo $form->dropDownList($model_feature, "[$key]researchmanager", User::getAll(), ["class" => "form-control", "empty" => "select", 'onchange' => "updateFeatureDetail($key)"]) ?>
                    </td>
                    <td>
                        <?php echo $form->dropDownList($model_feature, "[$key]default_allocate_sales_person_id", User::getSalesPersons(), ["class" => "form-control", "empty" => "select", 'onchange' => "updateFeatureDetail($key)"]) ?>
                    </td>
                    <td class="text-center nw" style="display: flex" >
                        <a class="btn btn-sm btn-danger" href="javascript:void(0);" onclick="getEditiondata(<?= $model_feature->id ?>)">
                            <i class="fa fa-eye"></i>
                        </a>
                        &nbsp;
                        <a class="btn btn-sm btn-danger" onclick="removeFeature('<?= $model_feature->id ?>', this)" data-label="Remove Row" href="javascript:void(0);">
                            <i class="fa fa-times"></i>
                        </a>
                    </td>
                </tr>
                <?php
            }
            ?>
        </tbody>
    </table>
</div>
<?php
$this->endWidget();
?>
<script>
    function updateFeatureDetail(key) {
        var data = {
            id: $("#ResearchPlanPicksFeature_" + key + "_id").val(),
            researchmanager: $("#ResearchPlanPicksFeature_" + key + "_researchmanager").val(),
            sales_person_id: $("#ResearchPlanPicksFeature_" + key + "_default_allocate_sales_person_id").val(),
        };
        jQuery.ajax({
            dataType: 'json',
            type: 'POST',
            url: 'index.php?r=research/updatefeature',
            cache: false,
            data: data,
            success: function (data) {
                $("#loader").hide();
                if (data.status == "success") {
                    t8.success("Details Saved successfully!");
                    $("#platetype_close").click();
                    reloadTable("#tbl_index");
                } else {
                    $.each(data, function (key, val) {
                        $("#plate-type-form #" + key + "_em_").text(val).show();
                        t8.error("" + val + "");
                    });
                }
            },
            complete: function () {
                $("#loader").hide();
            },
            beforeSend: function () {
                $("#loader").show();
            }
        });
    }
</script>
<script>
    function removeFeature(id, evt) {
        var message = "Do you want to delete this?";
        if (confirm(message)) {
            jQuery.ajax({
                dataType: 'json',
                type: 'POST',
                url: 'index.php?r=research/deletefeature',
                cache: false,
                data: {id: id},
                success: function (data) {
                    $("#loader").hide();
                    if (data.status == "success") {
                        getFeature('');
                    } else {
                        t8.error(data.message);
                    }
                },
                complete: function () {
                    $("#loader").hide();
                },
                beforeSend: function () {
                    $("#loader").show();
                }
            });
        }
    }
</script>