<?php
	$form = $this->beginWidget('CActiveForm', array(
		'id' => 'industry-form',
		'enableAjaxValidation' => false,
		'enableClientValidation' => false,
			));
?>
<!-- form start -->
<ul class="row clearfix form-ul material">
	<li class="col-sm-6">
		<label>Industry Name<span style="color:red;">*</span></label>
		<?php echo $form->hiddenField($model, 'id'); ?>
		<?php echo $form->textField($model, 'industry_name', array('class' => 'tooltipster', 'data-label' => 'Industry Name<span style="color:red;">*<span>')); ?>
		<?php echo $form->error($model, 'industry_name'); ?>
	</li>
	<li class="col-sm-6">
		<label>Description</label>
		<?php echo $form->textField($model, 'description', array('class' => 'tooltipster', 'data-label' => 'Description')); ?>
		<?php echo $form->error($model, 'description'); ?>
	</li>
</ul>

<div class="modal-footer">
    <button type="button" class="btn btn-danger" id="industry_close" data-dismiss="modal">Close</button>
    <?php
    	$url = Yii::app()->createUrl('masindustry/Save');
    	echo CHtml::ajaxSubmitButton('Save', $url, array(
        'dataType' => 'json',
        'type' => 'post',
        'success' => 'function(data) {
                                    if(data.status=="success"){
                                         t8.success("Industry Saved Successfully!");
                                          $("#industry_close").click();
                                         reloadTable("#tbl_industry");
                                    }
                                    else if(data.status=="failed"){
                                        t8.error("Industry is already Used Somewhere!");
                                       
                                   }
                                    else {
                                         $.each(data, function(key, val) {
                                                $("#industry-form #"+key+"_em_").text(val).show();
                                                t8.error(""+val+"");
                                            });
                                       }
                                       $("#industry-form .industry-form-save-btn").prop("disabled", false);
                                    }',
                                    'beforeSend' => 'function(){
                                        $("#industry-form .industry-form-save-btn").prop("disabled", true);
                                         $(".toast").hide();
                                    }',
     	), array('id' => 'mybtn' . rand(), 'class' => 'industry-form-save-btn btn btn-primary'));
	?>
</div>

<?php $this->endWidget(); ?>    