<script>
$(document).ready(function () {
    var table_id = "#feature_table";
    var table = $(table_id).on("preXhr.dt", function (e, settings, data) {
        data.display_type = $("#display_type").val();
        data.company_id = '<?php echo $company_id; ?>';
        data.company_type = '<?php echo $company_type; ?>';
        data.magazine_id = $("#magazine_id").val();
        data.edition_id = $("#edition_id").val();
        data.feature_id = $("#feature_id").val();
        return data;
    }).DataTable({
        pageLength: 50,
        processing: true,
        ajax: {
            url: "<?php echo Yii::app()->createUrl('company/GetFeatureList') ?>",
            type: "POST",
            cache: false,
        },
        serverSide: true,
        fixedColumns: true,
        // Disable search, entry list, and pagination
        searching: false,
        lengthChange: false,
        paging: false,
    });

    // To hide entry_list (info)
    $('.dataTables_info').hide();
    // Optionally, you can also hide the table summary (entries)
    $('.dataTables_length').hide();
});

</script>
<script type="text/javascript" src="https://cdn.rawgit.com/prashantchaudhary/ddslick/master/jquery.ddslick.min.js" ></script>
<section class="panel">
    <div class="card-body select-wrap">
        <div class="col-lg-12">
            <div class="form-group mt-10">
                <div class="row">
                    <div class="col-sm-4" id="research_magazines"></div>
                      <?php echo CHtml::hiddenField('magazine_id'); ?>
                    <div class="col-sm-4">
                        <div id="edition_div" class="editn-wrp">
                            <?php echo CHtml::dropDownList('edition_id', '', array(), array('data-label' => 'Select Edition', 'prompt' => 'Select Edition', 'class' => 'form-control select2','onchange' => 'getFeatureType(this.value)')); ?>
                        </div>
                    </div>
                    <div class="col-sm-4">
                        <div id="feature_div">
                            <?php echo CHtml::dropDownList('feature_id', '', array(), array('data-label' => 'Select Feature Type', 'prompt' => 'Select Feature Type', 'class' => 'form-control select2')); ?>    
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<div class="feature_table">
      <table class="table table-responsive table-primary tbl-scrolling" id="feature_table" width="100%">
    <thead>
        <tr>
            <th class="text-left">Sl NO</th>
            <th class="text-left">Magazine</th>
            <th class="text-left">Edition</th>
            <th class="text-left">Feature Type</th>
        </tr>
       
    </thead>
</table>  
</div>
<script>
   //Dropdown plugin data

    $('#research_magazines').ddslick({
        data:<?php echo $data; ?>,
        selectText: "Select Magazine",
        imagePosition: "left",
        onSelected: function (selectedData) {
            //callback function: do something with selectedData;

            var magazine_id = selectedData.selectedData.value.toString().trim();
            $('#magazine_id').val(magazine_id);
             getEdition(magazine_id);
             // Call the reloadTable function here
            reloadTable("#feature_table");
        }
    });
    
    $(document).ready(function() {
    $('.select2').select2({
    closeOnSelect: true
});
});
function getEdition(magazine_id) {
    jQuery.ajax({
        "data": "magazine_id=" + magazine_id,
        "type": "post",
        "dataType": "json",
        "url": "<?php echo Yii::app()->createUrl('company/GetEdition') ?>",
        "success": function (data) {
            if (data.status == 'success') {
                $('#edition_div').html(data.edition);
                reloadSelectBox();
            }

        },
    });
    }
     function getFeatureType(val) {
        var magazine_id = $('#magazineid').val();
        jQuery.ajax({
            "data": "magazine_id=" + magazine_id,
            "type": "post",
            "dataType": "json",
            "url": "<?php echo Yii::app()->createUrl('company/GetFeatureType') ?>",
            "success": function (data) {
                if (data.status == 'success') {
                    $('#feature_div').html(data.featuretype);
                    reloadSelectBox();
                }

            },
        });
    }
</script>