<?php
    $form = $this->beginWidget('CActiveForm', array(
        'id' => 'youtube-form',
        'enableAjaxValidation' => false,
        'enableClientValidation' => false,
            ));
?>
<!-- form start -->
<ul class="row clearfix form-ul material">
    <li class="col-sm-4">
        <label>Category<span style="color:red;">*</span></label>
            <?php echo $form->hiddenField($model, 'id'); ?>
        <?php echo $form->dropdownList($model, 'category_id', MasterCategory::getAll(),array('class' => 'form-control select2', 'data-label' => 'Category<span style="color:red;">*<span>','prompt'=>'--Select--')); ?>
        <?php echo $form->error($model, 'category_id'); ?>
        
    </li>
    <li class="col-sm-8">
        <label>YouTube Link<span style="color:red;">*</span></label>
        <?php echo $form->textarea($model, 'youtube_link' , array('class' => '', 'data-label' => 'YouTube Link<span style="color:red;">*<span>')); ?>
        <?php echo $form->error($model, 'youtube_link'); ?>
    </li>
    <li class="col-sm-3">
        <label>Launch Date<span style="color:red;">*</span></label>
        <?php 
        if (!empty($model->launch_date)) {
            $model->launch_date = DateModel::displayDate($model->launch_date, false);
        }
        else{
            $model->launch_date = date('Y-m-d');
             $model->launch_date = DateModel::displayDate($model->launch_date, false);
        }
        echo $form->textField($model, 'launch_date', array('class' => '', 'data-label' => 'Ediction<span style="color:red;">*<span>')); ?>
        <?php echo $form->error($model, 'launch_date'); ?>
    </li>
    <li class="col-sm-3">
        <label>App Icon</label>
        <?php
            $allowedExtensions = array("png", "jpg", "jpeg", "gif");
            $this->widget('ext.EAjaxUpload.EAjaxUpload', array(
                'id' => rand(),
                'config' => array(
                    'action' => Yii::app()->createUrl(Yii::app()->controller->id . '/FileUpload', array('folder' => 'uploads/youtubeicon')),
                    'multiple' => true,
                    'allowedExtensions' => $allowedExtensions,
                    'sizeLimit' => 20 * 1024 * 1024,
                    'onStart' => "js:function(){}",
                    'class' => 'pull-right',
                    'onComplete' => "js:function(id, fileName, responseJSON){ 
            var value = $('#app_icon').val();
            if(value == ''){
                 $('#upload_file_list').html(responseJSON.filename);
            }else{
                 var app_file = responseJSON.filename;
                 $('#upload_file_list').append(app_file);
            }
            
            var file_names = $('#upload_file_list').html();
            $('#AppYoutubeLink_app_icon').val(file_names);"
                        . "}",
                )
            ));
            ?>
             <input type="hidden" id="app_icon" name="app_icon" value="<?php echo $model->app_icon; ?>">
            <?php  echo $form->hiddenField($model, "app_icon");  
            ?>
             <p id="upload_file_list" style="display:none"></p> 
            <?php if ($model->app_icon != '') { ?>
                <img src="uploads/youtubeicon/<?php echo $model->app_icon ?>" width="100px" height="60px">
            <?php } ?>   
    </li>
    <li class="col-sm-3">
        <label>Recommanded Status</label>
        <?php echo $form->dropdownList($model, 'recommended' , array("Y"=>"Yes","N"=>"No"),array('prompt'=>'--Select--','class' => 'form-control select2', 'data-label' => 'YouTube Link<span style="color:red;">*<span>','prompt'=>'--Select--')); ?>
        <?php echo $form->error($model, 'recommended'); ?>
    </li>
    <li class="col-sm-3">
        <label>Trending Count<span style="color:red;">*</span></label>
        <?php echo $form->textField($model, 'trending_count', array('class' => '', 'data-label' => 'Trending Count','onkeypress' => 'return isPositiveInteger(event)'

)); ?>
        <?php echo $form->error($model, 'trending_count'); ?>
    </li>
</ul>

 <div class="modal-footer">
    <button type="button" class="btn btn-danger" id="mas_close" data-dismiss="modal">Close</button>
    <?php
        $url = Yii::app()->createUrl('appyoutubelink/Save');
        echo CHtml::ajaxSubmitButton('Save', $url, array(
        'dataType' => 'json',
        'type' => 'post',
        'success' => 'function(data) {
                                    if(data.status=="success"){
                                         t8.success("YouTube Link Saved Successfully!");
                                          $("#mas_close").click();
                                         reloadTable("#tbl_youtube");
                                    }
                                    else if(data.status=="failed"){
                                        t8.error("YouTube Link is already Used Somewhere!");
                                       
                                   }
                                    else {
                                         $.each(data, function(key, val) {
                                                $("#youtube-form #"+key+"_em_").text(val).show();
                                                t8.error(""+val+"");
                                            });
                                       }
                                       $("#youtube-form .youtube-form-save-btn").prop("disabled", false);
                                    }',
                                    'beforeSend' => 'function(){
                                        $("#youtube-form .youtube-form-save-btn").prop("disabled", true);
                                         $(".toast").hide();
                                    }',
        ), array('id' => 'mybtn' . rand(), 'class' => 'youtube-form-save-btn btn btn-primary'));
    ?>
</div>

<?php $this->endWidget(); ?>
<script>
    $(document).ready(function() {
    $('.select2').select2({
    closeOnSelect: true
});
});
</script>