<?php

/**
 * This is the model class for table "{{sales_order_details}}".
 *
 * The followings are the available columns in table '{{sales_order_details}}':
 * @property integer $id
 * @property integer $research_allocate_company_id
 * @property integer $company_contact_id
 * @property integer $art_work_contact_id
 * @property integer $magazine_id
 * @property integer $edition_id
 * @property integer $plan_picks_feature_id
 * @property integer $ad_size
 * @property string $deadline
 * @property string $casual_rate
 * @property string $discount_amt
 * @property string $discount_percent
 * @property string $amount
 * @property string $agency_commission
 * @property string $sub_total
 * @property string $gst
 * @property string $early_invoice_discount
 * @property string $received_amt
 * @property string $grand_total
 * @property string $invoice_date
 * @property integer $purchase_order
 * @property integer $company_id
 * @property string $thank_note
 * @property string $invoice_no
 * @property string $due_date
 * @property string $payment_status
 * @property integer $agency_from_company_id
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class SalesDetails extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{sales_order_details}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('research_allocate_company_id, company_contact_id, art_work_contact_id, magazine_id, edition_id, plan_picks_feature_id, ad_size, deadline, casual_rate, discount_amt, discount_percent, amount, agency_commission, sub_total, gst, early_invoice_discount, received_amt, grand_total, invoice_date, purchase_order, company_id, thank_note, invoice_no, due_date, agency_from_company_id, created_by, created_date_time, updated_by, updated_date_time', 'required'),
			array('research_allocate_company_id, company_contact_id, art_work_contact_id, magazine_id, edition_id, plan_picks_feature_id, ad_size, purchase_order, company_id, agency_from_company_id, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('casual_rate, discount_amt, discount_percent, amount, agency_commission, sub_total, gst, received_amt, grand_total', 'length', 'max'=>10),
			array('early_invoice_discount', 'length', 'max'=>15),
			array('invoice_no, payment_status', 'length', 'max'=>100),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, research_allocate_company_id, company_contact_id, art_work_contact_id, magazine_id, edition_id, plan_picks_feature_id, ad_size, deadline, casual_rate, discount_amt, discount_percent, amount, agency_commission, sub_total, gst, early_invoice_discount, received_amt, grand_total, invoice_date, purchase_order, company_id, thank_note, invoice_no, due_date, payment_status, agency_from_company_id, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		     'allocatecompany' => array(self::BELONGS_TO, 'ResearchAllocateCompany', 'research_allocate_company_id'),
            'allocateadv' => array(self::BELONGS_TO, 'ResearchAdvertisingCompany', 'research_allocate_company_id'),
            'features'=>array(self::BELONGS_TO,'ResearchPlanPicksFeature','plan_picks_feature_id'),
            'magazine' => array(self::BELONGS_TO, 'MasterMagazine', 'magazine_id'),
            'edition' => array(self::BELONGS_TO, 'MasterEdition', 'edition_id'),
            'company'=>array(self::BELONGS_TO,'Company','company_id'),
            'payment'=>array(self::HAS_ONE,'Payment','invoice_id'),
            'contact'=>array(self::BELONGS_TO,'CompanyContact','company_contact_id'),
            'artwork_contact'=>array(self::BELONGS_TO,'CompanyContact','art_work_contact_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'research_allocate_company_id' => 'Research Allocate Company',
			'company_contact_id' => 'Company Contact',
			'art_work_contact_id' => 'Art Work Contact',
			'magazine_id' => 'Magazine',
			'edition_id' => 'Edition',
			'plan_picks_feature_id' => 'Plan Picks Feature',
			'ad_size' => 'Ad Size',
			'deadline' => 'Deadline',
			'casual_rate' => 'Casual Rate',
			'discount_amt' => 'Discount Amt',
			'discount_percent' => 'Discount Percent',
			'amount' => 'Amount',
			'agency_commission' => 'Agency Commission',
			'sub_total' => 'Sub Total',
			'gst' => 'Gst',
			'early_invoice_discount' => 'Early Invoice Discount',
			'received_amt' => 'Received Amt',
			'grand_total' => 'Grand Total',
			'invoice_date' => 'Invoice Date',
			'purchase_order' => 'Purchase Order',
			'company_id' => 'Company',
			'thank_note' => 'Thank Note',
			'invoice_no' => 'Invoice No',
			'due_date' => 'Due Date',
			'payment_status' => 'Payment Status',
			'agency_from_company_id' => 'Agency From Company',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('research_allocate_company_id',$this->research_allocate_company_id);
		$criteria->compare('company_contact_id',$this->company_contact_id);
		$criteria->compare('art_work_contact_id',$this->art_work_contact_id);
		$criteria->compare('magazine_id',$this->magazine_id);
		$criteria->compare('edition_id',$this->edition_id);
		$criteria->compare('plan_picks_feature_id',$this->plan_picks_feature_id);
		$criteria->compare('ad_size',$this->ad_size);
		$criteria->compare('deadline',$this->deadline,true);
		$criteria->compare('casual_rate',$this->casual_rate,true);
		$criteria->compare('discount_amt',$this->discount_amt,true);
		$criteria->compare('discount_percent',$this->discount_percent,true);
		$criteria->compare('amount',$this->amount,true);
		$criteria->compare('agency_commission',$this->agency_commission,true);
		$criteria->compare('sub_total',$this->sub_total,true);
		$criteria->compare('gst',$this->gst,true);
		$criteria->compare('early_invoice_discount',$this->early_invoice_discount,true);
		$criteria->compare('received_amt',$this->received_amt,true);
		$criteria->compare('grand_total',$this->grand_total,true);
		$criteria->compare('invoice_date',$this->invoice_date,true);
		$criteria->compare('purchase_order',$this->purchase_order);
		$criteria->compare('company_id',$this->company_id);
		$criteria->compare('thank_note',$this->thank_note,true);
		$criteria->compare('invoice_no',$this->invoice_no,true);
		$criteria->compare('due_date',$this->due_date,true);
		$criteria->compare('payment_status',$this->payment_status,true);
		$criteria->compare('agency_from_company_id',$this->agency_from_company_id);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return SalesDetails the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
