<?php

/**
 * This is the model class for table "crm_research_picks_company".
 *
 * The followings are the available columns in table 'crm_research_picks_company':
 * @property integer $id
 * @property integer $magazine_id
 * @property integer $feature_id
 * @property integer $company_id
 * @property integer $status
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class ResearchDecisionMakingCompany extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public $dmc_industry;
    public $dmc_category;

    public function tableName() {
        return '{{research_decision_making_company}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('magazine_id,company_id', 'required'),
            array('magazine_id, feature_id, edition_id,company_id, status,contact_person, created_by, updated_by', 'numerical', 'integerOnly' => true),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, magazine_id, feature_id, company_id, status,contact_person, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'company' => array(self::BELONGS_TO, 'Company', 'company_id'),
            'contact' => array(self::BELONGS_TO, 'CompanyContact', 'contact_person'),
            'features' => array(self::BELONGS_TO, 'ResearchPlanPicksFeature', 'feature_id'),
            'magazine' => array(self::BELONGS_TO, 'MasterMagazine', 'magazine_id'),
            'edition' => array(self::BELONGS_TO, 'MasterEdition', 'edition_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'magazine_id' => 'Magazine',
            'edition_id' => 'Edition',
            'feature_id' => 'PFeature',
            'company_id' => 'Company',
            'status' => ' 1-Confirm,2-Move Forward,3-Discard',
            'created_by' => 'Created By',
            'created_date_time' => 'Created Date Time',
            'updated_by' => 'Updated By',
            'updated_date_time' => 'Updated Date Time',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('magazine_id', $this->magazine_id);
        $criteria->compare('feature_id', $this->feature_id);
        $criteria->compare('company_id', $this->company_id);
        $criteria->compare('status', $this->status);
        $criteria->compare('created_by', $this->created_by);
        $criteria->compare('created_date_time', $this->created_date_time, true);
        $criteria->compare('updated_by', $this->updated_by);
        $criteria->compare('updated_date_time', $this->updated_date_time, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return ResearchPicksCompany the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public static function getDecisionMakerStatus($id) {
        switch ($id) {
            case 1:
                $title = "Confirm";
                break;
            case 2:
                $title = "Move Forward";
                break;
            case 3:
                $title = "Discard";
                break;
            default:
                $title = "No Status";
        }
        return $title;
    }

    public static function getCompanyByFeatureId($feature_id = 0) {
        $condition = 'feature_id="' . $feature_id . '"';
        $model = ResearchPicksCompany::model()->with('company')->findAll(array('select' => 't.company_id as id,company_name as company_id', 'condition' => $condition, 'order' => 'company_name'));
        return CHtml::listData($model, 'id', 'company_id');
    }

}
