<?php

/**
 * This is the model class for table "{{master_currency}}".
 *
 * The followings are the available columns in table '{{master_currency}}':
 * @property integer $id
 * @property string $currency
 * @property string $currency_code
 * @property string $exchange_rate
 * @property string $isActive
 */
class MasterCurrency extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{master_currency}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('currency, currency_code, exchange_rate', 'required'),
			array('currency, currency_code, exchange_rate', 'length', 'max'=>255),
			array('isActive', 'length', 'max'=>1),
			array('currency_code', 'validateCurrencyCode'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, currency, currency_code, exchange_rate, isActive', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'currency' => 'Currency',
			'currency_code' => 'Currency Code',
			'exchange_rate' => 'Exchange Rate',
			'isActive' => 'Is Active',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('currency',$this->currency,true);
		$criteria->compare('currency_code',$this->currency_code,true);
		$criteria->compare('exchange_rate',$this->exchange_rate,true);
		$criteria->compare('isActive',$this->isActive,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return MasterCurrency the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	public function validateCurrencyCode($attribute, $params)
	{
    
		$condition = "isActive='Y' ";
		if($this->id>0){
			$condition .=" AND id!='".$this->id."' ";
		}
	    $code = $this->$attribute;
	    $condition .= "  AND currency_code='" . $code . "'";
	 	$exst_model = self::model()->find(array('condition' => $condition));
		    if (!empty($exst_model)) {
		        $this->addError($attribute, 'Currency Code must be unique..');
		    }
		
	}
}
