<?php

/**
 * This is the model class for table "{{mas_user_group}}".
 *
 * The followings are the available columns in table '{{mas_user_group}}':
 * @property integer $id
 * @property string $group_name
 * @property string $permissions
 * @property integer $created_by
 * @property string $created_date
 * @property integer $updated_by
 * @property string $updated_date
 * @property string $isActive
 */
class MasUserGroup extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{mas_user_group}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('group_name', 'required'),
			array('created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('group_name', 'length', 'max'=>255),
			array('isActive', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, group_name, permissions, created_by, created_date, updated_by, updated_date, isActive', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		     'masUsers' => array(self::HAS_MANY, 'MasUser', 'user_group_id'),
            'company' => array(self::BELONGS_TO, 'MasCompany', 'company_id'),
            'parentGroup' => array(self::BELONGS_TO, 'MasUserGroup', 'parent_id'),
            'children' => array(self::HAS_MANY, 'MasUserGroup', 'parent_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'group_name' => 'Group Name',
			'permissions' => 'Permissions',
			'created_by' => 'Created By',
			'created_date' => 'Created Date',
			'updated_by' => 'Updated By',
			'updated_date' => 'Updated Date',
			'isActive' => 'Is Active',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('group_name',$this->group_name,true);
		$criteria->compare('permissions',$this->permissions,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date',$this->created_date,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date',$this->updated_date,true);
		$criteria->compare('isActive',$this->isActive,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return MasUserGroup the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
	public static function getUserGroup($id = null) {
        $condition = 'isActive =  "Y" AND id > 1';
        //$condition = 'isActive =  "Y"';
        if ($id != null)
            $condition .= 'id<>' . $id;
        $model = self::model()->findAll(array('condition' => $condition, 'order' => 'group_name'));
        return CHtml::listData($model, 'id', 'group_name');
    }
     public static function subGroups1($id) {
        $condition = 'parent_id =  ' . $id;
        $subgroups = array();
        $model = self::model()->findAll(array('condition' => $condition));
        if (count($model) > 0) {
            foreach ($model as $eachModel) {
                $subgroups[] = $eachModel->id;
            }
        }
        return (implode(',', $subgroups));
    }

    public function getOneLevel($id) {

        $condition = 'parent_id =  ' . $id;
        $subgroups = array();
        $model = self::model()->findAll(array('condition' => $condition));
        if (count($model) > 0) {
            foreach ($model as $eachModel) {
                $subgroups[] = $eachModel->id;
            }
        }
        return $subgroups;
    }

    public function subGroups($parent_id) {
        $tree = Array();
        if (!empty($parent_id)) {
            $tree = self::getOneLevel($parent_id);
            foreach ($tree as $key => $val) {
                $ids = self::subGroups($val);
                $tree = array_merge($tree, $ids);
            }
        }
        return $tree;
    }

    public function renderCountOfUsers($data, $row) {
        return User::model()->count('user_group_id in (' . $data->id . ')');
    }

    public function GetUserPermission($user_group_id = 0, $permission_val = "") {
        $model = self::model()->findByPk($user_group_id);

        $permissionArray = CJSON::decode($model->permissions);
        return (int) $permissionArray[$permission_val];
    }

}
