<?php

/**
 * This is the model class for table "{{general_note}}".
 *
 * The followings are the available columns in table '{{general_note}}':
 * @property integer $id
 * @property integer $company_id
 * @property integer $contact_id
 * @property integer $magazine_id
 * @property integer $edition_id
 * @property integer $feature_id
 * @property string $callback_date_time
 * @property string $notes
 * @property integer $note_from
 * @property integer $note_status
 * @property string $callback_note
 * @property string $callback_done_date_time
 * @property integer $call_back_status
 * @property string $favourite
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class GeneralNote extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{general_note}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('company_id, contact_id,callback_date_time, notes', 'required'),
			array('company_id, contact_id, magazine_id, edition_id, feature_id, note_from, note_status, call_back_status, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('favourite', 'length', 'max'=>1),
			array('callback_note, callback_done_date_time', 'safe'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, company_id, contact_id, magazine_id, edition_id, feature_id, callback_date_time, notes, note_from, note_status, callback_note, callback_done_date_time, call_back_status, favourite, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		     'user' => array(self::BELONGS_TO, 'User', 'created_by'),
			 'contactId' => array(self::BELONGS_TO, 'CompanyContact','contact_id'),
			 'createded' => array(self::BELONGS_TO, 'User','created_by'),
			
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'company_id' => 'Company',
			'contact_id' => 'Contact',
			'magazine_id' => 'Magazine',
			'edition_id' => 'Edition',
			'feature_id' => 'Feature',
			'callback_date_time' => 'Callback Date Time',
			'notes' => 'Notes',
			'note_from' => 'Note From',
			'note_status' => 'Note Status',
			'callback_note' => 'Callback Note',
			'callback_done_date_time' => 'Callback Done Date Time',
			'call_back_status' => 'Call Back Status',
			'favourite' => 'Favourite',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('company_id',$this->company_id);
		$criteria->compare('contact_id',$this->contact_id);
		$criteria->compare('magazine_id',$this->magazine_id);
		$criteria->compare('edition_id',$this->edition_id);
		$criteria->compare('feature_id',$this->feature_id);
		$criteria->compare('callback_date_time',$this->callback_date_time,true);
		$criteria->compare('notes',$this->notes,true);
		$criteria->compare('note_from',$this->note_from);
		$criteria->compare('note_status',$this->note_status);
		$criteria->compare('callback_note',$this->callback_note,true);
		$criteria->compare('callback_done_date_time',$this->callback_done_date_time,true);
		$criteria->compare('call_back_status',$this->call_back_status);
		$criteria->compare('favourite',$this->favourite,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return GeneralNote the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
	 public static function getlastContactedPerson($company_id) {
        $condition = "1=1";
        if ($company_id > 0) {
            $condition.= ' AND company_id=' . $company_id;
        }
        $model = self::model()->find(array(  'condition' => $condition, 'order'=> "id DESC"));
        return $model->user->first_name . ' ' . $model->user->last_name;
    }
    public static function GetLastNote($company_id) {
        $condition = "1=1";
        if ($company_id > 0) {
            $condition.= ' AND company_id=' . $company_id;
        }
        $model = self::model()->find(array('condition' => $condition, 'order' => "id DESC"));
        $notes = $model->notes;
        return (strlen($notes) > 30) ? substr($notes, 0, 30) . '...' : $notes;
    }
}
