<?php

/**
 * This is the model class for table "{{feature_type}}".
 *
 * The followings are the available columns in table '{{feature_type}}':
 * @property integer $id
 * @property string $feature_name
 * @property integer $magazine_id
 * @property integer $status
 * @property string $isActive
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class FeatureType extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{feature_type}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('feature_name, magazine_id, created_by, created_date_time', 'required'),
			array('magazine_id, status, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('feature_name', 'length', 'max'=>300),
			array('isActive', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, feature_name, magazine_id, status, isActive, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'MagazineName' => array(self::BELONGS_TO,'MasterMagazine', 'magazine_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'feature_name' => 'Feature Name',
			'magazine_id' => 'Magazine',
			'status' => 'Status',
			'isActive' => 'Is Active',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('feature_name',$this->feature_name,true);
		$criteria->compare('magazine_id',$this->magazine_id);
		$criteria->compare('status',$this->status);
		$criteria->compare('isActive',$this->isActive,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return FeatureType the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	public static function getAll() {
        $condition = " isActive='Y'";
        $model = self::model()->findAll(array('select' => array('id', 'feature_name'), 'condition'=>$condition,'order' => 'feature_name'));
        return CHtml::listData($model, 'id', 'feature_name');
    }
     public static function getFeatureByMagazine($magazine_id) {
        $condition = 'isActive="Y" AND magazine_id="' . $magazine_id . '"';
        $model = self::model()->findAll(array(
            'select' => 'DISTINCT feature_name, id',  // Use DISTINCT here
            'condition' => $condition,
            'order' => 'feature_name'
        ));
        return CHtml::listData($model, 'id', 'feature_name');

    }

}
